/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.ResultDisplayHandler;
import org.netbeans.modules.gsf.testrunner.api.ResultPanelTree;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StatisticsPanel
extends JPanel
implements ItemListener {
    private final ResultPanelTree treePanel;
    private JToggleButton btnFilter;
    private JButton rerunButton;
    private JButton nextFailure;
    private JButton previousFailure;
    private String tooltipShowAll;
    private String tooltipShowFailures;
    private final ResultDisplayHandler displayHandler;
    private static boolean showFailuresOnly = false;

    public StatisticsPanel(ResultDisplayHandler resultDisplayHandler) {
        super(new BorderLayout(0, 0));
        this.displayHandler = resultDisplayHandler;
        JComponent jComponent = this.createToolbar();
        this.treePanel = new ResultPanelTree(resultDisplayHandler);
        this.treePanel.setFiltered(this.btnFilter.isSelected());
        this.add((Component)jComponent, "West");
        this.add((Component)this.treePanel, "Center");
    }

    private JComponent createToolbar() {
        this.createFilterButton();
        this.createRerunButton();
        this.createNextPrevFailureButtons();
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setLayout(new BoxLayout(jToolBar, 1));
        jToolBar.add(this.rerunButton);
        jToolBar.add(this.btnFilter);
        jToolBar.add(this.previousFailure);
        jToolBar.add(this.nextFailure);
        jToolBar.add(Box.createHorizontalGlue());
        jToolBar.setFocusable(false);
        jToolBar.setFloatable(false);
        jToolBar.setBorderPainted(false);
        return jToolBar;
    }

    private void createRerunButton() {
        this.rerunButton = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/gsf/testrunner/resources/rerun.png", (boolean)true));
        this.rerunButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_RerunButton"));
        final RerunHandler rerunHandler = this.displayHandler.getSession().getRerunHandler();
        if (rerunHandler != null) {
            this.rerunButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    rerunHandler.rerun();
                }
            });
            rerunHandler.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    StatisticsPanel.this.rerunButton.setEnabled(rerunHandler.enabled());
                }
            });
            this.rerunButton.setEnabled(rerunHandler.enabled());
        }
        this.rerunButton.setToolTipText(NbBundle.getMessage(StatisticsPanel.class, (String)"MultiviewPanel.rerunButton.tooltip"));
    }

    private void createFilterButton() {
        this.btnFilter = new JToggleButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/gsf/testrunner/resources/filter.png", (boolean)true));
        this.btnFilter.getAccessibleContext().setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_FilterButton"));
        this.btnFilter.setSelected(showFailuresOnly);
        this.btnFilter.addItemListener(this);
        this.updateFilterButtonLabel();
    }

    private void updateFilterButtonLabel() {
        if (this.tooltipShowAll == null) {
            this.tooltipShowAll = NbBundle.getMessage(this.getClass(), (String)"MultiviewPanel.btnFilter.showAll.tooltip");
            this.tooltipShowFailures = NbBundle.getMessage(this.getClass(), (String)"MultiviewPanel.btnFilter.showFailures.tooltip");
        }
        this.btnFilter.setToolTipText(this.btnFilter.isSelected() ? this.tooltipShowAll : this.tooltipShowFailures);
    }

    private void createNextPrevFailureButtons() {
        this.nextFailure = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/gsf/testrunner/resources/nextmatch.png", (boolean)true));
        this.nextFailure.setToolTipText(NbBundle.getMessage(StatisticsPanel.class, (String)"MSG_NextFailure"));
        this.nextFailure.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatisticsPanel.this.selectNextFailure();
            }
        });
        this.previousFailure = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/gsf/testrunner/resources/prevmatch.png", (boolean)true));
        this.previousFailure.setToolTipText(NbBundle.getMessage(StatisticsPanel.class, (String)"MSG_PreviousFailure"));
        this.previousFailure.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatisticsPanel.this.selectPreviousFailure();
            }
        });
    }

    void selectPreviousFailure() {
        this.treePanel.selectPreviousFailure();
    }

    void selectNextFailure() {
        this.treePanel.selectNextFailure();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        showFailuresOnly = this.btnFilter.isSelected();
        this.treePanel.setFiltered(this.btnFilter.isSelected());
        this.updateFilterButtonLabel();
    }

    void displayReport(Report report) {
        this.treePanel.displayReport(report);
        this.btnFilter.setEnabled(this.treePanel.getSuccessDisplayedLevel() != 0);
    }

    void displayReports(List<Report> list) {
        if (list.isEmpty()) {
            return;
        }
        this.treePanel.displayReports(list);
        this.btnFilter.setEnabled(this.treePanel.getSuccessDisplayedLevel() != 0);
    }

    void displaySuiteRunning(String string) {
        this.treePanel.displaySuiteRunning(string);
    }

    void displayMsg(String string) {
        this.treePanel.displayMsg(string);
    }
}

