/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner;

import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public final class TestRunnerSettings {
    private static final String RESULTS_SPLITPANE_DIVIDER_VERTICAL = "resultsSplitDividerVertical";
    private static final String RESULTS_SPLITPANE_DIVIDER_HORIZONTAL = "resultsSplitDividerHorizontal";
    private static final String RESULTS_SPLITPANE_ORIENTATION = "resultsSplitOrientation";
    private static final int DEFAULT_DIVIDER_LOCATION_VERTICAL = 120;
    private static final int DEFAULT_DIVIDER_LOCATION_HORIZONTAL = 300;
    private static final int DEFAULT_DIVIDER_ORIENTATION = 1;
    private static final TestRunnerSettings INSTANCE = new TestRunnerSettings();

    private TestRunnerSettings() {
    }

    public static TestRunnerSettings getDefault() {
        return INSTANCE;
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(TestRunnerSettings.class);
    }

    public DividerSettings getDividerSettings(Integer n) {
        if (n == null) {
            n = this.getResultsSplitPaneOrientation();
        }
        return new DividerSettings(n, this.getResultsSplitPaneDivider(n));
    }

    public void setDividerSettings(DividerSettings dividerSettings) {
        this.setResultsSplitPaneOrientation(dividerSettings.getOrientation());
        this.setResultsSplitPaneDivider(dividerSettings.getLocation(), dividerSettings.getOrientation());
    }

    private int getResultsSplitPaneDivider(int n) {
        if (0 == n) {
            return this.getPreferences().getInt(RESULTS_SPLITPANE_DIVIDER_VERTICAL, 120);
        }
        return this.getPreferences().getInt(RESULTS_SPLITPANE_DIVIDER_HORIZONTAL, 300);
    }

    private void setResultsSplitPaneDivider(int n, int n2) {
        if (0 == n2) {
            this.getPreferences().putInt(RESULTS_SPLITPANE_DIVIDER_VERTICAL, n);
        } else {
            this.getPreferences().putInt(RESULTS_SPLITPANE_DIVIDER_HORIZONTAL, n);
        }
    }

    private int getResultsSplitPaneOrientation() {
        return this.getPreferences().getInt(RESULTS_SPLITPANE_ORIENTATION, 1);
    }

    private void setResultsSplitPaneOrientation(int n) {
        this.getPreferences().putInt(RESULTS_SPLITPANE_ORIENTATION, n);
    }

    public static final class DividerSettings {
        private final int orientation;
        private final int location;

        public DividerSettings(int n, int n2) {
            assert (n == 1 || n == 0);
            this.orientation = n;
            this.location = n2;
        }

        public int getOrientation() {
            return this.orientation;
        }

        public int getLocation() {
            return this.location;
        }
    }
}

