/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.issue.cache;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.logging.Level;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueCache;
import org.openide.util.NbBundle;

public class IssueCacheUtils {
    public static boolean wasSeen(Issue issue) {
        return IssueCacheUtils.getCache(issue).wasSeen(issue.getID());
    }

    public static void switchSeen(Issue issue) {
        try {
            IssueCache issueCache = IssueCacheUtils.getCache(issue);
            String string = issue.getID();
            issueCache.setSeen(string, !issueCache.wasSeen(string));
        }
        catch (IOException iOException) {
            BugtrackingManager.LOG.log(Level.SEVERE, null, iOException);
        }
    }

    public static void setSeen(Issue issue, boolean bl) {
        try {
            IssueCacheUtils.getCache(issue).setSeen(issue.getID(), bl);
        }
        catch (IOException iOException) {
            BugtrackingManager.LOG.log(Level.SEVERE, null, iOException);
        }
    }

    public static String getRecentChanges(Issue issue) {
        String string = IssueCacheUtils.getCache(issue).getIssueAccessor().getRecentChanges(issue);
        string = string == null ? "" : string.trim();
        if (string.equals("") && IssueCacheUtils.getCache(issue).getStatus(issue.getID()) == 8) {
            string = NbBundle.getMessage(IssueCacheUtils.class, (String)"LBL_IssueModified");
        }
        return string;
    }

    public static void addCacheListener(Issue issue, PropertyChangeListener propertyChangeListener) {
        IssueCacheUtils.getCache(issue).addPropertyChangeListener(issue, propertyChangeListener);
    }

    public static void removeCacheListener(Issue issue, PropertyChangeListener propertyChangeListener) {
        IssueCacheUtils.getCache(issue).removePropertyChangeListener(issue, propertyChangeListener);
    }

    private static IssueCache getCache(Issue issue) {
        Repository repository = issue.getRepository();
        IssueCache issueCache = (IssueCache)repository.getLookup().lookup(IssueCache.class);
        assert (issueCache != null);
        return issueCache;
    }
}

