/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.validation.adapters;

import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import org.netbeans.api.validation.adapters.DialogDescriptorAdapter;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DialogBuilder {
    private String token;
    private String title;
    private boolean modal = true;
    private Object[] options;
    private Object defaultOption;
    private DialogType dialogType = DialogType.PLAIN;
    private Object message;
    private Object[] additionalOptions;
    private HelpCtx ctx;
    private ButtonSet optionType;
    private ActionListener al;
    private Object[] closingOptions;
    private ValidationGroup validationGroup;

    public DialogBuilder(Class<?> clazz) {
        this(clazz.getName());
    }

    public DialogBuilder(String string) {
        this.token = string;
    }

    public DialogBuilder setModal(boolean bl) {
        this.modal = bl;
        return this;
    }

    public DialogBuilder setTitle(String string) {
        this.title = string;
        return this;
    }

    public DialogBuilder setOptions(Object ... objectArray) {
        this.options = objectArray;
        if (this.optionType != null) {
            throw new IllegalStateException("Call setOptions, or setOptionType, not both.They are mutually exclusive");
        }
        return this;
    }

    public DialogBuilder setDefaultButton(Object object) {
        this.defaultOption = object;
        return this;
    }

    public DialogBuilder setDialogType(DialogType dialogType) {
        this.dialogType = dialogType;
        return this;
    }

    public DialogBuilder setContent(Object object) {
        this.message = object;
        return this;
    }

    public DialogBuilder setHelpContext(HelpCtx helpCtx) {
        this.ctx = helpCtx;
        return this;
    }

    public DialogBuilder setAdditionalButtons(Object[] objectArray) {
        this.additionalOptions = objectArray;
        return this;
    }

    public DialogBuilder setButtonSet(ButtonSet buttonSet) {
        this.optionType = buttonSet;
        if (this.options != null) {
            throw new IllegalStateException("Use setButtons or setButtonSet, not both");
        }
        return this;
    }

    public DialogBuilder setActionListener(ActionListener actionListener) {
        this.al = actionListener;
        return this;
    }

    public DialogBuilder setClosingOptions(Object ... objectArray) {
        this.closingOptions = objectArray;
        return this;
    }

    public DialogBuilder setValidationGroup(ValidationGroup validationGroup) {
        this.validationGroup = validationGroup;
        return this;
    }

    public boolean showDialog(Object object) {
        return object.equals(this.showDialog());
    }

    public Object showDialog() {
        DialogDescriptor dialogDescriptor = this.createDialogDescriptor();
        System.err.println("MODAL? " + dialogDescriptor.isModal());
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        System.err.println("Exit dialog descriptor notify for " + dialogDescriptor);
        if (DialogDescriptor.YES_OPTION.equals(object) || DialogDescriptor.OK_OPTION.equals(object) || this.defaultOption != null && this.defaultOption.equals(object) || NbBundle.getMessage(DialogBuilder.class, (String)"BTN_CLOSE").equals(object)) {
            System.err.println("DLG RESULT " + object + " " + Thread.currentThread());
        }
        return object;
    }

    private ValidationPanel createValidationPanel(Object object, DialogDescriptor dialogDescriptor) {
        ValidationPanel validationPanel = this.validationGroup == null ? new ValidationPanel() : new ValidationPanel(this.validationGroup);
        validationPanel.setDelegateValidationUI(new DialogDescriptorAdapter(dialogDescriptor));
        if (object instanceof Component) {
            validationPanel.setInnerComponent((Component)object);
        } else {
            validationPanel.setInnerComponent(new JLabel(object.toString()));
        }
        return validationPanel;
    }

    private DialogDescriptor createDialogDescriptor() {
        if (this.message == null) {
            throw new IllegalStateException("Message not set");
        }
        Object object = this.message;
        DialogDescriptor dialogDescriptor = new DialogDescriptor(object, this.title);
        if (this.validationGroup != null) {
            object = this.createValidationPanel(object, dialogDescriptor);
            dialogDescriptor.setMessage(object);
        }
        if (object instanceof ValidationPanel) {
            DialogDescriptorAdapter dialogDescriptorAdapter = new DialogDescriptorAdapter(dialogDescriptor);
            ((ValidationPanel)object).setDelegateValidationUI(dialogDescriptorAdapter);
        }
        dialogDescriptor.setModal(this.modal);
        dialogDescriptor.setHelpCtx(this.ctx == null ? HelpCtx.DEFAULT_HELP : this.ctx);
        if (this.additionalOptions != null) {
            dialogDescriptor.setAdditionalOptions(this.options);
        }
        if (this.optionType != null) {
            if (this.optionType != ButtonSet.CLOSE) {
                dialogDescriptor.setOptionType(this.optionType.getDialogDisplayerConstant());
            } else {
                dialogDescriptor.setOptions(new Object[]{NbBundle.getMessage(DialogBuilder.class, (String)"BTN_CLOSE")});
            }
        } else if (this.options == null) {
            dialogDescriptor.setOptionType(ButtonSet.OK_CANCEL.getDialogDisplayerConstant());
        } else if (this.options != null) {
            dialogDescriptor.setOptions(this.options);
        }
        if (this.al != null) {
            dialogDescriptor.setButtonListener(this.al);
        }
        if (this.closingOptions != null) {
            dialogDescriptor.setClosingOptions(this.options);
        }
        dialogDescriptor.setMessageType(this.dialogType.getDialogDisplayerConstant());
        return dialogDescriptor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ButtonSet {
        OK_CANCEL,
        YES_NO,
        YES_NO_CANCEL,
        CLOSE;


        private int getDialogDisplayerConstant() {
            switch (this) {
                case OK_CANCEL: {
                    return 2;
                }
                case YES_NO: {
                    return 0;
                }
                case YES_NO_CANCEL: {
                    return 1;
                }
                case CLOSE: {
                    return -1;
                }
            }
            throw new AssertionError();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DialogType {
        WARNING,
        INFO,
        QUESTION,
        PLAIN,
        ERROR;


        int getDialogDisplayerConstant() {
            switch (this) {
                case WARNING: {
                    return 2;
                }
                case INFO: {
                    return 1;
                }
                case QUESTION: {
                    return 3;
                }
                case PLAIN: {
                    return -1;
                }
                case ERROR: {
                    return 0;
                }
            }
            throw new AssertionError();
        }
    }
}

