/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.util;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.xml.namespace.QName;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.websvc.jaxwsruntimemodel.JavaWsdlMapper;
import org.netbeans.modules.websvc.wsitconf.spi.WsitProvider;
import org.netbeans.modules.websvc.wsitconf.util.ServerUtils;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Input;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Output;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.RequestResponseOperation;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static final String MEX_CLASS_NAME = "com.sun.xml.ws.mex.server.MEXEndpoint";
    public static final String MEX_NAME = "MEXEndpoint";
    private static final Logger logger = Logger.getLogger(Util.class.getName());

    public static void changeLabelInComponent(JComponent jComponent, String string, String string2) {
        JLabel jLabel = Util.findLabel(jComponent, string);
        if (jLabel != null) {
            jLabel.setText(string2);
        }
    }

    public static void hideLabelAndLabelFor(JComponent jComponent, String string) {
        JLabel jLabel = Util.findLabel(jComponent, string);
        if (jLabel != null) {
            jLabel.setVisible(false);
            Component component = jLabel.getLabelFor();
            if (component != null) {
                component.setVisible(false);
            }
        }
    }

    public static void getAllComponents(Component[] componentArray, Collection<Component> collection) {
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] == null) continue;
            collection.add(componentArray[i]);
            if (((Container)componentArray[i]).getComponentCount() == 0) continue;
            Util.getAllComponents(((Container)componentArray[i]).getComponents(), collection);
        }
    }

    public static JLabel findLabel(JComponent jComponent, String string) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        Util.getAllComponents(jComponent.getComponents(), arrayList);
        for (Component component : arrayList) {
            JLabel jLabel;
            if (!(component instanceof JLabel) || !(jLabel = (JLabel)component).getText().equals(string)) continue;
            return jLabel;
        }
        return null;
    }

    public static SourceGroup[] getJavaSourceGroups(Project project) {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        Set<SourceGroup> set = Util.getTestSourceGroups(sourceGroupArray);
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            if (set.contains(sourceGroupArray[i])) continue;
            arrayList.add(sourceGroupArray[i]);
        }
        return arrayList.toArray(new SourceGroup[arrayList.size()]);
    }

    private static Set<SourceGroup> getTestSourceGroups(SourceGroup[] sourceGroupArray) {
        Map map = Util.createFoldersToSourceGroupsMap(sourceGroupArray);
        HashSet<SourceGroup> hashSet = new HashSet<SourceGroup>();
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            hashSet.addAll(Util.getTestTargets(sourceGroupArray[i], map));
        }
        return hashSet;
    }

    private static Map createFoldersToSourceGroupsMap(SourceGroup[] sourceGroupArray) {
        Map<FileObject, SourceGroup> map;
        if (sourceGroupArray.length == 0) {
            map = Collections.emptyMap();
        } else {
            map = new HashMap(2 * sourceGroupArray.length, 0.5f);
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                SourceGroup sourceGroup = sourceGroupArray[i];
                map.put(sourceGroup.getRootFolder(), sourceGroup);
            }
        }
        return map;
    }

    private static List<FileObject> getFileObjects(URL[] uRLArray) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (int i = 0; i < uRLArray.length; ++i) {
            FileObject fileObject = URLMapper.findFileObject((URL)uRLArray[i]);
            if (fileObject != null) {
                arrayList.add(fileObject);
                continue;
            }
            if (!logger.isLoggable(Level.INFO)) continue;
            logger.log(Level.INFO, "No FileObject found for the following URL: " + uRLArray[i]);
        }
        return arrayList;
    }

    private static List<SourceGroup> getTestTargets(SourceGroup sourceGroup, Map map) {
        URL[] uRLArray = UnitTestForSourceQuery.findUnitTests((FileObject)sourceGroup.getRootFolder());
        if (uRLArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
        List<FileObject> list = Util.getFileObjects(uRLArray);
        for (int i = 0; i < list.size(); ++i) {
            FileObject fileObject = list.get(i);
            SourceGroup sourceGroup2 = (SourceGroup)map.get(fileObject);
            if (sourceGroup2 == null) continue;
            arrayList.add(sourceGroup2);
        }
        return arrayList;
    }

    public static boolean isPositiveNumber(String string, boolean bl, boolean bl2) {
        Integer n = null;
        if (string == null || "".equals(string)) {
            return bl2;
        }
        try {
            n = Integer.parseInt(string);
            if (n != null) {
                if (bl) {
                    return n >= 0;
                }
                return n > 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.log(Level.FINE, null, numberFormatException);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getAliases(String string, char[] cArray, String string2) throws IOException {
        if (string == null || string2 == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            Object object;
            File file = new File(string);
            if (file == null || !file.exists()) {
                throw new IOException();
            }
            fileInputStream = new FileInputStream(file);
            KeyStore keyStore = KeyStore.getInstance(string2);
            keyStore.load(fileInputStream, cArray);
            Enumeration<String> enumeration = keyStore.aliases();
            ArrayList<Object> arrayList = new ArrayList<Object>(keyStore.size());
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                arrayList.add(object);
            }
            Collections.sort(arrayList);
            object = arrayList;
            return object;
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.log(Level.INFO, null, fileNotFoundException);
        }
        catch (KeyStoreException keyStoreException) {
            logger.log(Level.INFO, null, keyStoreException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.log(Level.INFO, null, noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            logger.log(Level.INFO, null, certificateException);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        return null;
    }

    public static final String getPassword(Project project) {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null) {
            InstanceProperties instanceProperties = j2eeModuleProvider.getInstanceProperties();
            return instanceProperties.getProperty("password");
        }
        return "";
    }

    public static boolean isJavaEE5orHigher(Project project) {
        J2eeModule j2eeModule;
        if (project == null) {
            return false;
        }
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null && (j2eeModule = j2eeModuleProvider.getJ2eeModule()) != null) {
            J2eeModule.Type type = j2eeModule.getType();
            double d = Double.parseDouble(j2eeModule.getModuleVersion());
            if (J2eeModule.Type.EJB.equals(type) && d > 2.1) {
                return true;
            }
            if (J2eeModule.Type.WAR.equals(type) && d > 2.4) {
                return true;
            }
            if (J2eeModule.Type.CAR.equals(type) && d > 1.4) {
                return true;
            }
        }
        return false;
    }

    public static boolean isEqual(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object != null && object2 != null) {
            return object.equals(object2);
        }
        return false;
    }

    private static boolean isOperationInList(String string, Collection<BindingOperation> collection) {
        for (BindingOperation bindingOperation : collection) {
            if (bindingOperation == null || !string.equals(bindingOperation.getName())) continue;
            return true;
        }
        return false;
    }

    public static Collection<BindingOperation> refreshOperations(Binding binding, FileObject fileObject) {
        if (binding == null) {
            return null;
        }
        Collection collection = binding.getBindingOperations();
        if (fileObject == null) {
            return collection;
        }
        PortType portType = Util.getPortType(binding);
        List<String> list = JavaWsdlMapper.getOperationNames(fileObject);
        for (String string : list) {
            if (Util.isOperationInList(string, collection)) continue;
            Util.generateOperation(binding, portType, string, fileObject);
        }
        return binding.getBindingOperations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BindingOperation generateOperation(Binding binding, PortType portType, String string, FileObject fileObject) {
        WSDLModel wSDLModel = binding.getModel();
        WSDLComponentFactory wSDLComponentFactory = wSDLModel.getFactory();
        Definitions definitions = (Definitions)binding.getParent();
        BindingOperation bindingOperation = null;
        boolean bl = wSDLModel.isIntransaction();
        if (!bl) {
            wSDLModel.startTransaction();
        }
        try {
            bindingOperation = wSDLComponentFactory.createBindingOperation();
            bindingOperation.setName(string);
            binding.addBindingOperation(bindingOperation);
            Message message = wSDLComponentFactory.createMessage();
            message.setName(string);
            definitions.addMessage(message);
            Message message2 = wSDLComponentFactory.createMessage();
            message2.setName(string + "Response");
            definitions.addMessage(message2);
            RequestResponseOperation requestResponseOperation = wSDLComponentFactory.createRequestResponseOperation();
            requestResponseOperation.setName(string);
            portType.addOperation((Operation)requestResponseOperation);
            Input input = wSDLComponentFactory.createInput();
            requestResponseOperation.setInput(input);
            input.setMessage(input.createReferenceTo((ReferenceableWSDLComponent)message, Message.class));
            Output output = wSDLComponentFactory.createOutput();
            requestResponseOperation.setOutput(output);
            output.setMessage(output.createReferenceTo((ReferenceableWSDLComponent)message2, Message.class));
            BindingOutput bindingOutput = wSDLComponentFactory.createBindingOutput();
            bindingOperation.setBindingOutput(bindingOutput);
            BindingInput bindingInput = wSDLComponentFactory.createBindingInput();
            bindingOperation.setBindingInput(bindingInput);
            List<String> list = JavaWsdlMapper.getOperationFaults(fileObject, string);
            for (String string2 : list) {
                BindingFault bindingFault = wSDLComponentFactory.createBindingFault();
                bindingOperation.addBindingFault(bindingFault);
            }
        }
        catch (NullPointerException nullPointerException) {
            logger.log(Level.INFO, "Cannot create operation: " + string + ", " + portType + nullPointerException.getLocalizedMessage());
        }
        finally {
            if (!bl) {
                wSDLModel.endTransaction();
            }
        }
        return bindingOperation;
    }

    public static PortType getPortType(Binding binding) {
        Definitions definitions = (Definitions)binding.getParent();
        QName qName = binding.getType().getQName();
        PortType portType = null;
        Collection collection = definitions.getPortTypes();
        for (PortType portType2 : collection) {
            if (portType2 == null || !qName.getLocalPart().equals(portType2.getName())) continue;
            portType = portType2;
            break;
        }
        return portType;
    }

    public static FileObject getFOForModel(WSDLModel wSDLModel) {
        if (wSDLModel == null) {
            return null;
        }
        ModelSource modelSource = wSDLModel.getModelSource();
        return Utilities.getFileObject((ModelSource)modelSource);
    }

    public static FileObject getSunDDFO(Project project) {
        J2eeModuleProvider j2eeModuleProvider = ServerUtils.getProvider(project);
        if (j2eeModuleProvider == null) {
            return null;
        }
        FileObject[] fileObjectArray = j2eeModuleProvider.getConfigurationFiles();
        if (fileObjectArray.length > 0) {
            return fileObjectArray[0];
        }
        return null;
    }

    public static Servlet getServlet(WebApp webApp, String string) {
        Servlet[] servletArray;
        for (Servlet servlet : servletArray = webApp.getServlet()) {
            if (!string.equals(servlet.getServletClass())) continue;
            return servlet;
        }
        return null;
    }

    public static void checkMetroLibrary(Project project) {
        Object object;
        if (project == null) {
            return;
        }
        WsitProvider wsitProvider = (WsitProvider)project.getLookup().lookup(WsitProvider.class);
        if (wsitProvider == null) {
            return;
        }
        if (!wsitProvider.isWsitSupported() && NotifyDescriptor.OK_OPTION.equals(object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(Util.class, (String)"TXT_AddLibraries"), 0)))) {
            wsitProvider.addMetroLibrary();
        }
    }
}

