/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.subpanels;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.openide.util.NbBundle;

public class AdvancedSecurityPanel
extends JPanel {
    private Binding binding;
    private boolean inSync = false;
    private DefaultFormatterFactory freshnessff = null;
    private DefaultFormatterFactory skewff = null;
    private ConfigVersion cfgVersion = null;
    private JFormattedTextField freshnessField;
    private JLabel freshnessLabel;
    private JFormattedTextField maxClockSkewField;
    private JLabel maxClockSkewLabel;
    private JCheckBox revocationChBox;

    public AdvancedSecurityPanel(Binding binding, ConfigVersion configVersion) {
        this.binding = binding;
        this.cfgVersion = configVersion;
        this.freshnessff = new DefaultFormatterFactory();
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setGroupingUsed(false);
        NumberFormatter numberFormatter = new NumberFormatter(numberFormat);
        numberFormat.setMaximumIntegerDigits(8);
        numberFormatter.setCommitsOnValidEdit(true);
        numberFormatter.setMinimum(Integer.valueOf(0));
        numberFormatter.setMaximum(Integer.valueOf(99999999));
        this.freshnessff.setDefaultFormatter(numberFormatter);
        this.skewff = new DefaultFormatterFactory();
        NumberFormat numberFormat2 = NumberFormat.getIntegerInstance();
        numberFormat2.setGroupingUsed(false);
        NumberFormatter numberFormatter2 = new NumberFormatter(numberFormat2);
        numberFormat2.setMaximumIntegerDigits(8);
        numberFormatter2.setCommitsOnValidEdit(true);
        numberFormatter2.setMinimum(Integer.valueOf(0));
        numberFormatter2.setMaximum(Integer.valueOf(99999999));
        this.skewff.setDefaultFormatter(numberFormatter2);
        this.initComponents();
        this.sync();
    }

    private void sync() {
        this.inSync = true;
        String string = ProprietarySecurityPolicyModelHelper.getMaxClockSkew(this.binding);
        if (string == null) {
            this.setMaxClockSkew("300000");
        } else {
            this.setMaxClockSkew(string);
        }
        String string2 = ProprietarySecurityPolicyModelHelper.getTimestampFreshness(this.binding);
        if (string2 == null) {
            this.setFreshness("300000");
        } else {
            this.setFreshness(string2);
        }
        this.setRevocation(ProprietarySecurityPolicyModelHelper.isRevocationEnabled(this.binding));
        this.enableDisable();
        this.inSync = false;
    }

    private Number getMaxClockSkew() {
        return (Number)this.maxClockSkewField.getValue();
    }

    private void setMaxClockSkew(String string) {
        this.maxClockSkewField.setText(string);
    }

    private Number getFreshness() {
        return (Number)this.freshnessField.getValue();
    }

    private void setFreshness(String string) {
        this.freshnessField.setText(string);
    }

    private void setRevocation(Boolean bl) {
        if (bl == null) {
            this.revocationChBox.setSelected(false);
        } else {
            this.revocationChBox.setSelected(bl);
        }
    }

    public Boolean getRevocation() {
        if (this.revocationChBox.isSelected()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void storeState() {
        ProprietarySecurityPolicyModelHelper.setRevocation(this.binding, this.revocationChBox.isSelected(), false);
        Number number = this.getFreshness();
        if (number == null || "300000".equals(number.toString())) {
            ProprietarySecurityPolicyModelHelper.setTimestampFreshness(this.binding, null, false);
        } else {
            ProprietarySecurityPolicyModelHelper.setTimestampFreshness(this.binding, number.toString(), false);
        }
        Number number2 = this.getMaxClockSkew();
        if (number2 == null || "300000".equals(number2.toString())) {
            ProprietarySecurityPolicyModelHelper.setMaxClockSkew(this.binding, null, false);
        } else {
            ProprietarySecurityPolicyModelHelper.setMaxClockSkew(this.binding, number2.toString(), false);
        }
    }

    private void enableDisable() {
    }

    private void initComponents() {
        this.maxClockSkewLabel = new JLabel();
        this.freshnessLabel = new JLabel();
        this.freshnessField = new JFormattedTextField();
        this.maxClockSkewField = new JFormattedTextField();
        this.revocationChBox = new JCheckBox();
        this.maxClockSkewLabel.setText(NbBundle.getMessage(AdvancedSecurityPanel.class, (String)"LBL_AdvancedSec_maxClockSkew"));
        this.freshnessLabel.setText(NbBundle.getMessage(AdvancedSecurityPanel.class, (String)"LBL_AdvancedSec_TimestampFreshnessLabel"));
        this.freshnessField.setFormatterFactory(this.freshnessff);
        this.maxClockSkewField.setColumns(8);
        this.maxClockSkewField.setFormatterFactory(this.skewff);
        this.revocationChBox.setText(NbBundle.getMessage(AdvancedSecurityPanel.class, (String)"LBL_AdvancedSec_Revocation"));
        this.revocationChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.revocationChBox.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.freshnessLabel).add((Component)this.maxClockSkewLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.maxClockSkewField, -1, 104, Short.MAX_VALUE).add((Component)this.freshnessField, -1, 104, Short.MAX_VALUE))).add((Component)this.revocationChBox)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.maxClockSkewLabel).add((Component)this.maxClockSkewField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.freshnessLabel).add((Component)this.freshnessField, -2, -1, -2)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.revocationChBox).addContainerGap()));
    }
}

