/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model.presenters.actions;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.presenters.actions.ConfirmDeletionPanel;
import org.netbeans.modules.vmd.api.model.presenters.actions.DeletableState;
import org.netbeans.modules.vmd.api.model.presenters.actions.DeleteDependencyPresenter;
import org.netbeans.modules.vmd.api.model.presenters.actions.DeletePresenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeleteSupport {
    private DeleteSupport() {
    }

    private static DeletableState canDelete(Collection<DesignComponent> collection) {
        boolean bl = false;
        for (DesignComponent designComponent : collection) {
            for (DeletePresenter deletePresenter : designComponent.getPresenters(DeletePresenter.class)) {
                DeletableState deletableState = deletePresenter.canDelete();
                switch (deletableState) {
                    case DISALLOWED: {
                        return DeletableState.DISALLOWED;
                    }
                    case DISALLOWED_FOR_USER_ONLY: {
                        bl = true;
                    }
                }
            }
        }
        return bl ? DeletableState.DISALLOWED_FOR_USER_ONLY : DeletableState.ALLOWED;
    }

    static boolean isSilent(DesignComponent designComponent) {
        for (DeletePresenter deletePresenter : designComponent.getPresenters(DeletePresenter.class)) {
            if (!deletePresenter.isSilent()) continue;
            return true;
        }
        return false;
    }

    private static Collection<DesignComponent> gatherAllComponentsToDelete(DesignDocument designDocument, Collection<DesignComponent> collection) {
        HashSet<DesignComponent> hashSet = new HashSet<DesignComponent>(collection);
        Collection<DesignComponent> collection2 = Collections.unmodifiableCollection(hashSet);
        while (DeleteSupport.findNewlyRequired(designDocument.getRootComponent(), hashSet, collection2)) {
        }
        return hashSet;
    }

    private static boolean findNewlyRequired(DesignComponent designComponent, Collection<DesignComponent> collection, Collection<DesignComponent> collection2) {
        boolean bl = false;
        if (!collection.contains(designComponent) && DeleteSupport.requiresToLive(designComponent, collection2)) {
            collection.add(designComponent);
            bl = true;
        }
        for (DesignComponent designComponent2 : designComponent.getComponents()) {
            if (!DeleteSupport.findNewlyRequired(designComponent2, collection, collection2)) continue;
            bl = true;
        }
        return bl;
    }

    private static boolean requiresToLive(DesignComponent designComponent, Collection<DesignComponent> collection) {
        for (DeleteDependencyPresenter deleteDependencyPresenter : designComponent.getPresenters(DeleteDependencyPresenter.class)) {
            if (!deleteDependencyPresenter.requiresToLive(collection)) continue;
            return true;
        }
        return false;
    }

    private static void notifyComponentsDeleting(DesignComponent designComponent, Collection<DesignComponent> collection) {
        for (DeleteDependencyPresenter object : designComponent.getPresenters(DeleteDependencyPresenter.class)) {
            object.componentsDeleting(collection);
        }
        for (DesignComponent designComponent2 : designComponent.getComponents()) {
            DeleteSupport.notifyComponentsDeleting(designComponent2, collection);
        }
    }

    public static boolean canDeleteAsUser(DesignDocument designDocument, Collection<DesignComponent> collection) {
        if (DeleteSupport.canDelete(collection) != DeletableState.ALLOWED) {
            return false;
        }
        Collection<DesignComponent> collection2 = DeleteSupport.gatherAllComponentsToDelete(designDocument, collection);
        return DeleteSupport.canDelete(collection2) != DeletableState.DISALLOWED;
    }

    public static void invokeDirectUserDeletion(DesignDocument designDocument, Collection<DesignComponent> collection, boolean bl) {
        if (DeleteSupport.canDelete(collection) != DeletableState.ALLOWED) {
            return;
        }
        Collection<DesignComponent> collection2 = DeleteSupport.gatherAllComponentsToDelete(designDocument, collection);
        if (DeleteSupport.canDelete(collection2) == DeletableState.DISALLOWED) {
            return;
        }
        if (bl && !ConfirmDeletionPanel.show(collection, collection2)) {
            return;
        }
        DeleteSupport.notifyComponentsDeleting(designDocument.getRootComponent(), Collections.unmodifiableCollection(collection2));
        for (DesignComponent designComponent : collection2) {
            for (DeletePresenter deletePresenter : designComponent.getPresenters(DeletePresenter.class)) {
                deletePresenter.delete();
            }
        }
        designDocument.deleteComponents(collection2);
    }
}

