/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model.common;

import java.awt.datatransfer.Transferable;
import java.util.Collections;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.common.AcceptPresenter;
import org.netbeans.modules.vmd.api.model.common.AcceptSuggestion;
import org.netbeans.modules.vmd.api.model.common.DefaultDataFlavor;

public final class AcceptSupport {
    private AcceptSupport() {
    }

    public static boolean isAcceptable(DesignComponent designComponent, Transferable transferable, AcceptSuggestion acceptSuggestion) {
        if (designComponent == null || transferable == null) {
            return false;
        }
        ComponentProducer componentProducer = DefaultDataFlavor.decodeFromDataFlavors(designComponent.getDocument(), transferable);
        for (AcceptPresenter acceptPresenter : designComponent.getPresenters(AcceptPresenter.class)) {
            switch (acceptPresenter.getKind()) {
                case COMPONENT_PRODUCER: {
                    if (componentProducer == null || !acceptPresenter.isAcceptable(componentProducer, acceptSuggestion)) break;
                    return true;
                }
                case TRANSFERABLE: {
                    if (!acceptPresenter.isAcceptable(transferable, acceptSuggestion)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public static ComponentProducer.Result accept(DesignComponent designComponent, Transferable transferable, AcceptSuggestion acceptSuggestion) {
        if (designComponent == null || transferable == null) {
            return null;
        }
        ComponentProducer componentProducer = DefaultDataFlavor.decodeFromDataFlavors(designComponent.getDocument(), transferable);
        for (AcceptPresenter acceptPresenter : designComponent.getPresenters(AcceptPresenter.class)) {
            switch (acceptPresenter.getKind()) {
                case COMPONENT_PRODUCER: {
                    if (componentProducer == null || !acceptPresenter.isAcceptable(componentProducer, acceptSuggestion)) break;
                    return acceptPresenter.accept(componentProducer, acceptSuggestion);
                }
                case TRANSFERABLE: {
                    if (!acceptPresenter.isAcceptable(transferable, acceptSuggestion)) break;
                    return acceptPresenter.accept(transferable, acceptSuggestion);
                }
            }
        }
        return null;
    }

    public static boolean isAcceptable(DesignComponent designComponent, ComponentProducer componentProducer, AcceptSuggestion acceptSuggestion) {
        if (designComponent == null || componentProducer == null) {
            return false;
        }
        for (AcceptPresenter acceptPresenter : designComponent.getPresenters(AcceptPresenter.class)) {
            switch (acceptPresenter.getKind()) {
                case COMPONENT_PRODUCER: {
                    if (!acceptPresenter.isAcceptable(componentProducer, acceptSuggestion)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public static ComponentProducer.Result accept(DesignComponent designComponent, ComponentProducer componentProducer, AcceptSuggestion acceptSuggestion) {
        if (designComponent == null || componentProducer == null) {
            return null;
        }
        for (AcceptPresenter acceptPresenter : designComponent.getPresenters(AcceptPresenter.class)) {
            switch (acceptPresenter.getKind()) {
                case COMPONENT_PRODUCER: {
                    if (!acceptPresenter.isAcceptable(componentProducer, acceptSuggestion)) break;
                    return acceptPresenter.accept(componentProducer, acceptSuggestion);
                }
            }
        }
        return null;
    }

    public static void selectComponentProducerResult(ComponentProducer.Result result) {
        DesignComponent designComponent;
        DesignComponent designComponent2 = designComponent = result != null ? result.getMainComponent() : null;
        if (designComponent != null) {
            designComponent.getDocument().setSelectedComponents("accept", Collections.singleton(designComponent));
        }
    }
}

