/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.reformat;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.reformat.BracesStack;
import org.netbeans.modules.cnd.editor.reformat.DiffLinkedList;
import org.netbeans.modules.cnd.editor.reformat.ExtendedTokenSequence;
import org.netbeans.modules.cnd.editor.reformat.Reformatter;
import org.netbeans.modules.cnd.editor.reformat.ReformatterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreprocessorFormatter {
    private ReformatterImpl context;
    private final ExtendedTokenSequence ts;
    private final CodeStyle codeStyle;
    private final DiffLinkedList diffs;
    private int prepocessorDepth = 0;
    private Stack<PreprocessorStateStack> stateStack = new Stack();
    private BracesStack braces;

    PreprocessorFormatter(ReformatterImpl reformatterImpl) {
        this.context = reformatterImpl;
        this.ts = reformatterImpl.ts;
        this.codeStyle = reformatterImpl.codeStyle;
        this.diffs = reformatterImpl.diffs;
        this.braces = reformatterImpl.braces;
    }

    void indentPreprocessor(Token<CppTokenId> token) {
        TokenSequence tokenSequence = this.ts.embedded(CppTokenId.languagePreproc());
        if (tokenSequence == null) {
            return;
        }
        tokenSequence.moveStart();
        while (tokenSequence.moveNext() && (tokenSequence.token().id() == CppTokenId.WHITESPACE || tokenSequence.token().id() == CppTokenId.PREPROCESSOR_START)) {
        }
        Token token2 = null;
        boolean bl = false;
        if (tokenSequence.token() != null) {
            token2 = tokenSequence.token();
        }
        PreprocessorStateStack preprocessorStateStack = null;
        if (token2 != null) {
            switch ((CppTokenId)token2.id()) {
                case PREPROCESSOR_ELSE: 
                case PREPROCESSOR_ELIF: {
                    --this.prepocessorDepth;
                    if (this.stateStack.empty()) break;
                    preprocessorStateStack = this.stateStack.pop();
                    preprocessorStateStack.outputStack.add(this.braces.clone());
                    this.braces.reset(preprocessorStateStack.inputStack);
                    break;
                }
                case PREPROCESSOR_ENDIF: {
                    --this.prepocessorDepth;
                    if (this.stateStack.empty()) break;
                    preprocessorStateStack = this.stateStack.pop();
                    preprocessorStateStack.outputStack.add(this.braces.clone());
                    this.braces.reset(preprocessorStateStack.getBestOutputStack());
                }
            }
            if (this.context.doFormat()) {
                while (tokenSequence.movePrevious()) {
                    if (tokenSequence.token().id() != CppTokenId.PREPROCESSOR_START) continue;
                    bl = true;
                    break;
                }
            }
        }
        if (bl) {
            this.selectPreprocessorIndent(token, tokenSequence);
        }
        if (token2 != null) {
            switch ((CppTokenId)token2.id()) {
                case PREPROCESSOR_IF: 
                case PREPROCESSOR_IFDEF: 
                case PREPROCESSOR_IFNDEF: {
                    ++this.prepocessorDepth;
                    this.stateStack.push(new PreprocessorStateStack(this.braces.clone()));
                    break;
                }
                case PREPROCESSOR_ELSE: 
                case PREPROCESSOR_ELIF: {
                    ++this.prepocessorDepth;
                    if (preprocessorStateStack != null) {
                        this.stateStack.push(preprocessorStateStack);
                        break;
                    }
                    this.stateStack.push(new PreprocessorStateStack(this.braces.clone()));
                }
            }
        }
    }

    private void selectPreprocessorIndent(Token<CppTokenId> token, TokenSequence<CppTokenId> tokenSequence) {
        Token token2 = null;
        if (tokenSequence.moveNext()) {
            token2 = tokenSequence.token();
            tokenSequence.movePrevious();
        }
        switch (this.codeStyle.indentPreprocessorDirectives()) {
            case CODE_INDENT: {
                this.indentByCode(token, tokenSequence, (Token<CppTokenId>)token2);
                break;
            }
            case START_LINE: {
                this.noIndent(token, tokenSequence, (Token<CppTokenId>)token2);
                break;
            }
            case PREPROCESSOR_INDENT: {
                this.indentByPreprocessor(token, tokenSequence, (Token<CppTokenId>)token2);
            }
        }
    }

    private void noIndent(Token<CppTokenId> token, TokenSequence<CppTokenId> tokenSequence, Token<CppTokenId> token2) {
        this.indentBefore(token, 0, false);
        this.indentAfter(tokenSequence, token2, 0);
    }

    private void indentBefore(Token<CppTokenId> token, int n, boolean bl) {
        DiffLinkedList.DiffResult diffResult = this.diffs.getDiffs(this.ts, -1);
        if (diffResult != null) {
            if (diffResult.after != null) {
                diffResult.after.replaceSpaces(n, bl);
                if (diffResult.replace != null && !diffResult.after.hasNewLine()) {
                    diffResult.replace.replaceSpaces(0, false);
                }
                return;
            }
            if (diffResult.replace != null) {
                diffResult.replace.replaceSpaces(n, bl);
                return;
            }
        }
        if (token != null && token.id() == CppTokenId.WHITESPACE) {
            if (!Reformatter.Diff.equals(((Object)token.text()).toString(), 0, n, bl)) {
                this.ts.replacePrevious(token, 0, n, bl);
            }
        } else if (n > 0) {
            this.ts.addBeforeCurrent(0, n, bl);
        }
    }

    private void indentAfter(TokenSequence<CppTokenId> tokenSequence, Token<CppTokenId> token, int n) {
        if (token.id() == CppTokenId.WHITESPACE) {
            if (!Reformatter.Diff.equals(((Object)token.text()).toString(), 0, n, false)) {
                this.diffs.addFirst(tokenSequence.offset() + tokenSequence.token().length(), tokenSequence.offset() + tokenSequence.token().length() + token.length(), 0, n, false);
            }
        } else if (n > 0) {
            this.diffs.addFirst(tokenSequence.offset() + tokenSequence.token().length(), tokenSequence.offset() + tokenSequence.token().length(), 0, n, false);
        }
    }

    private void indentByCode(Token<CppTokenId> token, TokenSequence<CppTokenId> tokenSequence, Token<CppTokenId> token2) {
        if (this.codeStyle.sharpAtStartLine()) {
            this.indentBefore(token, 0, false);
            this.indentAfter(tokenSequence, token2, this.context.getIndent());
        } else {
            this.indentBefore(token, this.context.getIndent(), true);
            this.indentAfter(tokenSequence, token2, 0);
        }
    }

    private void indentByPreprocessor(Token<CppTokenId> token, TokenSequence<CppTokenId> tokenSequence, Token<CppTokenId> token2) {
        if (this.codeStyle.sharpAtStartLine()) {
            this.indentBefore(token, 0, false);
            this.indentAfter(tokenSequence, token2, this.getPreprocessorIndent(this.prepocessorDepth));
        } else {
            this.indentBefore(token, this.getPreprocessorIndent(this.prepocessorDepth), true);
            this.indentAfter(tokenSequence, token2, 0);
        }
    }

    private int getPreprocessorIndent(int n) {
        if (n > 0) {
            if (this.codeStyle.getFormatNewlineBeforeBrace() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED) {
                return n * (this.codeStyle.indentSize() / 2);
            }
            return n * this.codeStyle.indentSize();
        }
        return 0;
    }

    private static class PreprocessorStateStack {
        private BracesStack inputStack;
        private List<BracesStack> outputStack = new ArrayList<BracesStack>();

        private PreprocessorStateStack(BracesStack bracesStack) {
            this.inputStack = bracesStack;
        }

        private BracesStack getBestOutputStack() {
            if (this.outputStack.size() > 0) {
                BracesStack bracesStack = null;
                int n = Integer.MAX_VALUE;
                BracesStack bracesStack2 = null;
                int n2 = Integer.MIN_VALUE;
                int n3 = this.inputStack.getLength();
                for (BracesStack bracesStack3 : this.outputStack) {
                    int n4 = bracesStack3.getLength();
                    if (n4 < n3) {
                        if (n4 > n) continue;
                        bracesStack = bracesStack3;
                        n = n4;
                        continue;
                    }
                    if (n4 <= n3 || n4 < n2) continue;
                    bracesStack2 = bracesStack3;
                    n2 = n4;
                }
                if (bracesStack != null && bracesStack2 == null) {
                    return bracesStack;
                }
                if (bracesStack2 != null) {
                    return bracesStack2;
                }
                return this.outputStack.get(this.outputStack.size() - 1);
            }
            return this.inputStack;
        }
    }
}

