/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.indent;

import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CppTokenId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenItem {
    private final int index;
    private final CppTokenId tokenId;
    protected final TokenSequence<CppTokenId> tokenSeq;
    private final boolean skipPP;

    public TokenItem(TokenSequence<CppTokenId> tokenSequence, boolean bl) {
        this.index = tokenSequence.index();
        this.tokenId = (CppTokenId)tokenSequence.token().id();
        this.tokenSeq = tokenSequence;
        this.skipPP = bl;
    }

    public TokenSequence<CppTokenId> getTokenSequence() {
        return this.tokenSeq;
    }

    private void go() {
        this.tokenSeq.moveIndex(this.index);
        this.tokenSeq.moveNext();
    }

    public CppTokenId getTokenID() {
        return this.tokenId;
    }

    public int index() {
        return this.index;
    }

    public TokenItem getNext() {
        this.go();
        while (this.tokenSeq.moveNext()) {
            if (this.skipPP && this.tokenSeq.token().id() == CppTokenId.PREPROCESSOR_DIRECTIVE) continue;
            return new TokenItem(this.tokenSeq, this.skipPP);
        }
        return null;
    }

    public TokenItem getPrevious() {
        this.go();
        while (this.tokenSeq.movePrevious()) {
            if (this.skipPP && this.tokenSeq.token().id() == CppTokenId.PREPROCESSOR_DIRECTIVE) continue;
            return new TokenItem(this.tokenSeq, this.skipPP);
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object instanceof TokenItem) {
            return ((TokenItem)object).index == this.index;
        }
        return false;
    }

    public int hashCode() {
        int n = 5;
        n = 43 * n + this.index;
        n = 43 * n + (this.tokenId != null ? this.tokenId.hashCode() : 0);
        return n;
    }

    public String toString() {
        return this.tokenId + "(" + this.index + ")";
    }
}

