/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.gsf;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.SemanticAnalyzer;
import org.netbeans.modules.css.gsf.CssAnalyser;
import org.netbeans.modules.css.gsf.CssGSFParser;
import org.netbeans.modules.css.gsf.api.CssParserResult;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssSemanticAnalyzer
extends SemanticAnalyzer {
    private boolean cancelled;
    private Map<OffsetRange, Set<ColoringAttributes>> semanticHighlights;

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights() {
        return this.semanticHighlights;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public void run(Parser.Result result, SchedulerEvent schedulerEvent) {
        this.cancelled = false;
        if (this.cancelled) {
            return;
        }
        final HashMap<OffsetRange, Set<ColoringAttributes>> hashMap = new HashMap<OffsetRange, Set<ColoringAttributes>>();
        SimpleNode simpleNode = ((CssParserResult)result).root();
        final Snapshot snapshot = result.getSnapshot();
        if (simpleNode == null) {
            this.semanticHighlights = hashMap;
            return;
        }
        NodeVisitor nodeVisitor = new NodeVisitor(){

            public void visit(SimpleNode simpleNode) {
                if (simpleNode.kind() == 24 || simpleNode.kind() == 23 || simpleNode.kind() == 26 || simpleNode.kind() == 27 || simpleNode.kind() == 25) {
                    int n = snapshot.getOriginalOffset(simpleNode.startOffset());
                    int n2 = snapshot.getOriginalOffset(simpleNode.endOffset());
                    if (n >= 0 && n2 >= 0) {
                        OffsetRange offsetRange = new OffsetRange(n, n2);
                        hashMap.put(offsetRange, ColoringAttributes.METHOD_SET);
                    }
                } else if (simpleNode.kind() == 18) {
                    int n = snapshot.getOriginalOffset(simpleNode.startOffset());
                    int n3 = snapshot.getOriginalOffset(simpleNode.endOffset());
                    if (n >= 0 && n3 >= 0) {
                        OffsetRange offsetRange = new OffsetRange(n, n3);
                        String string = simpleNode.image().trim();
                        if (CssGSFParser.containsGeneratedCode(string)) {
                            return;
                        }
                        if (CssAnalyser.isVendorSpecificProperty(string)) {
                            hashMap.put(offsetRange, ColoringAttributes.CUSTOM2_SET);
                        } else {
                            hashMap.put(offsetRange, ColoringAttributes.CUSTOM1_SET);
                        }
                    }
                }
            }
        };
        simpleNode.visitChildren(nodeVisitor);
        this.semanticHighlights = hashMap;
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return null;
    }
}

