/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.gsf;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.KeystrokeHandler;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.css.editor.LexerUtils;
import org.netbeans.modules.css.gsf.api.CssParserResult;
import org.netbeans.modules.css.lexer.api.CssTokenId;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.css.parser.SimpleNodeUtil;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.parsing.api.Snapshot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssBracketCompleter
implements KeystrokeHandler {
    private static final char[][] PAIRS = new char[][]{{'{', '}'}, {'\"', '\"'}, {'\'', '\''}};
    private char justAddedPair;
    private int justAddedPairOffset = -1;

    private int pairIndex(char c) {
        for (int i = 0; i < PAIRS.length; ++i) {
            char c2 = PAIRS[i][0];
            if (c2 != c) continue;
            return i;
        }
        return -1;
    }

    public boolean beforeCharInserted(Document document, int n, JTextComponent jTextComponent, char c) throws BadLocationException {
        TokenSequence<CssTokenId> tokenSequence;
        int n2;
        TokenSequence<CssTokenId> tokenSequence2;
        Caret caret = jTextComponent.getCaret();
        if (this.justAddedPair == c && this.justAddedPairOffset == n) {
            this.justAddedPair = '\u0000';
            this.justAddedPairOffset = -1;
            caret.setDot(n + 1);
            return true;
        }
        this.justAddedPair = '\u0000';
        this.justAddedPairOffset = -1;
        if (c == '}' && (tokenSequence2 = LexerUtils.getCssTokenSequence(document, n)) != null) {
            tokenSequence2.move(n);
            if (tokenSequence2.moveNext() && tokenSequence2.token().id() == CssTokenId.RBRACE) {
                caret.setDot(n + 1);
                return true;
            }
        }
        if ((n2 = this.pairIndex(c)) == -1) {
            return false;
        }
        if (jTextComponent.getSelectionStart() != n) {
            return false;
        }
        if ((c == '\'' || c == '\"') && (tokenSequence = LexerUtils.getCssTokenSequence(document, n)) != null) {
            Token token;
            int n3 = tokenSequence.move(n);
            if (tokenSequence.moveNext() && (token = tokenSequence.token()).id() == CssTokenId.STRING) {
                char c2 = token.text().charAt(n3);
                if (c2 == c) {
                    caret.setDot(n + 1);
                    return true;
                }
                return false;
            }
            tokenSequence.move(n);
            while (tokenSequence.movePrevious()) {
                token = tokenSequence.token();
                if (token.text().charAt(0) == c) {
                    if (token.id() == CssTokenId.STRING || token.id() == CssTokenId.STRING1 || token.id() == CssTokenId.STRING2) break;
                    return false;
                }
                if (token.id() != CssTokenId.LBRACE && token.id() != CssTokenId.RBRACE && token.id() != CssTokenId.SEMICOLON) continue;
                break;
            }
        }
        this.justAddedPair = PAIRS[n2][1];
        this.justAddedPairOffset = n + 1;
        document.insertString(n, String.valueOf(PAIRS[n2][0]), null);
        document.insertString(n + 1, String.valueOf(this.justAddedPair), null);
        caret.setDot(n + 1);
        return true;
    }

    public boolean afterCharInserted(Document document, int n, JTextComponent jTextComponent, char c) throws BadLocationException {
        if ('}' != c) {
            return false;
        }
        int n2 = Utilities.getRowFirstNonWhite((BaseDocument)((BaseDocument)document), (int)n);
        if (n2 != n) {
            return false;
        }
        this.reindentLater((BaseDocument)document, n);
        return false;
    }

    public boolean charBackspaced(Document document, int n, JTextComponent jTextComponent, char c) throws BadLocationException {
        if (this.justAddedPairOffset - 1 == n) {
            document.remove(n, 1);
        }
        this.justAddedPair = '\u0000';
        this.justAddedPairOffset = -1;
        return false;
    }

    public int beforeBreak(Document document, int n, JTextComponent jTextComponent) throws BadLocationException {
        if (n == 0 || n == document.getLength()) {
            return -1;
        }
        String string = document.getText(n - 1, 2);
        if ("{}".equals(string)) {
            BaseDocument baseDocument = (BaseDocument)document;
            document.insertString(n, "\n", null);
            jTextComponent.getCaret().setDot(n);
            this.reindentLater(baseDocument, n);
        }
        return -1;
    }

    public OffsetRange findMatching(Document document, int n) {
        return OffsetRange.NONE;
    }

    public List<OffsetRange> findLogicalRanges(ParserResult parserResult, int n) {
        SimpleNode simpleNode;
        ArrayList<OffsetRange> arrayList = new ArrayList<OffsetRange>(2);
        SimpleNode simpleNode2 = ((CssParserResult)parserResult).root();
        Snapshot snapshot = parserResult.getSnapshot();
        if (simpleNode2 != null && (simpleNode = SimpleNodeUtil.findDescendant(simpleNode2, snapshot.getEmbeddedOffset(n))) != null) {
            do {
                OffsetRange offsetRange;
                int n2 = snapshot.getOriginalOffset(simpleNode.startOffset());
                int n3 = snapshot.getOriginalOffset(simpleNode.endOffset());
                if (n2 == -1 || n3 == -1) continue;
                OffsetRange offsetRange2 = offsetRange = arrayList.isEmpty() ? null : arrayList.get(arrayList.size() - 1);
                if (offsetRange != null && offsetRange.getEnd() - offsetRange.getStart() >= n3 - n2) continue;
                arrayList.add(new OffsetRange(n2, n3));
            } while ((simpleNode = (SimpleNode)simpleNode.jjtGetParent()) != null);
        }
        return arrayList;
    }

    public int getNextWordOffset(Document document, int n, boolean bl) {
        return -1;
    }

    private void reindentLater(final BaseDocument baseDocument, int n) throws BadLocationException {
        final Position position = baseDocument.createPosition(Utilities.getRowStart((BaseDocument)baseDocument, (int)n));
        final Position position2 = baseDocument.createPosition(Utilities.getRowEnd((BaseDocument)baseDocument, (int)n));
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                final Indent indent = Indent.get((Document)baseDocument);
                indent.lock();
                try {
                    baseDocument.runAtomic(new Runnable(){

                        public void run() {
                            try {
                                indent.reindent(position.getOffset(), position2.getOffset());
                                System.out.println("formatted");
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                    });
                }
                finally {
                    indent.unlock();
                }
            }
        });
    }
}

