/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.formatting.api.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.css.formatting.api.LexUtilities;
import org.netbeans.modules.css.formatting.api.embedding.JoinedTokenSequence;
import org.netbeans.modules.css.formatting.api.support.AbstractIndenter;
import org.netbeans.modules.css.formatting.api.support.IndentCommand;
import org.netbeans.modules.css.formatting.api.support.IndenterContextData;
import org.netbeans.modules.editor.indent.spi.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MarkupAbstractIndenter<T1 extends TokenId>
extends AbstractIndenter<T1> {
    private Stack<MarkupItem> stack = null;
    private List<EliminatedTag> eliminatedTags;
    private boolean inOpeningTagAttributes;
    private boolean inUnformattableTagContent;
    private String unformattableTagName = null;
    private int attributesIndent;
    private int firstPreservedLineIndent = -1;

    public MarkupAbstractIndenter(Language<T1> language, Context context) {
        super(language, context);
    }

    protected abstract boolean isOpenTagNameToken(Token<T1> var1);

    protected abstract boolean isCloseTagNameToken(Token<T1> var1);

    protected abstract boolean isStartTagSymbol(Token<T1> var1);

    protected abstract boolean isStartTagClosingSymbol(Token<T1> var1);

    protected abstract boolean isEndTagSymbol(Token<T1> var1);

    protected abstract boolean isEndTagClosingSymbol(Token<T1> var1);

    protected abstract boolean isTagArgumentToken(Token<T1> var1);

    protected abstract boolean isBlockCommentToken(Token<T1> var1);

    protected abstract boolean isTagContentToken(Token<T1> var1);

    protected abstract boolean isClosingTagOptional(String var1);

    protected abstract boolean isOpeningTagOptional(String var1);

    protected abstract Boolean isEmptyTag(String var1);

    protected abstract boolean isTagContentUnformattable(String var1);

    protected abstract Set<String> getTagChildren(String var1);

    protected abstract boolean isPreservedLine(Token<T1> var1, IndenterContextData<T1> var2);

    protected abstract int getPreservedLineInitialIndentation(JoinedTokenSequence<T1> var1) throws BadLocationException;

    protected boolean isStableFormattingStartToken(Token<T1> token, JoinedTokenSequence<T1> joinedTokenSequence) {
        return false;
    }

    protected abstract boolean isForeignLanguageStartToken(Token<T1> var1, JoinedTokenSequence<T1> var2);

    protected abstract boolean isForeignLanguageEndToken(Token<T1> var1, JoinedTokenSequence<T1> var2);

    private Stack<MarkupItem> getStack() {
        return this.stack;
    }

    @Override
    protected void reset() {
        this.stack = new Stack();
        this.inOpeningTagAttributes = false;
        this.inUnformattableTagContent = false;
        this.attributesIndent = 0;
        this.eliminatedTags = new ArrayList<EliminatedTag>();
    }

    @Override
    protected int getFormatStableStart(JoinedTokenSequence<T1> joinedTokenSequence, int n, int n2, AbstractIndenter.OffsetRanges offsetRanges) throws BadLocationException {
        Token<T1> token;
        Token<T1> token2;
        joinedTokenSequence.move(n2, false);
        while (joinedTokenSequence.movePrevious() && (!this.isStableFormattingStartToken(token2 = joinedTokenSequence.token(), joinedTokenSequence) || joinedTokenSequence.offset() > n)) {
            if (this.isCloseTagNameToken(token2) && !this.isClosingTagOptional(this.getTokenName(token2)) && !this.isOpeningTagOptional(this.getTokenName(token2))) {
                this.moveToOpeningTag(joinedTokenSequence);
                continue;
            }
            if (!this.isOpenTagNameToken(token2) || this.isClosingTagOptional(this.getTokenName(token2)) || joinedTokenSequence.offset() >= n) continue;
            break;
        }
        int n3 = -1;
        while ((token = joinedTokenSequence.token()) != null) {
            int n4;
            if ((this.isStartTagSymbol(token) || this.isStableFormattingStartToken(token, joinedTokenSequence)) && (n4 = Utilities.getRowFirstNonWhite((BaseDocument)this.getDocument(), (int)joinedTokenSequence.offset())) != -1 && n4 == joinedTokenSequence.offset()) {
                n3 = joinedTokenSequence.offset();
                break;
            }
            if (joinedTokenSequence.movePrevious()) continue;
        }
        if (n3 == -1) {
            n3 = LexUtilities.getTokenSequenceStartOffset(joinedTokenSequence);
        }
        this.eliminateUnnecessaryTags(joinedTokenSequence, n, n3, offsetRanges);
        return n3;
    }

    private void eliminateUnnecessaryTags(JoinedTokenSequence<T1> joinedTokenSequence, int n, int n2, AbstractIndenter.OffsetRanges offsetRanges) throws BadLocationException {
        joinedTokenSequence.move(n, false);
        while (joinedTokenSequence.movePrevious()) {
            int n3;
            int n4;
            int n5;
            int n6;
            Token<T1> token = joinedTokenSequence.token();
            if (joinedTokenSequence.offset() < n2) break;
            if (!this.isCloseTagNameToken(token) || this.isClosingTagOptional(this.getTokenName(token)) || this.isOpeningTagOptional(this.getTokenName(token))) continue;
            String string = this.getTokenName(token);
            if (joinedTokenSequence.moveNext() && this.isEndTagSymbol(joinedTokenSequence.token())) {
                assert (this.isEndTagSymbol(joinedTokenSequence.token())) : "token=" + joinedTokenSequence.token() + " ts=" + joinedTokenSequence;
                n6 = joinedTokenSequence.offset() + this.getTokenName(joinedTokenSequence.token()).length();
                joinedTokenSequence.movePrevious();
            } else {
                n6 = joinedTokenSequence.offset() + this.getTokenName(joinedTokenSequence.token()).length();
            }
            if (!this.moveToOpeningTag(joinedTokenSequence)) continue;
            assert (this.getTokenName(joinedTokenSequence.token()).equalsIgnoreCase(string)) : "tag=" + string + " token=" + joinedTokenSequence.token();
            if (joinedTokenSequence.movePrevious() && this.isStartTagSymbol(joinedTokenSequence.token())) {
                assert (this.isStartTagSymbol(joinedTokenSequence.token())) : "token=" + joinedTokenSequence.token() + " ts=" + joinedTokenSequence;
                n5 = joinedTokenSequence.offset();
            } else {
                n5 = joinedTokenSequence.offset();
            }
            if (n5 >= n6 || (n4 = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)n5)) == (n3 = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)n6))) continue;
            offsetRanges.add(n5, n6);
            this.eliminatedTags.add(0, new EliminatedTag(n5, n6, string));
        }
    }

    private final MarkupItem createMarkupItem(Token<T1> token, boolean bl, int n) {
        String string = this.getTokenName(token);
        if (bl) {
            boolean bl2 = this.isClosingTagOptional(this.getTokenName(token));
            Set<String> set = null;
            Boolean bl3 = this.isEmptyTag(string);
            if (bl2 && bl3 != null && !bl3.booleanValue()) {
                set = this.getTagChildren(string);
            }
            return new MarkupItem(string, true, n, bl2, set, bl3 != null ? bl3 : false, false, false);
        }
        Boolean bl4 = this.isEmptyTag(string);
        return new MarkupItem(string, false, n, false, null, bl4 != null ? bl4 : false, false, false);
    }

    private static MarkupItem createVirtualMarkupItem(String string, boolean bl) {
        return new MarkupItem(string, false, -1, false, null, bl, true, false);
    }

    private static MarkupItem createEliminatedMarkupItem(String string, boolean bl) {
        return new MarkupItem(string, bl, -1, false, null, false, false, true);
    }

    private boolean moveToOpeningTag(JoinedTokenSequence<T1> joinedTokenSequence) {
        int n = joinedTokenSequence.index();
        String string = this.getTokenName(joinedTokenSequence.token());
        int n2 = 0;
        while (joinedTokenSequence.movePrevious()) {
            Token<T1> token = joinedTokenSequence.token();
            if (!this.isOpenTagNameToken(token) && !this.isCloseTagNameToken(token) || !string.equalsIgnoreCase(this.getTokenName(token))) continue;
            if (this.isOpenTagNameToken(token)) {
                if (n2 == 0) {
                    return true;
                }
                --n2;
                continue;
            }
            if (!this.isCloseTagNameToken(token)) continue;
            ++n2;
        }
        joinedTokenSequence.moveIndex(n);
        joinedTokenSequence.movePrevious();
        return false;
    }

    private void getIndentFromState(List<IndentCommand> list, boolean bl, int n) {
        Stack<MarkupItem> stack = this.getStack();
        int n2 = stack.size();
        int n3 = stack.size() - 1;
        while (n3 >= 0 && !((MarkupItem)stack.get((int)n3)).processed) {
            n2 = n3--;
        }
        ArrayList<MarkupItem> arrayList = new ArrayList<MarkupItem>();
        for (int i = n2; i < stack.size(); ++i) {
            MarkupItem markupItem = (MarkupItem)stack.get(i);
            assert (!markupItem.processed) : markupItem;
            boolean bl2 = true;
            if (i + 1 == stack.size() && this.inOpeningTagAttributes) {
                assert (markupItem.openingTag) : this.dumpMoreDiagnosticToResolveIssue162700(stack);
                break;
            }
            if (!markupItem.empty) {
                IndentCommand indentCommand = new IndentCommand(markupItem.openingTag ? IndentCommand.Type.INDENT : IndentCommand.Type.RETURN, n);
                bl2 = this.addIndentationCommand(list, indentCommand, markupItem, arrayList);
            }
            if (bl) {
                markupItem.processed = true;
            }
            if (!bl2) continue;
            arrayList.add(markupItem);
        }
        if (this.inOpeningTagAttributes) {
            IndentCommand indentCommand = new IndentCommand(IndentCommand.Type.CONTINUE, n);
            if (this.getAttributesIndent() != -1) {
                indentCommand.setFixedIndentSize(this.getAttributesIndent());
            }
            list.add(indentCommand);
        }
        if (bl) {
            this.removeFullyProcessedTags();
        }
    }

    private String dumpMoreDiagnosticToResolveIssue162700(Stack<MarkupItem> stack) {
        int n = stack.size() - 6;
        if (n < 0) {
            n = 0;
        }
        StringBuilder stringBuilder = new StringBuilder("diagnostic dump: ");
        ListIterator listIterator = stack.listIterator(n);
        while (listIterator.hasNext()) {
            MarkupItem markupItem = (MarkupItem)listIterator.next();
            stringBuilder.append(markupItem.toString() + " ");
        }
        return stringBuilder.toString();
    }

    private boolean addIndentationCommand(List<IndentCommand> list, IndentCommand indentCommand, MarkupItem markupItem, List<MarkupItem> list2) {
        IndentCommand indentCommand2;
        MarkupItem markupItem2;
        MarkupItem markupItem3 = markupItem2 = list2.size() > 0 ? list2.get(list2.size() - 1) : null;
        if (indentCommand.getType() == IndentCommand.Type.RETURN && list.size() > 0 && markupItem2 != null && (indentCommand2 = list.get(list.size() - 1)).getType() == IndentCommand.Type.INDENT && markupItem2.tagName.equals(markupItem.tagName) && markupItem2.openingTag && !markupItem.openingTag) {
            list.remove(list.size() - 1);
            list2.remove(list2.size() - 1);
            return false;
        }
        list.add(indentCommand);
        return true;
    }

    @Override
    protected List<IndentCommand> getLineIndent(IndenterContextData<T1> indenterContextData, List<IndentCommand> list) throws BadLocationException {
        Object object;
        Token<T1> token;
        this.processEliminatedTags(indenterContextData.getLineStartOffset());
        Stack<MarkupItem> stack = this.getStack();
        ArrayList<IndentCommand> arrayList = new ArrayList<IndentCommand>();
        this.getIndentFromState(arrayList, true, indenterContextData.getLineStartOffset());
        JoinedTokenSequence<T1> joinedTokenSequence = indenterContextData.getJoinedTokenSequences();
        joinedTokenSequence.move(indenterContextData.getLineStartOffset());
        ArrayList<MarkupItem> arrayList2 = new ArrayList<MarkupItem>();
        String string = null;
        boolean bl = this.isInUnformattableTagContent();
        while (!indenterContextData.isBlankLine() && joinedTokenSequence.moveNext() && (joinedTokenSequence.isCurrentTokenSequenceVirtual() && joinedTokenSequence.offset() < indenterContextData.getLineEndOffset() || joinedTokenSequence.offset() <= indenterContextData.getLineEndOffset())) {
            token = joinedTokenSequence.token();
            if (token == null || joinedTokenSequence.embedded() != null) continue;
            if (this.isOpenTagNameToken(token)) {
                arrayList2.add(this.createMarkupItem(token, true, this.getIndentationSize()));
                this.setInOpeningTagAttributes(true);
                string = this.getTokenName(token);
            } else if (this.isTagArgumentToken(token) && this.getAttributesIndent() == -1) {
                int n = joinedTokenSequence.index();
                int n2 = joinedTokenSequence.offset();
                joinedTokenSequence.movePrevious();
                object = this.findPreviousNonWhiteSpaceToken(joinedTokenSequence);
                if (this.isOpenTagNameToken((Token<T1>)object)) {
                    this.setAttributesIndent(n2 - indenterContextData.getLineNonWhiteStartOffset());
                }
                joinedTokenSequence.moveIndex(n);
                joinedTokenSequence.moveNext();
            } else if (this.isCloseTagNameToken(token)) {
                arrayList2.add(this.createMarkupItem(token, false, this.getIndentationSize()));
                String string2 = this.getTokenName(token);
                if (this.isTagContentUnformattable(string2) && string2.equals(this.unformattableTagName)) {
                    this.setInUnformattableTagContent(false);
                    if (bl && indenterContextData.getLineStartOffset() + 2 == joinedTokenSequence.offset()) {
                        bl = false;
                    }
                }
                string = null;
            } else if (this.isEndTagSymbol(token) || this.isEndTagClosingSymbol(token)) {
                if (this.isInOpeningTagAttributes()) {
                    this.setInOpeningTagAttributes(false);
                }
                if (this.isEndTagClosingSymbol(token)) {
                    MarkupItem markupItem = null;
                    if (arrayList2.size() > 0) {
                        markupItem = (MarkupItem)arrayList2.get(arrayList2.size() - 1);
                    } else if (stack.size() > 0) {
                        markupItem = stack.peek();
                    }
                    if (markupItem != null) {
                        arrayList2.add(MarkupAbstractIndenter.createVirtualMarkupItem(markupItem.tagName, markupItem.empty));
                    } else assert (false) : "token:" + token + " ts=" + joinedTokenSequence;
                } else if (string != null && !this.isInUnformattableTagContent() && this.isTagContentUnformattable(string)) {
                    this.setInUnformattableTagContent(true, string);
                }
            }
            if (this.isPreservedLine(token, indenterContextData)) {
                if (this.firstPreservedLineIndent == -1) {
                    this.firstPreservedLineIndent = this.getPreservedLineInitialIndentation(joinedTokenSequence);
                }
                IndentCommand indentCommand = new IndentCommand(IndentCommand.Type.PRESERVE_INDENTATION, indenterContextData.getLineStartOffset());
                indentCommand.setFixedIndentSize(this.firstPreservedLineIndent);
                arrayList.add(indentCommand);
            } else {
                this.firstPreservedLineIndent = -1;
            }
            if (this.isForeignLanguageStartToken(token, joinedTokenSequence)) {
                arrayList.add(new IndentCommand(IndentCommand.Type.BLOCK_START, indenterContextData.getLineStartOffset()));
                continue;
            }
            if (!this.isForeignLanguageEndToken(token, joinedTokenSequence)) continue;
            arrayList.add(new IndentCommand(IndentCommand.Type.BLOCK_END, indenterContextData.getLineStartOffset()));
        }
        if (indenterContextData.isBlankLine() && arrayList.isEmpty() && joinedTokenSequence.moveNext() && (token = joinedTokenSequence.token()) != null && joinedTokenSequence.embedded() == null && this.isPreservedLine(token, indenterContextData)) {
            IndentCommand indentCommand = new IndentCommand(IndentCommand.Type.PRESERVE_INDENTATION, indenterContextData.getLineStartOffset());
            if (this.firstPreservedLineIndent == -1) {
                this.firstPreservedLineIndent = this.getPreservedLineInitialIndentation(joinedTokenSequence);
            }
            indentCommand.setFixedIndentSize(this.firstPreservedLineIndent);
            arrayList.add(indentCommand);
        }
        if (bl) {
            arrayList.add(new IndentCommand(IndentCommand.Type.DO_NOT_INDENT_THIS_LINE, indenterContextData.getLineStartOffset()));
        }
        int n = stack.size();
        this.addTags(arrayList2);
        if (!indenterContextData.isBlankLine()) {
            joinedTokenSequence.move(indenterContextData.getLineNonWhiteStartOffset());
            if (joinedTokenSequence.moveNext() && (this.isStartTagSymbol(joinedTokenSequence.token()) || this.isStartTagClosingSymbol(joinedTokenSequence.token()))) {
                boolean bl2 = this.isStartTagClosingSymbol(joinedTokenSequence.token());
                if (joinedTokenSequence.moveNext()) {
                    String string3 = this.getTokenName(joinedTokenSequence.token());
                    object = new ArrayList();
                    for (int i = n; i < stack.size(); ++i) {
                        MarkupItem markupItem = (MarkupItem)stack.get(i);
                        if (markupItem.empty) continue;
                        assert (!markupItem.processed) : markupItem;
                        if (markupItem.virtual) {
                            assert (!markupItem.openingTag) : "only closing tag item is expected: " + markupItem;
                            arrayList.add(new IndentCommand(IndentCommand.Type.RETURN, indenterContextData.getLineStartOffset()));
                            markupItem.processed = true;
                            continue;
                        }
                        if (!bl2 || !markupItem.tagName.equalsIgnoreCase(string3) || !indenterContextData.isIndentThisLine()) break;
                        arrayList.add(new IndentCommand(IndentCommand.Type.RETURN, indenterContextData.getLineStartOffset()));
                        markupItem.processed = true;
                        break;
                    }
                    if (object.size() > 0) {
                        arrayList.addAll((Collection<IndentCommand>)object);
                    }
                }
            }
        }
        if (arrayList.isEmpty()) {
            arrayList.add(new IndentCommand(IndentCommand.Type.NO_CHANGE, indenterContextData.getLineStartOffset()));
        }
        if (indenterContextData.getNextLineStartOffset() != -1) {
            this.getIndentFromState(list, false, indenterContextData.getNextLineStartOffset());
            if (list.size() == 0) {
                list.add(new IndentCommand(IndentCommand.Type.NO_CHANGE, indenterContextData.getNextLineStartOffset()));
            }
        }
        return arrayList;
    }

    private void processEliminatedTags(int n) {
        ArrayList<MarkupItem> arrayList = new ArrayList<MarkupItem>();
        this.generateVirtualMarkupItemsForEliminatedTags(arrayList, n);
        if (arrayList.size() > 0) {
            this.addTags(arrayList);
        }
    }

    private void generateVirtualMarkupItemsForEliminatedTags(List<MarkupItem> list, int n) {
        EliminatedTag eliminatedTag;
        Iterator<EliminatedTag> iterator = this.eliminatedTags.iterator();
        while (iterator.hasNext() && (eliminatedTag = iterator.next()).end <= n) {
            list.add(MarkupAbstractIndenter.createEliminatedMarkupItem(eliminatedTag.tag, true));
            iterator.remove();
        }
    }

    private String getTokenName(Token<T1> token) {
        return ((Object)token.text()).toString().trim();
    }

    private Token<T1> findPreviousNonWhiteSpaceToken(JoinedTokenSequence<T1> joinedTokenSequence) {
        while (this.isWhiteSpaceToken(joinedTokenSequence.token()) && joinedTokenSequence.movePrevious()) {
        }
        return joinedTokenSequence.token();
    }

    private void addTags(List<MarkupItem> list) {
        for (MarkupItem markupItem : list) {
            if (!markupItem.virtual) {
                if (markupItem.openingTag) {
                    this.getStack().addAll(this.calculateAllVirtualCloseTagsForOpenTag(markupItem));
                } else {
                    this.getStack().addAll(this.calculateAllVirtualCloseTagsForCloseTag(markupItem));
                }
            }
            if (markupItem.eliminated) continue;
            this.getStack().push(markupItem);
        }
    }

    private List<MarkupItem> eliminateTagsOpenedAndClosedOnOneLine(List<MarkupItem> list) {
        ArrayList<MarkupItem> arrayList = new ArrayList<MarkupItem>();
        for (int i = list.size() - 1; i >= 0; --i) {
            int n;
            MarkupItem markupItem = list.get(i);
            if (!markupItem.openingTag && (n = MarkupAbstractIndenter.indexOfOpenTag(list, markupItem, i)) != -1) {
                i = n;
                continue;
            }
            arrayList.add(0, markupItem);
        }
        return arrayList;
    }

    private List<MarkupItem> calculateAllVirtualCloseTagsForOpenTag(MarkupItem markupItem) {
        ArrayList<MarkupItem> arrayList = new ArrayList<MarkupItem>();
        block0: for (int i = this.getStack().size() - 1; i >= 0; --i) {
            MarkupItem markupItem2 = (MarkupItem)this.getStack().get(i);
            if (!markupItem2.openingTag) {
                int n = MarkupAbstractIndenter.indexOfOpenTag(this.getStack(), markupItem2, i);
                if (n != -1) {
                    i = n;
                    continue;
                }
                if (!DEBUG) continue;
                System.err.println("WARNING: cannot find open tag for " + markupItem2 + " before index " + i + ": " + (this.getStack().size() < 30 ? this.getStack() : "[too many items]"));
                continue;
            }
            if (!markupItem2.optionalClosingTag) break;
            if (markupItem2.children != null) {
                if (markupItem2.children.contains(markupItem.tagName.toUpperCase())) break;
                for (String string : markupItem2.children) {
                    if (!this.isOpeningTagOptional(string)) continue;
                    break block0;
                }
                arrayList.add(MarkupAbstractIndenter.createVirtualMarkupItem(markupItem2.tagName, markupItem2.empty));
                continue;
            }
            arrayList.add(MarkupAbstractIndenter.createVirtualMarkupItem(markupItem2.tagName, markupItem2.empty));
        }
        return arrayList;
    }

    private List<MarkupItem> calculateAllVirtualCloseTagsForCloseTag(MarkupItem markupItem) {
        int n = -1;
        ArrayList<MarkupItem> arrayList = new ArrayList<MarkupItem>();
        for (int i = this.getStack().size() - 1; i >= 0; --i) {
            MarkupItem markupItem2 = (MarkupItem)this.getStack().get(i);
            if (!markupItem2.openingTag) {
                int n2 = MarkupAbstractIndenter.indexOfOpenTag(this.getStack(), markupItem2, i);
                if (n2 != -1) {
                    i = n2;
                    continue;
                }
                if (!AbstractIndenter.DEBUG) continue;
                System.err.println("WARNING: cannot find open tag for " + markupItem2 + " before index " + i + ": " + (this.getStack().size() < 30 ? this.getStack() : "[too many items]"));
                continue;
            }
            if (markupItem2.tagName.equalsIgnoreCase(markupItem.tagName)) {
                n = -1;
                break;
            }
            if (markupItem2.optionalClosingTag) {
                if (n == -1) {
                    n = arrayList.size();
                }
                arrayList.add(MarkupAbstractIndenter.createVirtualMarkupItem(markupItem2.tagName, markupItem2.empty));
                continue;
            }
            if (n == -1) {
                n = arrayList.size();
                arrayList.add(MarkupAbstractIndenter.createVirtualMarkupItem(markupItem2.tagName, markupItem2.empty));
                continue;
            }
            if (AbstractIndenter.DEBUG) {
                System.err.println("WARNING: cannot find opening tag for " + markupItem + ": " + this.getStack() + " stopped searching at " + markupItem2);
            }
            markupItem.eliminated = true;
            break;
        }
        if (n != -1) {
            while (arrayList.size() > n) {
                arrayList.remove(arrayList.size() - 1);
            }
        }
        return arrayList;
    }

    private static int indexOfOpenTag(List<MarkupItem> list, MarkupItem markupItem, int n) {
        assert (!markupItem.openingTag) : markupItem;
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            MarkupItem markupItem2 = list.get(i);
            if (!markupItem2.tagName.equalsIgnoreCase(markupItem.tagName)) continue;
            if (markupItem2.openingTag) {
                if (n2 == 0) {
                    return i;
                }
                --n2;
                continue;
            }
            ++n2;
        }
        return -1;
    }

    private void removeFullyProcessedTags() {
    }

    private boolean isInOpeningTagAttributes() {
        return this.inOpeningTagAttributes;
    }

    private void setInOpeningTagAttributes(boolean bl) {
        this.inOpeningTagAttributes = bl;
        this.attributesIndent = -1;
    }

    private int getAttributesIndent() {
        return this.attributesIndent;
    }

    private void setAttributesIndent(int n) {
        this.attributesIndent = n;
    }

    private boolean isInUnformattableTagContent() {
        return this.inUnformattableTagContent;
    }

    private void setInUnformattableTagContent(boolean bl, String string) {
        this.inUnformattableTagContent = bl;
        this.unformattableTagName = string;
    }

    private void setInUnformattableTagContent(boolean bl) {
        this.inUnformattableTagContent = bl;
        this.unformattableTagName = null;
    }

    private static class EliminatedTag {
        private int start;
        private int end;
        private String tag;

        public EliminatedTag(int n, int n2, String string) {
            this.start = n;
            this.end = n2;
            this.tag = string;
        }

        public String toString() {
            return "EliminatedTag[" + this.tag + " at " + this.start + "-" + this.end + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MarkupItem {
        public String tagName;
        public boolean openingTag;
        public int indentLevel;
        public boolean processed;
        public boolean optionalClosingTag;
        public Set<String> children;
        public boolean virtual;
        public boolean empty;
        public boolean eliminated;

        public MarkupItem(String string, boolean bl, int n, boolean bl2, Set<String> set, boolean bl3, boolean bl4, boolean bl5) {
            this.tagName = string;
            this.openingTag = bl;
            this.indentLevel = n;
            this.optionalClosingTag = bl2;
            this.processed = false;
            this.children = set;
            this.empty = bl3;
            this.virtual = bl4;
            this.eliminated = bl5;
        }

        public String toString() {
            return "HtmlStackItem[" + (this.openingTag ? "<" : "</") + "tagName=" + this.tagName + "," + "indent=" + this.indentLevel + "," + "optionalClosingTag=" + this.optionalClosingTag + "," + "processed=" + this.processed + "," + "virtual=" + this.virtual + "," + "empty=" + this.empty + "]";
        }
    }
}

