/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.formatting.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.css.formatting.api.embedding.JoinedTokenSequence;
import org.netbeans.modules.css.formatting.api.embedding.VirtualSource;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexUtilities {
    private LexUtilities() {
    }

    public static <T extends TokenId> TokenSequence<T> getTokenSequence(BaseDocument baseDocument, int n, Language<T> language) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
        return LexUtilities.getTokenSequence((TokenHierarchy<Document>)tokenHierarchy, n, language);
    }

    public static <T extends TokenId> TokenSequence<T> getTokenSequence(TokenHierarchy<Document> tokenHierarchy, int n, Language<T> language) {
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence(language);
        if (tokenSequence == null) {
            List list = tokenHierarchy.embeddedTokenSequences(n, true);
            for (TokenSequence tokenSequence2 : list) {
                if (tokenSequence2.language() != language) continue;
                tokenSequence = tokenSequence2;
                break;
            }
            if (tokenSequence == null) {
                list = tokenHierarchy.embeddedTokenSequences(n, false);
                for (TokenSequence tokenSequence2 : list) {
                    if (tokenSequence2.language() != language) continue;
                    tokenSequence = tokenSequence2;
                    break;
                }
            }
        }
        return tokenSequence;
    }

    public static Language<? extends TokenId> getLanguage(BaseDocument baseDocument, int n) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
        return LexUtilities.getLanguage((TokenHierarchy<BaseDocument>)tokenHierarchy, n);
    }

    public static Language<? extends TokenId> getLanguage(TokenHierarchy<BaseDocument> tokenHierarchy, int n) {
        List list = tokenHierarchy.embeddedTokenSequences(n, true);
        if (list.size() == 0) {
            return null;
        }
        return ((TokenSequence)list.get(list.size() - 1)).language();
    }

    public static <T extends TokenId> TokenSequence<T> getPositionedSequence(BaseDocument baseDocument, int n, Language<T> language) {
        return LexUtilities.getPositionedSequence(baseDocument, n, true, language);
    }

    public static <T extends TokenId> TokenSequence<T> getPositionedSequence(BaseDocument baseDocument, int n, boolean bl, Language<T> language) {
        TokenSequence<T> tokenSequence = LexUtilities.getTokenSequence(baseDocument, n, language);
        if (tokenSequence != null) {
            try {
                tokenSequence.move(n);
            }
            catch (AssertionError assertionError) {
                DataObject dataObject = (DataObject)baseDocument.getProperty((Object)"stream");
                if (dataObject != null) {
                    Exceptions.attachMessage((Throwable)((Object)assertionError), (String)FileUtil.getFileDisplayName((FileObject)dataObject.getPrimaryFile()));
                }
                throw assertionError;
            }
            if (!bl && !tokenSequence.moveNext()) {
                return null;
            }
            if (bl && !tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return null;
            }
            return tokenSequence;
        }
        return null;
    }

    public static <T extends TokenId> Token<T> findNext(TokenSequence<T> tokenSequence, List<T> list) {
        if (list.contains(tokenSequence.token().id())) {
            while (tokenSequence.moveNext() && list.contains(tokenSequence.token().id())) {
            }
        }
        if (tokenSequence.token() == null || list.contains(tokenSequence.token().id())) {
            return null;
        }
        return tokenSequence.token();
    }

    public static <T extends TokenId> Token<T> findNext(JoinedTokenSequence<T> joinedTokenSequence, List<T> list) {
        if (list.contains(joinedTokenSequence.token().id())) {
            while (joinedTokenSequence.moveNext() && list.contains(joinedTokenSequence.token().id())) {
            }
        }
        if (joinedTokenSequence.token() == null || list.contains(joinedTokenSequence.token().id())) {
            return null;
        }
        return joinedTokenSequence.token();
    }

    public static <T extends TokenId> Token<T> findPrevious(TokenSequence<T> tokenSequence, List<T> list) {
        if (list.contains(tokenSequence.token().id())) {
            while (tokenSequence.movePrevious() && list.contains(tokenSequence.token().id())) {
            }
        }
        if (tokenSequence.token() == null || list.contains(tokenSequence.token().id())) {
            return null;
        }
        return tokenSequence.token();
    }

    public static <T extends TokenId> Token<T> findPrevious(JoinedTokenSequence<T> joinedTokenSequence, List<T> list) {
        if (list.contains(joinedTokenSequence.token().id())) {
            while (joinedTokenSequence.movePrevious() && list.contains(joinedTokenSequence.token().id())) {
            }
        }
        if (joinedTokenSequence.token() == null || list.contains(joinedTokenSequence.token().id())) {
            return null;
        }
        return joinedTokenSequence.token();
    }

    private static <T extends TokenId> TokenSequence<T> getVirtualTokens(VirtualSource virtualSource, int n, int n2, Language<T> language) {
        if (virtualSource == null) {
            return null;
        }
        String string = virtualSource.getSource(n, n2);
        if (string == null || string.length() == 0) {
            return null;
        }
        return TokenHierarchy.create((CharSequence)string, language).tokenSequence(language);
    }

    public static int getTokenSequenceEndOffset(TokenSequence<? extends TokenId> tokenSequence) {
        int n = tokenSequence.index();
        tokenSequence.moveEnd();
        tokenSequence.movePrevious();
        int n2 = tokenSequence.offset() + tokenSequence.token().length();
        tokenSequence.move(n);
        return n2;
    }

    public static int getTokenSequenceEndOffset(JoinedTokenSequence<? extends TokenId> joinedTokenSequence) {
        int n = joinedTokenSequence.index();
        joinedTokenSequence.moveEnd();
        joinedTokenSequence.movePrevious();
        int n2 = joinedTokenSequence.offset() + joinedTokenSequence.token().length();
        joinedTokenSequence.move(n);
        return n2;
    }

    public static int getTokenSequenceStartOffset(TokenSequence<? extends TokenId> tokenSequence) {
        int n = tokenSequence.index();
        tokenSequence.moveStart();
        tokenSequence.moveNext();
        int n2 = tokenSequence.offset();
        tokenSequence.move(n);
        return n2;
    }

    public static int getTokenSequenceStartOffset(JoinedTokenSequence<? extends TokenId> joinedTokenSequence) {
        int n = joinedTokenSequence.index();
        joinedTokenSequence.moveStart();
        joinedTokenSequence.moveNext();
        int n2 = joinedTokenSequence.offset();
        joinedTokenSequence.move(n);
        return n2;
    }

    public static <T1 extends TokenId> Token<T1> getTokenAtOffset(JoinedTokenSequence<T1> joinedTokenSequence, int n) {
        int n2 = joinedTokenSequence.index();
        joinedTokenSequence.move(n);
        joinedTokenSequence.moveNext();
        Token<T1> token = joinedTokenSequence.token();
        joinedTokenSequence.moveIndex(n2);
        return token;
    }

    public static <T1 extends TokenId> List<TokenSequence<T1>> getEmbeddedTokenSequences(BaseDocument baseDocument, Language<T1> language, int n, int n2) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : tokenHierarchy.languagePaths()) {
            if (!object.endsWith(LanguagePath.get(language))) continue;
            arrayList.add(object);
        }
        ArrayList arrayList2 = new ArrayList();
        for (LanguagePath languagePath : arrayList) {
            List list = tokenHierarchy.tokenSequenceList(languagePath, n, n2);
            for (TokenSequence tokenSequence : list) {
                tokenSequence.moveStart();
                if (!tokenSequence.moveNext()) continue;
                arrayList2.add(tokenSequence);
            }
        }
        Collections.sort(arrayList2, new Comparator<TokenSequence<T1>>(){

            @Override
            public int compare(TokenSequence<T1> tokenSequence, TokenSequence<T1> tokenSequence2) {
                assert (tokenSequence.offset() != tokenSequence2.offset());
                return tokenSequence.offset() - tokenSequence2.offset();
            }
        });
        return arrayList2;
    }

    private static <T1 extends TokenId> List<JoinedTokenSequence.CodeBlock<T1>> calculateCodeBlock(List<TokenSequence<T1>> list, VirtualSource virtualSource) throws BadLocationException {
        ArrayList<JoinedTokenSequence.CodeBlock<T1>> arrayList = new ArrayList<JoinedTokenSequence.CodeBlock<T1>>();
        for (int i = 0; i < list.size(); ++i) {
            TokenSequence<T1> tokenSequence = list.get(i);
            ArrayList arrayList2 = new ArrayList();
            arrayList2.add(new JoinedTokenSequence.TokenSequenceWrapper<T1>(tokenSequence, false));
            for (int j = i + 1; j < list.size(); ++j) {
                TokenSequence<T1> tokenSequence2 = list.get(j - 1);
                tokenSequence2.moveEnd();
                tokenSequence2.movePrevious();
                TokenSequence<T1> tokenSequence3 = list.get(j);
                tokenSequence3.moveStart();
                tokenSequence3.moveNext();
                TokenSequence tokenSequence4 = LexUtilities.getVirtualTokens(virtualSource, tokenSequence2.offset() + tokenSequence2.token().length(), tokenSequence3.offset(), tokenSequence.language());
                if (tokenSequence4 == null) break;
                arrayList2.add(new JoinedTokenSequence.TokenSequenceWrapper(tokenSequence4, true));
                arrayList2.add(new JoinedTokenSequence.TokenSequenceWrapper<T1>(tokenSequence3, false));
                ++i;
            }
            arrayList.add(new JoinedTokenSequence.CodeBlock(arrayList2));
        }
        return arrayList;
    }

    public static <T1 extends TokenId> List<JoinedTokenSequence.CodeBlock<T1>> createCodeBlocks(BaseDocument baseDocument, Language<T1> language, VirtualSource virtualSource) throws BadLocationException {
        List<TokenSequence<T1>> list = LexUtilities.getEmbeddedTokenSequences(baseDocument, language, 0, baseDocument.getLength());
        if (list.size() == 0) {
            return null;
        }
        return LexUtilities.calculateCodeBlock(list, virtualSource);
    }
}

