/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.css.editor.model.CssRule;
import org.netbeans.modules.css.editor.model.CssRuleItem;
import org.netbeans.modules.css.gsf.api.CssParserResult;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.css.parser.SimpleNodeUtil;
import org.netbeans.modules.css.parser.Token;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CssModel {
    private static final Logger LOGGER = Logger.getLogger(CssModel.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private final List<CssRule> rules = new ArrayList<CssRule>(10);
    private final Collection<String> imported_files = new ArrayList<String>();
    private Snapshot snapshot;

    public static CssModel create(CssParserResult cssParserResult) {
        return new CssModel(cssParserResult.getSnapshot(), cssParserResult.root());
    }

    private CssModel(Snapshot snapshot, SimpleNode simpleNode) {
        this.snapshot = snapshot;
        if (simpleNode != null) {
            this.updateModel(snapshot, simpleNode);
        }
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public List<CssRule> rules() {
        return this.rules;
    }

    public Collection<String> getImportedFileNames() {
        return this.imported_files;
    }

    public Collection<FileObject> getImportedFiles() {
        FileObject fileObject = this.snapshot.getSource().getFileObject().getParent();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (String string : this.getImportedFileNames()) {
            FileObject fileObject2 = fileObject.getFileObject(string);
            if (fileObject2 == null) continue;
            arrayList.add(fileObject2);
        }
        return arrayList;
    }

    public Collection<CssModel> getImportedFileModels() {
        final ArrayList<CssModel> arrayList = new ArrayList<CssModel>();
        for (FileObject fileObject : this.getImportedFiles()) {
            if (!fileObject.isValid() || !fileObject.getMIMEType().equals("text/x-css")) continue;
            try {
                Source source = Source.create((FileObject)fileObject);
                ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        CssParserResult cssParserResult = (CssParserResult)resultIterator.getParserResult();
                        arrayList.add(CssModel.create(cssParserResult));
                    }
                });
            }
            catch (ParseException parseException) {
                Exceptions.printStackTrace((Throwable)parseException);
            }
        }
        return arrayList;
    }

    public Collection<CssModel> getImportedFileModelsRecursively() {
        ArrayList<CssModel> arrayList = new ArrayList<CssModel>();
        for (CssModel cssModel : this.getImportedFileModels()) {
            arrayList.add(cssModel);
            arrayList.addAll(cssModel.getImportedFileModelsRecursively());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CssRule ruleForOffset(int n) {
        List<CssRule> list = this.rules;
        synchronized (list) {
            if (this.rules != null) {
                for (CssRule cssRule : this.rules()) {
                    if (cssRule.getRuleNameOffset() > n || cssRule.getRuleCloseBracketOffset() < n) continue;
                    return cssRule;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateModel(final Snapshot snapshot, SimpleNode simpleNode) {
        List<CssRule> list = this.rules;
        synchronized (list) {
            NodeVisitor nodeVisitor = new NodeVisitor(){

                public void visit(SimpleNode simpleNode) {
                    Token token;
                    if (simpleNode.kind() == 19) {
                        Object object;
                        Token token2 = simpleNode.jjtGetFirstToken();
                        Token token3 = simpleNode.jjtGetLastToken();
                        int n = -1;
                        int n2 = -1;
                        ArrayList<Integer> arrayList = new ArrayList<Integer>();
                        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                        while (token2 != null && token2.offset <= token3.offset) {
                            if (token2.kind == 8) {
                                n = token2.offset;
                            } else if (token2.kind == 9) {
                                n2 = token2.offset;
                            } else if (token2.kind == 12) {
                                arrayList.add(token2.offset);
                            } else if (token2.kind == 13) {
                                arrayList2.add(token2.offset);
                            }
                            token2 = token2.next;
                        }
                        SimpleNode simpleNode2 = SimpleNodeUtil.getChildByType(simpleNode, 20);
                        SimpleNode[] simpleNodeArray = SimpleNodeUtil.getChildrenByType(simpleNode, 29);
                        ArrayList<CssRuleItem> arrayList3 = new ArrayList<CssRuleItem>(simpleNodeArray.length);
                        for (int i = 0; i < simpleNodeArray.length; ++i) {
                            object = simpleNodeArray[i];
                            SimpleNode simpleNode3 = SimpleNodeUtil.getChildByType((SimpleNode)object, 18);
                            SimpleNode simpleNode4 = SimpleNodeUtil.getChildByType((SimpleNode)object, 31);
                            if (simpleNode3 == null || simpleNode4 == null) {
                                return;
                            }
                            int n3 = i < arrayList.size() ? (Integer)arrayList.get(i) : -1;
                            int n4 = i < arrayList2.size() ? (Integer)arrayList2.get(i) : -1;
                            CssRuleItem cssRuleItem = new CssRuleItem(simpleNode3.image().trim(), simpleNode3.startOffset(), simpleNode4.image().trim(), simpleNode4.startOffset(), n4, n3);
                            arrayList3.add(cssRuleItem);
                        }
                        String string = simpleNode2.image().trim();
                        object = new CssRule(snapshot, string, simpleNode2.startOffset(), n, n2, arrayList3);
                        CssModel.this.rules.add(object);
                    } else if (simpleNode.kind() == 6 && (token = SimpleNodeUtil.getNodeToken(simpleNode, 23)) != null) {
                        CssModel.this.imported_files.add(SimpleNodeUtil.unquotedValue(token.image));
                    }
                }
            };
            SimpleNodeUtil.visitChildren(simpleNode, nodeVisitor);
            if (LOG) {
                LOGGER.fine("CssModel parse tree:");
                LOGGER.fine(simpleNode.dump());
                LOGGER.fine("CssModel structure:");
                for (CssRule cssRule : this.rules) {
                    LOGGER.fine(cssRule.toString());
                }
            }
        }
    }
}

