/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.impl;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.spi.ConnectionAuthenticator;
import org.netbeans.modules.hudson.spi.PasswordAuthorizer;
import org.openide.util.Lookup;

public class ServletConnectionAuthenticator
implements ConnectionAuthenticator {
    private static final Logger LOGGER = Logger.getLogger(ServletConnectionAuthenticator.class.getName());

    public void prepareRequest(URLConnection uRLConnection, URL uRL) {
    }

    public URLConnection forbidden(URLConnection uRLConnection, URL uRL) {
        for (PasswordAuthorizer passwordAuthorizer : Lookup.getDefault().lookupAll(PasswordAuthorizer.class)) {
            String[] stringArray = passwordAuthorizer.authorize(uRL);
            if (stringArray == null) continue;
            LOGGER.log(Level.FINE, "Got authorization for {0} on {1} from {2}", new Object[]{stringArray[0], uRL, passwordAuthorizer});
            for (String string : new String[]{"j_acegi_security_check", "j_security_check"}) {
                try {
                    LOGGER.log(Level.FINER, "Posting authentication to {0}", string);
                    new ConnectionBuilder().url(new URL(uRL, string)).postData(("j_username=" + URLEncoder.encode(stringArray[0], "UTF-8") + "&j_password=" + URLEncoder.encode(stringArray[1], "UTF-8")).getBytes("UTF-8")).homeURL(uRL).authentication(false).connection();
                    LOGGER.log(Level.FINER, "Posted authentication to {0} worked", string);
                    return uRLConnection.getURL().openConnection();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.FINE, null, iOException);
                }
            }
        }
        return null;
    }
}

