/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer.api;

import hidden.org.codehaus.plexus.util.Base64;
import hidden.org.codehaus.plexus.util.FileUtils;
import hidden.org.codehaus.plexus.util.IOUtil;
import hidden.org.codehaus.plexus.util.StringUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hit;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginIndexManager {
    private static final String ZIP_LOCATION = "org/netbeans/modules/maven/indexer/pluginz.zip";
    private static final String INDEX_PATH = "maven-plugins-index";
    private static IndexReader indexReader;
    private static String FIELD_ID;
    private static String FIELD_MVN_VERSION;
    private static String FIELD_GOALS;
    private static String FIELD_PREFIX;
    private static String PREFIX_FIELD_GOAL;
    private static String FIELD_CYCLES;
    private static String PREFIX_FIELD_CYCLE;
    static final int BUFFER = 2048;

    private static synchronized IndexSearcher getIndexSearcher() throws Exception {
        if (indexReader == null) {
            FSDirectory fSDirectory = FSDirectory.getDirectory((File)PluginIndexManager.getDefaultIndexLocation());
            indexReader = IndexReader.open((Directory)fSDirectory);
        }
        return new IndexSearcher(indexReader);
    }

    public static Set<String> getPluginGoalNames(Set<String> set) throws Exception {
        PrefixQuery prefixQuery;
        IndexSearcher indexSearcher = PluginIndexManager.getIndexSearcher();
        BooleanQuery booleanQuery = new BooleanQuery();
        for (String object2 : set) {
            prefixQuery = new PrefixQuery(new Term(FIELD_ID, object2));
            booleanQuery.add(new BooleanClause((Query)prefixQuery, BooleanClause.Occur.SHOULD));
        }
        Hits hits = indexSearcher.search((Query)booleanQuery);
        Iterator iterator = hits.iterator();
        prefixQuery = new TreeSet();
        while (iterator.hasNext()) {
            String[] stringArray;
            Hit hit = (Hit)iterator.next();
            Document document = hit.getDocument();
            String string = document.getField(FIELD_PREFIX).stringValue();
            String string2 = document.getField(FIELD_GOALS).stringValue();
            for (String string3 : stringArray = StringUtils.split((String)string2, (String)" ")) {
                prefixQuery.add(string + ":" + string3);
            }
        }
        return prefixQuery;
    }

    public static Set<String> getPluginGoals(String string, String string2, String string3) throws Exception {
        String string4;
        TermQuery termQuery;
        assert (string != null && string2 != null && string3 != null);
        IndexSearcher indexSearcher = PluginIndexManager.getIndexSearcher();
        Hits hits = indexSearcher.search((Query)(termQuery = new TermQuery(new Term(FIELD_ID, string4 = string + "|" + string2 + "|" + string3))));
        if (hits.length() == 0) {
            return null;
        }
        Iterator iterator = hits.iterator();
        TreeSet<String> treeSet = new TreeSet<String>();
        while (iterator.hasNext()) {
            String[] stringArray;
            Hit hit = (Hit)iterator.next();
            Document document = hit.getDocument();
            String string5 = document.getField(FIELD_GOALS).stringValue();
            for (String string6 : stringArray = StringUtils.split((String)string5, (String)" ")) {
                treeSet.add(string6);
            }
        }
        return treeSet;
    }

    public static Set<String> getPluginParameterNames(String string, String string2, String string3, String string4) throws Exception {
        String string5;
        TermQuery termQuery;
        assert (string != null && string2 != null && string3 != null);
        IndexSearcher indexSearcher = PluginIndexManager.getIndexSearcher();
        Hits hits = indexSearcher.search((Query)(termQuery = new TermQuery(new Term(FIELD_ID, string5 = string + "|" + string2 + "|" + string3))));
        if (hits.length() == 0) {
            return null;
        }
        Iterator iterator = hits.iterator();
        TreeSet<String> treeSet = new TreeSet<String>();
        while (iterator.hasNext()) {
            String[] stringArray;
            Hit hit = (Hit)iterator.next();
            Document document = hit.getDocument();
            String string6 = document.getField(FIELD_GOALS).stringValue();
            for (String string7 : stringArray = StringUtils.split((String)string6, (String)" ")) {
                String[] stringArray2;
                if (string4 != null && !string4.equals(string7)) continue;
                String string8 = document.getField(PREFIX_FIELD_GOAL + string7).stringValue();
                for (String string9 : stringArray2 = StringUtils.split((String)string8, (String)"\n")) {
                    String[] stringArray3 = StringUtils.split((String)string9, (String)"|");
                    String string10 = stringArray3[0];
                    String string11 = stringArray3[1];
                    if (!"true".equals(string11)) continue;
                    treeSet.add(string10);
                }
            }
        }
        return treeSet;
    }

    public static Set<ParameterDetail> getPluginParameters(String string, String string2, String string3, String string4) throws Exception {
        String string5;
        TermQuery termQuery;
        assert (string != null && string2 != null && string3 != null);
        IndexSearcher indexSearcher = PluginIndexManager.getIndexSearcher();
        Hits hits = indexSearcher.search((Query)(termQuery = new TermQuery(new Term(FIELD_ID, string5 = string + "|" + string2 + "|" + string3))));
        if (hits.length() == 0) {
            return null;
        }
        Iterator iterator = hits.iterator();
        TreeSet<ParameterDetail> treeSet = new TreeSet<ParameterDetail>(new PComparator());
        while (iterator.hasNext()) {
            String[] stringArray;
            Hit hit = (Hit)iterator.next();
            Document document = hit.getDocument();
            String string6 = document.getField(FIELD_GOALS).stringValue();
            for (String string7 : stringArray = StringUtils.split((String)string6, (String)" ")) {
                String[] stringArray2;
                if (string4 != null && !string4.equals(string7)) continue;
                String string8 = document.getField(PREFIX_FIELD_GOAL + string7).stringValue();
                for (String string9 : stringArray2 = StringUtils.split((String)string8, (String)"\n")) {
                    Object object;
                    String string10;
                    String string11;
                    String[] stringArray3 = StringUtils.split((String)string9, (String)"|");
                    String string12 = stringArray3[0];
                    String string13 = stringArray3[1];
                    String string14 = stringArray3[2];
                    boolean bl = "true".equals(string14);
                    if (!"true".equals(string13)) continue;
                    String string15 = stringArray3[3];
                    if (string15 != null && "null".equals(string15)) {
                        string15 = null;
                    }
                    if ((string11 = stringArray3[4]) != null && "null".equals(string11)) {
                        string11 = null;
                    }
                    if (stringArray3.length > 5) {
                        string10 = stringArray3[5];
                        object = Base64.decodeBase64((byte[])string10.getBytes());
                        string10 = new String((byte[])object, "UTF-8");
                    } else {
                        string10 = null;
                    }
                    object = new ParameterDetail(string12, string15, string11, bl, string10);
                    treeSet.add((ParameterDetail)object);
                }
            }
        }
        return treeSet;
    }

    public static Set<String> getPluginsForGoalPrefix(String string) throws Exception {
        TermQuery termQuery;
        assert (string != null);
        IndexSearcher indexSearcher = PluginIndexManager.getIndexSearcher();
        Hits hits = indexSearcher.search((Query)(termQuery = new TermQuery(new Term(FIELD_PREFIX, string))));
        if (hits.length() == 0) {
            return null;
        }
        Iterator iterator = hits.iterator();
        TreeSet<String> treeSet = new TreeSet<String>();
        while (iterator.hasNext()) {
            Hit hit = (Hit)iterator.next();
            Document document = hit.getDocument();
            String string2 = document.getField(FIELD_ID).stringValue();
            treeSet.add(string2);
        }
        return treeSet;
    }

    public static Map<String, List<String>> getLifecyclePlugins(String string, String string2, String[] hits) throws Exception {
        assert (string != null);
        IndexSearcher indexSearcher = PluginIndexManager.getIndexSearcher();
        BooleanQuery booleanQuery = new BooleanQuery();
        TermQuery termQuery = new TermQuery(new Term(FIELD_CYCLES, string));
        booleanQuery.add((Query)termQuery, BooleanClause.Occur.MUST);
        if (string2 == null) {
            string2 = "2.0.9";
        }
        BooleanQuery booleanQuery2 = new BooleanQuery();
        termQuery = new TermQuery(new Term(FIELD_MVN_VERSION, string2));
        booleanQuery2.add((Query)termQuery, BooleanClause.Occur.SHOULD);
        for (String string3 : hits) {
            termQuery = new TermQuery(new Term(FIELD_ID, string3));
            booleanQuery2.add((Query)termQuery, BooleanClause.Occur.SHOULD);
        }
        booleanQuery.add((Query)booleanQuery2, BooleanClause.Occur.SHOULD);
        Hits hits2 = indexSearcher.search((Query)booleanQuery);
        if (hits2.length() == 0) {
            return null;
        }
        Iterator iterator = hits2.iterator();
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        while (iterator.hasNext()) {
            String[] stringArray;
            String string3;
            string3 = (Hit)iterator.next();
            Document document = string3.getDocument();
            Field field = document.getField(PREFIX_FIELD_CYCLE + string);
            if (field == null) continue;
            String string4 = field.stringValue();
            for (String string5 : stringArray = StringUtils.split((String)string4, (String)"\n")) {
                String[] stringArray2 = StringUtils.split((String)string5, (String)"=");
                String[] stringArray3 = StringUtils.split((String)stringArray2[1], (String)",");
                ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray3));
                linkedHashMap.put(stringArray2[0], arrayList);
            }
        }
        return linkedHashMap;
    }

    private static int checkLocalVersion(File[] fileArray) {
        for (File file : fileArray) {
            try {
                int n = Integer.parseInt(file.getName());
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                Exceptions.printStackTrace((Throwable)numberFormatException);
            }
        }
        return fileArray.length > 0 ? Integer.MAX_VALUE : 0;
    }

    /*
     * Exception decompiling
     */
    private static int checkZipVersion(File var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getDefaultIndexLocation() {
        File file;
        block10: {
            int n;
            File[] fileArray;
            block11: {
                String string = System.getProperty("netbeans.user");
                if (string != null) {
                    file = new File(new File(new File(string, "var"), "cache"), INDEX_PATH);
                } else {
                    fileArray = FileUtil.toFile((FileObject)FileUtil.getConfigRoot());
                    file = new File((File)fileArray, INDEX_PATH);
                }
                file.mkdirs();
                fileArray = file.listFiles();
                if (fileArray != null && fileArray.length != 0) break block11;
                InputStream inputStream = null;
                try {
                    inputStream = PluginIndexManager.class.getClassLoader().getResourceAsStream(ZIP_LOCATION);
                    ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                    PluginIndexManager.unzip(zipInputStream, file);
                }
                catch (Throwable throwable) {
                    IOUtil.close(inputStream);
                    throw throwable;
                }
                IOUtil.close((InputStream)inputStream);
                break block10;
            }
            int n2 = PluginIndexManager.checkZipVersion(file);
            if (n2 > (n = PluginIndexManager.checkLocalVersion(fileArray)) && n > 0) {
                try {
                    FileUtils.deleteDirectory((File)new File(file, "" + n));
                    InputStream inputStream = null;
                    try {
                        inputStream = PluginIndexManager.class.getClassLoader().getResourceAsStream(ZIP_LOCATION);
                        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                        PluginIndexManager.unzip(zipInputStream, file);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(inputStream);
                        throw throwable;
                    }
                    IOUtil.close((InputStream)inputStream);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        File[] fileArray = file.listFiles();
        assert (fileArray != null && fileArray.length == 1);
        file = fileArray[0];
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzip(ZipInputStream zipInputStream, File file) {
        try {
            ZipEntry zipEntry;
            BufferedOutputStream bufferedOutputStream = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int n;
                byte[] byArray = new byte[2048];
                File file2 = new File(file, zipEntry.getName());
                file2.getParentFile().mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 2048);
                while ((n = zipInputStream.read(byArray, 0, 2048)) != -1) {
                    bufferedOutputStream.write(byArray, 0, n);
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            IOUtil.close((InputStream)zipInputStream);
        }
    }

    static {
        FIELD_ID = "id";
        FIELD_MVN_VERSION = "mvn";
        FIELD_GOALS = "gls";
        FIELD_PREFIX = "prfx";
        PREFIX_FIELD_GOAL = "mj_";
        FIELD_CYCLES = "ccls";
        PREFIX_FIELD_CYCLE = "ccl_";
    }

    public static class ParameterDetail {
        private String name;
        private String expression;
        private String defaultValue;
        private boolean required;
        private String description;

        public ParameterDetail(String string, String string2, String string3, boolean bl, String string4) {
            this.name = string;
            this.expression = string2;
            this.defaultValue = string3;
            this.required = bl;
            this.description = string4;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getDescription() {
            return this.description;
        }

        public String getExpression() {
            return this.expression;
        }

        public String getName() {
            return this.name;
        }

        public boolean isRequired() {
            return this.required;
        }

        public String getHtmlDetails(boolean bl) {
            return "<html><body>" + (bl ? "<h4>" + NbBundle.getMessage(PluginIndexManager.class, (String)"TXT_LBL_PARAMETER") + this.getName() + "</h4>" : "") + "<b>" + NbBundle.getMessage(PluginIndexManager.class, (String)"LBL_Expression") + "</b>" + (this.getExpression() != null ? "${" + this.getExpression() + "}" : NbBundle.getMessage(PluginIndexManager.class, (String)"LBL_Undefined")) + "<br>" + "<b>" + NbBundle.getMessage(PluginIndexManager.class, (String)"LBL_DefaultValue") + "</b>" + (this.getDefaultValue() != null ? this.getDefaultValue() : NbBundle.getMessage(PluginIndexManager.class, (String)"LBL_Undefined")) + "<br><b>" + NbBundle.getMessage(PluginIndexManager.class, (String)"LBL_Description") + "</b><br>" + this.getDescription() + "</body></html>";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PComparator
    implements Comparator<ParameterDetail> {
        private PComparator() {
        }

        @Override
        public int compare(ParameterDetail parameterDetail, ParameterDetail parameterDetail2) {
            return parameterDetail.getName().compareTo(parameterDetail2.getName());
        }
    }
}

