/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.msa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.collector.DataCollectorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorDataProviderConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorMetadata;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.tool.DLightToolConfiguration;
import org.netbeans.modules.dlight.api.visualizer.VisualizerConfiguration;
import org.netbeans.modules.dlight.collector.procfs.ProcFSDCConfiguration;
import org.netbeans.modules.dlight.dtrace.collector.DTDCConfiguration;
import org.netbeans.modules.dlight.indicators.DataRowToTimeSeries;
import org.netbeans.modules.dlight.indicators.TimeSeriesDescriptor;
import org.netbeans.modules.dlight.indicators.TimeSeriesIndicatorConfiguration;
import org.netbeans.modules.dlight.msa.support.MSASQLTables;
import org.netbeans.modules.dlight.spi.tool.DLightToolConfigurationProvider;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.visualizers.api.ThreadMapVisualizerConfiguration;
import org.netbeans.modules.dlight.visualizers.api.ThreadStateResources;
import org.openide.util.NbBundle;

public class ThreadMapToolConfigurationProvider
implements DLightToolConfigurationProvider {
    private static final Logger log = DLightLogger.getLogger(ThreadMapToolConfigurationProvider.class);
    public static final int INDICATOR_POSITION = 10;
    private static final String ID = "dlight.tool.threadmap";
    private static final String TOOL_NAME = ThreadMapToolConfigurationProvider.loc("ThreadMapTool.ToolName", new String[0]);
    private static final String DETAILED_TOOL_NAME = ThreadMapToolConfigurationProvider.loc("ThreadMapTool.DetailedToolName", new String[0]);

    public DLightToolConfiguration create() {
        DLightToolConfiguration dLightToolConfiguration = new DLightToolConfiguration(ID, TOOL_NAME);
        dLightToolConfiguration.setLongName(DETAILED_TOOL_NAME);
        dLightToolConfiguration.setIcon("org/netbeans/modules/dlight/msa/resources/thread_microstates_16.png");
        dLightToolConfiguration.setDescription(ThreadMapToolConfigurationProvider.loc("ThreadMapTool.Description", new String[0]));
        List<DataTableMetadata.Column> list = Arrays.asList(MSASQLTables.prstat.P_SLEEP, MSASQLTables.prstat.P_WAIT, MSASQLTables.prstat.P_BLOCKED, MSASQLTables.prstat.P_RUNNING);
        TimeSeriesIndicatorConfiguration timeSeriesIndicatorConfiguration = new TimeSeriesIndicatorConfiguration(new IndicatorMetadata(list), 10);
        timeSeriesIndicatorConfiguration.setTitle(ThreadMapToolConfigurationProvider.loc("ThreadMapTool.Indicator.Title", new String[0]));
        timeSeriesIndicatorConfiguration.setGraphScale(1);
        timeSeriesIndicatorConfiguration.addTimeSeriesDescriptors(new TimeSeriesDescriptor[]{new TimeSeriesDescriptor(ThreadStateResources.THREAD_SLEEPING.color, ThreadStateResources.THREAD_SLEEPING.name, TimeSeriesDescriptor.Kind.REL_SURFACE), new TimeSeriesDescriptor(ThreadStateResources.THREAD_WAITING.color, ThreadStateResources.THREAD_WAITING.name, TimeSeriesDescriptor.Kind.REL_SURFACE), new TimeSeriesDescriptor(ThreadStateResources.THREAD_BLOCKED.color, ThreadStateResources.THREAD_BLOCKED.name, TimeSeriesDescriptor.Kind.REL_SURFACE), new TimeSeriesDescriptor(ThreadStateResources.THREAD_RUNNING.color, ThreadStateResources.THREAD_RUNNING.name, TimeSeriesDescriptor.Kind.REL_SURFACE)});
        timeSeriesIndicatorConfiguration.setDataRowHandler((DataRowToTimeSeries)new IndicatorDataHandler(list));
        timeSeriesIndicatorConfiguration.setActionDisplayName(ThreadMapToolConfigurationProvider.loc("ThreadMapTool.Indicator.Action", new String[0]));
        timeSeriesIndicatorConfiguration.setActionTooltip(ThreadMapToolConfigurationProvider.loc("ThreadMapTool.Indicator.Action.Tooltip", new String[0]));
        ThreadMapVisualizerConfiguration threadMapVisualizerConfiguration = new ThreadMapVisualizerConfiguration();
        timeSeriesIndicatorConfiguration.addVisualizerConfiguration((VisualizerConfiguration)threadMapVisualizerConfiguration);
        dLightToolConfiguration.addIndicatorConfiguration((IndicatorConfiguration)timeSeriesIndicatorConfiguration);
        ProcFSDCConfiguration procFSDCConfiguration = new ProcFSDCConfiguration();
        procFSDCConfiguration.collectProcInfo(1000);
        procFSDCConfiguration.collectMSA(1000);
        dLightToolConfiguration.addIndicatorDataProviderConfiguration((IndicatorDataProviderConfiguration)procFSDCConfiguration);
        dLightToolConfiguration.addDataCollectorConfiguration((DataCollectorConfiguration)procFSDCConfiguration);
        dLightToolConfiguration.addDataCollectorConfiguration((DataCollectorConfiguration)DTDCConfiguration.createCpuSamplingConfiguration());
        return dLightToolConfiguration;
    }

    private static String loc(String string, String ... stringArray) {
        return NbBundle.getMessage(ThreadMapToolConfigurationProvider.class, (String)string, (Object[])stringArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IndicatorDataHandler
    implements DataRowToTimeSeries {
        private static final Object lock = IndicatorDataHandler.class.getName() + "Lock";
        private final List<String> colNames = new ArrayList<String>();

        private IndicatorDataHandler(List<DataTableMetadata.Column> list) {
            for (DataTableMetadata.Column column : list) {
                this.colNames.add(column.getColumnName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float[] getData(DataRow dataRow) {
            int n = 0;
            float[] fArray = null;
            Object object = lock;
            synchronized (object) {
                for (String string : this.colNames) {
                    block7: {
                        try {
                            float f = dataRow.getFloatValue(string).floatValue();
                            if (fArray == null) {
                                fArray = new float[this.colNames.size()];
                            }
                            fArray[n] = f;
                        }
                        catch (RuntimeException runtimeException) {
                            if (!log.isLoggable(Level.FINE)) break block7;
                            log.log(Level.FINE, "Will not add this entry", runtimeException);
                        }
                    }
                    ++n;
                }
            }
            return fArray;
        }

        public Map<String, String> getDetails() {
            return Collections.emptyMap();
        }
    }
}

