/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.PersistenceHandler;
import org.netbeans.core.windows.TopComponentGroupImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.CloneDocumentAction;
import org.netbeans.core.windows.persistence.PersistenceManager;
import org.netbeans.core.windows.view.ui.MainWindow;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class ResetWindowsAction
extends AbstractAction {
    public ResetWindowsAction() {
        this.putValue("Name", NbBundle.getMessage(CloneDocumentAction.class, (String)"CTL_ResetWindows"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        final NbTopManager.WindowSystem windowSystem = (NbTopManager.WindowSystem)Lookup.getDefault().lookup(NbTopManager.WindowSystem.class);
        if (null == windowSystem) {
            Logger.getLogger(ResetWindowsAction.class.getName()).log(Level.INFO, "Reset Windows action does not support custom WindowSystem implementations.");
            return;
        }
        final WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        if (windowManagerImpl.getMainWindow() instanceof MainWindow) {
            ((MainWindow)windowManagerImpl.getMainWindow()).setFullScreenMode(false);
        }
        windowManagerImpl.getMainWindow().setExtendedState(0);
        TopComponentGroupImpl topComponentGroupImpl = (TopComponentGroupImpl)windowManagerImpl.findTopComponentGroup("OpenedProjects");
        final boolean bl = null != topComponentGroupImpl && topComponentGroupImpl.isOpened();
        final TopComponent[] topComponentArray = windowManagerImpl.getEditorTopComponents();
        windowManagerImpl.closeNonEditorViews();
        windowManagerImpl.getMainWindow().setVisible(false);
        final TopComponent topComponent = windowManagerImpl.getArbitrarySelectedEditorTopComponent();
        windowManagerImpl.deselectEditorTopComponents();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n;
                Object object;
                FileObject fileObject = FileUtil.getConfigFile((String)"Windows2Local");
                if (null != fileObject) {
                    try {
                        object = fileObject.getChildren();
                        n = ((FileObject[])object).length;
                        for (int i = 0; i < n; ++i) {
                            FileObject fileObject2 = object[i];
                            if ("Components".equals(fileObject2.getName())) continue;
                            fileObject2.delete();
                        }
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                }
                windowSystem.hide();
                WindowManagerImpl.getInstance().resetModel();
                PersistenceManager.getDefault().reset();
                PersistenceHandler.getDefault().clear();
                windowSystem.load();
                windowSystem.show();
                if (bl && null != (object = windowManagerImpl.findTopComponentGroup("OpenedProjects"))) {
                    object.open();
                }
                object = (ModeImpl)windowManagerImpl.findMode("editor");
                for (n = 0; n < topComponentArray.length; ++n) {
                    ((ModeImpl)object).addOpenedTopComponentNoNotify(topComponentArray[n]);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Frame frame = windowManagerImpl.getMainWindow();
                        frame.invalidate();
                        frame.repaint();
                    }
                });
                if (null != topComponent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            topComponent.requestActive();
                        }
                    });
                }
            }
        });
    }
}

