/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.actions;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.netbeans.spi.actions.ActionStub;
import org.netbeans.spi.actions.IndirectAction;
import org.netbeans.spi.actions.NbAction;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContextAction<T>
extends NbAction {
    final Class<T> type;
    private final StubListener stubListener = new StubListener();
    ActionStub<T> stub;
    static boolean unitTest;

    protected ContextAction(Class<T> clazz) {
        this(clazz, null, null);
    }

    protected ContextAction(Class<T> clazz, String string, Image image) {
        this.type = clazz;
        Parameters.notNull((CharSequence)"type", clazz);
        if (string != null) {
            this.putValue("Name", string);
        }
        if (image != null) {
            this.putValue("SmallIcon", new ImageIcon(image));
        }
        this.putValue("noIconInMenu", true);
    }

    public final boolean isEnabled() {
        return this._isEnabled();
    }

    boolean _isEnabled() {
        ActionStub<T> actionStub = this.getStub();
        Collection<T> collection = actionStub.collection();
        boolean bl = this.checkQuantity(collection) && actionStub.isEnabled();
        return bl;
    }

    boolean checkQuantity(Collection<? extends T> collection) {
        return this.checkQuantity(collection.size());
    }

    protected boolean checkQuantity(int n) {
        return n > 0;
    }

    protected boolean isEnabled(Collection<? extends T> collection) {
        return true;
    }

    protected abstract void actionPerformed(Collection<? extends T> var1);

    public final void actionPerformed(ActionEvent actionEvent) {
        this.getStub().actionPerformed(null);
    }

    @Override
    protected final NbAction internalCreateContextAwareInstance(Lookup lookup) {
        return this.createStub(lookup);
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass();
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    ActionStub<T> createStub(Lookup lookup) {
        return new ActionStub(lookup, this);
    }

    private ActionStub<T> createInternalStub() {
        assert (Thread.holdsLock(this.lock()));
        ActionStub<T> actionStub = this.createStub(Utilities.actionsGlobalContext());
        return actionStub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ActionStub<T> getStub() {
        Object object = this.lock();
        synchronized (object) {
            if (this.stub == null && this.attached()) {
                this.stub = this.createInternalStub();
                this.stub.addPropertyChangeListener(this.stubListener);
            }
            return this.stub == null ? this.createInternalStub() : this.stub;
        }
    }

    public String toString() {
        return super.toString() + "[name=" + this.getValue("Name") + " type=" + this.type.getName() + "]";
    }

    protected void change(Collection<? extends T> collection, Action action) {
    }

    @Override
    void internalAddNotify() {
        this.stub = this.getStub();
        this.stub.resultChanged(null);
        super.internalAddNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void internalRemoveNotify() {
        try {
            super.internalRemoveNotify();
        }
        finally {
            this.stub.removePropertyChangeListener(this.stubListener);
            this.stub = null;
        }
    }

    protected final void refresh() {
        this.getStub().resultChanged(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<? extends T> stubCollection() {
        Object object = this.lock();
        synchronized (object) {
            return this.stub == null ? null : this.stub.collection();
        }
    }

    public static <T extends Lookup.Provider, R> ContextAction<T> createIndirectAction(Class<T> clazz, ContextAction<R> contextAction, boolean bl) {
        return new IndirectAction<T, R>(clazz, contextAction, bl);
    }

    public static <T extends Lookup.Provider, R> ContextAction<T> createIndirectAction(Class<T> clazz, ContextAction<R> contextAction) {
        return ContextAction.createIndirectAction(clazz, contextAction, true);
    }

    private class StubListener
    implements PropertyChangeListener {
        private StubListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ContextAction.this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }
}

