/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.structure.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.modules.editor.structure.api.DocumentElementEvent;
import org.netbeans.modules.editor.structure.api.DocumentElementListener;
import org.netbeans.modules.editor.structure.api.DocumentModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DocumentElement {
    private String name;
    private String type;
    private Position startPos;
    private Position endPos;
    private DocumentModel model;
    private Attributes attributes;
    DocumentElementListener deListener = null;
    HashSet<DocumentElementListener> deListeners = null;
    private static final Attributes EMPTY_ATTRIBUTES = new Attributes();
    private static final int PRINT_MAX_CHARS = 10;

    DocumentElement(String string, String string2, Map<String, String> map, int n, int n2, DocumentModel documentModel) throws BadLocationException {
        if (!documentModel.elementsNamesCache.containsKey(string)) {
            documentModel.elementsNamesCache.put(string, string);
        }
        this.name = documentModel.elementsNamesCache.get(string);
        if (!documentModel.elementsTypesCache.containsKey(string2)) {
            documentModel.elementsTypesCache.put(string2, string2);
        }
        this.type = documentModel.elementsTypesCache.get(string2);
        this.model = documentModel;
        this.attributes = !map.isEmpty() ? new Attributes(documentModel, map) : EMPTY_ATTRIBUTES;
        this.setStartPosition(n);
        this.setEndPosition(n2);
    }

    public AttributeSet getAttributes() {
        return this.attributes;
    }

    public Document getDocument() {
        return this.model.getDocument();
    }

    public DocumentElement getElement(int n) {
        List<DocumentElement> list = this.getChildren();
        if (list.size() == 0) {
            return null;
        }
        return this.getChildren().get(n);
    }

    public int getElementCount() {
        return this.getChildren().size();
    }

    public int getStartOffset() {
        return this.startPos.getOffset();
    }

    public int getEndOffset() {
        return this.endPos.getOffset();
    }

    public int getElementIndex(int n) {
        Iterator<DocumentElement> iterator = this.getChildren().iterator();
        int n2 = Integer.MAX_VALUE;
        DocumentElement documentElement = null;
        while (iterator.hasNext()) {
            int n3;
            DocumentElement documentElement2 = iterator.next();
            if (documentElement2.getStartOffset() <= n && documentElement2.getEndOffset() > n) {
                documentElement = documentElement2;
                break;
            }
            int n4 = Math.abs(documentElement2.getStartOffset() - n);
            int n5 = Math.min(n4, n3 = Math.abs(documentElement2.getEndOffset() - n));
            if (n2 <= n5) continue;
            documentElement = documentElement2;
            n2 = n5;
        }
        if (documentElement == null) {
            return -1;
        }
        return this.getChildren().indexOf(documentElement);
    }

    public String getName() {
        return this.name;
    }

    public DocumentElement getParentElement() {
        return this.model.getParent(this);
    }

    public boolean isLeaf() {
        return this.getChildren().isEmpty();
    }

    void setAttributes(Map<String, String> map) {
        this.attributes = new Attributes(this.model, map);
    }

    boolean isEmpty() {
        return this.getStartOffset() == this.getEndOffset();
    }

    public DocumentModel getDocumentModel() {
        return this.model;
    }

    public String getType() {
        return this.type;
    }

    public List<DocumentElement> getChildren() {
        return this.model.getChildren(this);
    }

    public synchronized void addDocumentElementListener(DocumentElementListener documentElementListener) {
        if (documentElementListener == null) {
            throw new NullPointerException("The argument cannot be null!");
        }
        if (documentElementListener == this.deListener || this.deListeners != null && this.deListeners.contains(documentElementListener)) {
            return;
        }
        if (this.deListeners == null) {
            if (this.deListener == null) {
                this.deListener = documentElementListener;
            } else {
                this.deListeners = new HashSet();
                this.deListeners.add(this.deListener);
                this.deListeners.add(documentElementListener);
                this.deListener = null;
            }
        } else {
            this.deListeners.add(documentElementListener);
        }
    }

    public synchronized void removeDocumentElementListener(DocumentElementListener documentElementListener) {
        if (documentElementListener == this.deListener) {
            this.deListener = null;
        } else if (this.deListeners != null) {
            this.deListeners.remove(documentElementListener);
        }
    }

    void setStartPosition(int n) throws BadLocationException {
        this.startPos = this.model.getDocument().createPosition(n);
    }

    void setEndPosition(int n) throws BadLocationException {
        this.endPos = this.model.getDocument().createPosition(n);
    }

    String getContent() throws BadLocationException {
        return this.model.getDocument().getText(this.getStartOffset(), this.getEndOffset() - this.getStartOffset());
    }

    private synchronized void fireDocumentElementEvent(DocumentElementEvent documentElementEvent) {
        if (this.deListener != null) {
            this.fireDocumentElementEvent(this.deListener, documentElementEvent);
        } else if (this.deListeners != null) {
            for (DocumentElementListener documentElementListener : this.deListeners) {
                this.fireDocumentElementEvent(documentElementListener, documentElementEvent);
            }
        }
    }

    private void fireDocumentElementEvent(DocumentElementListener documentElementListener, DocumentElementEvent documentElementEvent) {
        switch (documentElementEvent.getType()) {
            case 2: {
                documentElementListener.elementAdded(documentElementEvent);
                break;
            }
            case 3: {
                documentElementListener.elementRemoved(documentElementEvent);
                break;
            }
            case 1: {
                documentElementListener.contentChanged(documentElementEvent);
                break;
            }
            case 5: {
                documentElementListener.attributesChanged(documentElementEvent);
            }
        }
    }

    void childAdded(DocumentElement documentElement) {
        this.fireDocumentElementEvent(new DocumentElementEvent(2, this, documentElement));
    }

    void childRemoved(DocumentElement documentElement) {
        this.fireDocumentElementEvent(new DocumentElementEvent(3, this, documentElement));
    }

    void contentChanged() {
        this.fireDocumentElementEvent(new DocumentElementEvent(1, this, null));
    }

    void attributesChanged() {
        this.fireDocumentElementEvent(new DocumentElementEvent(5, this, null));
    }

    public boolean equals(Object object) {
        if (!(object instanceof DocumentElement)) {
            return false;
        }
        DocumentElement documentElement = (DocumentElement)object;
        return documentElement.getName().equals(this.getName()) && documentElement.getType().equals(this.getType()) && documentElement.getStartOffset() == this.getStartOffset() && documentElement.getEndOffset() == this.getEndOffset();
    }

    public int hashCode() {
        int n = 5;
        n = 29 * n + (this.name != null ? this.name.hashCode() : 0);
        n = 29 * n + (this.type != null ? this.type.hashCode() : 0);
        n = 29 * n + (this.startPos != null ? this.startPos.hashCode() : 0);
        n = 29 * n + (this.endPos != null ? this.endPos.hashCode() : 0);
        return n;
    }

    public String toString() {
        String string = "";
        try {
            string = this.getContent().trim().length() > 10 ? this.getContent().trim().substring(0, 10) + "..." : this.getContent().trim();
        }
        catch (BadLocationException badLocationException) {
            string = "error:" + badLocationException.getMessage();
        }
        return "DE (" + this.hashCode() + ")[\"" + this.getName() + "\" (" + this.getType() + ") <" + this.getStartOffset() + "-" + this.getEndOffset() + "> '" + this.encodeNewLines(string) + "']";
    }

    private String encodeNewLines(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\n') {
                stringBuffer.append("\\n");
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Attributes
    implements AttributeSet {
        private String[] attr_keys;
        private String[] attr_vals;

        Attributes() {
            this.attr_keys = null;
            this.attr_vals = null;
        }

        Attributes(DocumentModel documentModel, Map<String, String> map) {
            this.attr_keys = new String[map.size()];
            this.attr_vals = new String[map.size()];
            this.initAttrs(documentModel, map);
        }

        private void initAttrs(DocumentModel documentModel, Map<String, String> map) {
            int n = 0;
            for (String string : map.keySet()) {
                if (!documentModel.elementsAttrNamesCache.containsKey(string)) {
                    documentModel.elementsAttrNamesCache.put(string, string);
                }
                this.attr_keys[n] = documentModel.elementsAttrNamesCache.get(string);
                String string2 = map.get(string);
                if (!documentModel.elementsAttrValueCache.containsKey(string2)) {
                    documentModel.elementsAttrValueCache.put(string2, string2);
                }
                this.attr_vals[n++] = documentModel.elementsAttrValueCache.get(string2);
            }
        }

        private List<String> keys() {
            if (this.attr_keys == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(this.attr_keys);
        }

        @Override
        public int getAttributeCount() {
            return this.attr_keys == null ? 0 : this.attr_keys.length;
        }

        @Override
        public boolean isDefined(Object object) {
            return this.keys().contains(object);
        }

        @Override
        public boolean isEqual(AttributeSet attributeSet) {
            if (this.getAttributeCount() != attributeSet.getAttributeCount()) {
                return false;
            }
            return this.containsAttributes(attributeSet);
        }

        @Override
        public AttributeSet copyAttributes() {
            return this;
        }

        @Override
        public Object getAttribute(Object object) {
            if (this.attr_keys == null) {
                return null;
            }
            for (int i = 0; i < this.attr_keys.length; ++i) {
                if (!this.attr_keys[i].equals(object)) continue;
                return this.attr_vals[i];
            }
            return null;
        }

        public Enumeration<String> getAttributeNames() {
            return Collections.enumeration(this.keys());
        }

        @Override
        public boolean containsAttribute(Object object, Object object2) {
            return object2.equals(this.getAttribute(object));
        }

        @Override
        public boolean containsAttributes(AttributeSet attributeSet) {
            Enumeration<?> enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object object;
                Object obj = enumeration.nextElement();
                if (this.containsAttribute(obj, object = attributeSet.getAttribute(obj))) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            Enumeration<String> enumeration = this.getAttributeNames();
            StringBuffer stringBuffer = new StringBuffer();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                Object object = this.getAttribute(string);
                stringBuffer.append((Object)string);
                stringBuffer.append('=');
                stringBuffer.append(object);
                stringBuffer.append(' ');
            }
            return stringBuffer.toString();
        }

        @Override
        public AttributeSet getResolveParent() {
            return null;
        }

        public int compareTo(AttributeSet attributeSet) {
            return this.toString().compareTo(attributeSet.toString());
        }
    }
}

