/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.content;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.welcome.content.RSSFeed;
import org.openide.util.NbPreferences;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinationRSSFeed
extends RSSFeed {
    private String url1;
    private String url2;
    private int maxItemCount;

    public CombinationRSSFeed(String string, String string2, boolean bl, int n) {
        super(bl);
        this.maxItemCount = n;
        this.url1 = string;
        this.url2 = string2;
    }

    @Override
    protected List<RSSFeed.FeedItem> buildItemList() throws SAXException, ParserConfigurationException, IOException {
        XMLReader xMLReader = XMLUtil.createXMLReader((boolean)false, (boolean)true);
        RSSFeed.FeedHandler feedHandler = new RSSFeed.FeedHandler(this.getMaxItemCount());
        xMLReader.setContentHandler(feedHandler);
        xMLReader.setEntityResolver((EntityResolver)EntityCatalog.getDefault());
        xMLReader.setErrorHandler(new RSSFeed.ErrorCatcher());
        xMLReader.parse(this.findInputSource(new URL(this.url1)));
        ArrayList<RSSFeed.FeedItem> arrayList = new ArrayList<RSSFeed.FeedItem>(2 * this.getMaxItemCount());
        arrayList.addAll(feedHandler.getItemList());
        feedHandler = new RSSFeed.FeedHandler(this.getMaxItemCount());
        xMLReader.setContentHandler(feedHandler);
        xMLReader.parse(this.findInputSource(new URL(this.url2)));
        arrayList.addAll(feedHandler.getItemList());
        List<RSSFeed.FeedItem> list = this.sortNodes(arrayList);
        if (list.size() > this.getMaxItemCount()) {
            list = list.subList(0, this.getMaxItemCount());
        }
        return list;
    }

    private ArrayList<RSSFeed.FeedItem> sortNodes(ArrayList<RSSFeed.FeedItem> arrayList) {
        Collections.sort(arrayList, new DateFeedItemComparator());
        return arrayList;
    }

    @Override
    protected void clearCache() {
        try {
            NbPreferences.forModule(RSSFeed.class).remove(this.url2path(new URL(this.url1)));
            NbPreferences.forModule(RSSFeed.class).remove(this.url2path(new URL(this.url2)));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @Override
    protected int getMaxItemCount() {
        return this.maxItemCount;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateFeedItemComparator
    implements Comparator<RSSFeed.FeedItem> {
        private static DateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
        private static DateFormat dateFormatLong = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
        private static DateFormat dateFormatShort = new SimpleDateFormat("EEE, dd MMM yyyy", Locale.ENGLISH);

        private DateFeedItemComparator() {
        }

        @Override
        public int compare(RSSFeed.FeedItem feedItem, RSSFeed.FeedItem feedItem2) {
            Date date = this.extractDate(feedItem);
            Date date2 = this.extractDate(feedItem2);
            if (null == date && null == date2) {
                return 0;
            }
            if (null == date) {
                return 1;
            }
            if (null == date2) {
                return -1;
            }
            if (date.after(date2)) {
                return -1;
            }
            if (date.before(date2)) {
                return 1;
            }
            return 0;
        }

        private Date extractDate(RSSFeed.FeedItem feedItem) {
            try {
                if (null != feedItem.dateTime) {
                    return dateFormat.parse(feedItem.dateTime);
                }
            }
            catch (ParseException parseException) {
                try {
                    return dateFormatShort.parse(feedItem.dateTime);
                }
                catch (ParseException parseException2) {
                    try {
                        return dateFormatLong.parse(feedItem.dateTime);
                    }
                    catch (ParseException parseException3) {
                        // empty catch block
                    }
                }
            }
            return null;
        }
    }
}

