/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.EventQueue;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.dlight.api.datafilter.DataFilterManager;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.management.api.DLightSessionListener;
import org.netbeans.modules.dlight.spi.visualizer.Visualizer;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerContainer;
import org.netbeans.modules.dlight.visualizers.support.TimeIntervalPanel;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VisualizerTopComponentTopComponent
extends TopComponent
implements VisualizerContainer,
DLightSessionListener {
    private static VisualizerTopComponentTopComponent instance;
    private static final String PREFERRED_ID = "VisualizerTopComponentTopComponent";
    private JPanel performanceMonitorViewsArea = new JPanel();
    private TimeIntervalPanel toolbarArea = new TimeIntervalPanel(null);
    private JComponent viewComponent;
    private String currentToolName;
    private DLightSession session;

    private VisualizerTopComponentTopComponent() {
        this.initComponents();
        this.initPerformanceMonitorViewComponents();
        this.setName(NbBundle.getMessage(VisualizerTopComponentTopComponent.class, (String)"CTL_VisualizerTopComponentTopComponent"));
        this.setToolTipText(NbBundle.getMessage(VisualizerTopComponentTopComponent.class, (String)"HINT_VisualizerTopComponentTopComponent"));
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized VisualizerTopComponentTopComponent getDefault() {
        if (instance == null) {
            instance = new VisualizerTopComponentTopComponent();
        }
        return instance;
    }

    protected void componentActivated() {
        super.componentActivated();
        if (this.viewComponent != null) {
            super.requestFocusInWindow(false);
            this.viewComponent.requestFocus();
        }
    }

    public static synchronized VisualizerTopComponentTopComponent findInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (topComponent == null) {
            Logger.getLogger(VisualizerTopComponentTopComponent.class.getName()).warning("Cannot find VisualizerTopComponentTopComponent component. It will not be located properly in the window system.");
            return VisualizerTopComponentTopComponent.getDefault();
        }
        if (topComponent instanceof VisualizerTopComponentTopComponent) {
            return (VisualizerTopComponentTopComponent)topComponent;
        }
        Logger.getLogger(VisualizerTopComponentTopComponent.class.getName()).warning("There seem to be multiple components with the 'VisualizerTopComponentTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return VisualizerTopComponentTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
        DLightManager.getDefault().removeDLightSessionListener((DLightSessionListener)this);
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void setContent(String string, JComponent jComponent) {
        if (this.currentToolName != null && this.currentToolName.equals(string) && this.viewComponent == jComponent) {
            return;
        }
        this.currentToolName = string;
        this.performanceMonitorViewsArea.removeAll();
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.viewComponent = jComponent;
        this.performanceMonitorViewsArea.add(jComponent);
        this.toolbarArea.update((DataFilterManager)DLightManager.getDefault().getActiveSession());
        this.setName(string);
        this.setToolTipText(string);
        this.validate();
        this.repaint();
    }

    public void addVisualizer(String string, String string2, Visualizer<?> visualizer) {
        this.setContent(string2, visualizer.getComponent());
        visualizer.refresh();
    }

    public void showup() {
        this.open();
        this.requestActive();
    }

    public void removeVisualizer(final Visualizer<?> visualizer) {
        if (EventQueue.isDispatchThread()) {
            this.closePerformanceMonitor(visualizer);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    VisualizerTopComponentTopComponent.this.closePerformanceMonitor(visualizer);
                }
            });
        }
    }

    public void requestFocus() {
        if (this.viewComponent != null) {
            this.viewComponent.requestFocus();
        } else {
            super.requestFocus(true);
        }
    }

    public void addContent(String string, JComponent jComponent) {
        if (this.currentToolName == null || !this.currentToolName.equals(string) || this.viewComponent != jComponent) {
            this.currentToolName = string;
            this.performanceMonitorViewsArea.removeAll();
            this.setLayout(new BoxLayout((Container)((Object)this), 1));
        }
        this.viewComponent = jComponent;
        this.performanceMonitorViewsArea.add(jComponent);
        this.toolbarArea.update((DataFilterManager)DLightManager.getDefault().getActiveSession());
        this.setName(string);
        this.setToolTipText(string);
        this.validate();
        this.repaint();
    }

    public void activeSessionChanged(DLightSession dLightSession, DLightSession dLightSession2) {
        this.session = dLightSession2;
        this.toolbarArea.update((DataFilterManager)this.session);
    }

    public void sessionAdded(DLightSession dLightSession) {
    }

    public void sessionRemoved(DLightSession dLightSession) {
    }

    private void initPerformanceMonitorViewComponents() {
        this.setLayout(new BorderLayout());
        this.performanceMonitorViewsArea.setLayout(new BorderLayout());
        this.add(this.toolbarArea, "North");
        this.add(this.performanceMonitorViewsArea, "Center");
    }

    public void closePerformanceMonitor(Visualizer<?> visualizer) {
        if (this.viewComponent != visualizer.getComponent()) {
            return;
        }
        this.toolbarArea.update((DataFilterManager)null);
        this.performanceMonitorViewsArea.remove(visualizer.getComponent());
        this.setName(NbBundle.getMessage(VisualizerTopComponentTopComponent.class, (String)"RunMonitorDetailes"));
        this.repaint();
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return VisualizerTopComponentTopComponent.getDefault();
        }
    }
}

