/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.FunctionCallWithMetric;
import org.netbeans.modules.dlight.core.stack.dataprovider.FunctionCallTreeTableNode;
import org.netbeans.modules.dlight.core.stack.dataprovider.SourceFileInfoDataProvider;
import org.netbeans.modules.dlight.core.stack.dataprovider.StackDataProvider;
import org.netbeans.modules.dlight.core.stack.spi.AnnotatedSourceSupport;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.netbeans.modules.dlight.spi.SourceSupportProvider;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.visualizers.ImageLoader;
import org.netbeans.modules.dlight.visualizers.TreeTableVisualizer;
import org.netbeans.modules.dlight.visualizers.api.CallersCalleesVisualizerConfiguration;
import org.netbeans.modules.dlight.visualizers.api.TreeTableVisualizerConfiguration;
import org.netbeans.modules.dlight.visualizers.api.impl.TreeTableVisualizerConfigurationAccessor;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CallersCalleesVisualizer
extends TreeTableVisualizer<FunctionCallTreeTableNode> {
    public static final String IS_CALLS = "TopTenFunctionsIsCalls";
    private static final int TOP_FUNCTIONS_COUNT = 10;
    private final CallersCalleesVisualizerConfiguration configuration;
    private final StackDataProvider dataProvider;
    private final Object syncFillInLock = new Object();
    private JToggleButton callers;
    private JToggleButton calls;
    private boolean isCalls = true;
    private Future<List<FunctionCallWithMetric>> syncFillDataTask;
    private DefaultMutableTreeNode focusedTreeNode = null;
    private final List<DataTableMetadata.Column> metricsList;

    CallersCalleesVisualizer(StackDataProvider stackDataProvider, TreeTableVisualizerConfiguration treeTableVisualizerConfiguration) {
        super(treeTableVisualizerConfiguration, stackDataProvider);
        this.configuration = (CallersCalleesVisualizerConfiguration)treeTableVisualizerConfiguration;
        this.configuration.setNodeActionProvider(new NodeActionsProviderImpl());
        this.dataProvider = stackDataProvider;
        this.isCalls = NbPreferences.forModule(CallersCalleesVisualizer.class).getBoolean(IS_CALLS, true);
        this.metricsList = Arrays.asList(TreeTableVisualizerConfigurationAccessor.getDefault().getTableColumns(treeTableVisualizerConfiguration));
    }

    public TreeTableVisualizerConfiguration getConfiguration() {
        return super.getVisualizerConfiguration();
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        if (TreeTableVisualizerConfigurationAccessor.getDefault().isTableView(this.getConfiguration())) {
            return;
        }
        JButton jButton = new JButton();
        this.calls = new JToggleButton();
        this.callers = new JToggleButton();
        JToolBar jToolBar = this.getButtonsTolbar();
        jToolBar.setFloatable(false);
        jToolBar.setOrientation(1);
        jToolBar.setRollover(true);
        jButton.setIcon(ImageLoader.loadIcon("focus.png"));
        jButton.setFocusable(false);
        jButton.setHorizontalTextPosition(0);
        jButton.setMaximumSize(new Dimension(28, 28));
        jButton.setMinimumSize(new Dimension(28, 28));
        jButton.setPreferredSize(new Dimension(28, 28));
        jButton.setVerticalTextPosition(3);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallersCalleesVisualizer.this.focusOnActionPerformed(actionEvent);
            }
        });
        jToolBar.add(jButton);
        jToolBar.add(new JToolBar.Separator());
        this.calls.setIcon(ImageLoader.loadIcon("who_is_called.png"));
        this.calls.setFocusable(false);
        this.calls.setHorizontalTextPosition(0);
        this.calls.setVerticalTextPosition(3);
        this.calls.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallersCalleesVisualizer.this.callsActionPerformed(actionEvent);
            }
        });
        jToolBar.add(this.calls);
        this.callers.setIcon(ImageLoader.loadIcon("who_calls.png"));
        this.callers.setFocusable(false);
        this.callers.setHorizontalTextPosition(0);
        this.callers.setVerticalTextPosition(3);
        this.callers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallersCalleesVisualizer.this.callersActionPerformed(actionEvent);
            }
        });
        jToolBar.add(this.callers);
        this.repaint();
        this.revalidate();
    }

    private void callsActionPerformed(ActionEvent actionEvent) {
        if (this.isCalls == this.calls.isSelected()) {
            return;
        }
        this.setDirection(true);
    }

    private void callersActionPerformed(ActionEvent actionEvent) {
        if (this.isCalls != this.callers.isSelected()) {
            return;
        }
        this.setDirection(false);
    }

    private void focusOnActionPerformed(ActionEvent actionEvent) {
        ExplorerManager explorerManager = this.getExplorerManager();
        if (explorerManager == null) {
            return;
        }
        Node[] nodeArray = explorerManager.getSelectedNodes();
        if (nodeArray == null || nodeArray.length == 0) {
            return;
        }
        Node node = nodeArray[0];
        this.focusedTreeNode = (DefaultMutableTreeNode)node.getLookup().lookup(DefaultMutableTreeNode.class);
        FunctionCallWithMetric functionCallWithMetric = this.focusedTreeNode == null ? null : ((FunctionCallTreeTableNode)this.focusedTreeNode.getUserObject()).getDeligator();
        this.setNodes(Arrays.asList(this.focusedTreeNode));
        this.loadTree(this.focusedTreeNode, Arrays.asList(new FunctionCallTreeTableNode(functionCallWithMetric)));
    }

    private ExplorerManager getExplorerManager() {
        if (this.treeTableView != null && this.treeTableView instanceof ExplorerManager.Provider) {
            return ((ExplorerManager.Provider)this.treeTableView).getExplorerManager();
        }
        return null;
    }

    private void setDirection(boolean bl) {
        this.isCalls = bl;
        NbPreferences.forModule(CallersCalleesVisualizer.class).putBoolean(IS_CALLS, this.isCalls);
        this.updateButtons();
        this.update();
    }

    private synchronized void update() {
        if (this.focusedTreeNode == null) {
            this.asyncFillModel(this.getConfiguration().getMetadata().getColumns(), true);
            return;
        }
        this.loadTree(this.focusedTreeNode, Arrays.asList((FunctionCallTreeTableNode)this.focusedTreeNode.getUserObject()));
    }

    @Override
    protected void loadTree(final DefaultMutableTreeNode defaultMutableTreeNode, final List<FunctionCallTreeTableNode> list) {
        Runnable runnable = new Runnable(){

            public void run() {
                List list3 = FunctionCallTreeTableNode.getFunctionCalls((List)list);
                final List list2 = CallersCalleesVisualizer.this.dataProvider.getCallees(list3, CallersCalleesVisualizer.this.configuration.getMetadata().getColumns(), null, CallersCalleesVisualizer.this.isCalls);
                UIThread.invoke((Runnable)new Runnable(){

                    public void run() {
                        CallersCalleesVisualizer.this.update(defaultMutableTreeNode, list2);
                    }
                });
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            DLightExecutorService.submit((Runnable)runnable, (String)"Get callers/callees");
        } else {
            runnable.run();
        }
    }

    @Override
    protected void updateTree(DefaultMutableTreeNode defaultMutableTreeNode, List<FunctionCallTreeTableNode> list) {
        defaultMutableTreeNode.removeAllChildren();
        if (list != null) {
            for (FunctionCallTreeTableNode functionCallTreeTableNode : list) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(functionCallTreeTableNode));
            }
        }
        this.fireTreeModelChanged(defaultMutableTreeNode);
    }

    private void update(DefaultMutableTreeNode defaultMutableTreeNode, List<FunctionCallWithMetric> list) {
        defaultMutableTreeNode.removeAllChildren();
        if (list != null) {
            for (FunctionCallWithMetric functionCallWithMetric : list) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(new FunctionCallTreeTableNode(functionCallWithMetric)));
            }
        }
        this.fireTreeModelChanged(defaultMutableTreeNode);
        this.notifyAnnotedSourceProviders();
    }

    @Override
    protected void syncFillModel(List<DataTableMetadata.Column> list) {
        List list2 = this.dataProvider.getHotSpotFunctions(list, null, 10);
        this.update(list2);
    }

    private final List<FunctionCallWithMetric> getAllChildren(TreeNode treeNode) {
        if (!(treeNode instanceof DefaultMutableTreeNode)) {
            return Collections.emptyList();
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode;
        if (!(defaultMutableTreeNode.getUserObject() instanceof FunctionCallTreeTableNode)) {
            return Collections.emptyList();
        }
        ArrayList<FunctionCallWithMetric> arrayList = new ArrayList<FunctionCallWithMetric>();
        arrayList.add(((FunctionCallTreeTableNode)defaultMutableTreeNode.getUserObject()).getDeligator());
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            arrayList.addAll(this.getAllChildren(defaultMutableTreeNode.getChildAt(i)));
        }
        return arrayList;
    }

    private final List<FunctionCallWithMetric> getAllFunctions() {
        ArrayList<FunctionCallWithMetric> arrayList = new ArrayList<FunctionCallWithMetric>();
        int n = this.TREE_ROOT.getChildCount();
        for (int i = 0; i < n; ++i) {
            arrayList.addAll(this.getAllChildren(this.TREE_ROOT.getChildAt(i)));
        }
        return arrayList;
    }

    private void notifyAnnotedSourceProviders() {
        final List<FunctionCallWithMetric> list = this.getAllFunctions();
        Collection collection = Lookup.getDefault().lookupAll(AnnotatedSourceSupport.class);
        for (final AnnotatedSourceSupport annotatedSourceSupport : collection) {
            DLightExecutorService.submit((Runnable)new Runnable(){

                public void run() {
                    annotatedSourceSupport.updateSource((SourceFileInfoDataProvider)CallersCalleesVisualizer.this.dataProvider, CallersCalleesVisualizer.this.metricsList, list, null);
                }
            }, (String)"Annoted Source from FunctionsListView Visualizer");
        }
    }

    private void notifyAnnotedSourceProviders(final List<FunctionCallWithMetric> list) {
        Collection collection = Lookup.getDefault().lookupAll(AnnotatedSourceSupport.class);
        for (final AnnotatedSourceSupport annotatedSourceSupport : collection) {
            DLightExecutorService.submit((Runnable)new Runnable(){

                public void run() {
                    annotatedSourceSupport.updateSource((SourceFileInfoDataProvider)CallersCalleesVisualizer.this.dataProvider, CallersCalleesVisualizer.this.metricsList, list, null);
                }
            }, (String)"Annoted Source from FunctionsListView Visualizer");
        }
    }

    private void update(List<FunctionCallWithMetric> list) {
        boolean bl = list == null || list.isEmpty();
        this.setContent(bl);
        if (!bl) {
            ArrayList<FunctionCallTreeTableNode> arrayList = new ArrayList<FunctionCallTreeTableNode>();
            for (FunctionCallWithMetric functionCallWithMetric : list) {
                arrayList.add(new FunctionCallTreeTableNode(functionCallWithMetric));
            }
            this.updateList(arrayList);
            this.notifyAnnotedSourceProviders(list);
        }
    }

    @Override
    protected String getIcon(FunctionCallTreeTableNode functionCallTreeTableNode) {
        return super.getIcon(functionCallTreeTableNode);
    }

    @Override
    protected void updateButtons() {
        if (TreeTableVisualizerConfigurationAccessor.getDefault().isTableView(this.getConfiguration())) {
            return;
        }
        if (this.calls != null) {
            this.calls.setSelected(this.isCalls);
            this.callers.setSelected(!this.isCalls);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.updateButtons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        super.removeNotify();
        Object object = this.syncFillInLock;
        synchronized (object) {
            if (this.syncFillDataTask != null) {
                this.syncFillDataTask.cancel(true);
                this.syncFillDataTask = null;
            }
        }
    }

    @Override
    public int onTimer() {
        if (!this.isShown() || !this.isShowing()) {
            return 0;
        }
        this.syncFillModel(this.configuration.getMetadata().getColumns());
        return 0;
    }

    private class GoToSourceAction
    extends AbstractAction {
        private final FunctionCallWithMetric functionCall;
        private final Future<SourceFileInfoProvider.SourceFileInfo> sourceFileInfoTask;
        private boolean isEnabled;
        private boolean gotTheInfo;

        public GoToSourceAction(FunctionCallWithMetric functionCallWithMetric) {
            super(NbBundle.getMessage(CallersCalleesVisualizer.class, (String)"GoToSourceActionName"));
            this.isEnabled = false;
            this.gotTheInfo = false;
            this.functionCall = functionCallWithMetric;
            this.sourceFileInfoTask = DLightExecutorService.submit((Callable)new Callable<SourceFileInfoProvider.SourceFileInfo>(){

                @Override
                public SourceFileInfoProvider.SourceFileInfo call() {
                    return CallersCalleesVisualizer.this.dataProvider.getSourceFileInfo((FunctionCall)GoToSourceAction.this.functionCall);
                }
            }, (String)"SourceFileInfo getting info from CallersCalees Visualizer");
            this.waitForSourceFileInfo();
        }

        private void waitForSourceFileInfo() {
            DLightExecutorService.submit((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Object object = (SourceFileInfoProvider.SourceFileInfo)GoToSourceAction.this.sourceFileInfoTask.get();
                        GoToSourceAction.this.isEnabled = object != null && object.isSourceKnown();
                    }
                    catch (InterruptedException interruptedException) {
                        GoToSourceAction.this.isEnabled = false;
                    }
                    catch (ExecutionException executionException) {
                        GoToSourceAction.this.isEnabled = false;
                    }
                    finally {
                        GoToSourceAction goToSourceAction = GoToSourceAction.this;
                        synchronized (goToSourceAction) {
                            GoToSourceAction.this.gotTheInfo = true;
                        }
                        GoToSourceAction.this.setEnabled(GoToSourceAction.this.isEnabled);
                    }
                }
            }, (String)"Wait For the SourceFileInfo");
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DLightExecutorService.submit((Runnable)new Runnable(){

                public void run() {
                    SourceFileInfoProvider.SourceFileInfo sourceFileInfo = null;
                    try {
                        sourceFileInfo = (SourceFileInfoProvider.SourceFileInfo)GoToSourceAction.this.sourceFileInfoTask.get();
                    }
                    catch (InterruptedException interruptedException) {
                        Exceptions.printStackTrace((Throwable)interruptedException);
                    }
                    catch (ExecutionException executionException) {
                        Exceptions.printStackTrace((Throwable)executionException);
                    }
                    if (sourceFileInfo == null) {
                        return;
                    }
                    SourceSupportProvider sourceSupportProvider = (SourceSupportProvider)Lookup.getDefault().lookup(SourceSupportProvider.class);
                    sourceSupportProvider.showSource(sourceFileInfo);
                    CallersCalleesVisualizer.this.notifyAnnotedSourceProviders();
                }
            }, (String)"GoToSource from Callers Calees Visualizer");
        }
    }

    class NodeActionsProviderImpl
    implements NodeActionsProvider {
        NodeActionsProviderImpl() {
        }

        public void performDefaultAction(Object object) throws UnknownTypeException {
            if (!(object instanceof DefaultMutableTreeNode)) {
                throw new UnknownTypeException(object);
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (!(object2 instanceof FunctionCallTreeTableNode)) {
                return;
            }
            FunctionCallWithMetric functionCallWithMetric = ((FunctionCallTreeTableNode)object2).getDeligator();
            GoToSourceAction goToSourceAction = new GoToSourceAction(functionCallWithMetric);
            goToSourceAction.actionPerformed(null);
        }

        public Action[] getActions(Object object) throws UnknownTypeException {
            if (!(object instanceof DefaultMutableTreeNode)) {
                throw new UnknownTypeException(object);
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (!(object2 instanceof FunctionCallTreeTableNode)) {
                return null;
            }
            return new Action[]{new GoToSourceAction(((FunctionCallTreeTableNode)object2).getDeligator())};
        }
    }
}

