/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.ui.options;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.utils.FileChooser;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.utils.Path;
import org.netbeans.modules.cnd.ui.options.DownloadUtils;
import org.netbeans.modules.cnd.ui.options.ToolsPanel;
import org.netbeans.modules.cnd.ui.options.ToolsPanelModel;
import org.netbeans.modules.cnd.ui.options.VersionCommand;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolCollectionPanel
extends JPanel
implements DocumentListener,
ItemListener {
    private final String MAKE_NAME = "make";
    private final String DEBUGGER_NAME = "debugger";
    private final String C_NAME = "C";
    private final String CPP_NAME = "C++";
    private final String FORTRAN_NAME = "Fortran";
    private final String ASSEMBLER_NAME = "Assembler";
    private final String QMAKE_NAME = "QMake";
    private final String CMAKE_NAME = "CMake";
    private Color tfColor = null;
    private boolean isUrl = false;
    private final ToolsPanel manager;
    private JButton btAsBrowse;
    private JButton btCBrowse;
    private JButton btCMakeBrowse;
    private JButton btCppBrowse;
    private JButton btDebuggerBrowse;
    private JButton btFortranBrowse;
    private JButton btInstall;
    private JButton btMakeBrowse;
    private JButton btQMakeBrowse;
    private JCheckBox cbAsRequired;
    private JCheckBox cbCRequired;
    private JCheckBox cbCppRequired;
    private JCheckBox cbDebuggerRequired;
    private JCheckBox cbFortranRequired;
    private JCheckBox cbMakeRequired;
    private JLabel lbAsCommand;
    private JLabel lbBaseDirectory;
    private JLabel lbCCommand;
    private JLabel lbCMakePath;
    private JLabel lbCppCommand;
    private JLabel lbDebuggerCommand;
    private JLabel lbFamily;
    private JLabel lbFamilyValue;
    private JLabel lbFortranCommand;
    private JLabel lbMakeCommand;
    private JLabel lbQMakePath;
    private JLabel requiredToolsLabel;
    private JPanel requiredToolsPanel;
    private JScrollPane scrollPane;
    private JTextField tfAsPath;
    private JTextField tfBaseDirectory;
    private JTextField tfCMakePath;
    private JTextField tfCPath;
    private JTextField tfCppPath;
    private JTextField tfDebuggerPath;
    private JTextField tfFortranPath;
    private JTextField tfMakePath;
    private JTextField tfQMakePath;
    private JTextPane tpInstall;

    public ToolCollectionPanel(ToolsPanel toolsPanel) {
        this.manager = toolsPanel;
        this.initComponents();
        this.tpInstall.setContentType("text/html");
        this.btInstall.setVisible(this.isUrl);
        this.scrollPane.setVisible(this.isUrl);
        this.cbDebuggerRequired.setName("debugger");
        this.cbCRequired.setName("c");
        this.cbCppRequired.setName("c++");
        this.cbFortranRequired.setName("fortran");
        this.cbAsRequired.setName("assembler");
    }

    void initializeUI() {
        if (!this.manager.getModel().showRequiredTools()) {
            this.requiredToolsLabel.setVisible(false);
            this.requiredToolsPanel.setVisible(false);
        }
        this.btCBrowse.setEnabled(false);
        this.btCppBrowse.setEnabled(false);
        this.btFortranBrowse.setEnabled(false);
        this.btAsBrowse.setEnabled(false);
        this.btMakeBrowse.setEnabled(false);
        this.btDebuggerBrowse.setEnabled(false);
        this.tfMakePath.setEditable(false);
        this.tfDebuggerPath.setEditable(false);
        this.tfQMakePath.setEditable(false);
        this.tfCMakePath.setEditable(false);
        if (this.manager.getModel().enableRequiredCompilerCB()) {
            this.cbCRequired.setEnabled(true);
            this.cbCppRequired.setEnabled(true);
            this.cbFortranRequired.setEnabled(true);
            this.cbAsRequired.setEnabled(true);
        } else {
            this.cbCRequired.setEnabled(false);
            this.cbCppRequired.setEnabled(false);
            this.cbFortranRequired.setEnabled(false);
            this.cbAsRequired.setEnabled(false);
        }
        this.cbMakeRequired.setSelected(this.manager.getModel().isMakeRequired());
        this.cbDebuggerRequired.setSelected(this.manager.getModel().isDebuggerRequired());
        this.cbCRequired.setSelected(this.manager.getModel().isCRequired());
        this.cbCppRequired.setSelected(this.manager.getModel().isCppRequired());
        this.cbFortranRequired.setSelected(this.manager.getModel().isFortranRequired());
        this.cbAsRequired.setSelected(this.manager.getModel().isAsRequired());
    }

    void updateUI(boolean bl, CompilerSet compilerSet) {
        this.lbDebuggerCommand.setVisible(this.manager.isCustomizableDebugger());
        this.tfDebuggerPath.setVisible(this.manager.isCustomizableDebugger());
        this.btDebuggerBrowse.setVisible(this.manager.isCustomizableDebugger());
        this.cbMakeRequired.setVisible(this.manager.getModel().showRequiredBuildTools());
        this.cbDebuggerRequired.setVisible(this.manager.getModel().showRequiredDebugTools() && this.manager.isCustomizableDebugger());
        this.cbCppRequired.setVisible(this.manager.getModel().showRequiredBuildTools());
        this.cbCRequired.setVisible(this.manager.getModel().showRequiredBuildTools());
        this.cbFortranRequired.setVisible(this.manager.getModel().showRequiredBuildTools());
        this.cbAsRequired.setVisible(this.manager.getModel().showRequiredBuildTools());
    }

    void removeCompilerSet() {
        this.lbFamilyValue.setText("");
        this.tfBaseDirectory.setText("");
        this.tfCPath.setText("");
        this.tfCppPath.setText("");
        this.tfFortranPath.setText("");
        this.tfAsPath.setText("");
        this.tfMakePath.setText("");
        this.tfDebuggerPath.setText("");
        this.tfQMakePath.setText("");
        this.tfCMakePath.setText("");
    }

    void updateCompilerSet(CompilerSet compilerSet, boolean bl) {
        if (compilerSet.isUrlPointer()) {
            return;
        }
        if (bl) {
            compilerSet.getTool(0).setPath(this.tfCPath.getText());
            compilerSet.getTool(1).setPath(this.tfCppPath.getText());
            compilerSet.getTool(2).setPath(this.tfFortranPath.getText());
            compilerSet.getTool(4).setPath(this.tfAsPath.getText());
            compilerSet.getTool(5).setPath(this.tfMakePath.getText());
            compilerSet.getTool(6).setPath(this.tfDebuggerPath.getText());
            compilerSet.getTool(7).setPath(this.tfQMakePath.getText());
            compilerSet.getTool(8).setPath(this.tfCMakePath.getText());
        } else {
            compilerSet.findTool(0).setPath(this.tfCPath.getText());
            compilerSet.findTool(1).setPath(this.tfCppPath.getText());
            compilerSet.findTool(2).setPath(this.tfFortranPath.getText());
            compilerSet.findTool(4).setPath(this.tfAsPath.getText());
            compilerSet.findTool(5).setPath(this.tfMakePath.getText());
            compilerSet.findTool(6).setPath(this.tfDebuggerPath.getText());
            compilerSet.findTool(7).setPath(this.tfQMakePath.getText());
            compilerSet.findTool(8).setPath(this.tfCMakePath.getText());
        }
    }

    void applyChanges() {
        ToolsPanelModel toolsPanelModel = this.manager.getModel();
        if (toolsPanelModel != null) {
            if (toolsPanelModel.isDebuggerRequired() != this.cbDebuggerRequired.isSelected()) {
                toolsPanelModel.setDebuggerRequired(this.cbDebuggerRequired.isSelected());
            }
            if (toolsPanelModel.isCRequired() != this.cbCRequired.isSelected()) {
                toolsPanelModel.setCRequired(this.cbCRequired.isSelected());
            }
            if (toolsPanelModel.isCppRequired() != this.cbCppRequired.isSelected()) {
                toolsPanelModel.setCppRequired(this.cbCppRequired.isSelected());
            }
            if (toolsPanelModel.isFortranRequired() != this.cbFortranRequired.isSelected()) {
                toolsPanelModel.setFortranRequired(this.cbFortranRequired.isSelected());
            }
            if (toolsPanelModel.isAsRequired() != this.cbAsRequired.isSelected()) {
                toolsPanelModel.setAsRequired(this.cbAsRequired.isSelected());
            }
        }
    }

    void preChangeCompilerSet(CompilerSet compilerSet) {
        if (compilerSet == null) {
            this.lbFamilyValue.setText("");
            this.updateToolsControls(false, false, false, true);
            return;
        }
        if (compilerSet.isUrlPointer()) {
            this.isUrl = true;
            String string = compilerSet.getCompilerFlavor().toString();
            String string2 = compilerSet.getDisplayName();
            String string3 = compilerSet.getCompilerFlavor().getToolchainDescriptor().getUpdateCenterUrl();
            String string4 = ToolsPanel.getString("ToolsPanel.UpdateCenterMessage", string, string2, string3);
            this.tpInstall.setText(string4);
            this.tpInstall.setBackground(this.getBackground());
            this.tpInstall.select(this.tpInstall.getDocument().getLength() - 1, this.tpInstall.getDocument().getLength() - 1);
        } else {
            this.isUrl = false;
            this.tfBaseDirectory.setText(compilerSet.getDirectory());
        }
        this.scrollPane.setVisible(this.isUrl);
        this.btInstall.setVisible(this.isUrl);
        this.lbFamily.setVisible(!this.isUrl);
        this.lbFamilyValue.setVisible(!this.isUrl);
        this.lbAsCommand.setVisible(!this.isUrl);
        this.lbBaseDirectory.setVisible(!this.isUrl);
        this.lbCCommand.setVisible(!this.isUrl);
        this.lbCMakePath.setVisible(!this.isUrl);
        this.lbCppCommand.setVisible(!this.isUrl);
        this.lbDebuggerCommand.setVisible(!this.isUrl);
        this.lbFortranCommand.setVisible(!this.isUrl);
        this.lbMakeCommand.setVisible(!this.isUrl);
        this.lbQMakePath.setVisible(!this.isUrl);
        this.tfAsPath.setVisible(!this.isUrl);
        this.tfBaseDirectory.setVisible(!this.isUrl);
        this.tfCMakePath.setVisible(!this.isUrl);
        this.tfCPath.setVisible(!this.isUrl);
        this.tfCppPath.setVisible(!this.isUrl);
        this.tfDebuggerPath.setVisible(!this.isUrl);
        this.tfFortranPath.setVisible(!this.isUrl);
        this.tfMakePath.setVisible(!this.isUrl);
        this.tfQMakePath.setVisible(!this.isUrl);
        this.btAsBrowse.setVisible(!this.isUrl);
        this.btCBrowse.setVisible(!this.isUrl);
        this.btCMakeBrowse.setVisible(!this.isUrl);
        this.btCppBrowse.setVisible(!this.isUrl);
        this.btDebuggerBrowse.setVisible(!this.isUrl);
        this.btFortranBrowse.setVisible(!this.isUrl);
        this.btMakeBrowse.setVisible(!this.isUrl);
        this.btQMakeBrowse.setVisible(!this.isUrl);
        this.lbFamilyValue.setText(compilerSet.getCompilerFlavor().toString());
    }

    void changeCompilerSet(CompilerSet compilerSet) {
        Tool tool = null;
        Tool tool2 = null;
        Tool tool3 = null;
        Tool tool4 = null;
        Tool tool5 = null;
        Tool tool6 = null;
        Tool tool7 = null;
        Tool tool8 = null;
        if (!compilerSet.isUrlPointer()) {
            tool = compilerSet.getTool(0);
            tool2 = compilerSet.getTool(1);
            tool3 = compilerSet.getTool(2);
            tool4 = compilerSet.getTool(4);
            tool5 = compilerSet.getTool(5);
            tool6 = compilerSet.getTool(6);
            tool7 = compilerSet.getTool(7);
            tool8 = compilerSet.getTool(8);
        }
        if (tool != null) {
            this.setCPathField(tool.getPath());
        } else {
            this.tfCPath.setText("");
        }
        if (tool2 != null) {
            this.setCppPathField(tool2.getPath());
        } else {
            this.tfCppPath.setText("");
        }
        if (tool3 != null) {
            this.setFortranPathField(tool3.getPath());
        } else {
            this.tfFortranPath.setText("");
        }
        if (tool4 != null) {
            this.setAsPathField(tool4.getPath());
        } else {
            this.tfAsPath.setText("");
        }
        if (tool7 != null) {
            this.setQMakePathField(tool7.getPath());
        } else {
            this.tfQMakePath.setText("");
        }
        if (tool8 != null) {
            this.setCMakePathField(tool8.getPath());
        } else {
            this.tfCMakePath.setText("");
        }
        if (tool5 != null) {
            this.setMakePathField(tool5.getPath());
        } else {
            this.tfMakePath.setText("");
        }
        if (tool6 != null) {
            this.setGdbPathField(tool6.getPath());
        } else {
            this.tfDebuggerPath.setText("");
        }
    }

    private void setMakePathField(String string) {
        this.tfMakePath.setText(string);
    }

    private void validateMakePathField() {
        this.setPathFieldValid(this.tfMakePath, this.isPathFieldValid(this.tfMakePath) && this.supportedMake(this.tfMakePath));
        this.manager.dataValid();
    }

    private void setGdbPathField(String string) {
        this.tfDebuggerPath.setText(string);
    }

    private void validateGdbPathField() {
        this.setPathFieldValid(this.tfDebuggerPath, this.isPathFieldValid(this.tfDebuggerPath));
        this.manager.dataValid();
    }

    private void setCPathField(String string) {
        this.tfCPath.setText(string);
    }

    private void validateCPathField() {
        this.setPathFieldValid(this.tfCPath, this.isPathFieldValid(this.tfCPath));
        this.manager.dataValid();
    }

    private void setCppPathField(String string) {
        this.tfCppPath.setText(string);
    }

    private void validateCppPathField() {
        this.setPathFieldValid(this.tfCppPath, this.isPathFieldValid(this.tfCppPath));
        this.manager.dataValid();
    }

    private void setFortranPathField(String string) {
        this.tfFortranPath.setText(string);
    }

    private void validateFortranPathField() {
        this.setPathFieldValid(this.tfFortranPath, this.isPathFieldValid(this.tfFortranPath));
        this.manager.dataValid();
    }

    private void setAsPathField(String string) {
        this.tfAsPath.setText(string);
    }

    private void validateAsPathField() {
        this.setPathFieldValid(this.tfAsPath, this.isPathFieldValid(this.tfAsPath));
        this.manager.dataValid();
    }

    private void setQMakePathField(String string) {
        this.tfQMakePath.setText(string);
    }

    private void validateQMakePathField() {
        this.setPathFieldValid(this.tfQMakePath, this.isPathFieldValid(this.tfQMakePath));
        this.manager.dataValid();
    }

    private void setCMakePathField(String string) {
        this.tfCMakePath.setText(string);
    }

    private void validateCMakePathField() {
        this.setPathFieldValid(this.tfCMakePath, this.isPathFieldValid(this.tfCMakePath));
        this.manager.dataValid();
    }

    private void setPathFieldValid(JTextField jTextField, boolean bl) {
        if (bl) {
            jTextField.setForeground(this.tfColor);
        } else {
            jTextField.setForeground(Color.RED);
        }
    }

    private boolean supportedMake(JTextField jTextField) {
        String string = jTextField.getText();
        if (string.length() == 0) {
            return false;
        }
        return ToolsPanel.supportedMake(string);
    }

    boolean isToolsValid() {
        boolean bl = this.cbMakeRequired.isSelected() ? this.isPathFieldValid(this.tfMakePath) && this.supportedMake(this.tfMakePath) : true;
        boolean bl2 = this.cbDebuggerRequired.isSelected() ? this.isPathFieldValid(this.tfDebuggerPath) : true;
        boolean bl3 = this.cbCRequired.isSelected() ? this.isPathFieldValid(this.tfCPath) : true;
        boolean bl4 = this.cbCppRequired.isSelected() ? this.isPathFieldValid(this.tfCppPath) : true;
        boolean bl5 = this.cbFortranRequired.isSelected() ? this.isPathFieldValid(this.tfFortranPath) : true;
        boolean bl6 = this.cbAsRequired.isSelected() ? this.isPathFieldValid(this.tfAsPath) : true;
        return bl && bl2 && bl3 && bl4 && bl5 && bl6;
    }

    void getErrors(List<String> list) {
        boolean bl;
        boolean bl2 = this.cbMakeRequired.isSelected() ? this.isPathFieldValid(this.tfMakePath) && this.supportedMake(this.tfMakePath) : true;
        boolean bl3 = this.cbDebuggerRequired.isSelected() ? this.isPathFieldValid(this.tfDebuggerPath) : true;
        boolean bl4 = this.cbCRequired.isSelected() ? this.isPathFieldValid(this.tfCPath) : true;
        boolean bl5 = this.cbCppRequired.isSelected() ? this.isPathFieldValid(this.tfCppPath) : true;
        boolean bl6 = this.cbFortranRequired.isSelected() ? this.isPathFieldValid(this.tfFortranPath) : true;
        boolean bl7 = bl = this.cbAsRequired.isSelected() ? this.isPathFieldValid(this.tfAsPath) : true;
        if (this.cbMakeRequired.isSelected() && !bl2) {
            if (!this.isPathFieldValid(this.tfMakePath)) {
                list.add(ToolsPanel.getString("TP_ErrorMessage_MissedMake"));
            } else {
                list.add(ToolsPanel.getString("TP_ErrorMessage_UnsupportedMake", "mingw32-make"));
            }
        }
        if (this.cbCRequired.isSelected() && !bl4) {
            list.add(ToolsPanel.getString("TP_ErrorMessage_MissedCCompiler"));
        }
        if (this.cbCppRequired.isSelected() && !bl5) {
            list.add(ToolsPanel.getString("TP_ErrorMessage_MissedCppCompiler"));
        }
        if (this.cbDebuggerRequired.isSelected() && !bl3 && this.manager.isCustomizableDebugger()) {
            list.add(ToolsPanel.getString("TP_ErrorMessage_MissedDebugger"));
        }
        if (this.cbFortranRequired.isSelected() && !bl6) {
            list.add(ToolsPanel.getString("TP_ErrorMessage_MissedFortranCompiler"));
        }
        if (this.cbAsRequired.isSelected() && !bl) {
            list.add(ToolsPanel.getString("TP_ErrorMessage_MissedAssembler"));
        }
    }

    void updateToolsControls(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.btCBrowse.setEnabled(bl2);
        this.btCppBrowse.setEnabled(bl2);
        this.btFortranBrowse.setEnabled(bl2);
        this.btAsBrowse.setEnabled(bl2);
        this.btMakeBrowse.setEnabled(bl2);
        this.btDebuggerBrowse.setEnabled(bl2);
        this.btQMakeBrowse.setEnabled(bl2);
        this.btCMakeBrowse.setEnabled(bl2);
        this.updateTextField(this.tfMakePath, bl, bl4);
        this.updateTextField(this.tfDebuggerPath, bl, bl4);
        this.updateTextField(this.tfBaseDirectory, false, bl4);
        this.updateTextField(this.tfCPath, bl, bl4);
        this.updateTextField(this.tfCppPath, bl, bl4);
        this.updateTextField(this.tfFortranPath, bl, bl4);
        this.updateTextField(this.tfAsPath, bl, bl4);
        this.updateTextField(this.tfQMakePath, bl, bl4);
        this.updateTextField(this.tfCMakePath, bl, bl4);
    }

    private void updateTextField(JTextField jTextField, boolean bl, boolean bl2) {
        if (bl2) {
            jTextField.setText("");
        }
        jTextField.setEditable(bl);
    }

    private boolean isPathFieldValid(JTextField jTextField) {
        String string = jTextField.getText();
        if (string.length() == 0) {
            return false;
        }
        if (this.manager.getExecutionEnvironment().isLocal()) {
            File file = new File(string);
            boolean bl = false;
            if (Utilities.isWindows()) {
                bl = string.endsWith(".lnk") ? false : (file.exists() || new File(string + ".lnk").exists()) && !file.isDirectory();
            } else {
                boolean bl2 = bl = file.exists() && !file.isDirectory();
            }
            if (!bl) {
                String string2;
                ArrayList<String> arrayList = Path.getPath();
                Iterator<String> iterator = arrayList.iterator();
                while (iterator.hasNext() && !(bl = (file = new File((string2 = iterator.next()) + File.separatorChar + string)).exists() && !file.isDirectory())) {
                }
            }
            return bl;
        }
        return true;
    }

    private boolean selectCompiler(JTextField jTextField) {
        String string = this.tfBaseDirectory.getText();
        FileChooser fileChooser = new FileChooser(ToolsPanel.getString("SELECT_TOOL_TITLE"), null, 0, null, string, false);
        int n = fileChooser.showOpenDialog(this);
        if (n == 1) {
            return false;
        }
        if (!new File(new File(this.tfBaseDirectory.getText()), fileChooser.getSelectedFile().getName()).exists()) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)ToolsPanel.getString("COMPILER_BASE_ERROR"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return false;
        }
        String string2 = fileChooser.getSelectedFile().getPath();
        if (Utilities.isWindows() && string2.endsWith(".lnk")) {
            string2 = string2.substring(0, string2.length() - 4);
        }
        jTextField.setText(string2);
        return true;
    }

    private boolean selectTool(JTextField jTextField) {
        String string = jTextField.getText();
        FileChooser fileChooser = new FileChooser(ToolsPanel.getString("SELECT_TOOL_TITLE"), null, 0, null, string, false);
        int n = fileChooser.showOpenDialog(this);
        if (n == 1) {
            return false;
        }
        String string2 = fileChooser.getSelectedFile().getPath();
        if (Utilities.isWindows() && string2.endsWith(".lnk")) {
            string2 = string2.substring(0, string2.length() - 4);
        }
        jTextField.setText(string2);
        return true;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        boolean bl;
        boolean bl2 = bl = !this.manager.isUpdatindOrChangingCompilerSet();
        if (bl) {
            this.manager.setChanged(true);
        }
        Document document = documentEvent.getDocument();
        String string = (String)document.getProperty("title");
        int n = -1;
        String string2 = null;
        if (string.equals("make")) {
            this.validateMakePathField();
            n = 5;
            string2 = this.tfMakePath.getText();
        } else if (string.equals("debugger")) {
            this.validateGdbPathField();
            n = 6;
            string2 = this.tfDebuggerPath.getText();
        } else if (string.equals("C")) {
            this.validateCPathField();
            n = 0;
            string2 = this.tfCPath.getText();
        } else if (string.equals("C++")) {
            this.validateCppPathField();
            n = 1;
            string2 = this.tfCppPath.getText();
        } else if (string.equals("Fortran")) {
            this.validateFortranPathField();
            n = 2;
            string2 = this.tfFortranPath.getText();
        } else if (string.equals("Assembler")) {
            this.validateAsPathField();
            n = 4;
            string2 = this.tfAsPath.getText();
        } else if (string.equals("QMake")) {
            this.validateQMakePathField();
            n = 7;
            string2 = this.tfQMakePath.getText();
        } else if (string.equals("CMake")) {
            this.validateCMakePathField();
            n = 8;
            string2 = this.tfCMakePath.getText();
        }
        if (bl && 0 <= n) {
            this.manager.getCurrentCompilerSet().getTool(n).setPath(string2);
            this.manager.fireCompilerSetChange();
            this.manager.fireCompilerSetModified();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof JCheckBox && !this.manager.isUpdatindOrChangingCompilerSet()) {
            this.manager.dataValid();
        }
    }

    private String getToolVersion(Tool tool, JTextField jTextField) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(tool.getDisplayName() + ": ");
        if (this.isPathFieldValid(jTextField)) {
            String string;
            String string2 = jTextField.getText();
            if (!IpeUtils.isPathAbsolute(string2)) {
                string2 = Path.findCommand(string2);
            }
            if ((string = this.postVersionInfo(tool, string2)) != null) {
                stringBuilder.append(string);
            } else {
                stringBuilder.append(ToolsPanel.getString("TOOL_VERSION_NOT_FOUND"));
            }
        } else {
            stringBuilder.append(ToolsPanel.getString("TOOL_NOT_FOUND"));
        }
        return stringBuilder.toString();
    }

    private String postVersionInfo(Tool tool, String string) {
        if (string == null) {
            return null;
        }
        return new VersionCommand(tool, string).getVersion();
    }

    String getVersion(CompilerSet compilerSet) {
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)ToolsPanel.getString("LBL_VersionInfo_Progress"));
        progressHandle.start(this.manager.isCustomizableDebugger() ? 8 : 7);
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        stringBuilder.append('\n');
        stringBuilder.append(this.getToolVersion(compilerSet.findTool(0), this.tfCPath)).append('\n');
        progressHandle.progress(++n);
        stringBuilder.append(this.getToolVersion(compilerSet.findTool(1), this.tfCppPath)).append('\n');
        progressHandle.progress(++n);
        stringBuilder.append(this.getToolVersion(compilerSet.findTool(2), this.tfFortranPath)).append('\n');
        progressHandle.progress(++n);
        stringBuilder.append(this.getToolVersion(compilerSet.findTool(4), this.tfAsPath)).append('\n');
        progressHandle.progress(++n);
        stringBuilder.append(this.getToolVersion(compilerSet.findTool(5), this.tfMakePath)).append('\n');
        if (this.manager.isCustomizableDebugger()) {
            progressHandle.progress(++n);
            stringBuilder.append(this.getToolVersion(compilerSet.findTool(6), this.tfDebuggerPath)).append('\n');
        }
        progressHandle.progress(++n);
        stringBuilder.append(this.getToolVersion(compilerSet.findTool(7), this.tfQMakePath)).append('\n');
        progressHandle.progress(++n);
        stringBuilder.append(this.getToolVersion(compilerSet.findTool(8), this.tfCMakePath)).append('\n');
        progressHandle.finish();
        String string = compilerSet.getCompilerFlavor().getToolchainDescriptor().getUpgradeUrl();
        if (string != null) {
            stringBuilder.append('\n').append(ToolsPanel.getString("TOOL_UPGRADE", string)).append('\n');
        }
        return stringBuilder.toString();
    }

    boolean isBaseDirValid() {
        return !this.isUrl && new File(this.tfBaseDirectory.getText()).exists();
    }

    private void initComponents() {
        this.lbMakeCommand = new JLabel();
        this.tfMakePath = new JTextField();
        this.tfMakePath.getDocument().putProperty("title", "make");
        this.tfMakePath.getDocument().addDocumentListener(this);
        this.btMakeBrowse = new JButton();
        this.lbDebuggerCommand = new JLabel();
        this.tfDebuggerPath = new JTextField();
        this.tfDebuggerPath.getDocument().putProperty("title", "debugger");
        this.tfDebuggerPath.getDocument().addDocumentListener(this);
        this.btDebuggerBrowse = new JButton();
        this.lbCCommand = new JLabel();
        this.tfCPath = new JTextField();
        this.tfCPath.getDocument().putProperty("title", "C");
        this.tfCPath.getDocument().addDocumentListener(this);
        this.btCBrowse = new JButton();
        this.lbCppCommand = new JLabel();
        this.tfCppPath = new JTextField();
        this.tfCppPath.getDocument().putProperty("title", "C++");
        this.tfCppPath.getDocument().addDocumentListener(this);
        this.btCppBrowse = new JButton();
        this.lbFortranCommand = new JLabel();
        this.tfFortranPath = new JTextField();
        this.tfFortranPath.getDocument().putProperty("title", "Fortran");
        this.tfFortranPath.getDocument().addDocumentListener(this);
        this.btFortranBrowse = new JButton();
        this.lbFamily = new JLabel();
        this.requiredToolsLabel = new JLabel();
        this.requiredToolsPanel = new JPanel();
        this.cbMakeRequired = new JCheckBox();
        this.cbDebuggerRequired = new JCheckBox();
        this.cbDebuggerRequired.addItemListener(this);
        this.cbCRequired = new JCheckBox();
        this.cbCRequired.addItemListener(this);
        this.cbCppRequired = new JCheckBox();
        this.cbCppRequired.addItemListener(this);
        this.cbFortranRequired = new JCheckBox();
        this.cbFortranRequired.addItemListener(this);
        this.cbAsRequired = new JCheckBox();
        this.cbFortranRequired.addItemListener(this);
        this.lbBaseDirectory = new JLabel();
        this.tfBaseDirectory = new JTextField();
        this.lbAsCommand = new JLabel();
        this.tfAsPath = new JTextField();
        this.tfAsPath.getDocument().putProperty("title", "Assembler");
        this.tfAsPath.getDocument().addDocumentListener(this);
        this.btAsBrowse = new JButton();
        this.lbQMakePath = new JLabel();
        this.lbCMakePath = new JLabel();
        this.tfQMakePath = new JTextField();
        this.tfQMakePath.getDocument().putProperty("title", "QMake");
        this.tfQMakePath.getDocument().addDocumentListener(this);
        this.tfCMakePath = new JTextField();
        this.tfCMakePath.getDocument().putProperty("title", "CMake");
        this.tfCMakePath.getDocument().addDocumentListener(this);
        this.btQMakeBrowse = new JButton();
        this.btCMakeBrowse = new JButton();
        this.lbFamilyValue = new JLabel();
        this.btInstall = new JButton();
        this.scrollPane = new JScrollPane();
        this.tpInstall = new JTextPane();
        this.setLayout(new GridBagLayout());
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle");
        this.lbMakeCommand.setText(resourceBundle.getString("ToolCollectionPanel.lbMakeCommand.text"));
        this.lbMakeCommand.setToolTipText(resourceBundle.getString("ToolCollectionPanel.lbMakeCommand.toolTipText"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 10, 0, 0);
        this.add((Component)this.lbMakeCommand, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 2, 0, 0);
        this.add((Component)this.tfMakePath, gridBagConstraints);
        this.btMakeBrowse.setText(resourceBundle.getString("ToolCollectionPanel.btMakeBrowse.text"));
        this.btMakeBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolCollectionPanel.this.btMakeBrowseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 6, 0, 6);
        this.add((Component)this.btMakeBrowse, gridBagConstraints);
        this.lbDebuggerCommand.setText(resourceBundle.getString("ToolCollectionPanel.lbDebuggerCommand.text"));
        this.lbDebuggerCommand.setToolTipText(resourceBundle.getString("ToolCollectionPanel.lbDebuggerCommand.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.add((Component)this.lbDebuggerCommand, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.add((Component)this.tfDebuggerPath, gridBagConstraints);
        this.btDebuggerBrowse.setText(resourceBundle.getString("ToolCollectionPanel.btDebuggerBrowse.text"));
        this.btDebuggerBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolCollectionPanel.this.btDebuggerBrowseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.btDebuggerBrowse, gridBagConstraints);
        this.lbCCommand.setText(resourceBundle.getString("ToolCollectionPanel.lbCCommand.text"));
        this.lbCCommand.setToolTipText(resourceBundle.getString("ToolCollectionPanel.lbCCommand.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.add((Component)this.lbCCommand, gridBagConstraints);
        this.tfCPath.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.add((Component)this.tfCPath, gridBagConstraints);
        this.btCBrowse.setText(resourceBundle.getString("ToolCollectionPanel.btCBrowse.text"));
        this.btCBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolCollectionPanel.this.btCBrowseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.btCBrowse, gridBagConstraints);
        this.lbCppCommand.setText(resourceBundle.getString("ToolCollectionPanel.lbCppCommand.text"));
        this.lbCppCommand.setToolTipText(resourceBundle.getString("ToolCollectionPanel.lbCppCommand.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.add((Component)this.lbCppCommand, gridBagConstraints);
        this.tfCppPath.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.add((Component)this.tfCppPath, gridBagConstraints);
        this.btCppBrowse.setText(resourceBundle.getString("ToolCollectionPanel.btCppBrowse.text"));
        this.btCppBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolCollectionPanel.this.btCppBrowseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.btCppBrowse, gridBagConstraints);
        this.lbFortranCommand.setText(resourceBundle.getString("ToolCollectionPanel.lbFortranCommand.text"));
        this.lbFortranCommand.setToolTipText(resourceBundle.getString("ToolCollectionPanel.lbFortranCommand.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.add((Component)this.lbFortranCommand, gridBagConstraints);
        this.tfFortranPath.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.add((Component)this.tfFortranPath, gridBagConstraints);
        this.btFortranBrowse.setText(resourceBundle.getString("ToolCollectionPanel.btFortranBrowse.text"));
        this.btFortranBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolCollectionPanel.this.btFortranBrowseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.btFortranBrowse, gridBagConstraints);
        this.lbFamily.setText(resourceBundle.getString("ToolCollectionPanel.lbFamily.text"));
        this.lbFamily.setToolTipText(resourceBundle.getString("ToolCollectionPanel.lbFamily.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.lbFamily, gridBagConstraints);
        this.requiredToolsLabel.setText(resourceBundle.getString("ToolCollectionPanel.requiredToolsLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 10, 0, 0);
        this.add((Component)this.requiredToolsLabel, gridBagConstraints);
        this.requiredToolsPanel.setLayout(new GridBagLayout());
        this.cbMakeRequired.setSelected(true);
        this.cbMakeRequired.setText(resourceBundle.getString("ToolCollectionPanel.cbMakeRequired.text"));
        this.cbMakeRequired.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.requiredToolsPanel.add((Component)this.cbMakeRequired, gridBagConstraints);
        this.cbDebuggerRequired.setText(resourceBundle.getString("ToolCollectionPanel.cbDebuggerRequired.text"));
        this.cbDebuggerRequired.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.requiredToolsPanel.add((Component)this.cbDebuggerRequired, gridBagConstraints);
        this.cbCRequired.setText(resourceBundle.getString("ToolCollectionPanel.cbCRequired.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.requiredToolsPanel.add((Component)this.cbCRequired, gridBagConstraints);
        this.cbCppRequired.setText(resourceBundle.getString("ToolCollectionPanel.cbCppRequired.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.requiredToolsPanel.add((Component)this.cbCppRequired, gridBagConstraints);
        this.cbFortranRequired.setText(resourceBundle.getString("ToolCollectionPanel.cbFortranRequired.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.requiredToolsPanel.add((Component)this.cbFortranRequired, gridBagConstraints);
        this.cbAsRequired.setText(resourceBundle.getString("ToolCollectionPanel.cbAsRequired.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.requiredToolsPanel.add((Component)this.cbAsRequired, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 2, 0, 6);
        this.add((Component)this.requiredToolsPanel, gridBagConstraints);
        this.lbBaseDirectory.setText(NbBundle.getMessage(ToolCollectionPanel.class, (String)"ToolCollectionPanel.lbBaseDirectory.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.add((Component)this.lbBaseDirectory, gridBagConstraints);
        this.tfBaseDirectory.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 2, 0, 0);
        this.add((Component)this.tfBaseDirectory, gridBagConstraints);
        this.lbAsCommand.setText(resourceBundle.getString("ToolCollectionPanel.lbAsCommand.text"));
        this.lbAsCommand.setToolTipText(resourceBundle.getString("ToolCollectionPanel.lbAsCommand.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.add((Component)this.lbAsCommand, gridBagConstraints);
        this.tfAsPath.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.add((Component)this.tfAsPath, gridBagConstraints);
        this.btAsBrowse.setText(resourceBundle.getString("ToolCollectionPanel.btAsBrowse.text"));
        this.btAsBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolCollectionPanel.this.btAsBrowseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.btAsBrowse, gridBagConstraints);
        this.lbQMakePath.setText(NbBundle.getMessage(ToolCollectionPanel.class, (String)"ToolCollectionPanel.lbQMakePath.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.add((Component)this.lbQMakePath, gridBagConstraints);
        this.lbCMakePath.setText(NbBundle.getMessage(ToolCollectionPanel.class, (String)"ToolCollectionPanel.lbCMakePath.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.add((Component)this.lbCMakePath, gridBagConstraints);
        this.tfQMakePath.setText(NbBundle.getMessage(ToolCollectionPanel.class, (String)"ToolCollectionPanel.tfQMakePath.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.add((Component)this.tfQMakePath, gridBagConstraints);
        this.tfCMakePath.setText(NbBundle.getMessage(ToolCollectionPanel.class, (String)"ToolCollectionPanel.tfCMakePath.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.add((Component)this.tfCMakePath, gridBagConstraints);
        this.btQMakeBrowse.setText(NbBundle.getMessage(ToolCollectionPanel.class, (String)"ToolCollectionPanel.btQMakeBrowse.text"));
        this.btQMakeBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolCollectionPanel.this.btQMakeBrowseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.btQMakeBrowse, gridBagConstraints);
        this.btCMakeBrowse.setText(NbBundle.getMessage(ToolCollectionPanel.class, (String)"ToolCollectionPanel.btCMakeBrowse.text"));
        this.btCMakeBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolCollectionPanel.this.btCMakeBrowseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.btCMakeBrowse, gridBagConstraints);
        this.lbFamilyValue.setText(NbBundle.getMessage(ToolCollectionPanel.class, (String)"ToolCollectionPanel.lbFamilyValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.add((Component)this.lbFamilyValue, gridBagConstraints);
        this.btInstall.setText(NbBundle.getMessage(ToolCollectionPanel.class, (String)"ToolsPanel.UpdateCenterInstallButton"));
        this.btInstall.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolCollectionPanel.this.btInstallActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        this.add((Component)this.btInstall, gridBagConstraints);
        this.scrollPane.setBorder(null);
        this.scrollPane.setMinimumSize(new Dimension(200, 200));
        this.scrollPane.setPreferredSize(new Dimension(200, 200));
        this.scrollPane.setViewportView(this.tpInstall);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.scrollPane, gridBagConstraints);
    }

    private void btMakeBrowseActionPerformed(ActionEvent actionEvent) {
        this.selectTool(this.tfMakePath);
    }

    private void btDebuggerBrowseActionPerformed(ActionEvent actionEvent) {
        this.selectTool(this.tfDebuggerPath);
    }

    private void btCBrowseActionPerformed(ActionEvent actionEvent) {
        this.selectCompiler(this.tfCPath);
    }

    private void btCppBrowseActionPerformed(ActionEvent actionEvent) {
        this.selectCompiler(this.tfCppPath);
    }

    private void btFortranBrowseActionPerformed(ActionEvent actionEvent) {
        this.selectCompiler(this.tfFortranPath);
    }

    private void btAsBrowseActionPerformed(ActionEvent actionEvent) {
        this.selectCompiler(this.tfAsPath);
    }

    private void btQMakeBrowseActionPerformed(ActionEvent actionEvent) {
        this.selectTool(this.tfQMakePath);
    }

    private void btCMakeBrowseActionPerformed(ActionEvent actionEvent) {
        this.selectTool(this.tfCMakePath);
    }

    private void btInstallActionPerformed(ActionEvent actionEvent) {
        CompilerSet compilerSet = this.manager.getCurrentCompilerSet();
        DownloadUtils.downloadCompilerSet(compilerSet);
    }
}

