/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.ui.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.cnd.ui.options.StringArrayCustomEditor;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

final class CndOtherOptionsPanel
extends JPanel
implements ActionListener {
    private boolean isChanged = false;
    private final List<ExtensionsElements> eeList = new ArrayList<ExtensionsElements>();
    private JPanel jPanel1;
    private JPanel jPanel2;

    public CndOtherOptionsPanel() {
        this.setName("TAB_CndOtherOptionsTab");
        this.initComponents();
        this.initGeneratedComponents();
        if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
            this.setOpaque(false);
        }
    }

    void applyChanges() {
        for (ExtensionsElements extensionsElements : this.eeList) {
            extensionsElements.apply();
        }
        this.isChanged = false;
    }

    void update() {
        for (ExtensionsElements extensionsElements : this.eeList) {
            extensionsElements.update();
        }
    }

    void cancel() {
        this.isChanged = false;
    }

    boolean isChanged() {
        return this.isChanged;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.isChanged = true;
    }

    private void editExtensionsButtonActionPerformed(ExtensionsElements extensionsElements) {
        StringArrayCustomEditor stringArrayCustomEditor = new StringArrayCustomEditor(extensionsElements.getValues().toArray(new String[0]), extensionsElements.defaultValue, CndOtherOptionsPanel.getMessage("EE_ItemLabel"), CndOtherOptionsPanel.getMessage("EE_ItemLabel_Mnemonic").charAt(0), CndOtherOptionsPanel.getMessage("EE_ItemListLabel"), CndOtherOptionsPanel.getMessage("EE_ItemListLabel_Mnemonic").charAt(0), false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)stringArrayCustomEditor, gridBagConstraints);
        Object[] objectArray = new Object[]{NotifyDescriptor.OK_OPTION};
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, CndOtherOptionsPanel.getMessage("ExtensionsListEditorTitle"), true, objectArray, NotifyDescriptor.OK_OPTION, 0, null, null);
        DialogDisplayer dialogDisplayer = DialogDisplayer.getDefault();
        Dialog dialog = dialogDisplayer.createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(CndOtherOptionsPanel.getMessage("ExtensionsListEditorTitle_AD"));
        dialog.pack();
        dialog.setSize(new Dimension(300, (int)dialog.getPreferredSize().getHeight()));
        dialog.setVisible(true);
        extensionsElements.defaultValue = stringArrayCustomEditor.getDefaultValue();
        extensionsElements.setValues(stringArrayCustomEditor.getItemList());
    }

    private void initGeneratedComponents() {
        ExtensionsElements extensionsElements;
        MIMEExtensions mIMEExtensions2;
        List list = MIMEExtensions.getCustomizable();
        for (MIMEExtensions mIMEExtensions2 : list) {
            extensionsElements = new ExtensionsElements(mIMEExtensions2);
            extensionsElements.label.setText(NbBundle.getMessage(CndOtherOptionsPanel.class, (String)"EE_ExtensionListTitle", (Object)mIMEExtensions2.getLocalizedDescription()));
            extensionsElements.button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CndOtherOptionsPanel.this.editExtensionsButtonActionPerformed(extensionsElements);
                }
            });
            this.eeList.add(extensionsElements);
        }
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        mIMEExtensions2 = groupLayout.createSequentialGroup();
        mIMEExtensions2.add(12, 12, 12);
        extensionsElements = groupLayout.createParallelGroup(1);
        for (int i = 0; i < this.eeList.size(); ++i) {
            extensionsElements.add(this.eeList.get((int)i).label);
        }
        mIMEExtensions2.add((GroupLayout.Group)extensionsElements);
        mIMEExtensions2.add(4, 4, 4);
        GroupLayout.ParallelGroup parallelGroup = groupLayout.createParallelGroup(1, false);
        for (int i = 0; i < this.eeList.size(); ++i) {
            parallelGroup.add((Component)this.eeList.get((int)i).textfield, -1, 274, Short.MAX_VALUE);
        }
        mIMEExtensions2.add((GroupLayout.Group)parallelGroup);
        mIMEExtensions2.add(6, 6, 6);
        GroupLayout.ParallelGroup parallelGroup2 = groupLayout.createParallelGroup(1);
        for (int i = 0; i < this.eeList.size(); ++i) {
            parallelGroup2.add((Component)this.eeList.get((int)i).button);
        }
        mIMEExtensions2.add((GroupLayout.Group)parallelGroup2);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)mIMEExtensions2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout.SequentialGroup sequentialGroup = groupLayout.createSequentialGroup().addContainerGap();
        for (int i = 0; i < this.eeList.size(); ++i) {
            ExtensionsElements extensionsElements2 = this.eeList.get(i);
            sequentialGroup.add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)extensionsElements2.label).add((Component)extensionsElements2.textfield, -2, 23, -2).add((Component)extensionsElements2.button, -2, 23, -2));
            if (i != this.eeList.size() - 1) {
                sequentialGroup.addPreferredGap(0);
                continue;
            }
            sequentialGroup.addContainerGap(20, Short.MAX_VALUE);
        }
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)sequentialGroup));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel1.setOpaque(false);
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 399, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 0, Short.MAX_VALUE));
        this.jPanel2.setOpaque(false);
        GroupLayout groupLayout2 = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(0, 399, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(0, 276, Short.MAX_VALUE));
        GroupLayout groupLayout3 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(2).add(1, (Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(CndOtherOptionsPanel.class, (String)string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ExtensionsElements {
        private static final String DELIMITER = ", ";
        private final MIMEExtensions es;
        public final JLabel label = new JLabel();
        public final JEditorPane textfield = new JEditorPane();
        public final JButton button = new JButton();
        public List<String> list;
        public String defaultValue;

        public ExtensionsElements(MIMEExtensions mIMEExtensions) {
            this.es = mIMEExtensions;
            this.update();
            this.textfield.setContentType("text/html");
            this.textfield.setEditable(false);
            this.updateTextField();
            this.button.setText(CndOtherOptionsPanel.getMessage("CndOtherOptionsPanel.Extensions.EditButton"));
        }

        public void updateTextField() {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : this.list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(DELIMITER);
                }
                if (string.equals(this.defaultValue)) {
                    string = "<b>" + string + "</b>";
                }
                stringBuilder.append(string);
            }
            this.textfield.setText(stringBuilder.toString());
        }

        List<String> getValues() {
            return Collections.unmodifiableList(this.list);
        }

        void setValues(String[] stringArray) {
            this.list = Arrays.asList(stringArray);
            Collections.sort(this.list, String.CASE_INSENSITIVE_ORDER);
            this.updateTextField();
        }

        public void apply() {
            this.es.setExtensions(this.getValues(), this.defaultValue);
        }

        public void update() {
            this.list = new ArrayList<String>(this.es.getValues());
            this.defaultValue = this.es.getDefaultExtension();
            this.updateTextField();
        }
    }
}

