/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makewizard;

import java.util.ResourceBundle;
import org.netbeans.modules.cnd.makewizard.MakefileWizardPanel;
import org.netbeans.modules.cnd.makewizard.StdLib;
import org.netbeans.modules.cnd.makewizard.TargetData;
import org.openide.util.NbBundle;

public final class StdLibFlags {
    public StdLib motif = new StdLib(this.getString("TB_Motif"), this.getString("MNEM_Motif").charAt(0), "-lXm -lXt -lXext -lX11");
    public StdLib math = new StdLib(this.getString("TB_Math"), this.getString("MNEM_Math").charAt(0), "-lm");
    public StdLib socketnsl = new StdLib(this.getString("TB_Nsl"), this.getString("MNEM_Nsl").charAt(0), "-lsocket -lnsl");
    public StdLib solthread = new StdLib(this.getString("TB_SolThreads"), this.getString("MNEM_SolThreads").charAt(0), "-lthread");
    public StdLib posixthread = new StdLib(this.getString("TB_PosixThreads"), this.getString("MNEM_PosixThreads").charAt(0), "-lpthread");
    public StdLib posix4 = new StdLib(this.getString("TB_Posix4"), this.getString("MNEM_Posix4").charAt(0), "-lposix4");
    public StdLib i18n = new StdLib(this.getString("TB_I18n"), this.getString("MNEM_I18n").charAt(0), "-lintl");
    public StdLib genlib = new StdLib(this.getString("TB_GenLib"), this.getString("MNEM_GenLib").charAt(0), "-lm");
    public StdLib dynamiclib = new StdLib(this.getString("TB_DynamicLib"), this.getString("MNEM_DynamicLib").charAt(0), "-ldl");
    public StdLib curses = new StdLib(this.getString("TB_Curses"), this.getString("MNEM_Curses").charAt(0), "-lcurses");
    public StdLib rwtools = new StdLib(this.getString("TB_RWTools"), this.getString("MNEM_RWTools").charAt(0), "-library=rwtools7,iostream");
    public StdLib perflib = new StdLib(this.getString("TB_PerfLib"), this.getString("MNEM_PerfLib").charAt(0), "-xlic_lib=sunperf");
    private StdLib[] solarisStdLibs = new StdLib[]{this.motif, this.perflib, this.math, this.socketnsl, this.solthread, this.posixthread, this.posix4, this.i18n, this.genlib, this.curses, this.rwtools};
    private StdLib[] linuxStdLibs = new StdLib[]{this.motif, this.math, this.posixthread, this.dynamiclib, this.curses};
    private StdLib[] macosxStdLibs = new StdLib[]{this.math, this.posixthread, this.dynamiclib, this.curses};
    private int linkType;
    public static final int STATIC_LINK_TYPE = 0;
    public static final int DYNAMIC_LINK_TYPE = 1;
    private String indent = new String("    ");
    private ResourceBundle bundle = null;

    public StdLibFlags() {
        this.linkType = 1;
    }

    public StdLibFlags(StdLibFlags stdLibFlags) {
        this.motif = new StdLib(stdLibFlags.motif);
        this.math = new StdLib(stdLibFlags.math);
        this.socketnsl = new StdLib(stdLibFlags.socketnsl);
        this.solthread = new StdLib(stdLibFlags.solthread);
        this.posixthread = new StdLib(stdLibFlags.posixthread);
        this.posix4 = new StdLib(stdLibFlags.posix4);
        this.i18n = new StdLib(stdLibFlags.i18n);
        this.genlib = new StdLib(stdLibFlags.genlib);
        this.dynamiclib = new StdLib(stdLibFlags.dynamiclib);
        this.curses = new StdLib(stdLibFlags.curses);
        this.rwtools = new StdLib(stdLibFlags.rwtools);
        this.perflib = new StdLib(stdLibFlags.perflib);
    }

    public StdLib[] getSolarisStdLibs() {
        return this.solarisStdLibs;
    }

    public StdLib[] getLinuxStdLibs() {
        return this.linuxStdLibs;
    }

    public StdLib[] getMacOSXStdLibs() {
        return this.macosxStdLibs;
    }

    public boolean isMotifLibs() {
        return this.motif.isUsed();
    }

    public void setMotifLibs(boolean bl) {
        this.motif.setUsed(bl);
    }

    public int getLinkType() {
        return this.linkType;
    }

    public void setLinkType(int n) {
        if (n == 0 || n == 1) {
            this.linkType = n;
        }
    }

    public String getSysLibFlags(int n, int n2, boolean bl, TargetData targetData) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        if (this.getLinkType() == 1) {
            if (n == 0) {
                // empty if block
            }
        } else if (this.getLinkType() == 0) {
            if (n == 0) {
                stringBuilder.append("-Bstatic ");
            } else {
                stringBuilder.append("-static ");
            }
        }
        if (this.isMotifLibs() && !targetData.containsXdFiles()) {
            if (n2 == 0) {
                if (bl) {
                    stringBuilder.append("-L/usr/openwin/lib/sparcv9 ");
                    stringBuilder.append("-L/usr/dt/lib/sparcv9 ");
                    stringBuilder.append("-R/usr/openwin/lib/sparcv9 ");
                    stringBuilder.append("-R/usr/dt/lib/sparcv9 ");
                } else {
                    stringBuilder.append("-L/usr/openwin/lib -L/usr/dt/lib ");
                    stringBuilder.append("-R/usr/openwin/lib -R/usr/dt/lib ");
                }
            } else if (n2 == 1) {
                if (bl) {
                    stringBuilder.append("-L/usr/X11R6/lib ");
                } else {
                    stringBuilder.append("-L/usr/X11R6/lib ");
                }
            }
        }
        StdLib[] stdLibArray = n2 == 0 ? this.getSolarisStdLibs() : (n2 == 4 ? this.getMacOSXStdLibs() : this.getLinuxStdLibs());
        if (targetData.containsXdFiles()) {
            this.motif.setUsed(false);
            this.socketnsl.setUsed(false);
            this.genlib.setUsed(false);
        }
        for (int i = 0; i < stdLibArray.length; ++i) {
            if (!stdLibArray[i].isUsed()) continue;
            stringBuilder.append(stdLibArray[i].getCmd());
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    protected void dump() {
        this.println("    stdLibFlags = {");
        this.println("    }\n");
    }

    public void dump(String string) {
        this.setIndent(string);
        this.dump();
    }

    private void println(String string) {
        System.out.println(this.indent + string);
    }

    private void setIndent(String string) {
        this.indent = string;
    }

    private String getString(String string) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(MakefileWizardPanel.class);
        }
        return this.bundle.getString(string);
    }
}

