/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.loaders;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.Format;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.cnd.loaders.CndAbstractDataLoader;
import org.netbeans.modules.cnd.loaders.CndAbstractDataLoaderExt;
import org.netbeans.modules.cnd.loaders.ShellDataObject;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;

public class ShellDataLoader
extends CndAbstractDataLoaderExt {
    static final long serialVersionUID = -7173746465817543299L;

    public ShellDataLoader() {
        super("org.netbeans.modules.cnd.loaders.ShellDataObject");
    }

    protected String actionsContext() {
        return "Loaders/text/sh/Actions/";
    }

    protected String getMimeType() {
        return "text/sh";
    }

    protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
        return new ShellDataObject(fileObject, (MultiFileLoader)this);
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        return new ShellFormat(multiDataObject, fileObject);
    }

    private static class ShellFormat
    extends CndAbstractDataLoader.CndFormat {
        public ShellFormat(MultiDataObject multiDataObject, FileObject fileObject) {
            super(multiDataObject, fileObject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject createFromTemplate(FileObject fileObject, String string) throws IOException {
            String string2 = FileUtil.getExtension((String)string);
            if (string2.length() != 0) {
                string = string.substring(0, string.length() - string2.length() - 1);
            } else {
                string2 = this.getFile().getExt();
            }
            FileObject fileObject2 = fileObject.createData(string, string2);
            Format format = this.createFormat(fileObject, string, string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getFile().getInputStream(), FileEncodingQuery.getEncoding((FileObject)this.getFile())));
            try {
                FileLock fileLock = fileObject2.lock();
                try {
                    Charset charset = FileEncodingQuery.getEncoding((FileObject)fileObject2);
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileObject2.getOutputStream(fileLock), charset));
                    try {
                        String string3;
                        while ((string3 = bufferedReader.readLine()) != null) {
                            bufferedWriter.write(format.format(string3));
                            bufferedWriter.write("\n");
                        }
                    }
                    finally {
                        bufferedWriter.close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
            }
            finally {
                bufferedReader.close();
            }
            FileUtil.copyAttributes((FileObject)this.getFile(), (FileObject)fileObject2);
            CndAbstractDataLoader.setTemplate(fileObject2, false);
            return fileObject2;
        }
    }
}

