/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.picklist;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.cnd.api.picklist.DefaultPicklistElement;
import org.netbeans.modules.cnd.api.picklist.PicklistDataEvent;
import org.netbeans.modules.cnd.api.picklist.PicklistDataListener;
import org.netbeans.modules.cnd.api.picklist.PicklistElement;
import org.netbeans.modules.cnd.api.picklist.PicklistModel;

public class DefaultPicklistModel
implements PicklistModel,
Serializable {
    private static final long serialVersionUID = -8893287476464434693L;
    private int maxSize = 10;
    private static int increaseSize = 10;
    private PicklistElement[] picklist = null;
    private int picklistSize = 0;
    protected EventListenerList listenerList = null;

    public DefaultPicklistModel() {
        this.initialize(0);
    }

    public DefaultPicklistModel(int n) {
        this.initialize(n);
    }

    private EventListenerList getListenerList() {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        return this.listenerList;
    }

    private void initialize(int n) {
        if (n <= 0) {
            this.maxSize = 0;
            this.picklist = new PicklistElement[increaseSize];
        } else {
            this.maxSize = n;
            this.picklist = new PicklistElement[increaseSize];
        }
    }

    public void addElement(PicklistElement picklistElement) {
        this.addElement(picklistElement, true);
    }

    public void addElement(String string) {
        this.addElement(new DefaultPicklistElement(string), true);
    }

    public synchronized void addElement(PicklistElement picklistElement, boolean bl) {
        int n = this.contains(picklistElement);
        int n2 = 0;
        if (bl && n >= 0) {
            n2 = n;
            --this.picklistSize;
        } else {
            if (this.picklistSize == this.picklist.length) {
                PicklistElement[] picklistElementArray = new PicklistElement[this.picklist.length + increaseSize];
                for (int i = 0; i < this.picklist.length; ++i) {
                    picklistElementArray[i] = this.picklist[i];
                }
                this.picklist = picklistElementArray;
            }
            n2 = this.picklistSize;
        }
        for (int i = n2; i > 0; --i) {
            this.picklist[i] = this.picklist[i - 1];
        }
        this.picklist[0] = picklistElement;
        ++this.picklistSize;
        if (this.maxSize > 0 && this.picklistSize > this.maxSize) {
            --this.picklistSize;
        }
        this.fireContentsChanged(this);
    }

    public int contains(PicklistElement picklistElement) {
        int n = -1;
        if (picklistElement != null) {
            for (int i = 0; i < this.picklistSize; ++i) {
                if (!this.picklist[i].equals(picklistElement)) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    public PicklistElement getElementAt(int n) {
        if (n >= 0 && n < this.picklistSize) {
            return this.picklist[n];
        }
        return null;
    }

    public PicklistElement[] getElements() {
        PicklistElement[] picklistElementArray = new PicklistElement[this.picklistSize];
        for (int i = 0; i < this.picklistSize; ++i) {
            picklistElementArray[i] = this.picklist[i];
        }
        return picklistElementArray;
    }

    public String[] getElementsDisplayName() {
        PicklistElement[] picklistElementArray = this.getElements();
        String[] stringArray = new String[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            stringArray[i] = picklistElementArray[i].displayName();
        }
        return stringArray;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public PicklistElement getMostRecentUsedElement() {
        if (this.picklistSize > 0) {
            return this.picklist[0];
        }
        return null;
    }

    public int getSize() {
        return this.picklistSize;
    }

    public void removeAllElements() {
        this.picklistSize = 0;
        this.fireContentsChanged(this);
    }

    public PicklistElement removeElement(PicklistElement picklistElement) {
        return this.removeElementAt(this.contains(picklistElement));
    }

    public PicklistElement removeElementAt(int n) {
        PicklistElement picklistElement = null;
        if (n < 0 || n >= this.picklistSize) {
            return picklistElement;
        }
        picklistElement = this.picklist[n];
        for (int i = n; i < this.picklistSize - 1; ++i) {
            this.picklist[i] = this.picklist[i + 1];
        }
        --this.picklistSize;
        this.fireContentsChanged(this);
        return picklistElement;
    }

    public PicklistElement replaceElementAt(PicklistElement picklistElement, int n) {
        PicklistElement picklistElement2 = null;
        if (n < 0 || n >= this.picklistSize) {
            return picklistElement2;
        }
        picklistElement2 = this.picklist[n];
        this.picklist[n] = picklistElement;
        this.fireContentsChanged(this);
        return picklistElement2;
    }

    public void addPicklistDataListener(PicklistDataListener picklistDataListener) {
        this.getListenerList().add(PicklistDataListener.class, picklistDataListener);
    }

    public void removePicklistDataListener(PicklistDataListener picklistDataListener) {
        this.getListenerList().remove(PicklistDataListener.class, picklistDataListener);
    }

    public PicklistModel clonePicklist() {
        DefaultPicklistModel defaultPicklistModel = new DefaultPicklistModel(this.maxSize);
        for (int i = this.getSize() - 1; i >= 0; --i) {
            defaultPicklistModel.addElement(this.getElementAt(i), false);
        }
        return defaultPicklistModel;
    }

    public void copyPicklist(PicklistModel picklistModel) {
        this.removeAllElements();
        for (int i = picklistModel.getSize() - 1; i >= 0; --i) {
            this.addElement(picklistModel.getElementAt(i), false);
        }
    }

    public void dumpElements() {
        for (int i = 0; i < this.picklistSize; ++i) {
            System.out.println("[" + i + "] " + this.picklist[i].displayName());
        }
        System.out.println();
    }

    protected void fireContentsChanged(Object object) {
        Object[] objectArray = this.getListenerList().getListenerList();
        PicklistDataEvent picklistDataEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PicklistDataListener.class) continue;
            if (picklistDataEvent == null) {
                picklistDataEvent = new PicklistDataEvent(object, PicklistDataEvent.CONTENTS_CHANGED);
            }
            ((PicklistDataListener)objectArray[i + 1]).contentsChanged(picklistDataEvent);
        }
    }

    public void savePicklist(ObjectOutputStream objectOutputStream) {
        try {
            objectOutputStream.writeObject(this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void savePicklist(String string, String string2) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string + File.separator + string2));
            this.savePicklist(objectOutputStream);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static PicklistModel restorePicklist(ObjectInputStream objectInputStream) throws Exception {
        PicklistModel picklistModel = null;
        try {
            picklistModel = (PicklistModel)objectInputStream.readObject();
        }
        catch (Exception exception) {
            System.err.println("DefaultPicklistModel - restorePicklist - e " + exception);
            throw exception;
        }
        return picklistModel;
    }

    public static PicklistModel restorePicklist(String string, String string2) {
        PicklistModel picklistModel = null;
        File file = new File(string + File.separator + string2);
        if (file.exists()) {
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(string + File.separator + string2));
                picklistModel = DefaultPicklistModel.restorePicklist(objectInputStream);
                objectInputStream.close();
            }
            catch (Exception exception) {
                System.err.println("DefaultPicklistModel - restorePicklist - e " + exception);
                System.err.println("DefaultPicklistModel - restorePicklist - deleting serialized data");
                System.err.println("" + string + File.separator + string2 + " deleted");
                file.delete();
            }
        }
        return picklistModel;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            objectOutputStream.writeObject(this.maxSize);
            objectOutputStream.writeObject(this.picklistSize);
            for (int i = 0; i < this.picklistSize; ++i) {
                objectOutputStream.writeObject(this.picklist[i]);
            }
        }
        catch (IOException iOException) {
            System.err.println("DefaultPicklistModel - writeObject - ioe " + iOException);
            throw iOException;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            this.maxSize = (Integer)objectInputStream.readObject();
            this.picklistSize = (Integer)objectInputStream.readObject();
            this.picklist = new PicklistElement[this.picklistSize];
            for (int i = 0; i < this.picklistSize; ++i) {
                PicklistElement picklistElement;
                this.picklist[i] = picklistElement = (PicklistElement)objectInputStream.readObject();
            }
        }
        catch (IOException iOException) {
            System.err.println("DefaultPicklistModel - readObject - e " + iOException);
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("DefaultPicklistModel - readObject - e " + classNotFoundException);
            throw classNotFoundException;
        }
    }
}

