/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Component;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.target.iterator.api.TargetChooserPanel;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.core.Util;
import org.netbeans.modules.web.taglib.TLDDataObject;
import org.netbeans.modules.web.taglib.model.TagFileType;
import org.netbeans.modules.web.taglib.model.Taglib;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.Utilities;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageIterator
implements TemplateWizard.Iterator {
    private static final Logger LOG = Logger.getLogger(PageIterator.class.getName());
    private static final long serialVersionUID = -7586964579556513549L;
    private transient FileType fileType;
    private WizardDescriptor.Panel folderPanel;
    private transient SourceGroup[] sourceGroups;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient TemplateWizard wiz;

    public static PageIterator createJspIterator() {
        return new PageIterator(FileType.JSP);
    }

    public static PageIterator createJsfIterator() {
        return new PageIterator(FileType.JSF);
    }

    public static PageIterator createTagIterator() {
        return new PageIterator(FileType.TAG);
    }

    public static PageIterator createTagLibraryIterator() {
        return new PageIterator(FileType.TAGLIBRARY);
    }

    public static PageIterator createHtmlIterator() {
        return new PageIterator(FileType.HTML);
    }

    public static PageIterator createJSIterator() {
        return new PageIterator(FileType.JS);
    }

    public static PageIterator createXHtmlIterator() {
        return new PageIterator(FileType.XHTML);
    }

    public static PageIterator createXCssIterator() {
        return new PageIterator(FileType.CSS);
    }

    protected PageIterator(FileType fileType) {
        this.fileType = fileType;
    }

    protected WizardDescriptor.Panel[] createPanels(Project project) {
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        if (this.fileType.equals(FileType.JSP) || this.fileType.equals(FileType.JSF)) {
            this.sourceGroups = sources.getSourceGroups("doc_root");
            if (this.sourceGroups == null || this.sourceGroups.length == 0) {
                this.sourceGroups = sources.getSourceGroups("generic");
            }
            this.folderPanel = new TargetChooserPanel(project, this.sourceGroups, (Object)this.fileType);
            return new WizardDescriptor.Panel[]{this.folderPanel};
        }
        if (this.fileType.equals(FileType.HTML) || this.fileType.equals(FileType.XHTML) || this.fileType.equals(FileType.CSS) || this.fileType.equals(FileType.JS)) {
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("doc_root");
            SourceGroup[] sourceGroupArray2 = Util.getJavaSourceGroups(project);
            if (sourceGroupArray != null && sourceGroupArray2 != null) {
                this.sourceGroups = new SourceGroup[sourceGroupArray.length + sourceGroupArray2.length];
                System.arraycopy(sourceGroupArray, 0, this.sourceGroups, 0, sourceGroupArray.length);
                System.arraycopy(sourceGroupArray2, 0, this.sourceGroups, sourceGroupArray.length, sourceGroupArray2.length);
            }
            if (this.sourceGroups == null || this.sourceGroups.length == 0) {
                this.sourceGroups = sources.getSourceGroups("generic");
            }
            this.folderPanel = new TargetChooserPanel(project, this.sourceGroups, (Object)this.fileType);
            return new WizardDescriptor.Panel[]{this.folderPanel};
        }
        if (this.fileType.equals(FileType.TAG)) {
            this.sourceGroups = sources.getSourceGroups("web_inf");
            if (this.sourceGroups == null || this.sourceGroups.length == 0) {
                this.sourceGroups = sources.getSourceGroups("doc_root");
            }
            if (this.sourceGroups == null || this.sourceGroups.length == 0) {
                this.sourceGroups = sources.getSourceGroups("java");
            }
            if (this.sourceGroups == null || this.sourceGroups.length == 0) {
                this.sourceGroups = sources.getSourceGroups("generic");
            }
            this.folderPanel = new TargetChooserPanel(project, this.sourceGroups, (Object)this.fileType);
            return new WizardDescriptor.Panel[]{this.folderPanel};
        }
        if (this.fileType.equals(FileType.TAGLIBRARY)) {
            this.sourceGroups = sources.getSourceGroups("doc_root");
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("doc_root");
            SourceGroup[] sourceGroupArray3 = sources.getSourceGroups("web_inf");
            if (sourceGroupArray == null || sourceGroupArray.length == 0) {
                sourceGroupArray = sources.getSourceGroups("java");
            }
            if (sourceGroupArray != null && sourceGroupArray3 != null) {
                this.sourceGroups = new SourceGroup[sourceGroupArray.length + sourceGroupArray3.length];
                System.arraycopy(sourceGroupArray3, 0, this.sourceGroups, 0, sourceGroupArray3.length);
                System.arraycopy(sourceGroupArray, 0, this.sourceGroups, sourceGroupArray3.length, sourceGroupArray.length);
            }
            if (this.sourceGroups == null || this.sourceGroups.length == 0) {
                this.sourceGroups = sources.getSourceGroups("generic");
            }
            this.folderPanel = new TargetChooserPanel(project, this.sourceGroups, (Object)this.fileType);
            return new WizardDescriptor.Panel[]{this.folderPanel};
        }
        return new WizardDescriptor.Panel[]{Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])this.sourceGroups)};
    }

    private static boolean isJSF20(WebModule webModule) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)webModule.getDocumentBase(), (String)"classpath/compile");
        boolean bl = classPath.findResource("javax/faces/application/ProjectStage.class") != null;
        return bl;
    }

    public Set<DataObject> instantiate(TemplateWizard templateWizard) throws IOException {
        DataObject dataObject;
        DataObject dataObject2;
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)templateWizard);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        FileObject fileObject2 = Templates.getTemplate((WizardDescriptor)templateWizard);
        FileObject fileObject3 = fileObject2.getParent();
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        String string = null;
        if (FileType.JSP.equals(this.fileType) || FileType.JSF.equals(this.fileType)) {
            if (this.isSegment(templateWizard)) {
                fileObject2 = this.isXml(templateWizard) ? fileObject3.getFileObject("JSPFX", "jspf") : fileObject3.getFileObject("JSPF", "jspf");
            } else {
                if (this.isXml(templateWizard)) {
                    fileObject2 = fileObject3.getFileObject("JSPX", "jspx");
                }
                if (this.isFacelets(templateWizard)) {
                    fileObject2 = fileObject3.getFileObject("JSP", "xhtml");
                    dataObject2 = WebModule.getWebModule((FileObject)dataFolder.getPrimaryFile());
                    if (dataObject2 != null && PageIterator.isJSF20((WebModule)dataObject2)) {
                        hashMap.put("isJSF20", Boolean.TRUE);
                    }
                }
            }
        } else if (FileType.TAG.equals(this.fileType)) {
            if (this.isSegment(templateWizard)) {
                fileObject2 = this.isXml(templateWizard) ? fileObject3.getFileObject("TagFileFX", "tagf") : fileObject3.getFileObject("TagFileF", "tagf");
            } else if (this.isXml(templateWizard)) {
                fileObject2 = fileObject3.getFileObject("TagFileX", "tagx");
            }
        } else if (FileType.TAGLIBRARY.equals(this.fileType) && (dataObject2 = WebModule.getWebModule((FileObject)fileObject)) != null) {
            dataObject = dataObject2.getJ2eeProfile();
            if (Profile.J2EE_13.equals(dataObject)) {
                fileObject2 = fileObject3.getFileObject("TagLibrary_1_2", "tld");
                string = "http://java.sun.com/xml/ns/j2ee";
            } else if (Profile.J2EE_14.equals(dataObject)) {
                fileObject2 = fileObject3.getFileObject("TagLibrary_2_0", "tld");
                string = "http://java.sun.com/xml/ns/j2ee";
            }
        }
        dataObject2 = DataObject.find((FileObject)fileObject2);
        dataObject = dataObject2.createFromTemplate(dataFolder, Templates.getTargetName((WizardDescriptor)templateWizard), hashMap);
        if (dataObject != null) {
            FileObject fileObject4;
            if (FileType.TAGLIBRARY.equals(this.fileType)) {
                TLDDataObject tLDDataObject = (TLDDataObject)dataObject;
                Taglib taglib = tLDDataObject.getTaglib();
                if (string != null) {
                    taglib.setDefaultNamespace(string);
                }
                taglib.setUri(templateWizard.getProperty("uri").toString());
                taglib.setShortName(templateWizard.getProperty("prefix").toString());
                tLDDataObject.write(taglib);
            } else if (FileType.TAG.equals(this.fileType) && ((Boolean)templateWizard.getProperty("isTldSelected")).booleanValue() && (fileObject4 = (FileObject)templateWizard.getProperty("tldFileObject")) != null) {
                if (!fileObject4.canWrite()) {
                    String string2 = MessageFormat.format(NbBundle.getMessage(PageIterator.class, (String)"MSG_tldRO"), fileObject4.getNameExt());
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                } else {
                    String string3;
                    TLDDataObject tLDDataObject = (TLDDataObject)DataObject.find((FileObject)fileObject4);
                    Taglib taglib = null;
                    try {
                        taglib = tLDDataObject.getTaglib();
                    }
                    catch (IOException iOException) {
                        string3 = MessageFormat.format(NbBundle.getMessage(PageIterator.class, (String)"MSG_tldCorrupted"), fileObject4.getNameExt());
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string3, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    }
                    if (taglib != null) {
                        TagFileType tagFileType = new TagFileType();
                        tagFileType.setName(templateWizard.getProperty("tagName").toString());
                        string3 = null;
                        for (int i = 0; i < this.sourceGroups.length && string3 == null; ++i) {
                            FileObject fileObject5 = this.sourceGroups[i].getRootFolder();
                            string3 = fileObject5.getName() + "/" + FileUtil.getRelativePath((FileObject)fileObject5, (FileObject)dataObject.getPrimaryFile());
                        }
                        tagFileType.setPath("/" + string3);
                        taglib.addTagFile(tagFileType);
                        SaveCookie saveCookie = (SaveCookie)tLDDataObject.getCookie(SaveCookie.class);
                        if (saveCookie != null) {
                            saveCookie.save();
                        }
                        try {
                            tLDDataObject.write(taglib);
                        }
                        catch (IOException iOException) {
                            LOG.log(Level.WARNING, null, iOException);
                        }
                    }
                }
            }
        }
        return Collections.singleton(dataObject);
    }

    private boolean isXml(TemplateWizard templateWizard) {
        return (Boolean)templateWizard.getProperty(FileType.IS_XML);
    }

    private boolean isSegment(TemplateWizard templateWizard) {
        return (Boolean)templateWizard.getProperty(FileType.IS_SEGMENT);
    }

    private boolean isFacelets(TemplateWizard templateWizard) {
        return (Boolean)templateWizard.getProperty(FileType.IS_FACELETS);
    }

    public void initialize(TemplateWizard templateWizard) {
        this.wiz = templateWizard;
        this.index = 0;
        Project project = Templates.getProject((WizardDescriptor)templateWizard);
        this.panels = this.createPanels(project);
        Object object = templateWizard.getProperty("WizardPanel_contentData");
        String[] stringArray = null;
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        String[] stringArray2 = Utilities.createSteps(stringArray, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (stringArray2[i] == null) {
                stringArray2[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jComponent.putClientProperty("WizardPanel_contentData", stringArray2);
        }
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return NbBundle.getMessage(PageIterator.class, (String)"TITLE_x_of_y", (Object)(this.index + 1), (Object)this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener changeListener) {
    }

    public final void removeChangeListener(ChangeListener changeListener) {
    }
}

