/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.FilteringPathResourceImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PathMatcher;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SourcePathImplementation
implements ClassPathImplementation,
PropertyChangeListener {
    private static final String BUILD_DIR = "build.dir";
    private static final String BUILD_GENERATED_DIR = "build.generated.sources.dir";
    private static RequestProcessor REQ_PROCESSOR = new RequestProcessor();
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private List<PathResourceImplementation> resources;
    private SourceRoots sourceRoots;
    private AntProjectHelper projectHelper;
    private FileChangeListener fcl = null;
    private PropertyEvaluator evaluator;
    private File buildGeneratedDir = null;
    private final FileChangeListener buildGeneratedDirListener = new FileChangeAdapter(){

        public void fileFolderCreated(FileEvent fileEvent) {
            SourcePathImplementation.this.invalidate();
        }

        public void fileDeleted(FileEvent fileEvent) {
            SourcePathImplementation.this.invalidate();
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            SourcePathImplementation.this.invalidate();
        }
    };

    SourcePathImplementation(SourceRoots sourceRoots, AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator) {
        assert (sourceRoots != null && antProjectHelper != null && propertyEvaluator != null);
        this.sourceRoots = sourceRoots;
        this.sourceRoots.addPropertyChangeListener(this);
        this.projectHelper = antProjectHelper;
        this.evaluator = propertyEvaluator;
        propertyEvaluator.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private List<PathResourceImplementation> getGeneratedSrcRoots(String string, String[] stringArray) {
        ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
        File file = this.projectHelper.resolveFile(string);
        for (String string2 : stringArray) {
            File[] fileArray;
            File file2 = new File(file, string2);
            if (!file2.exists() || !file2.isDirectory()) continue;
            for (File file3 : fileArray = file2.listFiles()) {
                try {
                    URL uRL = file3.toURI().toURL();
                    if (!file3.exists()) {
                        assert (!uRL.toExternalForm().endsWith("/"));
                        uRL = new URL(uRL.toExternalForm() + '/');
                    }
                    arrayList.add(ClassPathSupport.createResource((URL)uRL));
                }
                catch (MalformedURLException malformedURLException) {
                    Exceptions.printStackTrace((Throwable)malformedURLException);
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidate() {
        SourcePathImplementation sourcePathImplementation = this;
        synchronized (sourcePathImplementation) {
            this.resources = null;
        }
        this.support.firePropertyChange("resources", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PathResourceImplementation> getResources() {
        URL[] uRLArray = this;
        synchronized (this) {
            if (this.resources != null) {
                // ** MonitorExit[uRLArray] (shouldn't be in output)
                return this.resources;
            }
            // ** MonitorExit[uRLArray] (shouldn't be in output)
            uRLArray = this.sourceRoots.getRootURLs();
            URL[] uRLArray2 = this;
            synchronized (this) {
                if (this.resources == null) {
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class PRI
                    implements FilteringPathResourceImplementation,
                    PropertyChangeListener {
                        PropertyChangeSupport pcs = new PropertyChangeSupport(this);
                        PathMatcher matcher;

                        PRI() {
                            SourcePathImplementation.this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)SourcePathImplementation.this.evaluator));
                        }

                        public URL[] getRoots() {
                            return new URL[]{uRL};
                        }

                        public boolean includes(URL uRL2, String string) {
                            if (this.matcher == null) {
                                this.matcher = new PathMatcher(SourcePathImplementation.this.evaluator.getProperty("includes"), SourcePathImplementation.this.evaluator.getProperty("excludes"), new File(URI.create(uRL2.toExternalForm())));
                            }
                            return this.matcher.matches(string, true);
                        }

                        public ClassPathImplementation getContent() {
                            return null;
                        }

                        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                            this.pcs.addPropertyChangeListener(propertyChangeListener);
                        }

                        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                            this.pcs.removePropertyChangeListener(propertyChangeListener);
                        }

                        @Override
                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            String string = propertyChangeEvent.getPropertyName();
                            if (string == null || string.equals("includes") || string.equals("excludes")) {
                                this.matcher = null;
                                PropertyChangeEvent propertyChangeEvent2 = new PropertyChangeEvent(this, "includes", null, null);
                                propertyChangeEvent2.setPropagationId(propertyChangeEvent);
                                this.pcs.firePropertyChange(propertyChangeEvent2);
                            }
                        }
                    }
                    ArrayList<PRI> arrayList = new ArrayList<PRI>(uRLArray.length);
                    for (final URL uRL : uRLArray) {
                        arrayList.add((SourcePathImplementation)this.new PRI());
                    }
                    try {
                        String malformedURLException = this.evaluator.getProperty(BUILD_GENERATED_DIR);
                        if (malformedURLException != null) {
                            File file = this.projectHelper.resolveFile(malformedURLException);
                            if (!file.equals(this.buildGeneratedDir)) {
                                if (this.buildGeneratedDir != null) {
                                    FileUtil.removeFileChangeListener((FileChangeListener)this.buildGeneratedDirListener, (File)this.buildGeneratedDir);
                                }
                                this.buildGeneratedDir = file;
                                FileUtil.addFileChangeListener((FileChangeListener)this.buildGeneratedDirListener, (File)this.buildGeneratedDir);
                            }
                            if (this.buildGeneratedDir.isDirectory()) {
                                for (File file2 : this.buildGeneratedDir.listFiles()) {
                                    if (!file2.isDirectory()) continue;
                                    arrayList.add((PRI)ClassPathSupport.createResource((URL)file2.toURI().toURL()));
                                }
                            }
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        Exceptions.printStackTrace((Throwable)malformedURLException);
                    }
                    this.resources = Collections.unmodifiableList(arrayList);
                }
                // ** MonitorExit[uRLArray2] (shouldn't be in output)
                return this.resources;
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SourceRoots.PROP_ROOTS.equals(propertyChangeEvent.getPropertyName())) {
            this.invalidate();
        } else if (this.evaluator != null && propertyChangeEvent.getSource() == this.evaluator && (propertyChangeEvent.getPropertyName() == null || BUILD_DIR.equals(propertyChangeEvent.getPropertyName()))) {
            this.invalidate();
        }
    }

    private class AddOnGeneratedSourceRootListener
    extends FileChangeAdapter {
        private List<List<String>> paths = Collections.synchronizedList(new ArrayList());
        private FileObject projRoot;

        AddOnGeneratedSourceRootListener(FileObject fileObject, String string, String[] stringArray) {
            this.projRoot = fileObject;
            StringTokenizer stringTokenizer = null;
            ArrayList<String> arrayList = null;
            for (String string2 : stringArray) {
                stringTokenizer = new StringTokenizer(string2, "/");
                arrayList = new ArrayList<String>();
                arrayList.add(string);
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
                this.paths.add(arrayList);
            }
        }

        public synchronized void listenToProjRoot() {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = null;
            FileObject fileObject = this.projRoot;
            FileChangeListener fileChangeListener = FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)fileObject);
            fileObject.addFileChangeListener(fileChangeListener);
            FileObject fileObject2 = null;
            FileObject fileObject3 = null;
            for (List<String> list : this.paths) {
                String string2;
                fileObject2 = fileObject;
                Iterator<String> iterator = list.iterator();
                while (iterator.hasNext() && (fileObject3 = fileObject2.getFileObject(string2 = iterator.next())) != null) {
                    string = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject3);
                    if (arrayList.contains(string)) continue;
                    arrayList.add(string);
                    fileChangeListener = FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)fileObject3);
                    fileObject3.addFileChangeListener(fileChangeListener);
                    fileObject2 = fileObject3;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileFolderCreated(FileEvent fileEvent) {
            AddOnGeneratedSourceRootListener addOnGeneratedSourceRootListener = this;
            synchronized (addOnGeneratedSourceRootListener) {
                SourceRootScannerTask sourceRootScannerTask = new SourceRootScannerTask(SourcePathImplementation.this, (FileChangeListener)this, this.paths, (FileObject)fileEvent.getSource(), fileEvent.getFile());
                REQ_PROCESSOR.post((Runnable)sourceRootScannerTask);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SourceRootScannerTask
    implements Runnable {
        SourcePathImplementation spi = null;
        FileChangeListener fcl = null;
        List<List<String>> paths = null;
        FileObject parent = null;
        FileObject child = null;
        List<String> listenerAddedDirs = new ArrayList<String>();

        public SourceRootScannerTask(SourcePathImplementation sourcePathImplementation, FileChangeListener fileChangeListener, List<List<String>> list, FileObject fileObject, FileObject fileObject2) {
            this.spi = sourcePathImplementation;
            this.fcl = fileChangeListener;
            this.paths = list;
            this.parent = fileObject;
            this.child = fileObject2;
        }

        private void firePropertyChange() {
            this.spi.invalidate();
        }

        private void addListeners(List<String> list, int n) {
            int n2 = list.size();
            FileObject fileObject = this.parent;
            FileObject fileObject2 = this.child;
            String string = null;
            FileChangeListener fileChangeListener = null;
            for (int i = n; i < n2 && (fileObject2 = fileObject.getFileObject(list.get(i))) != null && fileObject2.isFolder(); ++i) {
                string = FileUtil.getRelativePath((FileObject)this.parent, (FileObject)fileObject2);
                if (!this.listenerAddedDirs.contains(string)) {
                    this.listenerAddedDirs.add(string);
                    fileChangeListener = FileUtil.weakFileChangeListener((FileChangeListener)this.fcl, (Object)fileObject2);
                    fileObject2.addFileChangeListener(fileChangeListener);
                }
                if (i == n2 - 1) {
                    if (fileObject2.getChildren().length <= 0) break;
                    this.firePropertyChange();
                    break;
                }
                fileObject = fileObject2;
            }
        }

        @Override
        public void run() {
            Iterator<List<String>> iterator = this.paths.iterator();
            List<String> list = null;
            int n = -1;
            int n2 = -1;
            boolean bl = false;
            while (iterator.hasNext()) {
                list = iterator.next();
                n = list.indexOf(this.child.getName());
                n2 = list.indexOf(this.parent.getName());
                boolean bl2 = bl = n2 + 1 == list.size();
                if (bl) {
                    if (n != -1) continue;
                    this.firePropertyChange();
                    continue;
                }
                if (n == -1 || n2 != n - 1) continue;
                this.addListeners(list, n);
            }
        }
    }
}

