/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.Box;
import com.sun.perseus.j2d.RenderGraphics;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.CompositeGraphicsNodeProxy;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.ElementNodeProxy;
import com.sun.perseus.model.FloatTraitAnim;
import com.sun.perseus.model.Group;
import com.sun.perseus.model.IDRef;
import com.sun.perseus.model.Messages;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.StringTraitAnim;
import com.sun.perseus.model.TraitAnim;
import com.sun.perseus.model.UseProxy;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGRect;

public class Use
extends Group
implements IDRef {
    static final String[][] REQUIRED_TRAITS_NS = new String[][]{{"http://www.w3.org/1999/xlink", "href"}};
    protected float x;
    protected float y;
    protected ElementNodeProxy proxy;
    protected String idRef;
    protected ElementNode ref;

    public Use(DocumentNode ownerDocument) {
        super(ownerDocument);
    }

    protected void clearLayouts() {
        this.clearLayouts(this.proxy);
    }

    public ModelNode nodeHitAt(float[] pt) {
        if (this.canRenderState != 0) {
            return null;
        }
        return this.nodeHitAt(this.getLastExpandedChild(), pt);
    }

    ModelNode proxyNodeHitAt(float[] pt, ElementNodeProxy proxy) {
        if (this.canRenderState != 0) {
            return null;
        }
        return this.nodeHitAt(proxy.getLastExpandedChild(), pt);
    }

    protected void propagatePropertyState(int propertyIndex, Object parentPropertyValue) {
        if (this.firstProxy != null) {
            ElementNodeProxy proxy = this.firstProxy;
            while (proxy != null) {
                ((CompositeGraphicsNodeProxy)proxy).proxiedPropertyStateChange(propertyIndex, parentPropertyValue);
                proxy = proxy.nextProxy;
            }
        }
        ModelNode node = this.getFirstExpandedChild();
        while (node != null) {
            node.recomputePropertyState(propertyIndex, parentPropertyValue);
            node = node.nextSibling;
        }
    }

    protected void propagateFloatPropertyState(int propertyIndex, float parentPropertyValue) {
        if (this.firstProxy != null) {
            ElementNodeProxy proxy = this.firstProxy;
            while (proxy != null) {
                ((CompositeGraphicsNodeProxy)proxy).proxiedFloatPropertyStateChange(propertyIndex, parentPropertyValue);
                proxy = proxy.nextProxy;
            }
        }
        ModelNode node = this.getFirstExpandedChild();
        while (node != null) {
            node.recomputeFloatPropertyState(propertyIndex, parentPropertyValue);
            node = node.nextSibling;
        }
    }

    protected void propagatePackedPropertyState(int propertyIndex, int parentPropertyValue) {
        if (this.firstProxy != null) {
            ElementNodeProxy proxy = this.firstProxy;
            while (proxy != null) {
                ((CompositeGraphicsNodeProxy)proxy).proxiedPackedPropertyStateChange(propertyIndex, parentPropertyValue);
                proxy = proxy.nextProxy;
            }
        }
        ModelNode node = this.getFirstExpandedChild();
        while (node != null) {
            node.recomputePackedPropertyState(propertyIndex, parentPropertyValue);
            node = node.nextSibling;
        }
    }

    protected void recomputeTransformState(Transform parentTransform) {
        this.txf = this.appendTransform(parentTransform, this.txf);
        this.inverseTxf = null;
        this.computeCanRenderTransformBit(this.txf);
        this.recomputeTransformState(this.txf, this.getFirstExpandedChild());
    }

    public void paint(RenderGraphics rg) {
        if (this.canRenderState != 0) {
            return;
        }
        Use.paint(this.getFirstExpandedChild(), rg);
    }

    protected void preValidate() {
        if (this.loaded && this.proxy == null && this.ref == null && this.idRef != null && !"".equals(this.idRef)) {
            throw new DOMException(11, Messages.formatMessage(Messages.ERROR_MISSING_REFERENCE, new String[]{this.getNamespaceURI(), this.getLocalName(), this.getId()}));
        }
    }

    public void setIdRef(String idRef) {
        if (idRef == this.idRef || idRef != null && idRef.equals(this.idRef)) {
            return;
        }
        this.idRef = idRef;
        this.ownerDocument.resolveIDRef(this, idRef);
        if (this.isInDocumentTree() && this.proxy == null && idRef != null && !"".equals(idRef)) {
            throw new DOMException(15, Messages.formatMessage(Messages.ERROR_MISSING_REFERENCE, new String[]{this.getNamespaceURI(), this.getLocalName(), this.getId()}));
        }
    }

    public String getLocalName() {
        return "use";
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new Use(doc);
    }

    public String getIdRef() {
        return this.idRef;
    }

    public void resolveTo(ElementNode ref) {
        if (this.isInDocumentTree()) {
            this.setProxy(ref.buildProxy());
        } else {
            this.ref = ref;
        }
    }

    void nodeHookedInDocumentTree() {
        super.nodeHookedInDocumentTree();
        if (this.ref != null) {
            this.setProxy(this.ref.buildProxy());
        }
    }

    final void nodeUnhookedFromDocumentTree() {
        super.nodeUnhookedFromDocumentTree();
        if (this.proxy != null) {
            this.unhookExpandedQuiet();
            this.proxy = null;
        }
    }

    ElementNodeProxy buildProxy() {
        return new UseProxy(this);
    }

    protected Transform appendTransform(Transform tx, Transform workTx) {
        if (this.transform == null && this.motion == null && this.x == 0.0f && this.y == 0.0f) {
            return tx;
        }
        tx = this.recycleTransform(tx, workTx);
        if (this.motion != null) {
            tx.mMultiply(this.motion);
        }
        if (this.transform != null) {
            tx.mMultiply(this.transform);
        }
        tx.mTranslate(this.x, this.y);
        return tx;
    }

    public void setX(float newX) {
        if (newX == this.x) {
            return;
        }
        this.modifyingNode();
        this.x = newX;
        this.recomputeTransformState();
        this.recomputeProxyTransformState();
        this.modifiedNode();
    }

    public void setY(float newY) {
        if (newY == this.y) {
            return;
        }
        this.modifyingNode();
        this.y = newY;
        this.recomputeTransformState();
        this.recomputeProxyTransformState();
        this.modifiedNode();
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public boolean hasDescendants() {
        return super.hasDescendants() || this.proxy != null;
    }

    void setProxy(ElementNodeProxy proxy) {
        if (proxy == null) {
            throw new IllegalArgumentException();
        }
        if (this.proxy != null) {
            this.modifyingNode();
            this.unhookExpandedQuiet();
            this.modifiedNode();
        }
        this.proxy = proxy;
        this.proxy.setParentQuiet(this);
        Use.nodeInserted(this.proxy);
        this.proxy.nextSibling = null;
        ElementNodeProxy useProxy = this.firstProxy;
        while (useProxy != null) {
            ((UseProxy)useProxy).useProxySet();
            useProxy = useProxy.nextProxy;
        }
    }

    protected ModelNode getFirstExpandedChild() {
        return this.proxy;
    }

    public ModelNode getFirstComputedExpandedChild() {
        return this.proxy;
    }

    protected ModelNode getLastExpandedChild() {
        return this.proxy;
    }

    protected void unhookExpandedQuiet() {
        this.unhookQuiet(this.proxy);
        this.proxy = null;
        ElementNodeProxy p = this.firstProxy;
        while (p != null) {
            p.unhookExpandedQuiet();
            p = p.nextProxy;
        }
    }

    public SVGRect getBBox() {
        Transform t = null;
        if (this.x != 0.0f || this.y != 0.0f) {
            t = new Transform(1.0f, 0.0f, 0.0f, 1.0f, this.x, this.y);
        }
        return this.addBBox(null, t);
    }

    Box addBBox(Box bbox, Transform t) {
        return this.proxy.addBBox(bbox, this.proxy.appendTransform(t, null));
    }

    public SVGMatrix getScreenCTM() {
        SVGMatrix m = super.getScreenCTM();
        if (m != null) {
            m = m.mTranslate(-this.x, -this.y);
        }
        return m;
    }

    boolean supportsTrait(String traitName) {
        if ("x" == traitName || "y" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    boolean supportsTraitNS(String namespaceURI, String traitName) {
        if ("http://www.w3.org/1999/xlink" == namespaceURI && "href" == traitName) {
            return true;
        }
        return super.supportsTraitNS(namespaceURI, traitName);
    }

    public String[][] getRequiredTraitsNS() {
        return REQUIRED_TRAITS_NS;
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("x" == name) {
            return Float.toString(this.getX());
        }
        if ("y" == name) {
            return Float.toString(this.getY());
        }
        return super.getTraitImpl(name);
    }

    String getTraitNSImpl(String namespaceURI, String name) throws DOMException {
        if ("http://www.w3.org/1999/xlink" == namespaceURI && "href" == name) {
            if (this.idRef == null) {
                return "";
            }
            return "#" + this.idRef;
        }
        return super.getTraitNSImpl(namespaceURI, name);
    }

    float getFloatTraitImpl(String name) throws DOMException {
        if ("x" == name) {
            return this.getX();
        }
        if ("y" == name) {
            return this.getY();
        }
        return super.getFloatTraitImpl(name);
    }

    TraitAnim createTraitAnimImpl(String traitName) {
        if ("x" == traitName || "y" == traitName) {
            return new FloatTraitAnim(this, traitName, "float");
        }
        return super.createTraitAnimImpl(traitName);
    }

    TraitAnim createTraitAnimNSImpl(String traitNamespace, String traitName) {
        if (traitNamespace == "http://www.w3.org/1999/xlink" && traitName == "href") {
            return new StringTraitAnim(this, traitNamespace, traitName);
        }
        return super.createTraitAnimNSImpl(traitNamespace, traitName);
    }

    void setFloatArrayTrait(String name, float[][] value) throws DOMException {
        if ("x" == name) {
            this.setX(value[0][0]);
        } else if ("y" == name) {
            this.setY(value[0][0]);
        } else {
            super.setFloatArrayTrait(name, value);
        }
    }

    public float[][] validateFloatArrayTrait(String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if ("x" == traitName) {
            return this.toAnimatedFloatArray(this.parseFloatTrait(traitName, value));
        }
        if ("y" == traitName) {
            return this.toAnimatedFloatArray(this.parseFloatTrait(traitName, value));
        }
        return super.validateFloatArrayTrait(traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    String validateTraitNS(String namespaceURI, String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if ("http://www.w3.org/1999/xlink" == namespaceURI && "href" == traitName) {
            if (value == null || !value.startsWith("#")) {
                throw this.illegalTraitValue(traitName, value);
            }
            return value;
        }
        return super.validateTraitNS(namespaceURI, traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    public void setTraitImpl(String name, String value) throws DOMException {
        if ("x" == name) {
            this.setX(this.parseFloatTrait(name, value));
        } else if ("y" == name) {
            this.setY(this.parseFloatTrait(name, value));
        } else {
            super.setTraitImpl(name, value);
        }
    }

    public void setTraitNSImpl(String namespaceURI, String name, String value) throws DOMException {
        if ("http://www.w3.org/1999/xlink" == namespaceURI && "href" == name) {
            if (value == null || !value.startsWith("#")) {
                throw this.illegalTraitValue(name, value);
            }
            this.setIdRef(value.substring(1));
        } else {
            super.setTraitNSImpl(namespaceURI, name, value);
        }
    }

    public void setFloatTraitImpl(String name, float value) throws DOMException {
        if ("x" == name) {
            this.setX(value);
        } else if ("y" == name) {
            this.setY(value);
        } else {
            super.setFloatTraitImpl(name, value);
        }
    }

    String toStringTrait(String name, float[][] value) {
        if ("x" == name || "y" == name) {
            return Float.toString(value[0][0]);
        }
        return super.toStringTrait(name, value);
    }
}

