/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.save;

import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.Pretty;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.pretty.VeryPretty;
import org.netbeans.modules.java.source.query.CommentHandler;
import org.netbeans.modules.java.source.query.CommentSet;
import org.netbeans.modules.java.source.save.DiffFacility;
import org.netbeans.modules.java.source.save.EstimatorFactory;
import org.netbeans.modules.java.source.save.ListMatcher;
import org.netbeans.modules.java.source.save.Measure;
import org.netbeans.modules.java.source.save.PositionEstimator;
import org.netbeans.modules.java.source.transform.FieldGroupTree;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CasualDiff {
    protected ListBuffer<Diff> diffs;
    protected CommentHandler comments;
    protected JCTree.JCCompilationUnit oldTopLevel;
    protected WorkingCopy workingCopy;
    private TokenSequence<JavaTokenId> tokenSequence;
    private String origText;
    private VeryPretty printer;
    private Context context;
    private static final Logger LOG = Logger.getLogger(CasualDiff.class.getName());
    private Map<Integer, String> diffInfo = new HashMap<Integer, String>();
    private final Map<Tree, ?> tree2Tag;
    private final Map<Object, int[]> tag2Span;
    private boolean parameterPrint = false;
    private boolean enumConstantPrint = false;
    private Name origClassName = null;
    boolean anonClass = false;
    private static final EnumSet<Tree.Kind> compAssign = EnumSet.of(Tree.Kind.MULTIPLY_ASSIGNMENT, new Tree.Kind[]{Tree.Kind.DIVIDE_ASSIGNMENT, Tree.Kind.REMAINDER_ASSIGNMENT, Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.MINUS_ASSIGNMENT, Tree.Kind.LEFT_SHIFT_ASSIGNMENT, Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.AND_ASSIGNMENT, Tree.Kind.XOR_ASSIGNMENT, Tree.Kind.OR_ASSIGNMENT});
    private static final EnumSet<Tree.Kind> binaries = EnumSet.of(Tree.Kind.MULTIPLY, new Tree.Kind[]{Tree.Kind.DIVIDE, Tree.Kind.REMAINDER, Tree.Kind.PLUS, Tree.Kind.MINUS, Tree.Kind.LEFT_SHIFT, Tree.Kind.RIGHT_SHIFT, Tree.Kind.UNSIGNED_RIGHT_SHIFT, Tree.Kind.LESS_THAN, Tree.Kind.GREATER_THAN, Tree.Kind.LESS_THAN_EQUAL, Tree.Kind.GREATER_THAN_EQUAL, Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.AND, Tree.Kind.XOR, Tree.Kind.OR, Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR});
    private static final EnumSet<Tree.Kind> unaries = EnumSet.of(Tree.Kind.POSTFIX_INCREMENT, new Tree.Kind[]{Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.UNARY_PLUS, Tree.Kind.UNARY_MINUS, Tree.Kind.BITWISE_COMPLEMENT, Tree.Kind.LOGICAL_COMPLEMENT});

    protected CasualDiff(Context context, WorkingCopy workingCopy, Map<Tree, ?> map, Map<?, int[]> map2) {
        this.diffs = new ListBuffer();
        this.comments = CommentHandlerService.instance(context);
        this.workingCopy = workingCopy;
        this.tokenSequence = workingCopy.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        this.origText = workingCopy.getText();
        this.context = context;
        this.tree2Tag = map;
        this.tag2Span = map2;
        this.printer = new VeryPretty(workingCopy, VeryPretty.getCodeStyle(workingCopy), map, map2, this.origText);
    }

    public List<Diff> getDiffs() {
        return this.diffs.toList();
    }

    public static List<Diff> diff(Context context, WorkingCopy workingCopy, TreePath treePath, JCTree jCTree, Map<Integer, String> map, Map<Tree, ?> map2, Map<?, int[]> map3) {
        Object object;
        Object object222;
        CasualDiff casualDiff = new CasualDiff(context, workingCopy, map2, map3);
        JCTree jCTree2 = (JCTree)treePath.getLeaf();
        casualDiff.oldTopLevel = (JCTree.JCCompilationUnit)(jCTree2.getKind() == Tree.Kind.COMPILATION_UNIT ? jCTree2 : workingCopy.getCompilationUnit());
        for (Tree tree : treePath) {
            if (tree == jCTree2 || tree.getKind() != Tree.Kind.CLASS && tree.getKind() != Tree.Kind.BLOCK) continue;
            casualDiff.printer.indent();
        }
        if (jCTree2.getKind() == Tree.Kind.CLASS && treePath.getParentPath().getLeaf().getKind() == Tree.Kind.NEW_CLASS) {
            casualDiff.anonClass = true;
        }
        Object object3 = casualDiff.getBounds(jCTree2);
        boolean bl = jCTree2.getKind() == Tree.Kind.COMPILATION_UNIT;
        int n = (int)(bl ? 0 : object3[0]);
        Object object4 = bl ? (Object)casualDiff.workingCopy.getText().length() : object3[1];
        int n2 = casualDiff.oldTopLevel.lineMap.getLineNumber(n);
        int n3 = casualDiff.oldTopLevel.lineMap.getStartPosition(n2);
        casualDiff.printer.setInitialOffset(n3);
        Tree tree = jCTree2;
        for (Object object222 : treePath) {
            Tree tree2;
            if (object222.getKind() == Tree.Kind.METHOD) {
                tree2 = (MethodTree)object222;
                for (VariableTree variableTree : tree2.getParameters()) {
                    if (variableTree != tree) continue;
                    casualDiff.parameterPrint = true;
                }
                break;
            }
            if (object222.getKind() == Tree.Kind.VARIABLE) {
                tree2 = (JCTree.JCVariableDecl)object222;
                if ((((JCTree.JCVariableDecl)tree2).mods.flags & 0x4000L) != 0L && ((JCTree.JCVariableDecl)tree2).init == tree) {
                    casualDiff.enumConstantPrint = true;
                }
            }
            tree = object222;
        }
        if (jCTree2.getKind() == Tree.Kind.METHOD || !casualDiff.parameterPrint && jCTree2.getKind() == Tree.Kind.VARIABLE) {
            casualDiff.tokenSequence.move(n);
            if (casualDiff.tokenSequence.movePrevious() && casualDiff.tokenSequence.token().id() == JavaTokenId.WHITESPACE) {
                object = ((Object)casualDiff.tokenSequence.token().text()).toString();
                int n4 = ((String)object).lastIndexOf(10);
                n = casualDiff.tokenSequence.offset();
                if (n4 > -1) {
                    n += n4 + 1;
                }
            }
        }
        casualDiff.printer.print(casualDiff.workingCopy.getText().substring(n3, n));
        casualDiff.diffTree(jCTree2, jCTree, (JCTree)(treePath.getParentPath() != null ? treePath.getParentPath().getLeaf() : null), new int[]{n, (int)object3[1]});
        object = casualDiff.printer.toString().substring(n - n3);
        object222 = bl ? casualDiff.workingCopy.getText() : casualDiff.workingCopy.getText().substring(n, (int)object4);
        new DiffFacility(casualDiff).makeListMatch((String)object222, (String)object, n);
        map.putAll(casualDiff.diffInfo);
        return casualDiff.getDiffs();
    }

    public static List<Diff> diff(Context context, WorkingCopy workingCopy, java.util.List<? extends ImportTree> list, java.util.List<? extends ImportTree> list2, Map<Integer, String> map, Map<Tree, ?> map2, Map<?, int[]> map3) {
        CasualDiff casualDiff = new CasualDiff(context, workingCopy, map2, map3);
        casualDiff.oldTopLevel = (JCTree.JCCompilationUnit)workingCopy.getCompilationUnit();
        int n = casualDiff.oldTopLevel.getPackageName() != null ? casualDiff.endPos((JCTree)((Object)casualDiff.oldTopLevel.getPackageName())) : 0;
        LinkedList<JCTree.JCImport> linkedList = new LinkedList<JCTree.JCImport>();
        LinkedList<JCTree.JCImport> linkedList2 = new LinkedList<JCTree.JCImport>();
        for (ImportTree importTree : list) {
            linkedList.add((JCTree.JCImport)importTree);
        }
        for (ImportTree importTree : list2) {
            linkedList2.add((JCTree.JCImport)importTree);
        }
        PositionEstimator positionEstimator = EstimatorFactory.imports(linkedList, linkedList2, casualDiff.workingCopy);
        int n2 = casualDiff.diffList(linkedList, linkedList2, n, positionEstimator, Measure.DEFAULT, casualDiff.printer);
        String string = casualDiff.printer.toString();
        String string2 = casualDiff.workingCopy.getText().substring(n, n2);
        new DiffFacility(casualDiff).makeListMatch(string2, string, n);
        map.putAll(casualDiff.diffInfo);
        return casualDiff.getDiffs();
    }

    protected void append(Diff diff) {
        for (Diff diff2 : this.diffs) {
            if (!diff2.equals(diff)) continue;
            return;
        }
        this.diffs.append(diff);
    }

    public int endPos(JCTree jCTree) {
        return TreeInfo.getEndPos((JCTree)jCTree, (Map)((Object)this.oldTopLevel.endPositions));
    }

    private int endPos(List<? extends JCTree> list) {
        int n = -1;
        if (list.nonEmpty()) {
            n = this.endPos((JCTree)list.head);
            List list2 = list.tail;
            while (list2.nonEmpty()) {
                n = this.endPos((JCTree)list2.head);
                list2 = list2.tail;
            }
        }
        return n;
    }

    private int endPos(java.util.List<? extends JCTree> list) {
        if (list.isEmpty()) {
            return -1;
        }
        return this.endPos(list.get(list.size() - 1));
    }

    protected void diffTopLevel(JCTree.JCCompilationUnit jCCompilationUnit, JCTree.JCCompilationUnit jCCompilationUnit2) {
        int n = 0;
        this.oldTopLevel = jCCompilationUnit;
        n = this.diffPackageStatement(jCCompilationUnit, jCCompilationUnit2, n);
        PositionEstimator positionEstimator = EstimatorFactory.imports(jCCompilationUnit.getImports(), jCCompilationUnit2.getImports(), this.workingCopy);
        n = this.diffList(jCCompilationUnit.getImports(), jCCompilationUnit2.getImports(), n, positionEstimator, Measure.DEFAULT, this.printer);
        positionEstimator = EstimatorFactory.toplevel(jCCompilationUnit.getTypeDecls(), jCCompilationUnit2.getTypeDecls(), this.workingCopy);
        n = this.diffList(jCCompilationUnit.getTypeDecls(), jCCompilationUnit2.getTypeDecls(), n, positionEstimator, Measure.MEMBER, this.printer);
        this.printer.print(this.origText.substring(n));
    }

    private ChangeKind getChangeKind(Tree tree, Tree tree2) {
        if (tree == tree2) {
            return ChangeKind.NOCHANGE;
        }
        if (tree != null && tree2 != null) {
            return ChangeKind.MODIFY;
        }
        if (tree != null) {
            return ChangeKind.DELETE;
        }
        return ChangeKind.INSERT;
    }

    private int diffPackageStatement(JCTree.JCCompilationUnit jCCompilationUnit, JCTree.JCCompilationUnit jCCompilationUnit2, int n) {
        ChangeKind changeKind = this.getChangeKind(jCCompilationUnit.pid, jCCompilationUnit2.pid);
        switch (changeKind) {
            case NOCHANGE: {
                break;
            }
            case INSERT: {
                this.printer.printPackage(jCCompilationUnit2.pid);
                break;
            }
            case DELETE: {
                this.tokenSequence.move(jCCompilationUnit.pid.getStartPosition());
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                this.copyTo(n, this.tokenSequence.offset());
                this.tokenSequence.move(this.endPos(jCCompilationUnit.pid));
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                n = this.tokenSequence.offset() + 1;
                break;
            }
            case MODIFY: {
                this.copyTo(n, CasualDiff.getOldPos(jCCompilationUnit.pid));
                n = this.endPos(jCCompilationUnit.pid);
                this.printer.print(jCCompilationUnit2.pid);
                this.diffInfo.put(CasualDiff.getOldPos(jCCompilationUnit.pid), NbBundle.getMessage(CasualDiff.class, (String)"TXT_UpdatePackageStatement"));
            }
        }
        return n;
    }

    protected int diffImport(JCTree.JCImport jCImport, JCTree.JCImport jCImport2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds((JCTree)jCImport.getQualifiedIdentifier());
        if (jCImport.staticImport == jCImport2.staticImport) {
            this.copyTo(n, nArray2[0]);
        } else if (jCImport.staticImport) {
            PositionEstimator.moveFwdToToken(this.tokenSequence, n, JavaTokenId.STATIC);
            this.copyTo(n, this.tokenSequence.offset());
        } else {
            this.copyTo(n, nArray2[0]);
            this.printer.print("static ");
        }
        n = this.diffTree((JCTree)jCImport.getQualifiedIdentifier(), (JCTree)jCImport2.getQualifiedIdentifier(), nArray2);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffClassDef(JCTree.JCClassDecl jCClassDecl, JCTree.JCClassDecl jCClassDecl2, int[] nArray) {
        int n;
        int n2 = nArray[0];
        Name name = this.origClassName;
        int n3 = n2;
        if (!this.anonClass) {
            PositionEstimator positionEstimator;
            JavaTokenId[] javaTokenIdArray;
            this.tokenSequence.move(jCClassDecl.pos);
            this.tokenSequence.moveNext();
            this.tokenSequence.moveNext();
            PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
            n3 = this.tokenSequence.offset();
            n2 = this.diffModifiers(jCClassDecl.mods, jCClassDecl2.mods, jCClassDecl, n2);
            if (this.nameChanged(jCClassDecl.name, jCClassDecl2.name)) {
                this.copyTo(n2, n3);
                this.printer.print(jCClassDecl2.name);
                this.diffInfo.put(n3, NbBundle.getMessage(CasualDiff.class, (String)"TXT_ChangeClassName"));
                n2 = n3 += jCClassDecl.name.length();
                this.origClassName = jCClassDecl.name;
            } else {
                int n4 = n2;
                n2 = n3 += jCClassDecl.name.length();
                this.copyTo(n4, n2);
            }
            if (jCClassDecl.typarams.nonEmpty() && jCClassDecl2.typarams.nonEmpty()) {
                int n5 = n2;
                n2 = ((JCTree.JCTypeParameter)jCClassDecl.typarams.head).pos;
                this.copyTo(n5, n2);
            }
            n = jCClassDecl.typarams.isEmpty() && jCClassDecl2.typarams.nonEmpty() ? 1 : 0;
            List<JCTree.JCTypeParameter> list = jCClassDecl.typarams;
            List<JCTree.JCTypeParameter> list2 = jCClassDecl2.typarams;
            if (n != 0) {
                JavaTokenId[] javaTokenIdArray2 = new JavaTokenId[2];
                javaTokenIdArray2[0] = JavaTokenId.LT;
                javaTokenIdArray = javaTokenIdArray2;
                javaTokenIdArray2[1] = JavaTokenId.GT;
            } else {
                javaTokenIdArray = null;
            }
            n2 = this.diffParameterList(list, list2, javaTokenIdArray, n2, Measure.ARGUMENT);
            if (jCClassDecl.typarams.nonEmpty()) {
                n3 = this.endPos(jCClassDecl.typarams.last());
                this.tokenSequence.move(n3);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                n3 = this.tokenSequence.offset() + this.tokenSequence.token().length();
            }
            switch (this.getChangeKind(jCClassDecl.extending, jCClassDecl2.extending)) {
                case NOCHANGE: {
                    n3 = jCClassDecl.extending != null ? this.endPos(jCClassDecl.extending) : n3;
                    int n6 = n2;
                    n2 = n3;
                    this.copyTo(n6, n2);
                    break;
                }
                case MODIFY: {
                    this.copyTo(n2, CasualDiff.getOldPos(jCClassDecl.extending));
                    n2 = this.diffTree(jCClassDecl.extending, jCClassDecl2.extending, this.getBounds(jCClassDecl.extending));
                    break;
                }
                case INSERT: {
                    this.copyTo(n2, n3);
                    this.printer.print(" extends ");
                    this.printer.print(jCClassDecl2.extending);
                    n2 = n3;
                    break;
                }
                case DELETE: {
                    this.copyTo(n2, n3);
                    n2 = this.endPos(jCClassDecl.extending);
                }
            }
            if (jCClassDecl.implementing.isEmpty()) {
                if (jCClassDecl.extending != null) {
                    n3 = this.endPos(jCClassDecl.extending);
                }
            } else {
                n3 = jCClassDecl.implementing.iterator().next().getStartPosition();
            }
            long l = jCClassDecl.sym != null ? jCClassDecl.sym.flags() : jCClassDecl.mods.flags;
            PositionEstimator positionEstimator2 = positionEstimator = (l & 0x200L) == 0L ? EstimatorFactory.implementz(jCClassDecl.getImplementsClause(), jCClassDecl2.getImplementsClause(), this.workingCopy) : EstimatorFactory.extendz(jCClassDecl.getImplementsClause(), jCClassDecl2.getImplementsClause(), this.workingCopy);
            if (!jCClassDecl2.implementing.isEmpty()) {
                this.copyTo(n2, n3);
            }
            n2 = this.diffList2(jCClassDecl.implementing, jCClassDecl2.implementing, n3, positionEstimator);
            n3 = this.endPos(jCClassDecl) - 1;
            n3 = this.filterHidden(jCClassDecl.defs).isEmpty() ? this.endPos(jCClassDecl) - 1 : this.filterHidden(jCClassDecl.defs).get(0).getStartPosition() - 1;
            this.tokenSequence.move(n3);
            this.tokenSequence.moveNext();
            n3 = PositionEstimator.moveBackToToken(this.tokenSequence, n3, JavaTokenId.LBRACE) + 1;
        } else {
            n3 = PositionEstimator.moveFwdToToken(this.tokenSequence, CasualDiff.getOldPos(jCClassDecl), JavaTokenId.LBRACE);
            this.tokenSequence.moveNext();
            n3 = this.tokenSequence.offset();
        }
        n = this.printer.indent();
        Name name2 = this.printer.enclClassName;
        this.printer.enclClassName = jCClassDecl2.getSimpleName();
        PositionEstimator positionEstimator = EstimatorFactory.members(this.filterHidden(jCClassDecl.defs), this.filterHidden(jCClassDecl2.defs), this.workingCopy);
        if (n2 < n3) {
            this.copyTo(n2, n3);
        }
        n2 = this.diffList(this.filterHidden(jCClassDecl.defs), this.filterHidden(jCClassDecl2.defs), n3, positionEstimator, Measure.MEMBER, this.printer);
        this.printer.enclClassName = name2;
        this.origClassName = name;
        this.printer.undent(n);
        if (n2 != -1 && n2 < this.origText.length()) {
            if (this.origText.charAt(n2) == '}') {
                this.printer.toLeftMargin();
            }
            this.copyTo(n2, nArray[1]);
        }
        return nArray[1];
    }

    private boolean hasModifiers(JCTree.JCModifiers jCModifiers) {
        return jCModifiers != null && (!jCModifiers.getFlags().isEmpty() || !((List)jCModifiers.getAnnotations()).isEmpty());
    }

    protected int diffMethodDef(JCTree.JCMethodDecl jCMethodDecl, JCTree.JCMethodDecl jCMethodDecl2, int[] nArray) {
        int[] nArray2;
        int n;
        int n2;
        int n3;
        int n4 = nArray[0];
        if (!this.matchModifiers(jCMethodDecl.mods, jCMethodDecl2.mods)) {
            if (this.hasModifiers(jCMethodDecl2.mods)) {
                n4 = this.diffModifiers(jCMethodDecl.mods, jCMethodDecl2.mods, jCMethodDecl, n4);
            } else {
                n3 = CasualDiff.getOldPos(jCMethodDecl.mods);
                this.copyTo(n4, n3);
                int n5 = n4 = jCMethodDecl.restype != null ? CasualDiff.getOldPos(jCMethodDecl.restype) : jCMethodDecl.pos;
            }
        }
        int n6 = jCMethodDecl.typarams.isEmpty() ? (jCMethodDecl.restype != null ? CasualDiff.getOldPos(jCMethodDecl.restype) : jCMethodDecl.pos) : (n3 = CasualDiff.getOldPos((JCTree)jCMethodDecl.typarams.head));
        if (!this.listsMatch(jCMethodDecl.typarams, jCMethodDecl2.typarams)) {
            JavaTokenId[] javaTokenIdArray;
            if (jCMethodDecl2.typarams.nonEmpty()) {
                this.copyTo(n4, n3);
            } else if (this.hasModifiers(jCMethodDecl.mods)) {
                this.copyTo(n4, this.endPos(jCMethodDecl.mods));
            }
            n2 = jCMethodDecl.typarams.isEmpty() || jCMethodDecl2.typarams.isEmpty() ? 1 : 0;
            List<JCTree.JCTypeParameter> list = jCMethodDecl.typarams;
            List<JCTree.JCTypeParameter> list2 = jCMethodDecl2.typarams;
            if (n2 != 0) {
                JavaTokenId[] javaTokenIdArray2 = new JavaTokenId[2];
                javaTokenIdArray2[0] = JavaTokenId.LT;
                javaTokenIdArray = javaTokenIdArray2;
                javaTokenIdArray2[1] = JavaTokenId.GT;
            } else {
                javaTokenIdArray = null;
            }
            n4 = this.diffParameterList(list, list2, javaTokenIdArray, n3, Measure.ARGUMENT);
            if (n2 != 0 && jCMethodDecl.typarams.isEmpty()) {
                this.printer.print(" ");
            }
        }
        if (jCMethodDecl.restype != null) {
            int[] nArray3 = this.getBounds(jCMethodDecl.restype);
            this.copyTo(n4, nArray3[0]);
            int n7 = n4 = this.diffTree(jCMethodDecl.restype, jCMethodDecl2.restype, nArray3);
            n4 = nArray3[1];
            this.copyTo(n7, n4);
        }
        n2 = jCMethodDecl.typarams.isEmpty() ? (jCMethodDecl.restype != null ? jCMethodDecl.restype.getStartPosition() : jCMethodDecl.getStartPosition()) : jCMethodDecl.typarams.iterator().next().getStartPosition();
        if (!jCMethodDecl.sym.isConstructor() || this.origClassName != null) {
            if (this.nameChanged(jCMethodDecl.name, jCMethodDecl2.name)) {
                this.copyTo(n4, jCMethodDecl.pos);
                if (jCMethodDecl.sym.isConstructor() && this.origClassName != null) {
                    this.printer.print(jCMethodDecl2.name);
                    n4 = jCMethodDecl.pos + this.origClassName.length();
                } else {
                    this.printer.print(jCMethodDecl2.name);
                    this.diffInfo.put(jCMethodDecl.pos, NbBundle.getMessage(CasualDiff.class, (String)"TXT_RenameMethod") + " " + jCMethodDecl.name);
                    n4 = jCMethodDecl.pos + jCMethodDecl.name.length();
                }
            } else {
                int n8 = n4;
                n4 = jCMethodDecl.pos + jCMethodDecl.name.length();
                this.copyTo(n8, n4);
            }
        }
        if (jCMethodDecl.params.isEmpty()) {
            n = jCMethodDecl.restype != null ? jCMethodDecl.restype.getStartPosition() : jCMethodDecl.getStartPosition();
            PositionEstimator.moveFwdToToken(this.tokenSequence, n, JavaTokenId.RPAREN);
            n2 = this.tokenSequence.offset();
        } else {
            n2 = jCMethodDecl.params.iterator().next().getStartPosition();
        }
        if (!this.listsMatch(jCMethodDecl.params, jCMethodDecl2.params)) {
            this.copyTo(n4, n2);
            n = this.printer.setPrec(0);
            this.parameterPrint = true;
            n4 = this.diffParameterList(jCMethodDecl.params, jCMethodDecl2.params, null, n2, Measure.MEMBER);
            this.parameterPrint = false;
            this.printer.setPrec(n);
        }
        if (n4 < n2) {
            int n9 = n4;
            n4 = n2;
            this.copyTo(n9, n4);
        }
        if (jCMethodDecl.thrown.isEmpty()) {
            if (jCMethodDecl.body != null) {
                this.tokenSequence.move(jCMethodDecl.body.pos);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                this.tokenSequence.moveNext();
                n2 = this.tokenSequence.offset();
            } else if (jCMethodDecl.defaultValue != null) {
                this.tokenSequence.move(CasualDiff.getOldPos(jCMethodDecl.defaultValue));
                while (this.tokenSequence.movePrevious() && this.tokenSequence.token().id() != JavaTokenId.DEFAULT) {
                }
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                this.tokenSequence.moveNext();
                n2 = this.tokenSequence.offset();
            } else {
                n2 = this.endPos(jCMethodDecl) - 1;
            }
        } else {
            n2 = jCMethodDecl.thrown.iterator().next().getStartPosition();
        }
        int n10 = n4;
        n4 = n2;
        this.copyTo(n10, n4);
        PositionEstimator positionEstimator = EstimatorFactory.throwz(jCMethodDecl.getThrows(), jCMethodDecl2.getThrows(), this.workingCopy);
        n4 = this.diffList2(jCMethodDecl.thrown, jCMethodDecl2.thrown, n2, positionEstimator);
        if (jCMethodDecl.defaultValue != jCMethodDecl2.defaultValue) {
            if (jCMethodDecl.defaultValue == null) {
                this.printer.print(" default ");
                this.printer.print(jCMethodDecl2.defaultValue);
            } else if (jCMethodDecl2.defaultValue == null) {
                n4 = this.endPos(jCMethodDecl.defaultValue);
            } else {
                nArray2 = this.getBounds(jCMethodDecl.defaultValue);
                this.copyTo(n4, nArray2[0]);
                int n11 = n4 = this.diffTree(jCMethodDecl.defaultValue, jCMethodDecl2.defaultValue, nArray2);
                n4 = nArray2[1];
                this.copyTo(n11, n4);
            }
        }
        if (jCMethodDecl2.body == null && jCMethodDecl.body != null) {
            n4 = this.endPos(jCMethodDecl.body);
            this.printer.print(";");
        } else if (jCMethodDecl.body != null && jCMethodDecl2.body != null) {
            nArray2 = this.getBounds(jCMethodDecl.body);
            this.copyTo(n4, nArray2[0]);
            n4 = this.diffTree(jCMethodDecl.body, jCMethodDecl2.body, nArray2);
        }
        this.copyTo(n4, nArray[1]);
        return nArray[1];
    }

    protected int diffVarDef(JCTree.JCVariableDecl jCVariableDecl, JCTree.JCVariableDecl jCVariableDecl2, int n) {
        int n2 = jCVariableDecl.pos;
        this.copyTo(n, n2);
        if (this.nameChanged(jCVariableDecl.name, jCVariableDecl2.name)) {
            this.copyTo(n2, jCVariableDecl.pos);
            this.printer.print(jCVariableDecl2.name);
            this.diffInfo.put(jCVariableDecl.pos, NbBundle.getMessage(CasualDiff.class, (String)"TXT_RenameVariable") + " " + jCVariableDecl.name);
            n2 = jCVariableDecl.pos + jCVariableDecl.name.length();
        }
        if (jCVariableDecl2.init != null && jCVariableDecl.init != null) {
            int n3 = n2;
            n2 = CasualDiff.getOldPos(jCVariableDecl.init);
            this.copyTo(n3, n2);
            n2 = this.diffTree(jCVariableDecl.init, jCVariableDecl2.init, new int[]{n2, this.endPos(jCVariableDecl.init)});
        } else {
            int n4;
            if (jCVariableDecl.init != null && jCVariableDecl2.init == null) {
                n = CasualDiff.getOldPos(jCVariableDecl.init);
                this.tokenSequence.move(n);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                this.tokenSequence.moveNext();
                n4 = this.tokenSequence.offset();
                this.copyTo(n2, n4);
                n2 = this.endPos(jCVariableDecl.init);
            }
            if (jCVariableDecl.init == null && jCVariableDecl2.init != null) {
                n4 = this.endPos(jCVariableDecl);
                this.tokenSequence.move(n4);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                int n5 = n2;
                n2 = this.tokenSequence.offset();
                this.copyTo(n5, n2);
                this.printer.printVarInit(jCVariableDecl2);
            }
        }
        int n6 = n2;
        n2 = this.endPos(jCVariableDecl) - 1;
        this.copyTo(n6, n2);
        return n2;
    }

    private int diffVarDef(JCTree.JCVariableDecl jCVariableDecl, JCTree.JCVariableDecl jCVariableDecl2, int[] nArray) {
        int n;
        int n2 = nArray[0];
        if ((jCVariableDecl.mods.flags & 0x4000L) != 0L) {
            if (this.nameChanged(jCVariableDecl.name, jCVariableDecl2.name)) {
                this.copyTo(n2, jCVariableDecl.pos);
                this.printer.print(jCVariableDecl2.name);
                this.diffInfo.put(jCVariableDecl.pos, NbBundle.getMessage(CasualDiff.class, (String)"TXT_RenameEnumConstant") + " " + jCVariableDecl.name);
                n2 = jCVariableDecl.pos + jCVariableDecl.name.length();
            }
            JCTree.JCNewClass jCNewClass = (JCTree.JCNewClass)jCVariableDecl.init;
            JCTree.JCNewClass jCNewClass2 = (JCTree.JCNewClass)jCVariableDecl2.init;
            if (jCNewClass.args.nonEmpty() && jCNewClass2.args.nonEmpty()) {
                int n3 = n2;
                n2 = CasualDiff.getOldPos((JCTree)jCNewClass.args.head);
                this.copyTo(n3, n2);
                n2 = this.diffParameterList(jCNewClass.args, jCNewClass2.args, null, n2, Measure.ARGUMENT);
            }
            if (jCNewClass.def != null && jCNewClass2.def != null) {
                this.anonClass = true;
                int[] nArray2 = new int[]{n2, this.endPos(jCNewClass.def)};
                n2 = this.diffTree(jCNewClass.def, jCNewClass2.def, nArray2);
                this.anonClass = false;
            }
            this.copyTo(n2, nArray[1]);
            return nArray[1];
        }
        if (!this.matchModifiers(jCVariableDecl.mods, jCVariableDecl2.mods)) {
            if (this.hasModifiers(jCVariableDecl2.mods)) {
                n2 = this.diffModifiers(jCVariableDecl.mods, jCVariableDecl2.mods, jCVariableDecl, n2);
            } else if (this.hasModifiers(jCVariableDecl.mods)) {
                int n4 = CasualDiff.getOldPos(jCVariableDecl.mods);
                this.copyTo(n2, n4);
                n2 = CasualDiff.getOldPos(jCVariableDecl.vartype);
            }
        }
        int[] nArray3 = this.getBounds(jCVariableDecl.vartype);
        this.copyTo(n2, nArray3[0]);
        n2 = this.diffTree(jCVariableDecl.vartype, jCVariableDecl2.vartype, nArray3);
        if (this.nameChanged(jCVariableDecl.name, jCVariableDecl2.name)) {
            int n5 = n = jCVariableDecl.name == Names.instance((Context)this.context).error ? 1 : 0;
            if (n == 0) {
                this.copyTo(n2, jCVariableDecl.pos);
            } else {
                this.printer.print(" ");
            }
            this.printer.print(jCVariableDecl2.name);
            this.diffInfo.put(jCVariableDecl.pos, NbBundle.getMessage(CasualDiff.class, (String)"TXT_RenameVariable") + " " + jCVariableDecl.name);
            if (n == 0) {
                n2 = jCVariableDecl.pos + jCVariableDecl.name.length();
            }
        }
        if (jCVariableDecl2.init != null && jCVariableDecl.init != null) {
            int n6 = n2;
            n2 = CasualDiff.getOldPos(jCVariableDecl.init);
            this.copyTo(n6, n2);
            n2 = this.diffTree(jCVariableDecl.init, jCVariableDecl2.init, new int[]{n2, this.endPos(jCVariableDecl.init)});
        } else {
            if (jCVariableDecl.init != null && jCVariableDecl2.init == null) {
                n = CasualDiff.getOldPos(jCVariableDecl.init);
                this.tokenSequence.move(n);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                this.tokenSequence.moveNext();
                int n7 = this.tokenSequence.offset();
                this.copyTo(n2, n7);
                n2 = this.endPos(jCVariableDecl.init);
            }
            if (jCVariableDecl.init == null && jCVariableDecl2.init != null) {
                n = this.endPos(jCVariableDecl);
                this.tokenSequence.move(n);
                this.tokenSequence.moveNext();
                if (!JavaTokenId.COMMA.equals((Object)this.tokenSequence.token().id()) && !JavaTokenId.SEMICOLON.equals((Object)this.tokenSequence.token().id())) {
                    this.tokenSequence.movePrevious();
                }
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                this.tokenSequence.moveNext();
                int n8 = n2;
                n2 = this.tokenSequence.offset();
                this.copyTo(n8, n2);
                this.printer.printVarInit(jCVariableDecl2);
            }
        }
        this.copyTo(n2, nArray[1]);
        return nArray[1];
    }

    protected int diffBlock(JCTree.JCBlock jCBlock, JCTree.JCBlock jCBlock2, int[] nArray) {
        int n = nArray[0];
        if (jCBlock.flags != jCBlock2.flags) {
            // empty if block
        }
        if (jCBlock.stats.head != null && ((JCTree.JCStatement)jCBlock.stats.head).pos == jCBlock.pos) {
            jCBlock.stats = jCBlock.stats.tail;
        }
        if (jCBlock2.stats.head != null && ((JCTree.JCStatement)jCBlock2.stats.head).pos == jCBlock.pos) {
            jCBlock2.stats = jCBlock2.stats.tail;
        }
        PositionEstimator positionEstimator = EstimatorFactory.statements(this.filterHidden(jCBlock.stats), this.filterHidden(jCBlock2.stats), this.workingCopy);
        this.copyTo(n, jCBlock.pos + 1);
        int n2 = this.printer.indent();
        Name name = this.printer.enclClassName;
        this.printer.enclClassName = null;
        java.util.List<JCTree> list = this.filterHidden(jCBlock.stats);
        n = this.diffList(list, this.filterHidden(jCBlock2.stats), jCBlock.pos + 1, positionEstimator, Measure.MEMBER, this.printer);
        this.printer.enclClassName = name;
        if (n < this.endPos(jCBlock)) {
            int n3 = n;
            n = this.endPos(jCBlock);
            this.copyTo(n3, n);
        }
        this.printer.undent(n2);
        return n;
    }

    private int adjustLocalPointer(int n, CommentSet commentSet, CommentSet.RelativePosition relativePosition) {
        if (commentSet == null) {
            return n;
        }
        java.util.List<Comment> list = commentSet.getComments(relativePosition);
        if (!list.isEmpty()) {
            for (Comment comment : list) {
                n = Math.max(comment.endPos(), n);
            }
        }
        return n;
    }

    private boolean isComment(JavaTokenId javaTokenId) {
        switch (javaTokenId) {
            case LINE_COMMENT: 
            case BLOCK_COMMENT: 
            case JAVADOC_COMMENT: {
                return true;
            }
        }
        return false;
    }

    protected int diffDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop, JCTree.JCDoWhileLoop jCDoWhileLoop2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = new int[]{n, this.endPos(jCDoWhileLoop.body)};
        n = this.diffTree((JCTree)jCDoWhileLoop.body, (JCTree)jCDoWhileLoop2.body, nArray2, jCDoWhileLoop.getKind());
        int[] nArray3 = this.getBounds(jCDoWhileLoop.cond);
        if (jCDoWhileLoop.body.getKind() != Tree.Kind.BLOCK && jCDoWhileLoop2.body.getKind() == Tree.Kind.BLOCK) {
            PositionEstimator.moveBackToToken(this.tokenSequence, nArray3[0], JavaTokenId.WHILE);
            n = this.tokenSequence.offset();
        } else {
            this.copyTo(n, nArray3[0]);
            n = this.diffTree(jCDoWhileLoop.cond, jCDoWhileLoop2.cond, nArray3);
        }
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffWhileLoop(JCTree.JCWhileLoop jCWhileLoop, JCTree.JCWhileLoop jCWhileLoop2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCWhileLoop.cond);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree(jCWhileLoop.cond, jCWhileLoop2.cond, nArray2);
        int[] nArray3 = new int[]{n, this.endPos(jCWhileLoop.body)};
        n = this.diffTree((JCTree)jCWhileLoop.body, (JCTree)jCWhileLoop2.body, nArray3, jCWhileLoop.getKind());
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffForLoop(JCTree.JCForLoop jCForLoop, JCTree.JCForLoop jCForLoop2, int[] nArray) {
        int n;
        if (jCForLoop.init.nonEmpty()) {
            n = CasualDiff.getOldPos((JCTree)jCForLoop.init.head);
        } else {
            PositionEstimator.moveFwdToToken(this.tokenSequence, nArray[0], JavaTokenId.SEMICOLON);
            n = this.tokenSequence.offset();
        }
        this.copyTo(nArray[0], n);
        if (!this.listsMatch(jCForLoop.init, jCForLoop2.init)) {
            boolean bl;
            boolean bl2 = CasualDiff.containsVariable(jCForLoop.init);
            if (bl2 ^ (bl = CasualDiff.containsVariable(jCForLoop2.init))) {
                int n2 = this.printer.setPrec(0);
                n = this.diffParameterList(jCForLoop.init, jCForLoop2.init, null, n, Measure.ARGUMENT);
                this.printer.setPrec(n2);
            } else if (bl2) {
                java.util.List list = NbCollections.checkedListByCopy(jCForLoop.init, JCTree.JCVariableDecl.class, (boolean)false);
                FieldGroupTree fieldGroupTree = new FieldGroupTree(list, false);
                java.util.List list2 = NbCollections.checkedListByCopy(jCForLoop2.init, JCTree.JCVariableDecl.class, (boolean)false);
                FieldGroupTree fieldGroupTree2 = new FieldGroupTree(list2, false);
                int[] nArray2 = this.getBounds((JCTree)jCForLoop.init.head);
                JCTree jCTree = jCForLoop.init.get(jCForLoop.init.size() - 1);
                long l = this.workingCopy.getTrees().getSourcePositions().getEndPosition(this.oldTopLevel, jCTree);
                nArray2[1] = (int)l;
                n = this.diffTree(fieldGroupTree, fieldGroupTree2, nArray2);
            } else {
                n = this.diffParameterList(jCForLoop.init, jCForLoop2.init, null, n, Measure.ARGUMENT);
            }
        }
        if (jCForLoop.cond != null) {
            int n3 = n;
            n = CasualDiff.getOldPos(jCForLoop.cond);
            this.copyTo(n3, n);
            n = this.diffTree(jCForLoop.cond, jCForLoop2.cond, this.getBounds(jCForLoop.cond));
        } else {
            PositionEstimator.moveFwdToToken(this.tokenSequence, n, JavaTokenId.SEMICOLON);
            int n4 = n;
            n = this.tokenSequence.offset();
            this.copyTo(n4, n);
        }
        if (jCForLoop.step.nonEmpty()) {
            int n5 = n;
            n = CasualDiff.getOldPos((JCTree)jCForLoop.step.head);
            this.copyTo(n5, n);
        } else {
            PositionEstimator.moveFwdToToken(this.tokenSequence, n, JavaTokenId.SEMICOLON);
            this.tokenSequence.moveNext();
            int n6 = n;
            n = this.tokenSequence.offset();
            this.copyTo(n6, n);
        }
        n = this.diffParameterList(jCForLoop.step, jCForLoop2.step, null, n, Measure.ARGUMENT);
        int[] nArray3 = new int[]{n, this.endPos(jCForLoop.body)};
        n = this.diffTree((JCTree)jCForLoop.body, (JCTree)jCForLoop2.body, nArray3, jCForLoop.getKind());
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    private static boolean containsVariable(java.util.List<JCTree.JCStatement> list) {
        for (JCTree.JCStatement jCStatement : list) {
            if (jCStatement.getKind() != Tree.Kind.VARIABLE) continue;
            return true;
        }
        return false;
    }

    protected int diffForeachLoop(JCTree.JCEnhancedForLoop jCEnhancedForLoop, JCTree.JCEnhancedForLoop jCEnhancedForLoop2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCEnhancedForLoop.var);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree(jCEnhancedForLoop.var, jCEnhancedForLoop2.var, nArray2);
        int[] nArray3 = this.getBounds(jCEnhancedForLoop.expr);
        this.copyTo(n, nArray3[0]);
        n = this.diffTree(jCEnhancedForLoop.expr, jCEnhancedForLoop2.expr, nArray3);
        int[] nArray4 = new int[]{n, this.endPos(jCEnhancedForLoop.body)};
        n = this.diffTree((JCTree)jCEnhancedForLoop.body, (JCTree)jCEnhancedForLoop2.body, nArray4, jCEnhancedForLoop.getKind());
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffLabelled(JCTree.JCLabeledStatement jCLabeledStatement, JCTree.JCLabeledStatement jCLabeledStatement2, int[] nArray) {
        int n = nArray[0];
        if (this.nameChanged(jCLabeledStatement.label, jCLabeledStatement2.label)) {
            int n2 = n;
            n = CasualDiff.getOldPos(jCLabeledStatement);
            this.copyTo(n2, n);
            this.printer.print(jCLabeledStatement2.label);
            n += jCLabeledStatement.label.length();
        }
        int[] nArray2 = this.getBounds(jCLabeledStatement.body);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree(jCLabeledStatement.body, jCLabeledStatement2.body, nArray2);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffSwitch(JCTree.JCSwitch jCSwitch, JCTree.JCSwitch jCSwitch2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCSwitch.selector);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree(jCSwitch.selector, jCSwitch2.selector, nArray2);
        this.tokenSequence.move(nArray2[1]);
        while (this.tokenSequence.moveNext() && JavaTokenId.LBRACE != this.tokenSequence.token().id()) {
        }
        this.tokenSequence.moveNext();
        int n2 = n;
        n = this.tokenSequence.offset();
        this.copyTo(n2, n);
        PositionEstimator positionEstimator = EstimatorFactory.cases(jCSwitch.getCases(), jCSwitch2.getCases(), this.workingCopy);
        n = this.diffList(jCSwitch.cases, jCSwitch2.cases, n, positionEstimator, Measure.MEMBER, this.printer);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffCase(JCTree.JCCase jCCase, JCTree.JCCase jCCase2, int[] nArray) {
        Object object;
        int n = nArray[0];
        if (jCCase.pat != null) {
            object = this.getBounds(jCCase.pat);
            this.copyTo(n, object[0]);
            n = this.diffTree(jCCase.pat, jCCase2.pat, (int[])object);
            this.tokenSequence.move(object[1]);
            while (this.tokenSequence.moveNext() && JavaTokenId.COLON != this.tokenSequence.token().id()) {
            }
            this.tokenSequence.moveNext();
            int n2 = n;
            n = this.tokenSequence.offset();
            this.copyTo(n2, n);
        }
        if (jCCase.pat == null && jCCase2.pat != null) {
            this.printer.print(jCCase2);
            this.printer.newline();
            return nArray[1];
        }
        object = EstimatorFactory.statements(jCCase.getStatements(), jCCase2.getStatements(), this.workingCopy);
        n = this.diffList(jCCase.stats, jCCase2.stats, n, (PositionEstimator)object, Measure.MEMBER, this.printer);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffSynchronized(JCTree.JCSynchronized jCSynchronized, JCTree.JCSynchronized jCSynchronized2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCSynchronized.lock);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree(jCSynchronized.lock, jCSynchronized2.lock, nArray2);
        int[] nArray3 = this.getBounds(jCSynchronized.body);
        this.copyTo(n, nArray3[0]);
        n = this.diffTree(jCSynchronized.body, jCSynchronized2.body, nArray3);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffTry(JCTree.JCTry jCTry, JCTree.JCTry jCTry2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCTry.body);
        this.copyTo(n, nArray2[0]);
        int n2 = n = this.diffTree(jCTry.body, jCTry2.body, nArray2);
        n = nArray2[1];
        this.copyTo(n2, n);
        PositionEstimator positionEstimator = EstimatorFactory.catches(jCTry.getCatches(), jCTry2.getCatches(), this.workingCopy);
        n = this.diffList(jCTry.catchers, jCTry2.catchers, n, positionEstimator, Measure.DEFAULT, this.printer);
        if (jCTry.finalizer != null) {
            int[] nArray3 = this.getBounds(jCTry.finalizer);
            if (jCTry2.finalizer != null) {
                this.copyTo(n, nArray3[0]);
                n = this.diffTree(jCTry.finalizer, jCTry2.finalizer, nArray3);
            } else {
                int n3 = jCTry.catchers.isEmpty() ? this.endPos(jCTry.body) : this.endPos(jCTry.catchers);
                this.copyTo(n, n3);
                n = nArray3[1];
            }
            this.copyTo(n, nArray[1]);
        } else if (jCTry2.finalizer != null) {
            int n4 = jCTry.catchers.isEmpty() ? nArray[1] : this.endPos((JCTree)jCTry.catchers.reverse().head);
            int n5 = n;
            n = n4;
            this.copyTo(n5, n);
            this.printer.printFinallyBlock(jCTry2.finalizer);
            this.copyTo(n, nArray[1]);
        } else {
            this.copyTo(n, nArray[1]);
        }
        return nArray[1];
    }

    protected int diffCatch(JCTree.JCCatch jCCatch, JCTree.JCCatch jCCatch2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCCatch.param);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree(jCCatch.param, jCCatch2.param, nArray2);
        int[] nArray3 = this.getBounds(jCCatch.body);
        this.copyTo(n, nArray3[0]);
        n = this.diffTree(jCCatch.body, jCCatch2.body, nArray3);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffConditional(JCTree.JCConditional jCConditional, JCTree.JCConditional jCConditional2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCConditional.cond);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree(jCConditional.cond, jCConditional2.cond, nArray2);
        int[] nArray3 = this.getBounds(jCConditional.truepart);
        this.copyTo(n, nArray3[0]);
        n = this.diffTree(jCConditional.truepart, jCConditional2.truepart, nArray3);
        int[] nArray4 = this.getBounds(jCConditional.falsepart);
        this.copyTo(n, nArray4[0]);
        n = this.diffTree(jCConditional.falsepart, jCConditional2.falsepart, nArray4);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffIf(JCTree.JCIf jCIf, JCTree.JCIf jCIf2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCIf.cond);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree(jCIf.cond, jCIf2.cond, nArray2);
        int[] nArray3 = new int[]{n, this.endPos(jCIf.thenpart)};
        n = this.diffTree((JCTree)jCIf.thenpart, (JCTree)jCIf2.thenpart, nArray3, jCIf.getKind());
        if (jCIf.elsepart == null && jCIf2.elsepart != null) {
            this.printer.printElse(jCIf2, jCIf2.thenpart.getKind() == Tree.Kind.BLOCK);
        } else {
            if (jCIf.elsepart != null && jCIf2.elsepart == null) {
                this.copyTo(n, nArray3[1]);
                this.copyTo(this.getBounds(jCIf.elsepart)[1], nArray[1]);
                return nArray[1];
            }
            if (jCIf.elsepart != null) {
                nArray3 = new int[]{n, this.endPos(jCIf.elsepart)};
                n = this.diffTree((JCTree)jCIf.elsepart, (JCTree)jCIf2.elsepart, nArray3, jCIf.getKind());
            }
        }
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffExec(JCTree.JCExpressionStatement jCExpressionStatement, JCTree.JCExpressionStatement jCExpressionStatement2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCExpressionStatement.expr);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree(jCExpressionStatement.expr, jCExpressionStatement2.expr, nArray2);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffBreak(JCTree.JCBreak jCBreak, JCTree.JCBreak jCBreak2, int[] nArray) {
        Name name = jCBreak.label;
        Name name2 = jCBreak2.label;
        return this.printBreakContinueTree(nArray, name, name2, jCBreak);
    }

    protected int diffContinue(JCTree.JCContinue jCContinue, JCTree.JCContinue jCContinue2, int[] nArray) {
        Name name = jCContinue.label;
        Name name2 = jCContinue2.label;
        return this.printBreakContinueTree(nArray, name, name2, jCContinue);
    }

    protected int diffReturn(JCTree.JCReturn jCReturn, JCTree.JCReturn jCReturn2, int[] nArray) {
        int n = nArray[0];
        if (jCReturn.expr != null && jCReturn2.expr != null) {
            int[] nArray2 = this.getBounds(jCReturn.expr);
            this.copyTo(nArray[0], nArray2[0]);
            n = this.diffTree(jCReturn.expr, jCReturn2.expr, nArray2);
        }
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffThrow(JCTree.JCThrow jCThrow, JCTree.JCThrow jCThrow2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCThrow.expr);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree(jCThrow.expr, jCThrow2.expr, nArray2);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffAssert(JCTree.JCAssert jCAssert, JCTree.JCAssert jCAssert2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCAssert.cond);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree(jCAssert.cond, jCAssert2.cond, nArray2);
        if (jCAssert.detail != jCAssert2.detail) {
            if (jCAssert.detail == null) {
                this.copyTo(n, nArray2[1]);
                n = nArray2[1];
                this.printer.print(" : ");
                this.printer.print(jCAssert2.detail);
            } else {
                int[] nArray3 = this.getBounds(jCAssert.detail);
                if (jCAssert2.detail == null) {
                    this.copyTo(n, nArray2[1]);
                    n = nArray3[1];
                } else {
                    this.copyTo(n, nArray3[0]);
                    n = this.diffTree(jCAssert.detail, jCAssert2.detail, nArray3);
                }
            }
        }
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffApply(JCTree.JCMethodInvocation jCMethodInvocation, JCTree.JCMethodInvocation jCMethodInvocation2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCMethodInvocation.meth);
        if (jCMethodInvocation.typeargs.nonEmpty() && jCMethodInvocation2.typeargs.nonEmpty() && Tree.Kind.MEMBER_SELECT == jCMethodInvocation.meth.getKind()) {
            n = this.diffSelect((JCTree.JCFieldAccess)jCMethodInvocation.meth, (JCTree.JCFieldAccess)jCMethodInvocation2.meth, nArray2, jCMethodInvocation.typeargs, jCMethodInvocation2.typeargs);
        } else {
            n = this.diffParameterList(jCMethodInvocation.typeargs, jCMethodInvocation2.typeargs, null, n, Measure.ARGUMENT);
            n = this.diffTree(jCMethodInvocation.meth, jCMethodInvocation2.meth, nArray2);
        }
        if (!this.listsMatch(jCMethodInvocation.args, jCMethodInvocation2.args)) {
            if (jCMethodInvocation.args.nonEmpty()) {
                int n2 = n;
                n = CasualDiff.getOldPos((JCTree)jCMethodInvocation.args.head);
                this.copyTo(n2, n);
            } else {
                int n3 = n;
                n = nArray2[1];
                this.copyTo(n3, n);
                this.tokenSequence.move(n);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                this.tokenSequence.moveNext();
                int n4 = n;
                n = this.tokenSequence.offset();
                this.copyTo(n4, n);
            }
            n = this.diffParameterList(jCMethodInvocation.args, jCMethodInvocation2.args, null, n, Measure.ARGUMENT);
        }
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffNewClass(JCTree.JCNewClass jCNewClass, JCTree.JCNewClass jCNewClass2, int[] nArray) {
        int[] nArray2;
        int n = nArray[0];
        if (jCNewClass.encl != null) {
            nArray2 = this.getBounds(jCNewClass.encl);
            n = this.diffTree(jCNewClass.encl, jCNewClass2.encl, nArray2);
        }
        this.diffParameterList(jCNewClass.typeargs, jCNewClass2.typeargs, null, n, Measure.ARGUMENT);
        if (!this.enumConstantPrint) {
            nArray2 = this.getBounds(jCNewClass.clazz);
            this.copyTo(n, nArray2[0]);
            n = this.diffTree(jCNewClass.clazz, jCNewClass2.clazz, nArray2);
        }
        if (jCNewClass.args.nonEmpty()) {
            int n2 = n;
            n = CasualDiff.getOldPos((JCTree)jCNewClass.args.head);
            this.copyTo(n2, n);
        } else {
            PositionEstimator.moveFwdToToken(this.tokenSequence, jCNewClass.pos, JavaTokenId.LPAREN);
            this.tokenSequence.moveNext();
            int n3 = n;
            n = this.tokenSequence.offset();
            this.copyTo(n3, n);
        }
        n = this.diffParameterList(jCNewClass.args, jCNewClass2.args, null, n, Measure.ARGUMENT);
        if (jCNewClass.def != null) {
            if (jCNewClass2.def != null) {
                this.copyTo(n, CasualDiff.getOldPos(jCNewClass.def));
                this.anonClass = true;
                n = this.diffTree(jCNewClass.def, jCNewClass2.def, this.getBounds(jCNewClass.def));
                this.anonClass = false;
            } else {
                if (this.endPos(jCNewClass.args) > n) {
                    this.copyTo(n, this.endPos(jCNewClass.args));
                }
                this.printer.print(")");
                n = this.endPos(jCNewClass.def);
            }
        }
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffNewArray(JCTree.JCNewArray jCNewArray, JCTree.JCNewArray jCNewArray2, int[] nArray) {
        Object object;
        int n = nArray[0];
        if (jCNewArray.elemtype != null) {
            object = this.getBounds(jCNewArray.elemtype);
            this.copyTo(n, object[0]);
            n = this.diffTree(jCNewArray.elemtype, jCNewArray2.elemtype, (int[])object);
        }
        if (!this.listsMatch(jCNewArray.dims, jCNewArray2.dims) && !jCNewArray2.dims.isEmpty()) {
            object = jCNewArray.dims;
            List<JCTree.JCExpression> list = jCNewArray2.dims;
            while (((List)object).nonEmpty()) {
                int[] nArray2 = this.getBounds((JCTree)((List)object).head);
                this.copyTo(n, nArray2[0]);
                n = this.diffTree((JCTree)((List)object).head, (JCTree)list.head, nArray2);
                object = ((List)object).tail;
                list = list.tail;
            }
        }
        if (jCNewArray.elems != null) {
            if (jCNewArray.elems.head != null) {
                this.copyTo(n, CasualDiff.getOldPos((JCTree)jCNewArray.elems.head));
                n = this.diffParameterList(jCNewArray.elems, jCNewArray2.elems, null, CasualDiff.getOldPos((JCTree)jCNewArray.elems.head), Measure.ARGUMENT);
            } else if (jCNewArray2.elems != null && !jCNewArray2.elems.isEmpty()) {
                PositionEstimator.moveFwdToToken(this.tokenSequence, n, JavaTokenId.LBRACE);
                this.tokenSequence.moveNext();
                int n2 = n;
                n = this.tokenSequence.offset();
                this.copyTo(n2, n);
                n = this.diffParameterList(jCNewArray.elems, jCNewArray2.elems, null, n, Measure.ARGUMENT);
            }
        } else if (jCNewArray2.elems != null && !jCNewArray2.elems.isEmpty()) {
            this.printer.print("[]{");
            n = this.diffParameterList(Collections.emptyList(), jCNewArray2.elems, null, n, Measure.ARGUMENT);
            this.printer.print("}");
            PositionEstimator.moveFwdToToken(this.tokenSequence, n, JavaTokenId.SEMICOLON);
            this.tokenSequence.moveNext();
            n = nArray[1];
        }
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffParens(JCTree.JCParens jCParens, JCTree.JCParens jCParens2, int[] nArray) {
        int n = nArray[0];
        this.copyTo(n, CasualDiff.getOldPos(jCParens.expr));
        n = this.diffTree(jCParens.expr, jCParens2.expr, this.getBounds(jCParens.expr));
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffAssign(JCTree.JCAssign jCAssign, JCTree.JCAssign jCAssign2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCAssign.lhs);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree(jCAssign.lhs, jCAssign2.lhs, nArray2);
        int[] nArray3 = this.getBounds(jCAssign.rhs);
        if (jCAssign.lhs.getKind() == Tree.Kind.IDENTIFIER && jCAssign2.lhs.getKind() == Tree.Kind.IDENTIFIER && !((JCTree.JCIdent)jCAssign.lhs).name.equals(((JCTree.JCIdent)jCAssign2.lhs).name)) {
            this.tokenSequence.move(nArray3[0]);
            PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
            if (this.tokenSequence.token().id() != JavaTokenId.EQ) {
                if (VeryPretty.getCodeStyle(this.workingCopy).spaceAroundAssignOps()) {
                    this.printer.print(" = ");
                } else {
                    this.printer.print("=");
                }
            }
        }
        this.copyTo(n, nArray3[0]);
        n = this.diffTree(jCAssign.rhs, jCAssign2.rhs, nArray3);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffAssignop(JCTree.JCAssignOp jCAssignOp, JCTree.JCAssignOp jCAssignOp2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCAssignOp.lhs);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree(jCAssignOp.lhs, jCAssignOp2.lhs, nArray2);
        if (jCAssignOp.getTag() != jCAssignOp2.getTag()) {
            this.copyTo(n, jCAssignOp.pos);
            this.printer.print(this.getAssignementOperator(jCAssignOp2));
            n = jCAssignOp.pos + this.getAssignementOperator(jCAssignOp).length();
        }
        int[] nArray3 = this.getBounds(jCAssignOp.rhs);
        this.copyTo(n, nArray3[0]);
        n = this.diffTree(jCAssignOp.rhs, jCAssignOp2.rhs, nArray3);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    String getAssignementOperator(Tree tree) {
        switch (tree.getKind()) {
            case MULTIPLY_ASSIGNMENT: {
                return "*=";
            }
            case DIVIDE_ASSIGNMENT: {
                return "/=";
            }
            case REMAINDER_ASSIGNMENT: {
                return "%=";
            }
            case PLUS_ASSIGNMENT: {
                return "+=";
            }
            case MINUS_ASSIGNMENT: {
                return "-=";
            }
            case LEFT_SHIFT_ASSIGNMENT: {
                return "<<=";
            }
            case RIGHT_SHIFT_ASSIGNMENT: {
                return ">>=";
            }
            case AND_ASSIGNMENT: {
                return "&=";
            }
            case XOR_ASSIGNMENT: {
                return "^=";
            }
            case OR_ASSIGNMENT: {
                return "|=";
            }
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                return ">>>=";
            }
        }
        throw new IllegalArgumentException("Illegal kind " + (Object)((Object)tree.getKind()));
    }

    protected int diffUnary(JCTree.JCUnary jCUnary, JCTree.JCUnary jCUnary2, int[] nArray) {
        boolean bl;
        int[] nArray2 = this.getBounds(jCUnary.arg);
        boolean bl2 = bl = jCUnary2.getKind() != Tree.Kind.POSTFIX_DECREMENT && jCUnary2.getKind() != Tree.Kind.POSTFIX_INCREMENT;
        if (bl) {
            if (jCUnary.getTag() != jCUnary2.getTag()) {
                this.printer.print(this.operatorName(jCUnary2.getTag()));
            } else {
                this.copyTo(nArray[0], nArray2[0]);
            }
        }
        int n = this.diffTree(jCUnary.arg, jCUnary2.arg, nArray2);
        this.copyTo(n, nArray2[1]);
        if (!bl) {
            if (jCUnary.getTag() != jCUnary2.getTag()) {
                this.printer.print(this.operatorName(jCUnary2.getTag()));
            } else {
                this.copyTo(nArray2[1], nArray[1]);
            }
        }
        return nArray[1];
    }

    protected int diffBinary(JCTree.JCBinary jCBinary, JCTree.JCBinary jCBinary2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCBinary.lhs);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree(jCBinary.lhs, jCBinary2.lhs, nArray2);
        if (jCBinary.getTag() != jCBinary2.getTag()) {
            this.copyTo(n, jCBinary.pos);
            this.printer.print(this.operatorName(jCBinary2.getTag()));
            n = jCBinary.pos + this.operatorName(jCBinary.getTag()).toString().length();
        }
        int[] nArray3 = this.getBounds(jCBinary.rhs);
        this.copyTo(n, nArray3[0]);
        n = this.diffTree(jCBinary.rhs, jCBinary2.rhs, nArray3);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    private String operatorName(int n) {
        return new Pretty(null, false).operatorName(n);
    }

    protected int diffTypeCast(JCTree.JCTypeCast jCTypeCast, JCTree.JCTypeCast jCTypeCast2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCTypeCast.clazz);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree(jCTypeCast.clazz, jCTypeCast2.clazz, nArray2);
        int[] nArray3 = this.getBounds(jCTypeCast.expr);
        this.copyTo(n, nArray3[0]);
        n = this.diffTree(jCTypeCast.expr, jCTypeCast2.expr, nArray3);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffTypeTest(JCTree.JCInstanceOf jCInstanceOf, JCTree.JCInstanceOf jCInstanceOf2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCInstanceOf.expr);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree(jCInstanceOf.expr, jCInstanceOf2.expr, nArray2);
        int[] nArray3 = this.getBounds(jCInstanceOf.clazz);
        this.copyTo(n, nArray3[0]);
        n = this.diffTree(jCInstanceOf.clazz, jCInstanceOf2.clazz, nArray3);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffIndexed(JCTree.JCArrayAccess jCArrayAccess, JCTree.JCArrayAccess jCArrayAccess2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCArrayAccess.indexed);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree(jCArrayAccess.indexed, jCArrayAccess2.indexed, nArray2);
        int[] nArray3 = this.getBounds(jCArrayAccess.index);
        this.copyTo(n, nArray3[0]);
        n = this.diffTree(jCArrayAccess.index, jCArrayAccess2.index, nArray3);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffSelect(JCTree.JCFieldAccess jCFieldAccess, JCTree.JCFieldAccess jCFieldAccess2, int[] nArray, List<JCTree.JCExpression> list, List<JCTree.JCExpression> list2) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCFieldAccess.selected);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree(jCFieldAccess.selected, jCFieldAccess2.selected, nArray2);
        if (list != null && list2 != null) {
            int[] nArray3 = this.getBounds((JCTree)list.head);
            this.copyTo(n, nArray3[0]);
            n = this.diffParameterList(list, list2, null, nArray3[0], Measure.ARGUMENT);
            nArray3[1] = this.endPos(list);
            this.tokenSequence.move(nArray3[1]);
            PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
            PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
            int n2 = n;
            n = this.tokenSequence.offset();
            this.copyTo(n2, n);
        } else {
            this.tokenSequence.move(nArray2[1]);
            if (jCFieldAccess.name != Names.instance((Context)this.context).error) {
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                int n3 = n;
                n = this.tokenSequence.offset();
                this.copyTo(n3, n);
            }
        }
        if (this.nameChanged(jCFieldAccess.name, jCFieldAccess2.name)) {
            this.printer.print(jCFieldAccess2.name);
            this.diffInfo.put(n, NbBundle.getMessage(CasualDiff.class, (String)"TXT_UpdateReferenceTo") + " " + jCFieldAccess.name);
            n += jCFieldAccess.name.length();
        }
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffSelect(JCTree.JCFieldAccess jCFieldAccess, JCTree.JCFieldAccess jCFieldAccess2, int[] nArray) {
        return this.diffSelect(jCFieldAccess, jCFieldAccess2, nArray, null, null);
    }

    protected int diffIdent(JCTree.JCIdent jCIdent, JCTree.JCIdent jCIdent2, int[] nArray) {
        if (this.nameChanged(jCIdent.name, jCIdent2.name)) {
            this.copyTo(nArray[0], jCIdent.pos);
            this.printer.print(jCIdent2.name);
            this.diffInfo.put(jCIdent.pos, NbBundle.getMessage(CasualDiff.class, (String)"TXT_UpdateReferenceTo") + " " + jCIdent.name);
        } else {
            this.copyTo(nArray[0], nArray[1]);
        }
        return nArray[1];
    }

    protected int diffLiteral(JCTree.JCLiteral jCLiteral, JCTree.JCLiteral jCLiteral2, int[] nArray) {
        if (jCLiteral.typetag != jCLiteral2.typetag || jCLiteral.value != null && !jCLiteral.value.equals(jCLiteral2.value)) {
            int n = nArray[0];
            int[] nArray2 = this.getBounds(jCLiteral);
            this.copyTo(n, nArray2[0]);
            this.printer.print(jCLiteral2);
            this.copyTo(nArray2[1], nArray[1]);
        } else {
            this.copyTo(nArray[0], nArray[1]);
        }
        return nArray[1];
    }

    protected int diffTypeIdent(JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree, JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree2, int[] nArray) {
        if (jCPrimitiveTypeTree.typetag != jCPrimitiveTypeTree2.typetag) {
            this.printer.print(jCPrimitiveTypeTree2);
        } else {
            this.copyTo(nArray[0], nArray[1]);
        }
        return nArray[1];
    }

    protected int diffTypeArray(JCTree.JCArrayTypeTree jCArrayTypeTree, JCTree.JCArrayTypeTree jCArrayTypeTree2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCArrayTypeTree.elemtype);
        n = this.diffTree(jCArrayTypeTree.elemtype, jCArrayTypeTree2.elemtype, nArray2);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffTypeApply(JCTree.JCTypeApply jCTypeApply, JCTree.JCTypeApply jCTypeApply2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCTypeApply.clazz);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree(jCTypeApply.clazz, jCTypeApply2.clazz, nArray2);
        if (!this.listsMatch(jCTypeApply.arguments, jCTypeApply2.arguments)) {
            JavaTokenId[] javaTokenIdArray;
            int n2;
            int n3 = n2 = jCTypeApply.arguments.nonEmpty() ? CasualDiff.getOldPos((JCTree)jCTypeApply.arguments.head) : this.endPos(jCTypeApply.clazz);
            if (jCTypeApply2.arguments.nonEmpty()) {
                this.copyTo(n, n2);
            }
            boolean bl = jCTypeApply.arguments.isEmpty() || jCTypeApply2.arguments.isEmpty();
            List<JCTree.JCExpression> list = jCTypeApply.arguments;
            List<JCTree.JCExpression> list2 = jCTypeApply2.arguments;
            if (bl) {
                JavaTokenId[] javaTokenIdArray2 = new JavaTokenId[2];
                javaTokenIdArray2[0] = JavaTokenId.LT;
                javaTokenIdArray = javaTokenIdArray2;
                javaTokenIdArray2[1] = JavaTokenId.GT;
            } else {
                javaTokenIdArray = null;
            }
            n = this.diffParameterList(list, list2, javaTokenIdArray, n2, Measure.ARGUMENT);
        }
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffTypeParameter(JCTree.JCTypeParameter jCTypeParameter, JCTree.JCTypeParameter jCTypeParameter2, int[] nArray) {
        int n = nArray[0];
        this.copyTo(n, CasualDiff.getOldPos(jCTypeParameter));
        if (this.nameChanged(jCTypeParameter.name, jCTypeParameter2.name)) {
            this.printer.print(jCTypeParameter2.name);
            n += jCTypeParameter.name.length();
        }
        if (!this.listsMatch(jCTypeParameter.bounds, jCTypeParameter2.bounds)) {
            int n2;
            PositionEstimator positionEstimator = EstimatorFactory.implementz(jCTypeParameter.getBounds(), jCTypeParameter2.getBounds(), this.workingCopy);
            int n3 = n2 = jCTypeParameter.bounds.nonEmpty() ? CasualDiff.getOldPos((JCTree)jCTypeParameter.bounds.head) : -1;
            if (n2 > -1) {
                this.copyTo(n, n2);
                n = this.diffList2(jCTypeParameter.bounds, jCTypeParameter2.bounds, n2, positionEstimator);
            }
        }
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffWildcard(JCTree.JCWildcard jCWildcard, JCTree.JCWildcard jCWildcard2, int[] nArray) {
        int n = nArray[0];
        if (jCWildcard.kind != jCWildcard2.kind) {
            this.copyTo(n, jCWildcard.pos);
            this.printer.print(jCWildcard2.kind.toString());
            n = jCWildcard.pos + jCWildcard.kind.toString().length();
        }
        int[] nArray2 = this.getBounds(jCWildcard.inner);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree(jCWildcard.inner, jCWildcard2.inner, nArray2);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffTypeBoundKind(JCTree.TypeBoundKind typeBoundKind, JCTree.TypeBoundKind typeBoundKind2, int[] nArray) {
        int n = nArray[0];
        if (typeBoundKind.kind != typeBoundKind2.kind) {
            this.copyTo(n, typeBoundKind.pos);
            this.printer.print(typeBoundKind2.kind.toString());
            n = typeBoundKind.pos + typeBoundKind.kind.toString().length();
        }
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffAnnotation(JCTree.JCAnnotation jCAnnotation, JCTree.JCAnnotation jCAnnotation2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCAnnotation.annotationType);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree(jCAnnotation.annotationType, jCAnnotation2.annotationType, nArray2);
        JavaTokenId[] javaTokenIdArray = null;
        if (jCAnnotation.args.nonEmpty()) {
            int n2 = n;
            n = CasualDiff.getOldPos((JCTree)jCAnnotation.args.head);
            this.copyTo(n2, n);
        } else {
            int n3 = this.endPos(jCAnnotation);
            this.tokenSequence.move(n3);
            this.tokenSequence.movePrevious();
            if (JavaTokenId.RPAREN != this.tokenSequence.token().id()) {
                javaTokenIdArray = new JavaTokenId[]{JavaTokenId.LPAREN, JavaTokenId.RPAREN};
            } else {
                --n3;
            }
            int n4 = n;
            n = n3;
            this.copyTo(n4, n);
        }
        n = this.diffParameterList(jCAnnotation.args, jCAnnotation2.args, javaTokenIdArray, n, Measure.ARGUMENT);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffModifiers(JCTree.JCModifiers jCModifiers, JCTree.JCModifiers jCModifiers2, JCTree jCTree, int n) {
        int n2;
        if (jCModifiers == jCModifiers2) {
            return n;
        }
        int n3 = jCModifiers.annotations.nonEmpty() ? this.endPos(jCModifiers.annotations) : n;
        int n4 = n2 = jCModifiers.pos != -1 ? CasualDiff.getOldPos(jCModifiers) : CasualDiff.getOldPos(jCTree);
        if (this.listsMatch(jCModifiers.annotations, jCModifiers2.annotations)) {
            int n5 = n;
            n = n3 != n ? n3 : n2;
            this.copyTo(n5, n);
        } else {
            Object object;
            this.tokenSequence.move(n2);
            this.tokenSequence.movePrevious();
            if (JavaTokenId.WHITESPACE == this.tokenSequence.token().id()) {
                object = ((Object)this.tokenSequence.token().text()).toString();
                int n6 = ((String)object).lastIndexOf(10);
                n2 = this.tokenSequence.offset();
                if (n6 > -1) {
                    n2 += n6 + 1;
                }
                if (n2 < n) {
                    n2 = n;
                }
            }
            this.copyTo(n, n2);
            object = EstimatorFactory.annotations(jCModifiers.getAnnotations(), jCModifiers2.getAnnotations(), this.workingCopy, this.parameterPrint);
            n = this.diffList(jCModifiers.annotations, jCModifiers2.annotations, n2, (PositionEstimator)object, Measure.DEFAULT, this.printer);
        }
        int n7 = this.endPos(jCModifiers);
        if ((jCModifiers.flags & 0x2000L) != 0L) {
            this.tokenSequence.move(n7);
            this.tokenSequence.movePrevious();
            PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
            this.tokenSequence.moveNext();
            n7 = this.tokenSequence.offset();
        }
        if (jCModifiers.flags != jCModifiers2.flags) {
            if (n == n2) {
                if ((jCModifiers2.flags & 0xFFFFFFFFFFFFFDFFL) != 0L) {
                    this.printer.printFlags(jCModifiers2.flags & 0xFFFFFFFFFFFFFDFFL, jCModifiers.getFlags().isEmpty());
                    n = n7 > 0 ? n7 : n;
                } else if (n7 > 0) {
                    this.tokenSequence.move(n7);
                    while (this.tokenSequence.moveNext() && JavaTokenId.WHITESPACE == this.tokenSequence.token().id()) {
                    }
                    n = this.tokenSequence.offset();
                }
            } else {
                this.tokenSequence.move(n);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                int n8 = n;
                n = this.tokenSequence.offset();
                this.copyTo(n8, n);
                n = this.tokenSequence.offset();
                if (!jCModifiers.getFlags().isEmpty()) {
                    n = n7;
                }
                this.printer.printFlags(jCModifiers2.flags, jCModifiers.getFlags().isEmpty());
            }
        } else if (n7 > n) {
            int n9 = n;
            n = n7;
            this.copyTo(n9, n);
        }
        return n;
    }

    protected void diffLetExpr(JCTree.LetExpr letExpr, JCTree.LetExpr letExpr2) {
    }

    protected void diffErroneous(JCTree.JCErroneous jCErroneous, JCTree.JCErroneous jCErroneous2, int[] nArray) {
        JCTree jCTree = (JCTree)((List)jCErroneous.getErrorTrees()).get(0);
        JCTree jCTree2 = (JCTree)((List)jCErroneous2.getErrorTrees()).get(0);
        if (jCTree.getKind() == Tree.Kind.IDENTIFIER && jCTree2.getKind() == Tree.Kind.IDENTIFIER) {
            this.diffIdent((JCTree.JCIdent)jCTree, (JCTree.JCIdent)jCTree2, nArray);
        }
    }

    protected int diffFieldGroup(FieldGroupTree fieldGroupTree, FieldGroupTree fieldGroupTree2, int[] nArray) {
        if (!this.listsMatch(fieldGroupTree.getVariables(), fieldGroupTree2.getVariables())) {
            this.copyTo(nArray[0], fieldGroupTree.getStartPosition());
            if (fieldGroupTree.isEnum()) {
                int n = this.diffParameterList(fieldGroupTree.getVariables(), fieldGroupTree2.getVariables(), null, fieldGroupTree.getStartPosition(), Measure.ARGUMENT);
                this.copyTo(n, nArray[1]);
                return nArray[1];
            }
            int n = this.diffVarGroup(fieldGroupTree.getVariables(), fieldGroupTree2.getVariables(), null, fieldGroupTree.getStartPosition(), Measure.GROUP_VAR_MEASURE);
            this.copyTo(n, nArray[1]);
            return nArray[1];
        }
        this.tokenSequence.move(fieldGroupTree.endPos());
        PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
        this.tokenSequence.moveNext();
        return this.tokenSequence.offset();
    }

    protected boolean listContains(java.util.List<? extends JCTree> list, JCTree jCTree) {
        for (JCTree jCTree2 : list) {
            if (!this.treesMatch(jCTree2, jCTree)) continue;
            return true;
        }
        return false;
    }

    protected boolean treesMatch(JCTree jCTree, JCTree jCTree2) {
        return this.treesMatch(jCTree, jCTree2, true);
    }

    public boolean treesMatch(JCTree jCTree, JCTree jCTree2, boolean bl) {
        if (jCTree == jCTree2) {
            return true;
        }
        if (jCTree == null || jCTree2 == null) {
            return false;
        }
        if (jCTree.getTag() != jCTree2.getTag()) {
            return false;
        }
        if (!bl) {
            return true;
        }
        switch (jCTree.getTag()) {
            case 1: {
                return ((JCTree.JCCompilationUnit)jCTree).sourcefile.equals(((JCTree.JCCompilationUnit)jCTree2).sourcefile);
            }
            case 2: {
                return this.matchImport((JCTree.JCImport)jCTree, (JCTree.JCImport)jCTree2);
            }
            case 3: {
                return ((JCTree.JCClassDecl)jCTree).sym == ((JCTree.JCClassDecl)jCTree2).sym;
            }
            case 4: {
                return ((JCTree.JCMethodDecl)jCTree).sym == ((JCTree.JCMethodDecl)jCTree2).sym;
            }
            case 5: {
                return ((JCTree.JCVariableDecl)jCTree).sym == ((JCTree.JCVariableDecl)jCTree2).sym;
            }
            case 6: {
                return true;
            }
            case 7: {
                return this.matchBlock((JCTree.JCBlock)jCTree, (JCTree.JCBlock)jCTree2);
            }
            case 8: {
                return this.matchDoLoop((JCTree.JCDoWhileLoop)jCTree, (JCTree.JCDoWhileLoop)jCTree2);
            }
            case 9: {
                return this.matchWhileLoop((JCTree.JCWhileLoop)jCTree, (JCTree.JCWhileLoop)jCTree2);
            }
            case 10: {
                return this.matchForLoop((JCTree.JCForLoop)jCTree, (JCTree.JCForLoop)jCTree2);
            }
            case 11: {
                return this.matchForeachLoop((JCTree.JCEnhancedForLoop)jCTree, (JCTree.JCEnhancedForLoop)jCTree2);
            }
            case 12: {
                return this.matchLabelled((JCTree.JCLabeledStatement)jCTree, (JCTree.JCLabeledStatement)jCTree2);
            }
            case 13: {
                return this.matchSwitch((JCTree.JCSwitch)jCTree, (JCTree.JCSwitch)jCTree2);
            }
            case 14: {
                return this.matchCase((JCTree.JCCase)jCTree, (JCTree.JCCase)jCTree2);
            }
            case 15: {
                return this.matchSynchronized((JCTree.JCSynchronized)jCTree, (JCTree.JCSynchronized)jCTree2);
            }
            case 16: {
                return this.matchTry((JCTree.JCTry)jCTree, (JCTree.JCTry)jCTree2);
            }
            case 17: {
                return this.matchCatch((JCTree.JCCatch)jCTree, (JCTree.JCCatch)jCTree2);
            }
            case 18: {
                return this.matchConditional((JCTree.JCConditional)jCTree, (JCTree.JCConditional)jCTree2);
            }
            case 19: {
                return this.matchIf((JCTree.JCIf)jCTree, (JCTree.JCIf)jCTree2);
            }
            case 20: {
                return this.treesMatch(((JCTree.JCExpressionStatement)jCTree).expr, ((JCTree.JCExpressionStatement)jCTree2).expr);
            }
            case 21: {
                return this.matchBreak((JCTree.JCBreak)jCTree, (JCTree.JCBreak)jCTree2);
            }
            case 22: {
                return this.matchContinue((JCTree.JCContinue)jCTree, (JCTree.JCContinue)jCTree2);
            }
            case 23: {
                return this.treesMatch(((JCTree.JCReturn)jCTree).expr, ((JCTree.JCReturn)jCTree2).expr);
            }
            case 24: {
                return this.treesMatch(((JCTree.JCThrow)jCTree).expr, ((JCTree.JCThrow)jCTree2).expr);
            }
            case 25: {
                return this.matchAssert((JCTree.JCAssert)jCTree, (JCTree.JCAssert)jCTree2);
            }
            case 26: {
                return this.matchApply((JCTree.JCMethodInvocation)jCTree, (JCTree.JCMethodInvocation)jCTree2);
            }
            case 27: {
                if (((JCTree.JCNewClass)jCTree2).def != null) {
                    ((JCTree.JCNewClass)jCTree2).def.sym = null;
                }
                return this.matchNewClass((JCTree.JCNewClass)jCTree, (JCTree.JCNewClass)jCTree2);
            }
            case 28: {
                return this.matchNewArray((JCTree.JCNewArray)jCTree, (JCTree.JCNewArray)jCTree2);
            }
            case 29: {
                return this.treesMatch(((JCTree.JCParens)jCTree).expr, ((JCTree.JCParens)jCTree2).expr);
            }
            case 30: {
                return this.matchAssign((JCTree.JCAssign)jCTree, (JCTree.JCAssign)jCTree2);
            }
            case 31: {
                return this.matchTypeCast((JCTree.JCTypeCast)jCTree, (JCTree.JCTypeCast)jCTree2);
            }
            case 32: {
                return this.matchTypeTest((JCTree.JCInstanceOf)jCTree, (JCTree.JCInstanceOf)jCTree2);
            }
            case 33: {
                return this.matchIndexed((JCTree.JCArrayAccess)jCTree, (JCTree.JCArrayAccess)jCTree2);
            }
            case 34: {
                return this.matchSelect((JCTree.JCFieldAccess)jCTree, (JCTree.JCFieldAccess)jCTree2);
            }
            case 35: {
                return ((JCTree.JCIdent)jCTree).getName().contentEquals(((JCTree.JCIdent)jCTree2).getName());
            }
            case 36: {
                return this.matchLiteral((JCTree.JCLiteral)jCTree, (JCTree.JCLiteral)jCTree2);
            }
            case 37: {
                return ((JCTree.JCPrimitiveTypeTree)jCTree).typetag == ((JCTree.JCPrimitiveTypeTree)jCTree2).typetag;
            }
            case 38: {
                return this.treesMatch(((JCTree.JCArrayTypeTree)jCTree).elemtype, ((JCTree.JCArrayTypeTree)jCTree2).elemtype);
            }
            case 39: {
                return this.matchTypeApply((JCTree.JCTypeApply)jCTree, (JCTree.JCTypeApply)jCTree2);
            }
            case 40: {
                return this.matchTypeParameter((JCTree.JCTypeParameter)jCTree, (JCTree.JCTypeParameter)jCTree2);
            }
            case 41: {
                return this.matchWildcard((JCTree.JCWildcard)jCTree, (JCTree.JCWildcard)jCTree2);
            }
            case 42: {
                return ((JCTree.TypeBoundKind)jCTree).kind == ((JCTree.TypeBoundKind)jCTree2).kind;
            }
            case 43: {
                return this.matchAnnotation((JCTree.JCAnnotation)jCTree, (JCTree.JCAnnotation)jCTree2);
            }
            case 91: {
                return this.matchLetExpr((JCTree.LetExpr)jCTree, (JCTree.LetExpr)jCTree2);
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return this.matchUnary((JCTree.JCUnary)jCTree, (JCTree.JCUnary)jCTree2);
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                return this.matchBinary((JCTree.JCBinary)jCTree, (JCTree.JCBinary)jCTree2);
            }
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return this.matchAssignop((JCTree.JCAssignOp)jCTree, (JCTree.JCAssignOp)jCTree2);
            }
        }
        String string = jCTree.getKind().toString() + " " + jCTree.getClass().getName();
        throw new AssertionError((Object)string);
    }

    protected boolean nameChanged(Name name, Name name2) {
        byte[] byArray;
        if (name == name2) {
            return false;
        }
        if (name == null || name2 == null) {
            return true;
        }
        byte[] byArray2 = name.toUtf();
        int n = byArray2.length;
        if (n != (byArray = name2.toUtf()).length) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            if (byArray2[i] == byArray[i]) continue;
            return true;
        }
        return false;
    }

    protected int diffList2(java.util.List<? extends JCTree> list, java.util.List<? extends JCTree> list2, int n, PositionEstimator positionEstimator) {
        if (list == list2) {
            return n;
        }
        assert (list != null && list2 != null);
        int n2 = n;
        ListMatcher<? extends JCTree> listMatcher = ListMatcher.instance(list, list2);
        if (!listMatcher.match()) {
            return n;
        }
        Iterator<? extends JCTree> iterator = list.iterator();
        ListMatcher.ResultItem<? extends JCTree>[] resultItemArray = listMatcher.getTransformedResult();
        ListMatcher.Separator separator = listMatcher.separatorInstance();
        separator.compute();
        int[][] nArray = positionEstimator.getMatrix();
        int n3 = n;
        int n4 = 0;
        boolean bl = true;
        block6: for (int i = 0; i < resultItemArray.length; ++i) {
            ListMatcher.ResultItem<? extends JCTree> resultItem = resultItemArray[i];
            switch (resultItem.operation) {
                case MODIFY: {
                    this.tokenSequence.moveIndex(nArray[n4][4]);
                    if (this.tokenSequence.moveNext()) {
                        n3 = this.tokenSequence.offset();
                        if (JavaTokenId.COMMA == this.tokenSequence.token().id()) {
                            n3 += JavaTokenId.COMMA.fixedText().length();
                        }
                    }
                    JCTree jCTree = iterator.next();
                    ++n4;
                    if (!bl) {
                        this.copyTo(n2, CasualDiff.getOldPos(jCTree));
                    }
                    if (this.treesMatch(jCTree, (JCTree)resultItem.element, false)) {
                        n2 = this.diffTree(jCTree, (JCTree)resultItem.element, this.getBounds(jCTree));
                    } else {
                        this.printer.print((JCTree)resultItem.element);
                        n2 = Math.max(n3, this.endPos(jCTree));
                    }
                    bl = false;
                    continue block6;
                }
                case INSERT: {
                    String string;
                    String string2 = separator.head(i) ? positionEstimator.head() : (separator.prev(i) ? positionEstimator.sep() : null);
                    String string3 = string = separator.next(i) ? positionEstimator.sep() : null;
                    if (positionEstimator.getIndentString() != null && !positionEstimator.getIndentString().equals(" ")) {
                        string2 = string2 + positionEstimator.getIndentString();
                    }
                    this.copyTo(n2, n3);
                    this.printer.print(string2);
                    this.printer.print((JCTree)resultItem.element);
                    this.printer.print(string);
                    bl = false;
                    continue block6;
                }
                case DELETE: {
                    int n5 = 0;
                    if (n4 == 0 && nArray[n4 + 1][2] != -1 && nArray[n4 + 1][2] == nArray[n4 + 1][3]) {
                        ++n5;
                    }
                    int n6 = this.toOff(separator.head(i) || separator.prev(i) ? nArray[n4][1] : nArray[n4][2 + n5]);
                    int n7 = this.toOff(separator.tail(i) || separator.next(i) ? nArray[n4 + 1][2] : nArray[n4][4]);
                    assert (n6 != -1 && n7 != -1) : "Invalid offset!";
                    this.tokenSequence.moveIndex(nArray[n4][4]);
                    if (this.tokenSequence.moveNext()) {
                        n3 = this.tokenSequence.offset();
                        if (JavaTokenId.COMMA == this.tokenSequence.token().id()) {
                            n3 += JavaTokenId.COMMA.fixedText().length();
                        }
                    }
                    n2 = n4 == 0 && !list2.isEmpty() ? n7 : this.endPos((JCTree)resultItem.element);
                    JCTree jCTree = iterator.next();
                    ++n4;
                    continue block6;
                }
                case NOCHANGE: {
                    this.tokenSequence.moveIndex(nArray[n4][4]);
                    if (this.tokenSequence.moveNext()) {
                        n3 = this.tokenSequence.offset();
                        if (JavaTokenId.COMMA == this.tokenSequence.token().id()) {
                            n3 += JavaTokenId.COMMA.fixedText().length();
                        }
                    }
                    JCTree jCTree = iterator.next();
                    ++n4;
                    int n8 = n2;
                    n2 = this.endPos(jCTree);
                    this.copyTo(n8, n2);
                    bl = false;
                }
            }
        }
        return n2;
    }

    private int printBreakContinueTree(int[] nArray, Name name, Name name2, JCTree.JCStatement jCStatement) {
        String string;
        int n = nArray[0];
        String string2 = string = jCStatement.getKind() == Tree.Kind.BREAK ? "break" : "continue";
        if (this.nameChanged(name, name2)) {
            int n2 = n;
            n = CasualDiff.getOldPos(jCStatement);
            this.copyTo(n2, n);
            this.printer.print(string);
            n += string.length();
            if (name != null && name.length() > 0) {
                ++n;
            }
            if (name2 != null && name2.length() > 0) {
                this.printer.print(" ");
                this.printer.print(name2);
            }
            if (name != null) {
                n += name.length();
            }
        }
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    private int toOff(int n) {
        if (n == -1) {
            return -1;
        }
        this.tokenSequence.moveIndex(n);
        this.tokenSequence.moveNext();
        return this.tokenSequence.offset();
    }

    private int diffParameterList(java.util.List<? extends JCTree> list, java.util.List<? extends JCTree> list2, JavaTokenId[] javaTokenIdArray, int n, Comparator<JCTree> comparator) {
        int n2;
        boolean bl;
        assert (list != null && list2 != null);
        if (list == list2 || ((Object)list).equals(list2)) {
            return n;
        }
        boolean bl2 = bl = javaTokenIdArray != null && javaTokenIdArray.length != 0;
        if (list2.isEmpty()) {
            int n3 = this.endPos(list);
            if (bl) {
                this.tokenSequence.move(n3);
                PositionEstimator.moveFwdToToken(this.tokenSequence, n3, javaTokenIdArray[1]);
                this.tokenSequence.moveNext();
                n3 = this.tokenSequence.offset();
                if (!PositionEstimator.nonRelevant.contains(this.tokenSequence.token())) {
                    this.printer.print(" ");
                }
            }
            return n3;
        }
        ListMatcher<JCTree> listMatcher = ListMatcher.instance(list, list2, comparator);
        if (!listMatcher.match()) {
            return n;
        }
        ListMatcher.ResultItem[] resultItemArray = listMatcher.getResult();
        if (bl && list.isEmpty()) {
            this.printer.print(javaTokenIdArray[0].fixedText());
        }
        int n4 = 0;
        boolean bl3 = false;
        for (n2 = 0; n2 < resultItemArray.length; ++n2) {
            ListMatcher.ResultItem<JCTree> resultItem = resultItemArray[n2];
            switch (resultItem.operation) {
                case MODIFY: {
                    Object object = list.get(n4++);
                    int[] nArray = this.getBounds((JCTree)object);
                    this.tokenSequence.move(nArray[0]);
                    if (n4 != 1) {
                        PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                    }
                    this.tokenSequence.moveNext();
                    int n5 = this.tokenSequence.offset();
                    this.copyTo(n5, nArray[0], this.printer);
                    this.diffTree((JCTree)object, (JCTree)resultItem.element, nArray);
                    this.tokenSequence.move(nArray[1]);
                    PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                    if (!this.commaNeeded(resultItemArray, resultItem) && object.getKind() == Tree.Kind.VARIABLE && (((JCTree.JCModifiers)((VariableTree)object).getModifiers()).flags & 0x4000L) != 0L && this.tokenSequence.token().id() != JavaTokenId.SEMICOLON) {
                        this.printer.print(";");
                    }
                    n = this.tokenSequence.offset();
                    this.copyTo(nArray[1], n, this.printer);
                    break;
                }
                case INSERT: {
                    if (bl3 && VeryPretty.getCodeStyle(this.workingCopy).spaceAfterComma()) {
                        this.printer.print(" ");
                    }
                    this.printer.print((JCTree)resultItem.element);
                    break;
                }
                case DELETE: {
                    ++n4;
                    this.tokenSequence.move(this.getBounds((JCTree)resultItem.element)[1]);
                    PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                    n = this.tokenSequence.offset();
                    break;
                }
                case NOCHANGE: {
                    int n5;
                    Object object = this.getBounds((JCTree)resultItem.element);
                    this.tokenSequence.move((int)object[0]);
                    if (++n4 != 1) {
                        PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                    }
                    this.tokenSequence.moveNext();
                    int n6 = this.tokenSequence.offset();
                    this.tokenSequence.move((int)object[1]);
                    PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                    n = n5 = this.tokenSequence.offset();
                    this.copyTo(n6, n, this.printer);
                    break;
                }
            }
            if (this.commaNeeded(resultItemArray, resultItem)) {
                this.printer.print(",");
                bl3 = true;
                continue;
            }
            if (resultItem.operation == ListMatcher.Operation.DELETE) continue;
            bl3 = false;
        }
        if (bl && list.isEmpty()) {
            this.printer.print(javaTokenIdArray[1].fixedText());
        }
        if (list.isEmpty()) {
            return n;
        }
        n2 = this.endPos(list);
        this.tokenSequence.move(n2);
        PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
        return this.tokenSequence.offset();
    }

    private int diffVarGroup(java.util.List<? extends JCTree> list, java.util.List<? extends JCTree> list2, JavaTokenId[] javaTokenIdArray, int object, Comparator<JCTree> comparator) {
        boolean bl;
        assert (list != null && list2 != null);
        if (list == list2 || ((Object)list).equals(list2)) {
            return object;
        }
        boolean bl2 = bl = javaTokenIdArray != null && javaTokenIdArray.length != 0;
        if (list2.isEmpty()) {
            int n = this.endPos(list);
            if (bl) {
                this.tokenSequence.move(n);
                PositionEstimator.moveFwdToToken(this.tokenSequence, n, javaTokenIdArray[1]);
                this.tokenSequence.moveNext();
                n = this.tokenSequence.offset();
                if (!PositionEstimator.nonRelevant.contains(this.tokenSequence.token())) {
                    this.printer.print(" ");
                }
            }
            return n;
        }
        ListMatcher<JCTree> listMatcher = ListMatcher.instance(list, list2, comparator);
        if (!listMatcher.match()) {
            return object;
        }
        ListMatcher.ResultItem[] resultItemArray = listMatcher.getResult();
        if (bl && list.isEmpty()) {
            this.printer.print(javaTokenIdArray[0].fixedText());
        }
        int n = 0;
        for (int i = 0; i < resultItemArray.length; ++i) {
            ListMatcher.ResultItem<JCTree> resultItem = resultItemArray[i];
            switch (resultItem.operation) {
                case MODIFY: {
                    Object object2 = list.get(n++);
                    int[] nArray = this.getBounds((JCTree)object2);
                    if (n != 1) {
                        nArray[0] = ((JCTree)object2).pos;
                    }
                    this.tokenSequence.move(nArray[1]);
                    this.tokenSequence.movePrevious();
                    if (this.tokenSequence.token().id() == JavaTokenId.COMMA || this.tokenSequence.token().id() == JavaTokenId.SEMICOLON) {
                        nArray[1] = this.tokenSequence.offset();
                    }
                    this.tokenSequence.move(nArray[0]);
                    if (n != 1) {
                        PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                    }
                    this.tokenSequence.moveNext();
                    Object object3 = this.tokenSequence.offset();
                    this.copyTo((int)object3, nArray[0], this.printer);
                    int n2 = n != 1 ? this.diffVarDef((JCTree.JCVariableDecl)object2, (JCTree.JCVariableDecl)resultItem.element, nArray[0]) : this.diffVarDef((JCTree.JCVariableDecl)object2, (JCTree.JCVariableDecl)resultItem.element, nArray);
                    object = nArray[1];
                    this.copyTo(n2, (int)object, this.printer);
                    break;
                }
                case INSERT: {
                    Object object2 = (JCTree.JCVariableDecl)resultItem.element;
                    if (n == 0) {
                        int n3 = this.printer.setPrec(0);
                        this.printer.visitVarDef((JCTree.JCVariableDecl)object2);
                        this.printer.setPrec(n3);
                        break;
                    }
                    if (VeryPretty.getCodeStyle(this.workingCopy).spaceAfterComma()) {
                        this.printer.print(" ");
                    }
                    this.printer.print(((JCTree.JCVariableDecl)object2).name);
                    this.printer.printVarInit((JCTree.JCVariableDecl)object2);
                    break;
                }
                case NOCHANGE: {
                    Object object2 = this.getBounds((JCTree)resultItem.element);
                    if (++n != 1) {
                        object2[0] = ((JCTree)resultItem.element).pos;
                    }
                    this.tokenSequence.move((int)object2[0]);
                    if (n != 1) {
                        PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                    }
                    this.tokenSequence.moveNext();
                    int n4 = this.tokenSequence.offset();
                    Object object3 = object2[1];
                    this.tokenSequence.move((int)object3);
                    this.tokenSequence.movePrevious();
                    if (this.tokenSequence.token().id() == JavaTokenId.COMMA || this.tokenSequence.token().id() == JavaTokenId.SEMICOLON) {
                        object3 = this.tokenSequence.offset();
                    }
                    Object object4 = object3;
                    object = object4;
                    this.copyTo(n4, (int)object4, this.printer);
                    break;
                }
                case DELETE: {
                    ++n;
                    Object object2 = this.getBounds((JCTree)resultItem.element);
                    this.tokenSequence.move((int)object2[1]);
                    this.tokenSequence.movePrevious();
                    if (this.tokenSequence.token().id() == JavaTokenId.COMMA || this.tokenSequence.token().id() == JavaTokenId.SEMICOLON) {
                        object2[1] = this.tokenSequence.offset();
                    }
                    object = object2[1];
                    break;
                }
            }
            if (!this.commaNeeded(resultItemArray, resultItem)) continue;
            this.printer.print(",");
        }
        if (bl && list.isEmpty()) {
            this.printer.print(javaTokenIdArray[1].fixedText());
        }
        return object;
    }

    private boolean commaNeeded(ListMatcher.ResultItem[] resultItemArray, ListMatcher.ResultItem resultItem) {
        if (resultItem.operation == ListMatcher.Operation.DELETE) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < resultItemArray.length; ++i) {
            if (resultItem == resultItemArray[i]) {
                bl = true;
                continue;
            }
            if (!bl || resultItemArray[i].operation == ListMatcher.Operation.DELETE) continue;
            return true;
        }
        return false;
    }

    private java.util.List<JCTree> filterHidden(java.util.List<? extends JCTree> list) {
        ArrayList<JCTree> arrayList = new ArrayList<JCTree>();
        ArrayList<JCTree.JCVariableDecl> arrayList2 = new ArrayList<JCTree.JCVariableDecl>();
        boolean bl = false;
        for (JCTree jCTree : list) {
            JCTree.JCStatement jCStatement;
            if (Tree.Kind.VARIABLE == jCTree.getKind()) {
                jCStatement = (JCTree.JCVariableDecl)jCTree;
                if ((((JCTree.JCVariableDecl)jCStatement).mods.flags & 0x4000L) != 0L) {
                    arrayList2.add((JCTree.JCVariableDecl)jCStatement);
                    bl = true;
                    continue;
                }
                if (!arrayList2.isEmpty()) {
                    int n = CasualDiff.getOldPos((JCTree)arrayList2.get(0));
                    if (n != -1 && n != -2 && n == CasualDiff.getOldPos(jCStatement) && ((JCTree.JCVariableDecl)arrayList2.get(0)).getModifiers() == ((JCTree.JCVariableDecl)jCStatement).getModifiers()) {
                        arrayList2.add((JCTree.JCVariableDecl)jCStatement);
                        continue;
                    }
                    if (arrayList2.size() > 1) {
                        arrayList.add(new FieldGroupTree(arrayList2, bl));
                    } else {
                        arrayList.add((JCTree)arrayList2.get(0));
                    }
                    arrayList2 = new ArrayList();
                    bl = false;
                    arrayList2.add((JCTree.JCVariableDecl)jCStatement);
                    continue;
                }
                arrayList2.add((JCTree.JCVariableDecl)jCStatement);
                continue;
            }
            if (!arrayList2.isEmpty()) {
                if (arrayList2.size() > 1) {
                    arrayList.add(new FieldGroupTree(arrayList2, bl));
                } else {
                    arrayList.add((JCTree)arrayList2.get(0));
                }
                arrayList2 = new ArrayList();
                bl = false;
            }
            if (Tree.Kind.METHOD == jCTree.getKind()) {
                if ((((JCTree.JCMethodDecl)jCTree).mods.flags & 0x1000000000L) != 0L) {
                    continue;
                }
            } else if (Tree.Kind.BLOCK == jCTree.getKind()) {
                jCStatement = (JCTree.JCBlock)jCTree;
                if (((JCTree.JCBlock)jCStatement).stats.isEmpty() && ((JCTree.JCBlock)jCStatement).pos == -1 && ((JCTree.JCBlock)jCStatement).flags == 0L) continue;
            }
            arrayList.add(jCTree);
        }
        if (!arrayList2.isEmpty()) {
            if (arrayList2.size() > 1) {
                arrayList.add(new FieldGroupTree(arrayList2, bl));
            } else {
                arrayList.add((JCTree)arrayList2.get(0));
            }
        }
        return arrayList;
    }

    private int diffList(java.util.List<? extends JCTree> list, java.util.List<? extends JCTree> list2, int n, PositionEstimator positionEstimator, Comparator<JCTree> comparator, VeryPretty veryPretty) {
        if (list == list2 || ((Object)list).equals(list2)) {
            return n;
        }
        assert (list != null && list2 != null);
        ListMatcher<JCTree> listMatcher = ListMatcher.instance(list, list2, comparator);
        if (!listMatcher.match()) {
            return n;
        }
        JCTree jCTree = null;
        ListMatcher.ResultItem<JCTree>[] resultItemArray = listMatcher.getResult();
        if (list.isEmpty() && !list2.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            int n2 = positionEstimator.prepare(n, stringBuilder, stringBuilder2);
            this.copyTo(n, n2, veryPretty);
            if (list2.get(0).getKind() == Tree.Kind.IMPORT) {
                veryPretty.printImportsBlock(list2);
            } else {
                veryPretty.print(stringBuilder.toString());
                for (JCTree jCTree2 : list2) {
                    if (LineInsertionType.BEFORE == positionEstimator.lineInsertType()) {
                        veryPretty.newline();
                    }
                    veryPretty.print(jCTree2);
                    if (LineInsertionType.AFTER != positionEstimator.lineInsertType()) continue;
                    veryPretty.newline();
                }
                veryPretty.print(stringBuilder2.toString());
            }
            return n2;
        }
        if (list2.isEmpty() && !list.isEmpty()) {
            int[] nArray = positionEstimator.sectionRemovalBounds(null);
            this.copyTo(n, nArray[0]);
            return nArray[1];
        }
        int n3 = 0;
        int n4 = positionEstimator.getInsertPos(0);
        if (n4 > n) {
            int n2 = n;
            n = positionEstimator.getInsertPos(0);
            this.copyTo(n2, n, veryPretty);
        } else {
            n4 = n;
        }
        block7: for (int i = 0; i < resultItemArray.length; ++i) {
            ListMatcher.ResultItem<JCTree> resultItem = resultItemArray[i];
            switch (resultItem.operation) {
                case MODIFY: {
                    int[] nArray = positionEstimator.getPositions(n3);
                    this.copyTo(n, nArray[0], veryPretty);
                    n = this.diffTree(list.get(n3), (JCTree)resultItem.element, nArray);
                    ++n3;
                    continue block7;
                }
                case INSERT: {
                    Object object;
                    int n5;
                    int n7 = positionEstimator.getInsertPos(n3);
                    if (n7 > n) {
                        this.tokenSequence.move(n7);
                        PositionEstimator.moveToDifferentThan(this.tokenSequence, PositionEstimator.Direction.BACKWARD, EnumSet.of(JavaTokenId.WHITESPACE));
                        this.tokenSequence.moveNext();
                        int nArray = this.tokenSequence.offset();
                        if (nArray > n) {
                            int n6 = n;
                            n = nArray;
                            this.copyTo(n6, n);
                        }
                    }
                    int commentSet = ((JCTree)resultItem.element).getKind() != Tree.Kind.VARIABLE ? CasualDiff.getOldPos((JCTree)resultItem.element) : ((JCTree)resultItem.element).pos;
                    boolean bl = false;
                    if (commentSet > 0) {
                        for (JCTree n13 : list) {
                            n5 = n13.getKind() != Tree.Kind.VARIABLE ? CasualDiff.getOldPos(n13) : n13.pos;
                            if (commentSet != n5) continue;
                            bl = true;
                            object = this.printer;
                            int n8 = ((VeryPretty)object).indent();
                            this.printer = new VeryPretty(this.workingCopy, VeryPretty.getCodeStyle(this.workingCopy), this.tree2Tag, this.tag2Span, this.origText, ((VeryPretty)object).toString().length() + ((VeryPretty)object).getInitialOffset());
                            this.printer.reset(n8);
                            int n9 = list.indexOf(n13);
                            int[] nArray = positionEstimator.getPositions(n9);
                            int n10 = this.diffTree(n13, (JCTree)resultItem.element, nArray);
                            this.copyTo(n10, nArray[1]);
                            veryPretty.print(this.printer.toString());
                            this.printer = object;
                            this.printer.undent(n8);
                            break;
                        }
                    }
                    if (bl) continue block7;
                    if (jCTree != null && this.treesMatch((JCTree)resultItem.element, jCTree, false)) {
                        VeryPretty veryPretty2 = this.printer;
                        int n11 = veryPretty2.indent();
                        this.printer = new VeryPretty(this.workingCopy, VeryPretty.getCodeStyle(this.workingCopy), this.tree2Tag, this.tag2Span, this.origText, veryPretty2.toString().length() + veryPretty2.getInitialOffset());
                        this.printer.reset(n11);
                        n5 = list.indexOf(jCTree);
                        object = positionEstimator.getPositions(n5);
                        n = this.diffTree(jCTree, (JCTree)resultItem.element, (int[])object);
                        veryPretty.print(this.printer.toString());
                        this.printer = veryPretty2;
                        this.printer.undent(n11);
                        jCTree = null;
                        continue block7;
                    }
                    if (LineInsertionType.BEFORE == positionEstimator.lineInsertType()) {
                        veryPretty.newline();
                    }
                    veryPretty.print((JCTree)resultItem.element);
                    if (LineInsertionType.AFTER != positionEstimator.lineInsertType()) continue block7;
                    veryPretty.newline();
                    continue block7;
                }
                case DELETE: {
                    int[] nArray = positionEstimator.getPositions(n3);
                    if (n < nArray[0]) {
                        this.copyTo(n, nArray[0], veryPretty);
                    }
                    jCTree = list.get(n3);
                    ++n3;
                    CommentSet commentSet = this.comments.getComments(jCTree);
                    n = Math.max(nArray[1], Math.max(this.commentEnd(commentSet, CommentSet.RelativePosition.INLINE), this.commentEnd(commentSet, CommentSet.RelativePosition.TRAILING)));
                    continue block7;
                }
                case NOCHANGE: {
                    int[] nArray = positionEstimator.getPositions(n3);
                    if (nArray[0] > n && n3 != 0) {
                        this.copyTo(n, nArray[0], veryPretty);
                    }
                    n = nArray[0];
                    if (nArray.length > 3 && nArray[3] != -1 && i + 1 < resultItemArray.length) {
                        int n12 = n;
                        n = nArray[3];
                        this.copyTo(n12, n, veryPretty);
                        veryPretty.print(positionEstimator.append(n3));
                    }
                    int n13 = n;
                    n = nArray[1];
                    this.copyTo(n13, n, veryPretty);
                    jCTree = null;
                    ++n3;
                    continue block7;
                }
            }
        }
        return n;
    }

    protected int diffPrecedingComments(JCTree jCTree, JCTree jCTree2, int n) {
        java.util.List<Comment> list;
        CommentSet commentSet = this.comments.getComments(jCTree2);
        CommentSet commentSet2 = this.comments.getComments(jCTree);
        java.util.List<Comment> list2 = commentSet2.getComments(CommentSet.RelativePosition.PRECEDING);
        if (this.sameComments(list2, list = commentSet.getComments(CommentSet.RelativePosition.PRECEDING))) {
            return n;
        }
        return this.diffCommentLists(jCTree, jCTree2, list2, list, false, n);
    }

    protected int diffTrailingComments(JCTree jCTree, JCTree jCTree2, int n) {
        CommentSet commentSet = this.comments.getComments(jCTree2);
        CommentSet commentSet2 = this.comments.getComments(jCTree);
        java.util.List<Comment> list = commentSet2.getComments(CommentSet.RelativePosition.INLINE);
        java.util.List<Comment> list2 = commentSet.getComments(CommentSet.RelativePosition.INLINE);
        java.util.List<Comment> list3 = commentSet2.getComments(CommentSet.RelativePosition.TRAILING);
        java.util.List<Comment> list4 = commentSet.getComments(CommentSet.RelativePosition.TRAILING);
        if (this.sameComments(list, list2) && this.sameComments(list3, list4)) {
            return n;
        }
        n = this.diffCommentLists(jCTree, jCTree2, list, list2, false, n);
        boolean bl = false;
        boolean bl2 = false;
        for (Comment comment : list) {
            if (comment.style() != Comment.Style.LINE) continue;
            bl = true;
        }
        for (Comment comment : list2) {
            if (comment.style() != Comment.Style.LINE) continue;
            bl2 = true;
        }
        if (bl && !bl2) {
            this.printer.print("\n");
        }
        return this.diffCommentLists(jCTree, jCTree2, list3, list4, true, n);
    }

    private boolean sameComments(java.util.List<Comment> list, java.util.List<Comment> list2) {
        Iterator<Comment> iterator = list.iterator();
        Iterator<Comment> iterator2 = list2.iterator();
        Comment comment = this.safeNext(iterator);
        Comment comment2 = this.safeNext(iterator2);
        while (comment != null && comment2 != null) {
            comment = this.safeNext(iterator);
            comment2 = this.safeNext(iterator2);
        }
        return !(comment == null ^ comment2 == null);
    }

    private int diffCommentLists(JCTree jCTree, JCTree jCTree2, java.util.List<Comment> list, java.util.List<Comment> list2, boolean bl, int n) {
        int n2;
        int n3 = CasualDiff.getOldPos(jCTree);
        Iterator<Comment> iterator = list.iterator();
        Iterator<Comment> iterator2 = list2.iterator();
        Comment comment = this.safeNext(iterator);
        Comment comment2 = this.safeNext(iterator2);
        boolean bl2 = true;
        while (comment != null && comment2 != null) {
            n3 = comment.pos();
            n2 = this.commentStartCorrect(comment);
            if (bl2 && bl && n < n2) {
                this.copyTo(n, n2);
            }
            bl2 = false;
            n = Math.max(n, comment.endPos());
            if (this.commentsMatch(comment, comment2)) {
                comment = this.safeNext(iterator);
                comment2 = this.safeNext(iterator2);
                continue;
            }
            if (!this.listContains(list2, comment)) {
                if (!this.listContains(list, comment2)) {
                    comment = this.safeNext(iterator);
                    comment2 = this.safeNext(iterator2);
                    continue;
                }
                comment = this.safeNext(iterator);
                continue;
            }
            this.printer.print(comment2.getText());
            comment2 = this.safeNext(iterator2);
        }
        while (comment != null) {
            n2 = this.commentStartCorrect(comment);
            if (bl2 && bl && n < n2) {
                this.copyTo(n, n2);
            }
            bl2 = false;
            n = Math.max(n, comment.endPos());
            comment = this.safeNext(iterator);
        }
        while (comment2 != null) {
            if (Comment.Style.WHITESPACE != comment2.style()) {
                this.printer.printComment(comment2, !bl, false);
                n3 += comment2.endPos() - comment2.pos();
            }
            comment2 = this.safeNext(iterator);
        }
        return n;
    }

    private Comment safeNext(Iterator<Comment> iterator) {
        return iterator.hasNext() ? iterator.next() : null;
    }

    private boolean commentsMatch(Comment comment, Comment comment2) {
        if (comment == null && comment2 == null) {
            return true;
        }
        if (comment == null || comment2 == null) {
            return false;
        }
        return comment.equals(comment2);
    }

    private boolean listContains(java.util.List<Comment> list, Comment comment) {
        for (Comment comment2 : list) {
            if (!comment2.equals(comment)) continue;
            return true;
        }
        return false;
    }

    private int commentStartCorrect(Comment comment) {
        this.tokenSequence.move(comment.pos());
        boolean bl = false;
        while (this.tokenSequence.movePrevious()) {
            if (this.tokenSequence.token().id() != JavaTokenId.WHITESPACE) {
                return this.tokenSequence.offset() + this.tokenSequence.token().length();
            }
            int n = ((Object)this.tokenSequence.token().text()).toString().lastIndexOf(10);
            if (n != -1) {
                return this.tokenSequence.offset() + n + 1;
            }
            bl = true;
        }
        if (bl) {
            return this.tokenSequence.offset();
        }
        return comment.pos();
    }

    private int commentStart(CommentSet commentSet, CommentSet.RelativePosition relativePosition) {
        java.util.List<Comment> list = commentSet.getComments(relativePosition);
        if (list.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        return list.get(0).pos();
    }

    private int commentEnd(CommentSet commentSet, CommentSet.RelativePosition relativePosition) {
        java.util.List<Comment> list = commentSet.getComments(relativePosition);
        if (list.isEmpty()) {
            return -1;
        }
        return list.get(list.size() - 1).endPos();
    }

    private static JCTree leftMostTree(JCTree jCTree) {
        switch (jCTree.getTag()) {
            case 26: {
                return CasualDiff.leftMostTree(((JCTree.JCMethodInvocation)jCTree).meth);
            }
            case 30: {
                return CasualDiff.leftMostTree(((JCTree.JCAssign)jCTree).lhs);
            }
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return CasualDiff.leftMostTree(((JCTree.JCAssignOp)jCTree).lhs);
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                return CasualDiff.leftMostTree(((JCTree.JCBinary)jCTree).lhs);
            }
            case 3: {
                JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)jCTree;
                if (jCClassDecl.mods.pos == -1) break;
                return jCClassDecl.mods;
            }
            case 18: {
                return CasualDiff.leftMostTree(((JCTree.JCConditional)jCTree).cond);
            }
            case 20: {
                return CasualDiff.leftMostTree(((JCTree.JCExpressionStatement)jCTree).expr);
            }
            case 33: {
                return CasualDiff.leftMostTree(((JCTree.JCArrayAccess)jCTree).indexed);
            }
            case 4: {
                JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)jCTree;
                if (jCMethodDecl.mods.pos != -1) {
                    return jCMethodDecl.mods;
                }
                if (jCMethodDecl.restype != null) {
                    return CasualDiff.leftMostTree(jCMethodDecl.restype);
                }
                return jCMethodDecl;
            }
            case 34: {
                return CasualDiff.leftMostTree(((JCTree.JCFieldAccess)jCTree).selected);
            }
            case 39: {
                return CasualDiff.leftMostTree(((JCTree.JCTypeApply)jCTree).clazz);
            }
            case 38: {
                return CasualDiff.leftMostTree(((JCTree.JCArrayTypeTree)jCTree).elemtype);
            }
            case 32: {
                return CasualDiff.leftMostTree(((JCTree.JCInstanceOf)jCTree).expr);
            }
            case 52: 
            case 53: {
                return CasualDiff.leftMostTree(((JCTree.JCUnary)jCTree).arg);
            }
            case 5: {
                JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)jCTree;
                if (jCVariableDecl.mods.pos != -1) {
                    return jCVariableDecl.mods;
                }
                return CasualDiff.leftMostTree(jCVariableDecl.vartype);
            }
            case 1: {
                JCTree.JCCompilationUnit jCCompilationUnit = (JCTree.JCCompilationUnit)jCTree;
                assert (jCCompilationUnit.defs.size() > 0);
                return jCCompilationUnit.pid != null ? jCCompilationUnit.pid : (JCTree)jCCompilationUnit.defs.head;
            }
        }
        return jCTree;
    }

    private static int getOldPos(JCTree jCTree) {
        return TreeInfo.getStartPos(jCTree);
    }

    protected int diffTree(JCTree jCTree, JCTree jCTree2, int[] nArray) {
        return this.diffTree(jCTree, jCTree2, null, nArray);
    }

    protected int diffTree(JCTree jCTree, JCTree jCTree2, JCTree jCTree3, int[] nArray) {
        int n;
        Object obj = this.tree2Tag.get(jCTree2);
        if (obj != null) {
            int n2 = this.printer.toString().length();
            n = this.diffTreeImpl(jCTree, jCTree2, jCTree3, nArray);
            int n3 = this.printer.toString().length();
            this.tag2Span.put(obj, new int[]{n2 + this.printer.getInitialOffset(), n3 + this.printer.getInitialOffset()});
        } else {
            n = this.diffTreeImpl(jCTree, jCTree2, jCTree3, nArray);
        }
        return n;
    }

    protected int diffTreeImpl(JCTree jCTree, JCTree jCTree2, JCTree jCTree3, int[] nArray) {
        if (jCTree == null && jCTree2 != null) {
            throw new IllegalArgumentException("Null is not allowed in parameters.");
        }
        if (jCTree == jCTree2) {
            return nArray[0];
        }
        if (jCTree2 == null) {
            this.tokenSequence.move(nArray[1]);
            if (!this.tokenSequence.moveNext()) {
                return nArray[1];
            }
            while (this.tokenSequence.token().id() == JavaTokenId.WHITESPACE && this.tokenSequence.moveNext()) {
            }
            return this.tokenSequence.offset();
        }
        nArray[0] = this.diffPrecedingComments(jCTree, jCTree2, nArray[0]);
        int n = -1;
        if (!(jCTree.getTag() == jCTree2.getTag() || compAssign.contains((Object)jCTree.getKind()) && compAssign.contains((Object)jCTree2.getKind()) || binaries.contains((Object)jCTree.getKind()) && binaries.contains((Object)jCTree2.getKind()) || unaries.contains((Object)jCTree.getKind()) && unaries.contains((Object)jCTree2.getKind()))) {
            int[] nArray2 = this.getBounds(jCTree);
            if (nArray2[0] > nArray[0]) {
                this.copyTo(nArray[0], nArray2[0]);
            }
            this.printer.print(jCTree2);
            return nArray2[1];
        }
        nArray[1] = Math.min(nArray[1], Math.min(this.commentStart(this.comments.getComments(jCTree), CommentSet.RelativePosition.INLINE), this.commentStart(this.comments.getComments(jCTree), CommentSet.RelativePosition.TRAILING)));
        switch (jCTree.getTag()) {
            case 1: {
                this.diffTopLevel((JCTree.JCCompilationUnit)jCTree, (JCTree.JCCompilationUnit)jCTree2);
                break;
            }
            case 2: {
                n = this.diffImport((JCTree.JCImport)jCTree, (JCTree.JCImport)jCTree2, nArray);
                break;
            }
            case 3: {
                n = this.diffClassDef((JCTree.JCClassDecl)jCTree, (JCTree.JCClassDecl)jCTree2, nArray);
                break;
            }
            case 4: {
                n = this.diffMethodDef((JCTree.JCMethodDecl)jCTree, (JCTree.JCMethodDecl)jCTree2, nArray);
                break;
            }
            case 5: {
                n = this.diffVarDef((JCTree.JCVariableDecl)jCTree, (JCTree.JCVariableDecl)jCTree2, nArray);
                break;
            }
            case 6: {
                this.copyTo(nArray[0], nArray[1]);
                n = nArray[1];
                break;
            }
            case 7: {
                n = this.diffBlock((JCTree.JCBlock)jCTree, (JCTree.JCBlock)jCTree2, nArray);
                break;
            }
            case 8: {
                n = this.diffDoLoop((JCTree.JCDoWhileLoop)jCTree, (JCTree.JCDoWhileLoop)jCTree2, nArray);
                break;
            }
            case 9: {
                n = this.diffWhileLoop((JCTree.JCWhileLoop)jCTree, (JCTree.JCWhileLoop)jCTree2, nArray);
                break;
            }
            case 10: {
                n = this.diffForLoop((JCTree.JCForLoop)jCTree, (JCTree.JCForLoop)jCTree2, nArray);
                break;
            }
            case 11: {
                n = this.diffForeachLoop((JCTree.JCEnhancedForLoop)jCTree, (JCTree.JCEnhancedForLoop)jCTree2, nArray);
                break;
            }
            case 12: {
                n = this.diffLabelled((JCTree.JCLabeledStatement)jCTree, (JCTree.JCLabeledStatement)jCTree2, nArray);
                break;
            }
            case 13: {
                n = this.diffSwitch((JCTree.JCSwitch)jCTree, (JCTree.JCSwitch)jCTree2, nArray);
                break;
            }
            case 14: {
                n = this.diffCase((JCTree.JCCase)jCTree, (JCTree.JCCase)jCTree2, nArray);
                break;
            }
            case 15: {
                n = this.diffSynchronized((JCTree.JCSynchronized)jCTree, (JCTree.JCSynchronized)jCTree2, nArray);
                break;
            }
            case 16: {
                n = this.diffTry((JCTree.JCTry)jCTree, (JCTree.JCTry)jCTree2, nArray);
                break;
            }
            case 17: {
                n = this.diffCatch((JCTree.JCCatch)jCTree, (JCTree.JCCatch)jCTree2, nArray);
                break;
            }
            case 18: {
                n = this.diffConditional((JCTree.JCConditional)jCTree, (JCTree.JCConditional)jCTree2, nArray);
                break;
            }
            case 19: {
                n = this.diffIf((JCTree.JCIf)jCTree, (JCTree.JCIf)jCTree2, nArray);
                break;
            }
            case 20: {
                n = this.diffExec((JCTree.JCExpressionStatement)jCTree, (JCTree.JCExpressionStatement)jCTree2, nArray);
                break;
            }
            case 21: {
                n = this.diffBreak((JCTree.JCBreak)jCTree, (JCTree.JCBreak)jCTree2, nArray);
                break;
            }
            case 22: {
                n = this.diffContinue((JCTree.JCContinue)jCTree, (JCTree.JCContinue)jCTree2, nArray);
                break;
            }
            case 23: {
                n = this.diffReturn((JCTree.JCReturn)jCTree, (JCTree.JCReturn)jCTree2, nArray);
                break;
            }
            case 24: {
                n = this.diffThrow((JCTree.JCThrow)jCTree, (JCTree.JCThrow)jCTree2, nArray);
                break;
            }
            case 25: {
                n = this.diffAssert((JCTree.JCAssert)jCTree, (JCTree.JCAssert)jCTree2, nArray);
                break;
            }
            case 26: {
                n = this.diffApply((JCTree.JCMethodInvocation)jCTree, (JCTree.JCMethodInvocation)jCTree2, nArray);
                break;
            }
            case 27: {
                n = this.diffNewClass((JCTree.JCNewClass)jCTree, (JCTree.JCNewClass)jCTree2, nArray);
                break;
            }
            case 28: {
                n = this.diffNewArray((JCTree.JCNewArray)jCTree, (JCTree.JCNewArray)jCTree2, nArray);
                break;
            }
            case 29: {
                n = this.diffParens((JCTree.JCParens)jCTree, (JCTree.JCParens)jCTree2, nArray);
                break;
            }
            case 30: {
                n = this.diffAssign((JCTree.JCAssign)jCTree, (JCTree.JCAssign)jCTree2, nArray);
                break;
            }
            case 31: {
                n = this.diffTypeCast((JCTree.JCTypeCast)jCTree, (JCTree.JCTypeCast)jCTree2, nArray);
                break;
            }
            case 32: {
                n = this.diffTypeTest((JCTree.JCInstanceOf)jCTree, (JCTree.JCInstanceOf)jCTree2, nArray);
                break;
            }
            case 33: {
                n = this.diffIndexed((JCTree.JCArrayAccess)jCTree, (JCTree.JCArrayAccess)jCTree2, nArray);
                break;
            }
            case 34: {
                n = this.diffSelect((JCTree.JCFieldAccess)jCTree, (JCTree.JCFieldAccess)jCTree2, nArray);
                break;
            }
            case 35: {
                n = this.diffIdent((JCTree.JCIdent)jCTree, (JCTree.JCIdent)jCTree2, nArray);
                break;
            }
            case 36: {
                n = this.diffLiteral((JCTree.JCLiteral)jCTree, (JCTree.JCLiteral)jCTree2, nArray);
                break;
            }
            case 37: {
                n = this.diffTypeIdent((JCTree.JCPrimitiveTypeTree)jCTree, (JCTree.JCPrimitiveTypeTree)jCTree2, nArray);
                break;
            }
            case 38: {
                n = this.diffTypeArray((JCTree.JCArrayTypeTree)jCTree, (JCTree.JCArrayTypeTree)jCTree2, nArray);
                break;
            }
            case 39: {
                n = this.diffTypeApply((JCTree.JCTypeApply)jCTree, (JCTree.JCTypeApply)jCTree2, nArray);
                break;
            }
            case 40: {
                n = this.diffTypeParameter((JCTree.JCTypeParameter)jCTree, (JCTree.JCTypeParameter)jCTree2, nArray);
                break;
            }
            case 41: {
                n = this.diffWildcard((JCTree.JCWildcard)jCTree, (JCTree.JCWildcard)jCTree2, nArray);
                break;
            }
            case 42: {
                n = this.diffTypeBoundKind((JCTree.TypeBoundKind)jCTree, (JCTree.TypeBoundKind)jCTree2, nArray);
                break;
            }
            case 43: {
                n = this.diffAnnotation((JCTree.JCAnnotation)jCTree, (JCTree.JCAnnotation)jCTree2, nArray);
                break;
            }
            case 91: {
                this.diffLetExpr((JCTree.LetExpr)jCTree, (JCTree.LetExpr)jCTree2);
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                n = this.diffUnary((JCTree.JCUnary)jCTree, (JCTree.JCUnary)jCTree2, nArray);
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                n = this.diffBinary((JCTree.JCBinary)jCTree, (JCTree.JCBinary)jCTree2, nArray);
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                n = this.diffAssignop((JCTree.JCAssignOp)jCTree, (JCTree.JCAssignOp)jCTree2, nArray);
                break;
            }
            case 45: {
                this.diffErroneous((JCTree.JCErroneous)jCTree, (JCTree.JCErroneous)jCTree2, nArray);
                break;
            }
            case 44: {
                n = this.diffModifiers((JCTree.JCModifiers)jCTree, (JCTree.JCModifiers)jCTree2, jCTree3, nArray[0]);
                this.copyTo(n, nArray[1]);
                break;
            }
            default: {
                if (jCTree.getKind() == Tree.Kind.OTHER) {
                    if (!(jCTree instanceof FieldGroupTree)) break;
                    return this.diffFieldGroup((FieldGroupTree)jCTree, (FieldGroupTree)jCTree2, nArray);
                }
                String string = "Diff not implemented: " + jCTree.getKind().toString() + " " + jCTree.getClass().getName();
                throw new AssertionError((Object)string);
            }
        }
        return this.diffTrailingComments(jCTree, jCTree2, n);
    }

    protected boolean listsMatch(java.util.List<? extends JCTree> list, java.util.List<? extends JCTree> list2) {
        if (list == list2) {
            return true;
        }
        int n = list.size();
        if (list2.size() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.treesMatch(list.get(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean matchImport(JCTree.JCImport jCImport, JCTree.JCImport jCImport2) {
        return jCImport.staticImport == jCImport2.staticImport && this.treesMatch(jCImport.qualid, jCImport2.qualid);
    }

    private boolean matchBlock(JCTree.JCBlock jCBlock, JCTree.JCBlock jCBlock2) {
        return jCBlock.flags == jCBlock2.flags && this.listsMatch(jCBlock.stats, jCBlock2.stats);
    }

    private boolean matchDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop, JCTree.JCDoWhileLoop jCDoWhileLoop2) {
        return this.treesMatch(jCDoWhileLoop.cond, jCDoWhileLoop2.cond) && this.treesMatch(jCDoWhileLoop.body, jCDoWhileLoop2.body);
    }

    private boolean matchWhileLoop(JCTree.JCWhileLoop jCWhileLoop, JCTree.JCWhileLoop jCWhileLoop2) {
        return this.treesMatch(jCWhileLoop.cond, jCWhileLoop2.cond) && this.treesMatch(jCWhileLoop.body, jCWhileLoop2.body);
    }

    private boolean matchForLoop(JCTree.JCForLoop jCForLoop, JCTree.JCForLoop jCForLoop2) {
        return this.listsMatch(jCForLoop.init, jCForLoop2.init) && this.treesMatch(jCForLoop.cond, jCForLoop2.cond) && this.listsMatch(jCForLoop.step, jCForLoop2.step) && this.treesMatch(jCForLoop.body, jCForLoop2.body);
    }

    private boolean matchForeachLoop(JCTree.JCEnhancedForLoop jCEnhancedForLoop, JCTree.JCEnhancedForLoop jCEnhancedForLoop2) {
        return this.treesMatch(jCEnhancedForLoop.var, jCEnhancedForLoop2.var) && this.treesMatch(jCEnhancedForLoop.expr, jCEnhancedForLoop2.expr) && this.treesMatch(jCEnhancedForLoop.body, jCEnhancedForLoop2.body);
    }

    private boolean matchLabelled(JCTree.JCLabeledStatement jCLabeledStatement, JCTree.JCLabeledStatement jCLabeledStatement2) {
        return jCLabeledStatement.label == jCLabeledStatement2.label && this.treesMatch(jCLabeledStatement.body, jCLabeledStatement2.body);
    }

    private boolean matchSwitch(JCTree.JCSwitch jCSwitch, JCTree.JCSwitch jCSwitch2) {
        return this.treesMatch(jCSwitch.selector, jCSwitch2.selector) && this.listsMatch(jCSwitch.cases, jCSwitch2.cases);
    }

    private boolean matchCase(JCTree.JCCase jCCase, JCTree.JCCase jCCase2) {
        return this.treesMatch(jCCase.pat, jCCase2.pat) && this.listsMatch(jCCase.stats, jCCase2.stats);
    }

    private boolean matchSynchronized(JCTree.JCSynchronized jCSynchronized, JCTree.JCSynchronized jCSynchronized2) {
        return this.treesMatch(jCSynchronized.lock, jCSynchronized2.lock) && this.treesMatch(jCSynchronized.body, jCSynchronized2.body);
    }

    private boolean matchTry(JCTree.JCTry jCTry, JCTree.JCTry jCTry2) {
        return this.treesMatch(jCTry.finalizer, jCTry2.finalizer) && this.listsMatch(jCTry.catchers, jCTry2.catchers) && this.treesMatch(jCTry.body, jCTry2.body);
    }

    private boolean matchCatch(JCTree.JCCatch jCCatch, JCTree.JCCatch jCCatch2) {
        return this.treesMatch(jCCatch.param, jCCatch2.param) && this.treesMatch(jCCatch.body, jCCatch2.body);
    }

    private boolean matchConditional(JCTree.JCConditional jCConditional, JCTree.JCConditional jCConditional2) {
        return this.treesMatch(jCConditional.cond, jCConditional2.cond) && this.treesMatch(jCConditional.truepart, jCConditional2.truepart) && this.treesMatch(jCConditional.falsepart, jCConditional2.falsepart);
    }

    private boolean matchIf(JCTree.JCIf jCIf, JCTree.JCIf jCIf2) {
        return this.treesMatch(jCIf.cond, jCIf2.cond) && this.treesMatch(jCIf.thenpart, jCIf2.thenpart) && this.treesMatch(jCIf.elsepart, jCIf2.elsepart);
    }

    private boolean matchBreak(JCTree.JCBreak jCBreak, JCTree.JCBreak jCBreak2) {
        return jCBreak.label == jCBreak2.label && this.treesMatch(jCBreak.target, jCBreak2.target);
    }

    private boolean matchContinue(JCTree.JCContinue jCContinue, JCTree.JCContinue jCContinue2) {
        return jCContinue.label == jCContinue2.label && this.treesMatch(jCContinue.target, jCContinue2.target);
    }

    private boolean matchAssert(JCTree.JCAssert jCAssert, JCTree.JCAssert jCAssert2) {
        return this.treesMatch(jCAssert.cond, jCAssert2.cond) && this.treesMatch(jCAssert.detail, jCAssert2.detail);
    }

    private boolean matchApply(JCTree.JCMethodInvocation jCMethodInvocation, JCTree.JCMethodInvocation jCMethodInvocation2) {
        return jCMethodInvocation.varargsElement == jCMethodInvocation2.varargsElement && this.listsMatch(jCMethodInvocation.typeargs, jCMethodInvocation2.typeargs) && this.treesMatch(jCMethodInvocation.meth, jCMethodInvocation2.meth) && this.listsMatch(jCMethodInvocation.args, jCMethodInvocation2.args);
    }

    private boolean matchNewClass(JCTree.JCNewClass jCNewClass, JCTree.JCNewClass jCNewClass2) {
        return jCNewClass.constructor == jCNewClass2.constructor && this.treesMatch(jCNewClass.getIdentifier(), jCNewClass2.getIdentifier()) && this.listsMatch(jCNewClass.typeargs, jCNewClass2.typeargs) && this.listsMatch(jCNewClass.args, jCNewClass2.args) && jCNewClass.varargsElement == jCNewClass2.varargsElement && this.treesMatch(jCNewClass.def, jCNewClass2.def);
    }

    private boolean matchNewArray(JCTree.JCNewArray jCNewArray, JCTree.JCNewArray jCNewArray2) {
        return this.treesMatch(jCNewArray.elemtype, jCNewArray2.elemtype) && this.listsMatch(jCNewArray.dims, jCNewArray2.dims) && this.listsMatch(jCNewArray.elems, jCNewArray2.elems);
    }

    private boolean matchAssign(JCTree.JCAssign jCAssign, JCTree.JCAssign jCAssign2) {
        return this.treesMatch(jCAssign.lhs, jCAssign2.lhs) && this.treesMatch(jCAssign.rhs, jCAssign2.rhs);
    }

    private boolean matchAssignop(JCTree.JCAssignOp jCAssignOp, JCTree.JCAssignOp jCAssignOp2) {
        return jCAssignOp.operator == jCAssignOp2.operator && this.treesMatch(jCAssignOp.lhs, jCAssignOp2.lhs) && this.treesMatch(jCAssignOp.rhs, jCAssignOp2.rhs);
    }

    private boolean matchUnary(JCTree.JCUnary jCUnary, JCTree.JCUnary jCUnary2) {
        return jCUnary.operator == jCUnary2.operator && this.treesMatch(jCUnary.arg, jCUnary2.arg);
    }

    private boolean matchBinary(JCTree.JCBinary jCBinary, JCTree.JCBinary jCBinary2) {
        return jCBinary.operator == jCBinary2.operator && this.treesMatch(jCBinary.lhs, jCBinary2.lhs) && this.treesMatch(jCBinary.rhs, jCBinary2.rhs);
    }

    private boolean matchTypeCast(JCTree.JCTypeCast jCTypeCast, JCTree.JCTypeCast jCTypeCast2) {
        return this.treesMatch(jCTypeCast.clazz, jCTypeCast2.clazz) && this.treesMatch(jCTypeCast.expr, jCTypeCast2.expr);
    }

    private boolean matchTypeTest(JCTree.JCInstanceOf jCInstanceOf, JCTree.JCInstanceOf jCInstanceOf2) {
        return this.treesMatch(jCInstanceOf.clazz, jCInstanceOf2.clazz) && this.treesMatch(jCInstanceOf.expr, jCInstanceOf2.expr);
    }

    private boolean matchIndexed(JCTree.JCArrayAccess jCArrayAccess, JCTree.JCArrayAccess jCArrayAccess2) {
        return this.treesMatch(jCArrayAccess.indexed, jCArrayAccess2.indexed) && this.treesMatch(jCArrayAccess.index, jCArrayAccess2.index);
    }

    private boolean matchSelect(JCTree.JCFieldAccess jCFieldAccess, JCTree.JCFieldAccess jCFieldAccess2) {
        return this.treesMatch(jCFieldAccess.selected, jCFieldAccess2.selected) && jCFieldAccess.sym == jCFieldAccess2.sym;
    }

    private boolean matchLiteral(JCTree.JCLiteral jCLiteral, JCTree.JCLiteral jCLiteral2) {
        return jCLiteral.typetag == jCLiteral2.typetag && (jCLiteral.value == jCLiteral2.value || jCLiteral.value != null && jCLiteral.value.equals(jCLiteral2.value));
    }

    private boolean matchTypeApply(JCTree.JCTypeApply jCTypeApply, JCTree.JCTypeApply jCTypeApply2) {
        return this.treesMatch(jCTypeApply.clazz, jCTypeApply2.clazz) && this.listsMatch(jCTypeApply.arguments, jCTypeApply2.arguments);
    }

    private boolean matchTypeParameter(JCTree.JCTypeParameter jCTypeParameter, JCTree.JCTypeParameter jCTypeParameter2) {
        return jCTypeParameter.name == jCTypeParameter2.name && this.listsMatch(jCTypeParameter.bounds, jCTypeParameter2.bounds);
    }

    private boolean matchWildcard(JCTree.JCWildcard jCWildcard, JCTree.JCWildcard jCWildcard2) {
        return jCWildcard.kind == jCWildcard2.kind && this.treesMatch(jCWildcard.inner, jCWildcard2.inner);
    }

    private boolean matchAnnotation(JCTree.JCAnnotation jCAnnotation, JCTree.JCAnnotation jCAnnotation2) {
        return this.treesMatch(jCAnnotation.annotationType, jCAnnotation2.annotationType) && this.listsMatch(jCAnnotation.args, jCAnnotation2.args);
    }

    private boolean matchModifiers(JCTree.JCModifiers jCModifiers, JCTree.JCModifiers jCModifiers2) {
        return jCModifiers.flags == jCModifiers2.flags && this.listsMatch(jCModifiers.annotations, jCModifiers2.annotations);
    }

    private boolean matchLetExpr(JCTree.LetExpr letExpr, JCTree.LetExpr letExpr2) {
        return this.listsMatch(letExpr.defs, letExpr2.defs) && this.treesMatch(letExpr.expr, letExpr2.expr);
    }

    private boolean isCommaSeparated(JCTree.JCVariableDecl jCVariableDecl) {
        if (CasualDiff.getOldPos(jCVariableDecl) <= 0 || jCVariableDecl.pos <= 0) {
            return false;
        }
        this.tokenSequence.move(jCVariableDecl.pos);
        PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
        if (this.tokenSequence.token() == null) {
            return false;
        }
        if (JavaTokenId.COMMA == this.tokenSequence.token().id()) {
            return true;
        }
        if (jCVariableDecl.getInitializer() != null && (jCVariableDecl.mods.flags & 0x4000L) == 0L) {
            this.tokenSequence.move(this.endPos(jCVariableDecl.getInitializer()));
        } else {
            this.tokenSequence.move(jCVariableDecl.pos);
            this.tokenSequence.moveNext();
        }
        PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
        if (this.tokenSequence.token() == null) {
            return false;
        }
        return JavaTokenId.COMMA == this.tokenSequence.token().id();
    }

    private int[] getBounds(JCTree jCTree) {
        return new int[]{CasualDiff.getOldPos(jCTree), this.endPos(jCTree)};
    }

    private void copyTo(int n, int n2) {
        this.copyTo(n, n2, this.printer);
    }

    private void copyTo(int n, int n2, VeryPretty veryPretty) {
        if (n == n2) {
            return;
        }
        if (n > n2 || n < 0 || n2 < 0) {
            LOG.log(Level.INFO, "-----\n" + this.origText + "-----\n");
            LOG.log(Level.INFO, "Illegal values: from = " + n + "; to = " + n2 + "." + "Please, attach your messages.log to new issue!");
            if (n2 >= 0) {
                this.printer.eatChars(n - n2);
            }
            return;
        }
        if (n2 > this.origText.length()) {
            LOG.severe("-----\n" + this.origText + "-----\n");
            throw new IllegalArgumentException("Copying to " + n2 + " is greater then its size (" + this.origText.length() + ").");
        }
        veryPretty.print(this.origText.substring(n, n2));
    }

    private int diffTree(JCTree jCTree, JCTree jCTree2, int[] nArray, Tree.Kind kind) {
        if (jCTree.getKind() != jCTree2.getKind() && jCTree2.getKind() == Tree.Kind.BLOCK) {
            this.tokenSequence.move(CasualDiff.getOldPos(jCTree));
            PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
            this.tokenSequence.moveNext();
            this.copyTo(nArray[0], this.tokenSequence.offset());
            this.printer.printBlock(jCTree, jCTree2, kind);
            return this.endPos(jCTree);
        }
        nArray[0] = this.getBounds(jCTree)[0];
        this.copyTo(nArray[0], nArray[0]);
        return this.diffTree(jCTree, jCTree2, nArray);
    }

    public static class Diff {
        public DiffTypes type;
        int pos;
        int endOffset;
        protected JCTree oldTree;
        protected JCTree newTree;
        protected Comment oldComment;
        protected Comment newComment;
        private String text;
        boolean trailing;

        public static Diff insert(int n, String string) {
            return new Diff(DiffTypes.INSERT, n, -1, string);
        }

        public static Diff delete(int n, int n2) {
            return new Diff(DiffTypes.DELETE, n, n2, null);
        }

        Diff(DiffTypes diffTypes, int n, int n2, String string) {
            this.type = diffTypes;
            this.pos = n;
            this.endOffset = n2;
            this.text = string;
        }

        Diff(DiffTypes diffTypes, int n, JCTree jCTree, JCTree jCTree2, Comment comment, Comment comment2, boolean bl) {
            this(diffTypes, n, -1, null);
            assert (n >= 0) : "invalid source offset";
            this.oldTree = jCTree;
            this.newTree = jCTree2;
            this.oldComment = comment;
            this.newComment = comment2;
            this.trailing = bl;
        }

        public JCTree getOld() {
            return this.oldTree;
        }

        public JCTree getNew() {
            return this.newTree;
        }

        public int getPos() {
            return this.pos;
        }

        public int getEnd() {
            return this.endOffset;
        }

        public String getText() {
            return this.text;
        }

        public Comment getOldComment() {
            return this.oldComment;
        }

        public Comment getNewComment() {
            return this.newComment;
        }

        public boolean isTrailingComment() {
            return this.trailing;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Diff)) {
                return false;
            }
            Diff diff = (Diff)object;
            return this.type != diff.type && this.pos != diff.pos && this.oldTree != diff.oldTree && this.newTree != diff.newTree && this.oldComment != diff.oldComment && this.newComment != diff.newComment && this.trailing != diff.trailing;
        }

        public int hashCode() {
            return this.type.hashCode() + this.pos + (this.oldTree != null ? this.oldTree.hashCode() : 0) + (this.newTree != null ? this.newTree.hashCode() : 0) + (this.oldComment != null ? this.oldComment.hashCode() : 0) + (this.newComment != null ? this.newComment.hashCode() : 0) + Boolean.valueOf(this.trailing).hashCode();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("tree (");
            stringBuffer.append(this.type.toString());
            stringBuffer.append(") pos=");
            stringBuffer.append(this.pos);
            if (this.trailing) {
                stringBuffer.append(" trailing comment");
            }
            stringBuffer.append("\n");
            if (this.type == DiffTypes.DELETE || this.type == DiffTypes.INSERT || this.type == DiffTypes.MODIFY) {
                this.addDiffString(stringBuffer, this.oldTree, this.newTree);
            } else {
                this.addDiffString(stringBuffer, this.oldComment, this.newComment);
            }
            return stringBuffer.toString();
        }

        private void addDiffString(StringBuffer stringBuffer, Object object, Object object2) {
            if (object != null) {
                stringBuffer.append("< ");
                stringBuffer.append(object.toString());
                stringBuffer.append(object2 != null ? "\n---\n> " : "\n");
            } else {
                stringBuffer.append("> ");
            }
            if (object2 != null) {
                stringBuffer.append(object2.toString());
                stringBuffer.append('\n');
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LineInsertionType {
        BEFORE,
        AFTER,
        NONE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DiffTypes {
        MODIFY("modify"),
        INSERT("insert"),
        DELETE("delete");

        public final String name;

        private DiffTypes(String string2) {
            this.name = string2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ChangeKind {
        INSERT,
        DELETE,
        MODIFY,
        NOCHANGE;

    }
}

