/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.pretty;

import java.io.IOException;
import java.io.Writer;

public final class CharBuffer {
    char[] chars = new char[10];
    int used;
    int col;
    int maxcol;
    static final int UNLIMITED = 999999;
    int rightMargin = 72;
    int tabSize = 8;
    boolean expandTabs = true;
    int leftMargin = 0;
    int hardRightMargin = 999999;
    int lastBlankLines = 0;
    private static RuntimeException err = new IndexOutOfBoundsException();

    public final int length() {
        return this.used;
    }

    public void setLength(int n) {
        if (n < this.used) {
            this.used = n < 0 ? 0 : n;
        }
    }

    public CharBuffer() {
    }

    public CharBuffer(int n, int n2, boolean bl) {
        this();
        this.rightMargin = n;
        this.tabSize = n2;
        this.expandTabs = bl;
    }

    public final boolean hasMargin() {
        return this.hardRightMargin != 999999;
    }

    public int harden() {
        int n = this.hardRightMargin;
        this.hardRightMargin = this.rightMargin;
        return n;
    }

    public void restore(int n) {
        this.hardRightMargin = n;
    }

    private final void needRoom(int n) {
        if (this.chars.length <= this.used + n) {
            char[] cArray = new char[(this.used + n) * 2];
            System.arraycopy(this.chars, 0, cArray, 0, this.used);
            this.chars = cArray;
        }
    }

    private void columnOverflowCheck() {
        if ((this.col > this.hardRightMargin || this.maxcol > this.hardRightMargin) && this.hardRightMargin != 999999) {
            throw err;
        }
    }

    void toCol(int n) {
        if (!this.expandTabs) {
            while (this.col + this.tabSize - this.col % this.tabSize <= n) {
                this.append('\t');
            }
        }
        while (this.col < n) {
            this.append(' ');
        }
    }

    void toLeftMargin() {
        this.toCol(this.leftMargin);
    }

    void toColExactly(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n < this.col) {
            this.nlTerm();
        }
        this.toCol(n);
    }

    void notRightOf(int n) {
        if (n > this.col) {
            this.needSpace();
        } else {
            this.toColExactly(n);
        }
    }

    void ctlChar() {
        switch (this.chars[this.used - 1]) {
            case '\n': {
                if (this.hardRightMargin != 999999) {
                    throw err;
                }
                if (this.col > this.maxcol) {
                    this.maxcol = this.col;
                }
                this.col = 0;
                break;
            }
            case '\t': {
                this.col += this.tabSize - this.col % this.tabSize;
                break;
            }
            case '\b': {
                if (this.col > this.maxcol) {
                    this.maxcol = this.col;
                }
                --this.col;
            }
        }
        this.columnOverflowCheck();
    }

    private void append0(char c) {
        this.chars[this.used++] = c;
        if (c > ' ') {
            this.lastBlankLines = 0;
        }
        if (c < ' ') {
            this.ctlChar();
        } else if (++this.col > this.hardRightMargin) {
            this.columnOverflowCheck();
        }
    }

    public final void append(char c) {
        this.needRoom(1);
        this.append0(c);
    }

    public final void append(char[] cArray) {
        if (cArray != null) {
            this.append(cArray, 0, cArray.length);
        }
    }

    public final void append(char[] cArray, int n, int n2) {
        if (cArray != null) {
            this.needRoom(n2);
            while (--n2 >= 0) {
                this.append0(cArray[n++]);
            }
        }
    }

    public void append(String string) {
        int n = string.length();
        this.needRoom(n);
        for (int i = 0; i < n; ++i) {
            this.append0(string.charAt(i));
        }
    }

    public void append(CharBuffer charBuffer) {
        this.append(charBuffer.chars, 0, charBuffer.used);
    }

    public void appendUtf8(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        while (n < n3) {
            int n4;
            if ((n4 = byArray[n++] & 0xFF) >= 224) {
                n4 = (n4 & 0xF) << 12;
                n4 |= (byArray[n++] & 0x3F) << 6;
                n4 |= byArray[n++] & 0x3F;
            } else if (n4 >= 192) {
                n4 = (n4 & 0x1F) << 6;
                n4 |= byArray[n++] & 0x3F;
            }
            this.append((char)n4);
        }
    }

    public char[] toCharArray() {
        char[] cArray = new char[this.used];
        System.arraycopy(this.chars, 0, cArray, 0, this.used);
        return cArray;
    }

    public void copyClear(CharBuffer charBuffer) {
        char[] cArray = this.chars;
        this.chars = charBuffer.chars;
        this.used = charBuffer.used;
        charBuffer.chars = cArray;
        charBuffer.used = 0;
    }

    public void appendClear(CharBuffer charBuffer) {
        if (this.used == 0) {
            this.copyClear(charBuffer);
        } else {
            this.append(charBuffer);
            charBuffer.used = 0;
        }
    }

    public void clear() {
        this.used = 0;
        this.col = 0;
        this.maxcol = 0;
    }

    public int width() {
        return this.col > this.maxcol ? this.col : this.maxcol;
    }

    public String toString() {
        return new String(this.chars, 0, this.used);
    }

    public void writeTo(Writer writer) throws IOException {
        writer.write(this.chars, 0, this.used);
    }

    public String substring(int n, int n2) {
        return new String(this.chars, n, n2 - n);
    }

    public void to(Writer writer) throws IOException {
        this.to(writer, 0, this.used);
    }

    public void to(Writer writer, int n, int n2) throws IOException {
        writer.write(this.chars, n, n2);
    }

    public boolean equals(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() != this.used) {
                return false;
            }
            int n = this.used;
            while (--n >= 0) {
                if (this.chars[n] == string.charAt(n)) continue;
                return false;
            }
            return true;
        }
        return object == this;
    }

    public boolean equals(char[] cArray) {
        if (cArray.length != this.used) {
            return false;
        }
        int n = this.used;
        while (--n >= 0) {
            if (this.chars[n] == cArray[n]) continue;
            return false;
        }
        return true;
    }

    public void trim() {
        int n;
        int n2 = this.used;
        for (n = 0; n < n2 && this.chars[n] <= ' '; ++n) {
        }
        while (n < n2 && this.chars[n2 - 1] <= ' ') {
            --n2;
        }
        if (n >= n2) {
            this.used = 0;
        } else {
            this.used = n2 - n;
            if (n > 0) {
                System.arraycopy(this.chars, n, this.chars, 0, this.used);
            }
        }
    }

    public boolean endsWith(String string) {
        int n = string.length();
        if (n > this.used) {
            return false;
        }
        int n2 = this.used;
        while (--n >= 0) {
            if (this.chars[n2] != string.charAt(n)) {
                return false;
            }
            --n2;
        }
        return true;
    }

    public boolean startsWith(String string) {
        int n = string.length();
        if (n > this.used) {
            return false;
        }
        while (--n >= 0) {
            if (this.chars[n] == string.charAt(n)) continue;
            return false;
        }
        return true;
    }

    public void needSpace() {
        int n = this.used;
        if (n > 0 && this.chars[n - 1] > ' ') {
            this.append(' ');
        }
    }

    public void nlTerm() {
        if (this.hasMargin()) {
            this.needSpace();
        } else {
            int n = this.used;
            if (n <= 0) {
                return;
            }
            while (n > 0 && this.chars[n - 1] <= ' ') {
                --n;
            }
            this.used = n;
            this.append('\n');
        }
    }

    public void toLineStart() {
        if (this.hasMargin()) {
            this.needSpace();
        } else {
            int n = this.used;
            if (n <= 0) {
                return;
            }
            while (n > 0 && this.chars[n - 1] <= ' ' && this.chars[n - 1] != '\n') {
                --n;
            }
            this.used = n;
            this.col = 0;
        }
    }

    public void eatAwayChars(int n) {
        int n2;
        if (this.used <= 0) {
            return;
        }
        for (n2 = 0; n > n2 && this.chars[this.used - n2] != '\n'; ++n2) {
        }
        this.col = n2;
        this.used -= n2;
    }

    public void blanklines(int n) {
        int n2 = n = Math.max(this.lastBlankLines, n);
        if (this.hasMargin()) {
            this.needSpace();
        } else {
            this.nlTerm();
            while (n-- > 0) {
                this.append('\n');
            }
        }
        this.lastBlankLines = n2;
    }
}

