/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.modules.java.source.parsing.JavacParser;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.ParserFactory;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavacParserFactory
extends ParserFactory {
    private static final Logger TIMER = Logger.getLogger("TIMER.JavacParser");

    public JavacParser createParser(Collection<Snapshot> collection) {
        JavacParser javacParser;
        assert (collection != null);
        if (collection.size() == 1) {
            javacParser = collection.iterator().next().getSource().getFileObject();
            try {
                if (javacParser == null) {
                    return null;
                }
                if (javacParser.getFileSystem().isDefault() && javacParser.getAttribute("javax.script.ScriptEngine") != null && javacParser.getAttribute("template") == Boolean.TRUE) {
                    return null;
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        javacParser = new JavacParser(collection, false);
        if (TIMER.isLoggable(Level.FINE)) {
            LogRecord logRecord = new LogRecord(Level.FINE, "JavacParser");
            logRecord.setParameters(new Object[]{javacParser});
            TIMER.log(logRecord);
        }
        return javacParser;
    }

    public JavacParser createPrivateParser(Snapshot snapshot) {
        assert (snapshot != null);
        return snapshot.getSource().getFileObject() != null ? new JavacParser(Collections.singletonList(snapshot), true) : null;
    }

    public static JavacParserFactory getDefault() {
        Lookup lookup = MimeLookup.getLookup((String)"text/x-java");
        return (JavacParserFactory)((Object)lookup.lookup(JavacParserFactory.class));
    }
}

