/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.engine;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.java.source.engine.SourceReader;
import org.netbeans.modules.java.source.engine.SourceRewriter;

public class StringSourceRewriter
implements SourceRewriter {
    PrintWriter out;
    StringWriter sout = new StringWriter();

    public StringSourceRewriter() {
        this.out = new PrintWriter(this.sout);
    }

    public void writeTo(String string) throws IOException, BadLocationException {
        this.out.print(string);
    }

    public void skipThrough(SourceReader sourceReader, int n) throws IOException, BadLocationException {
        sourceReader.seek(n);
    }

    public void copyTo(SourceReader sourceReader, int n) throws IOException {
        char[] cArray = sourceReader.getCharsTo(n);
        this.out.write(cArray);
    }

    public void copyRest(SourceReader sourceReader) throws IOException {
        int n;
        char[] cArray = new char[4096];
        while ((n = sourceReader.read(cArray)) > 0) {
            this.out.write(cArray, 0, n);
        }
    }

    public void close(boolean bl) throws IOException {
        this.out.flush();
    }

    public String toString() {
        return this.sout.toString();
    }
}

