/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import java.util.prefs.Preferences;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.indent.spi.CodeStylePreferences;
import org.netbeans.modules.java.ui.FmtOptions;
import org.openide.filesystems.FileObject;

public final class CodeStyle {
    private Preferences preferences;

    private CodeStyle(Preferences preferences) {
        this.preferences = preferences;
    }

    public static CodeStyle getDefault(Project project) {
        return CodeStyle.getDefault(project.getProjectDirectory());
    }

    public static synchronized CodeStyle getDefault(FileObject fileObject) {
        Preferences preferences = CodeStylePreferences.get((FileObject)fileObject, (String)"text/x-java").getPreferences();
        return FmtOptions.codeStyleProducer.create(preferences);
    }

    public static synchronized CodeStyle getDefault(Document document) {
        Preferences preferences = CodeStylePreferences.get((Document)document, (String)"text/x-java").getPreferences();
        return FmtOptions.codeStyleProducer.create(preferences);
    }

    public boolean expandTabToSpaces() {
        return this.preferences.getBoolean("expand-tabs", FmtOptions.getDefaultAsBoolean("expand-tabs"));
    }

    public int getTabSize() {
        return this.preferences.getInt("tab-size", FmtOptions.getDefaultAsInt("tab-size"));
    }

    public int getIndentSize() {
        int n = this.preferences.getInt("indent-shift-width", FmtOptions.getDefaultAsInt("indent-shift-width"));
        if (n <= 0) {
            boolean bl = this.preferences.getBoolean("expand-tabs", FmtOptions.getDefaultAsBoolean("expand-tabs"));
            n = bl ? this.preferences.getInt("spaces-per-tab", FmtOptions.getDefaultAsInt("spaces-per-tab")) : this.preferences.getInt("tab-size", FmtOptions.getDefaultAsInt("tab-size"));
        }
        return n;
    }

    public int getContinuationIndentSize() {
        return this.preferences.getInt("continuationIndentSize", FmtOptions.getDefaultAsInt("continuationIndentSize"));
    }

    public int getLabelIndent() {
        return this.preferences.getInt("labelIndent", FmtOptions.getDefaultAsInt("labelIndent"));
    }

    public boolean absoluteLabelIndent() {
        return this.preferences.getBoolean("absoluteLabelIndent", FmtOptions.getDefaultAsBoolean("absoluteLabelIndent"));
    }

    public boolean indentTopLevelClassMembers() {
        return this.preferences.getBoolean("indentTopLevelClassMembers", FmtOptions.getDefaultAsBoolean("indentTopLevelClassMembers"));
    }

    public boolean indentCasesFromSwitch() {
        return this.preferences.getBoolean("indentCasesFromSwitch", FmtOptions.getDefaultAsBoolean("indentCasesFromSwitch"));
    }

    public int getRightMargin() {
        return this.preferences.getInt("text-limit-width", FmtOptions.getDefaultAsInt("text-limit-width"));
    }

    public boolean addLeadingStarInComment() {
        return this.preferences.getBoolean("addLeadingStarInComment", FmtOptions.getDefaultAsBoolean("addLeadingStarInComment"));
    }

    public boolean preferLongerNames() {
        return this.preferences.getBoolean("preferLongerNames", FmtOptions.getDefaultAsBoolean("preferLongerNames"));
    }

    public String getFieldNamePrefix() {
        return this.preferences.get("fieldNamePrefix", FmtOptions.getDefaultAsString("fieldNamePrefix"));
    }

    public String getFieldNameSuffix() {
        return this.preferences.get("fieldNameSuffix", FmtOptions.getDefaultAsString("fieldNameSuffix"));
    }

    public String getStaticFieldNamePrefix() {
        return this.preferences.get("staticFieldNamePrefix", FmtOptions.getDefaultAsString("staticFieldNamePrefix"));
    }

    public String getStaticFieldNameSuffix() {
        return this.preferences.get("staticFieldNameSuffix", FmtOptions.getDefaultAsString("staticFieldNameSuffix"));
    }

    public String getParameterNamePrefix() {
        return this.preferences.get("parameterNamePrefix", FmtOptions.getDefaultAsString("parameterNamePrefix"));
    }

    public String getParameterNameSuffix() {
        return this.preferences.get("parameterNameSuffix", FmtOptions.getDefaultAsString("parameterNameSuffix"));
    }

    public String getLocalVarNamePrefix() {
        return this.preferences.get("localVarNamePrefix", FmtOptions.getDefaultAsString("localVarNamePrefix"));
    }

    public String getLocalVarNameSuffix() {
        return this.preferences.get("localVarNameSuffix", FmtOptions.getDefaultAsString("localVarNameSuffix"));
    }

    public boolean qualifyFieldAccess() {
        return this.preferences.getBoolean("qualifyFieldAccess", FmtOptions.getDefaultAsBoolean("qualifyFieldAccess"));
    }

    public boolean useIsForBooleanGetters() {
        return this.preferences.getBoolean("useIsForBooleanGetters", FmtOptions.getDefaultAsBoolean("useIsForBooleanGetters"));
    }

    public boolean addOverrideAnnotation() {
        return this.preferences.getBoolean("addOverrideAnnotation", FmtOptions.getDefaultAsBoolean("addOverrideAnnotation"));
    }

    public boolean makeLocalVarsFinal() {
        return this.preferences.getBoolean("makeLocalVarsFinal", FmtOptions.getDefaultAsBoolean("makeLocalVarsFinal"));
    }

    public boolean makeParametersFinal() {
        return this.preferences.getBoolean("makeParametersFinal", FmtOptions.getDefaultAsBoolean("useFQNs"));
    }

    public BracePlacement getClassDeclBracePlacement() {
        String string = this.preferences.get("classDeclBracePlacement", FmtOptions.getDefaultAsString("classDeclBracePlacement"));
        return BracePlacement.valueOf(string);
    }

    public BracePlacement getMethodDeclBracePlacement() {
        String string = this.preferences.get("methodDeclBracePlacement", FmtOptions.getDefaultAsString("methodDeclBracePlacement"));
        return BracePlacement.valueOf(string);
    }

    public BracePlacement getOtherBracePlacement() {
        String string = this.preferences.get("otherBracePlacement", FmtOptions.getDefaultAsString("otherBracePlacement"));
        return BracePlacement.valueOf(string);
    }

    public boolean specialElseIf() {
        return this.preferences.getBoolean("specialElseIf", FmtOptions.getDefaultAsBoolean("specialElseIf"));
    }

    public BracesGenerationStyle redundantIfBraces() {
        String string = this.preferences.get("redundantIfBraces", FmtOptions.getDefaultAsString("redundantIfBraces"));
        return BracesGenerationStyle.valueOf(string);
    }

    public BracesGenerationStyle redundantForBraces() {
        String string = this.preferences.get("redundantForBraces", FmtOptions.getDefaultAsString("redundantForBraces"));
        return BracesGenerationStyle.valueOf(string);
    }

    public BracesGenerationStyle redundantWhileBraces() {
        String string = this.preferences.get("redundantWhileBraces", FmtOptions.getDefaultAsString("redundantWhileBraces"));
        return BracesGenerationStyle.valueOf(string);
    }

    public BracesGenerationStyle redundantDoWhileBraces() {
        String string = this.preferences.get("redundantDoWhileBraces", FmtOptions.getDefaultAsString("redundantDoWhileBraces"));
        return BracesGenerationStyle.valueOf(string);
    }

    public boolean alignMultilineMethodParams() {
        return this.preferences.getBoolean("alignMultilineMethodParams", FmtOptions.getDefaultAsBoolean("alignMultilineMethodParams"));
    }

    public boolean alignMultilineCallArgs() {
        return this.preferences.getBoolean("alignMultilineCallArgs", FmtOptions.getDefaultAsBoolean("alignMultilineCallArgs"));
    }

    public boolean alignMultilineAnnotationArgs() {
        return this.preferences.getBoolean("alignMultilineAnnotationArgs", FmtOptions.getDefaultAsBoolean("alignMultilineAnnotationArgs"));
    }

    public boolean alignMultilineImplements() {
        return this.preferences.getBoolean("alignMultilineImplements", FmtOptions.getDefaultAsBoolean("alignMultilineImplements"));
    }

    public boolean alignMultilineThrows() {
        return this.preferences.getBoolean("alignMultilineThrows", FmtOptions.getDefaultAsBoolean("alignMultilineThrows"));
    }

    public boolean alignMultilineParenthesized() {
        return this.preferences.getBoolean("alignMultilineParenthesized", FmtOptions.getDefaultAsBoolean("alignMultilineParenthesized"));
    }

    public boolean alignMultilineBinaryOp() {
        return this.preferences.getBoolean("alignMultilineBinaryOp", FmtOptions.getDefaultAsBoolean("alignMultilineBinaryOp"));
    }

    public boolean alignMultilineTernaryOp() {
        return this.preferences.getBoolean("alignMultilineTernaryOp", FmtOptions.getDefaultAsBoolean("alignMultilineTernaryOp"));
    }

    public boolean alignMultilineAssignment() {
        return this.preferences.getBoolean("alignMultilineAssignment", FmtOptions.getDefaultAsBoolean("alignMultilineAssignment"));
    }

    public boolean alignMultilineFor() {
        return this.preferences.getBoolean("alignMultilineFor", FmtOptions.getDefaultAsBoolean("alignMultilineFor"));
    }

    public boolean alignMultilineArrayInit() {
        return this.preferences.getBoolean("alignMultilineArrayInit", FmtOptions.getDefaultAsBoolean("alignMultilineArrayInit"));
    }

    public boolean placeElseOnNewLine() {
        return this.preferences.getBoolean("placeElseOnNewLine", FmtOptions.getDefaultAsBoolean("placeElseOnNewLine"));
    }

    public boolean placeWhileOnNewLine() {
        return this.preferences.getBoolean("placeWhileOnNewLine", FmtOptions.getDefaultAsBoolean("placeWhileOnNewLine"));
    }

    public boolean placeCatchOnNewLine() {
        return this.preferences.getBoolean("placeCatchOnNewLine", FmtOptions.getDefaultAsBoolean("placeCatchOnNewLine"));
    }

    public boolean placeFinallyOnNewLine() {
        return this.preferences.getBoolean("placeFinallyOnNewLine", FmtOptions.getDefaultAsBoolean("placeFinallyOnNewLine"));
    }

    public boolean placeNewLineAfterModifiers() {
        return this.preferences.getBoolean("placeNewLineAfterModifiers", FmtOptions.getDefaultAsBoolean("placeNewLineAfterModifiers"));
    }

    public WrapStyle wrapExtendsImplementsKeyword() {
        String string = this.preferences.get("wrapExtendsImplementsKeyword", FmtOptions.getDefaultAsString("wrapExtendsImplementsKeyword"));
        return WrapStyle.valueOf(string);
    }

    public WrapStyle wrapExtendsImplementsList() {
        String string = this.preferences.get("wrapExtendsImplementsList", FmtOptions.getDefaultAsString("wrapExtendsImplementsList"));
        return WrapStyle.valueOf(string);
    }

    public WrapStyle wrapMethodParams() {
        String string = this.preferences.get("wrapMethodParams", FmtOptions.getDefaultAsString("wrapMethodParams"));
        return WrapStyle.valueOf(string);
    }

    public WrapStyle wrapThrowsKeyword() {
        String string = this.preferences.get("wrapThrowsKeyword", FmtOptions.getDefaultAsString("wrapThrowsKeyword"));
        return WrapStyle.valueOf(string);
    }

    public WrapStyle wrapThrowsList() {
        String string = this.preferences.get("wrapThrowsList", FmtOptions.getDefaultAsString("wrapThrowsList"));
        return WrapStyle.valueOf(string);
    }

    public WrapStyle wrapMethodCallArgs() {
        String string = this.preferences.get("wrapMethodCallArgs", FmtOptions.getDefaultAsString("wrapMethodCallArgs"));
        return WrapStyle.valueOf(string);
    }

    public WrapStyle wrapAnnotationArgs() {
        String string = this.preferences.get("wrapAnnotationArgs", FmtOptions.getDefaultAsString("wrapAnnotationArgs"));
        return WrapStyle.valueOf(string);
    }

    public WrapStyle wrapChainedMethodCalls() {
        String string = this.preferences.get("wrapChainedMethodCalls", FmtOptions.getDefaultAsString("wrapChainedMethodCalls"));
        return WrapStyle.valueOf(string);
    }

    public WrapStyle wrapArrayInit() {
        String string = this.preferences.get("wrapArrayInit", FmtOptions.getDefaultAsString("wrapArrayInit"));
        return WrapStyle.valueOf(string);
    }

    public WrapStyle wrapFor() {
        String string = this.preferences.get("wrapFor", FmtOptions.getDefaultAsString("wrapFor"));
        return WrapStyle.valueOf(string);
    }

    public WrapStyle wrapForStatement() {
        String string = this.preferences.get("wrapForStatement", FmtOptions.getDefaultAsString("wrapForStatement"));
        return WrapStyle.valueOf(string);
    }

    public WrapStyle wrapIfStatement() {
        String string = this.preferences.get("wrapIfStatement", FmtOptions.getDefaultAsString("wrapIfStatement"));
        return WrapStyle.valueOf(string);
    }

    public WrapStyle wrapWhileStatement() {
        String string = this.preferences.get("wrapWhileStatement", FmtOptions.getDefaultAsString("wrapWhileStatement"));
        return WrapStyle.valueOf(string);
    }

    public WrapStyle wrapDoWhileStatement() {
        String string = this.preferences.get("wrapDoWhileStatement", FmtOptions.getDefaultAsString("wrapDoWhileStatement"));
        return WrapStyle.valueOf(string);
    }

    public WrapStyle wrapAssert() {
        String string = this.preferences.get("wrapAssert", FmtOptions.getDefaultAsString("wrapAssert"));
        return WrapStyle.valueOf(string);
    }

    public WrapStyle wrapEnumConstants() {
        String string = this.preferences.get("wrapEnumConstants", FmtOptions.getDefaultAsString("wrapEnumConstants"));
        return WrapStyle.valueOf(string);
    }

    public WrapStyle wrapAnnotations() {
        String string = this.preferences.get("wrapAnnotations", FmtOptions.getDefaultAsString("wrapAnnotations"));
        return WrapStyle.valueOf(string);
    }

    public WrapStyle wrapBinaryOps() {
        String string = this.preferences.get("wrapBinaryOps", FmtOptions.getDefaultAsString("wrapBinaryOps"));
        return WrapStyle.valueOf(string);
    }

    public WrapStyle wrapTernaryOps() {
        String string = this.preferences.get("wrapTernaryOps", FmtOptions.getDefaultAsString("wrapTernaryOps"));
        return WrapStyle.valueOf(string);
    }

    public WrapStyle wrapAssignOps() {
        String string = this.preferences.get("wrapAssignOps", FmtOptions.getDefaultAsString("wrapAssignOps"));
        return WrapStyle.valueOf(string);
    }

    public int getBlankLinesBeforePackage() {
        return this.preferences.getInt("blankLinesBeforePackage", FmtOptions.getDefaultAsInt("blankLinesBeforePackage"));
    }

    public int getBlankLinesAfterPackage() {
        return this.preferences.getInt("blankLinesAfterPackage", FmtOptions.getDefaultAsInt("blankLinesAfterPackage"));
    }

    public int getBlankLinesBeforeImports() {
        return this.preferences.getInt("blankLinesBeforeImports", FmtOptions.getDefaultAsInt("blankLinesBeforeImports"));
    }

    public int getBlankLinesAfterImports() {
        return this.preferences.getInt("blankLinesAfterImports", FmtOptions.getDefaultAsInt("blankLinesAfterImports"));
    }

    public int getBlankLinesBeforeClass() {
        return this.preferences.getInt("blankLinesBeforeClass", FmtOptions.getDefaultAsInt("blankLinesBeforeClass"));
    }

    public int getBlankLinesAfterClass() {
        return this.preferences.getInt("blankLinesAfterClass", FmtOptions.getDefaultAsInt("blankLinesAfterClass"));
    }

    public int getBlankLinesAfterClassHeader() {
        return this.preferences.getInt("blankLinesAfterClassHeader", FmtOptions.getDefaultAsInt("blankLinesAfterClassHeader"));
    }

    public int getBlankLinesBeforeFields() {
        return this.preferences.getInt("blankLinesBeforeFields", FmtOptions.getDefaultAsInt("blankLinesBeforeFields"));
    }

    public int getBlankLinesAfterFields() {
        return this.preferences.getInt("blankLinesAfterFields", FmtOptions.getDefaultAsInt("blankLinesAfterFields"));
    }

    public int getBlankLinesBeforeMethods() {
        return this.preferences.getInt("blankLinesBeforeMethods", FmtOptions.getDefaultAsInt("blankLinesBeforeMethods"));
    }

    public int getBlankLinesAfterMethods() {
        return this.preferences.getInt("blankLinesAfterMethods", FmtOptions.getDefaultAsInt("blankLinesAfterMethods"));
    }

    public boolean spaceBeforeWhile() {
        return this.preferences.getBoolean("spaceBeforeWhile", FmtOptions.getDefaultAsBoolean("spaceBeforeWhile"));
    }

    public boolean spaceBeforeElse() {
        return this.preferences.getBoolean("spaceBeforeElse", FmtOptions.getDefaultAsBoolean("spaceBeforeElse"));
    }

    public boolean spaceBeforeCatch() {
        return this.preferences.getBoolean("spaceBeforeCatch", FmtOptions.getDefaultAsBoolean("spaceBeforeCatch"));
    }

    public boolean spaceBeforeFinally() {
        return this.preferences.getBoolean("spaceBeforeFinally", FmtOptions.getDefaultAsBoolean("spaceBeforeFinally"));
    }

    public boolean spaceBeforeMethodDeclParen() {
        return this.preferences.getBoolean("spaceBeforeMethodDeclParen", FmtOptions.getDefaultAsBoolean("spaceBeforeMethodDeclParen"));
    }

    public boolean spaceBeforeMethodCallParen() {
        return this.preferences.getBoolean("spaceBeforeMethodCallParen", FmtOptions.getDefaultAsBoolean("spaceBeforeMethodCallParen"));
    }

    public boolean spaceBeforeIfParen() {
        return this.preferences.getBoolean("spaceBeforeIfParen", FmtOptions.getDefaultAsBoolean("spaceBeforeIfParen"));
    }

    public boolean spaceBeforeForParen() {
        return this.preferences.getBoolean("spaceBeforeForParen", FmtOptions.getDefaultAsBoolean("spaceBeforeForParen"));
    }

    public boolean spaceBeforeWhileParen() {
        return this.preferences.getBoolean("spaceBeforeWhileParen", FmtOptions.getDefaultAsBoolean("spaceBeforeWhileParen"));
    }

    public boolean spaceBeforeCatchParen() {
        return this.preferences.getBoolean("spaceBeforeCatchParen", FmtOptions.getDefaultAsBoolean("spaceBeforeCatchParen"));
    }

    public boolean spaceBeforeSwitchParen() {
        return this.preferences.getBoolean("spaceBeforeSwitchParen", FmtOptions.getDefaultAsBoolean("spaceBeforeSwitchParen"));
    }

    public boolean spaceBeforeSynchronizedParen() {
        return this.preferences.getBoolean("spaceBeforeSynchronizedParen", FmtOptions.getDefaultAsBoolean("spaceBeforeSynchronizedParen"));
    }

    public boolean spaceBeforeAnnotationParen() {
        return this.preferences.getBoolean("spaceBeforeAnnotationParen", FmtOptions.getDefaultAsBoolean("spaceBeforeAnnotationParen"));
    }

    public boolean spaceAroundUnaryOps() {
        return this.preferences.getBoolean("spaceAroundUnaryOps", FmtOptions.getDefaultAsBoolean("spaceAroundUnaryOps"));
    }

    public boolean spaceAroundBinaryOps() {
        return this.preferences.getBoolean("spaceAroundBinaryOps", FmtOptions.getDefaultAsBoolean("spaceAroundBinaryOps"));
    }

    public boolean spaceAroundTernaryOps() {
        return this.preferences.getBoolean("spaceAroundTernaryOps", FmtOptions.getDefaultAsBoolean("spaceAroundTernaryOps"));
    }

    public boolean spaceAroundAssignOps() {
        return this.preferences.getBoolean("spaceAroundAssignOps", FmtOptions.getDefaultAsBoolean("spaceAroundAssignOps"));
    }

    public boolean spaceBeforeClassDeclLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeClassDeclLeftBrace", FmtOptions.getDefaultAsBoolean("spaceBeforeClassDeclLeftBrace"));
    }

    public boolean spaceBeforeMethodDeclLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeMethodDeclLeftBrace", FmtOptions.getDefaultAsBoolean("spaceBeforeMethodDeclLeftBrace"));
    }

    public boolean spaceBeforeIfLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeIfLeftBrace", FmtOptions.getDefaultAsBoolean("spaceBeforeIfLeftBrace"));
    }

    public boolean spaceBeforeElseLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeElseLeftBrace", FmtOptions.getDefaultAsBoolean("spaceBeforeElseLeftBrace"));
    }

    public boolean spaceBeforeWhileLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeWhileLeftBrace", FmtOptions.getDefaultAsBoolean("spaceBeforeWhileLeftBrace"));
    }

    public boolean spaceBeforeForLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeForLeftBrace", FmtOptions.getDefaultAsBoolean("spaceBeforeForLeftBrace"));
    }

    public boolean spaceBeforeDoLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeDoLeftBrace", FmtOptions.getDefaultAsBoolean("spaceBeforeDoLeftBrace"));
    }

    public boolean spaceBeforeSwitchLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeSwitchLeftBrace", FmtOptions.getDefaultAsBoolean("spaceBeforeSwitchLeftBrace"));
    }

    public boolean spaceBeforeTryLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeTryLeftBrace", FmtOptions.getDefaultAsBoolean("spaceBeforeTryLeftBrace"));
    }

    public boolean spaceBeforeCatchLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeCatchLeftBrace", FmtOptions.getDefaultAsBoolean("spaceBeforeCatchLeftBrace"));
    }

    public boolean spaceBeforeFinallyLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeFinallyLeftBrace", FmtOptions.getDefaultAsBoolean("spaceBeforeFinallyLeftBrace"));
    }

    public boolean spaceBeforeSynchronizedLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeSynchronizedLeftBrace", FmtOptions.getDefaultAsBoolean("spaceBeforeSynchronizedLeftBrace"));
    }

    public boolean spaceBeforeStaticInitLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeStaticInitLeftBrace", FmtOptions.getDefaultAsBoolean("spaceBeforeStaticInitLeftBrace"));
    }

    public boolean spaceBeforeArrayInitLeftBrace() {
        return this.preferences.getBoolean("spaceBeforeArrayInitLeftBrace", FmtOptions.getDefaultAsBoolean("spaceBeforeArrayInitLeftBrace"));
    }

    public boolean spaceWithinParens() {
        return this.preferences.getBoolean("spaceWithinParens", FmtOptions.getDefaultAsBoolean("spaceWithinParens"));
    }

    public boolean spaceWithinMethodDeclParens() {
        return this.preferences.getBoolean("spaceWithinMethodDeclParens", FmtOptions.getDefaultAsBoolean("spaceWithinMethodDeclParens"));
    }

    public boolean spaceWithinMethodCallParens() {
        return this.preferences.getBoolean("spaceWithinMethodCallParens", FmtOptions.getDefaultAsBoolean("spaceWithinMethodCallParens"));
    }

    public boolean spaceWithinIfParens() {
        return this.preferences.getBoolean("spaceWithinIfParens", FmtOptions.getDefaultAsBoolean("spaceWithinIfParens"));
    }

    public boolean spaceWithinForParens() {
        return this.preferences.getBoolean("spaceWithinForParens", FmtOptions.getDefaultAsBoolean("spaceWithinForParens"));
    }

    public boolean spaceWithinWhileParens() {
        return this.preferences.getBoolean("spaceWithinWhileParens", FmtOptions.getDefaultAsBoolean("spaceWithinWhileParens"));
    }

    public boolean spaceWithinSwitchParens() {
        return this.preferences.getBoolean("spaceWithinSwitchParens", FmtOptions.getDefaultAsBoolean("spaceWithinSwitchParens"));
    }

    public boolean spaceWithinCatchParens() {
        return this.preferences.getBoolean("spaceWithinCatchParens", FmtOptions.getDefaultAsBoolean("spaceWithinCatchParens"));
    }

    public boolean spaceWithinSynchronizedParens() {
        return this.preferences.getBoolean("spaceWithinSynchronizedParens", FmtOptions.getDefaultAsBoolean("spaceWithinSynchronizedParens"));
    }

    public boolean spaceWithinTypeCastParens() {
        return this.preferences.getBoolean("spaceWithinTypeCastParens", FmtOptions.getDefaultAsBoolean("spaceWithinTypeCastParens"));
    }

    public boolean spaceWithinAnnotationParens() {
        return this.preferences.getBoolean("spaceWithinAnnotationParens", FmtOptions.getDefaultAsBoolean("spaceWithinAnnotationParens"));
    }

    public boolean spaceWithinBraces() {
        return this.preferences.getBoolean("spaceWithinBraces", FmtOptions.getDefaultAsBoolean("spaceWithinBraces"));
    }

    public boolean spaceWithinArrayInitBrackets() {
        return this.preferences.getBoolean("spaceWithinArrayInitBrackets", FmtOptions.getDefaultAsBoolean("spaceWithinArrayInitBrackets"));
    }

    public boolean spaceBeforeComma() {
        return this.preferences.getBoolean("spaceBeforeComma", FmtOptions.getDefaultAsBoolean("spaceBeforeComma"));
    }

    public boolean spaceAfterComma() {
        return this.preferences.getBoolean("spaceAfterComma", FmtOptions.getDefaultAsBoolean("spaceAfterComma"));
    }

    public boolean spaceBeforeSemi() {
        return this.preferences.getBoolean("spaceBeforeSemi", FmtOptions.getDefaultAsBoolean("spaceBeforeSemi"));
    }

    public boolean spaceAfterSemi() {
        return this.preferences.getBoolean("spaceAfterSemi", FmtOptions.getDefaultAsBoolean("spaceAfterSemi"));
    }

    public boolean spaceBeforeColon() {
        return this.preferences.getBoolean("spaceBeforeColon", FmtOptions.getDefaultAsBoolean("spaceBeforeColon"));
    }

    public boolean spaceAfterColon() {
        return this.preferences.getBoolean("spaceAfterColon", FmtOptions.getDefaultAsBoolean("spaceAfterColon"));
    }

    public boolean spaceAfterTypeCast() {
        return this.preferences.getBoolean("spaceAfterTypeCast", FmtOptions.getDefaultAsBoolean("spaceAfterTypeCast"));
    }

    public boolean useSingleClassImport() {
        return this.preferences.getBoolean("useSingleClassImport", FmtOptions.getDefaultAsBoolean("useSingleClassImport"));
    }

    public boolean useFQNs() {
        return this.preferences.getBoolean("useFQNs", FmtOptions.getDefaultAsBoolean("useFQNs"));
    }

    public int countForUsingStarImport() {
        return this.preferences.getInt("countForUsingStarImport", FmtOptions.getDefaultAsInt("countForUsingStarImport"));
    }

    public int countForUsingStaticStarImport() {
        return this.preferences.getInt("countForUsingStaticStarImport", FmtOptions.getDefaultAsInt("countForUsingStaticStarImport"));
    }

    public String[] getPackagesForStarImport() {
        return null;
    }

    static {
        FmtOptions.codeStyleProducer = new Producer();
    }

    private static class Producer
    implements FmtOptions.CodeStyleProducer {
        private Producer() {
        }

        public CodeStyle create(Preferences preferences) {
            return new CodeStyle(preferences);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WrapStyle {
        WRAP_ALWAYS,
        WRAP_IF_LONG,
        WRAP_NEVER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BracesGenerationStyle {
        GENERATE,
        LEAVE_ALONE,
        ELIMINATE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BracePlacement {
        SAME_LINE,
        NEW_LINE,
        NEW_LINE_HALF_INDENTED,
        NEW_LINE_INDENTED;

    }
}

