/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.refactoring.java.api.ChangeParametersRefactoring;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeParamsTransformer
extends RefactoringVisitor {
    private static final Set<Modifier> ALL_ACCESS_MODIFIERS = EnumSet.of(Modifier.PRIVATE, Modifier.PROTECTED, Modifier.PUBLIC);
    private Set<ElementHandle<ExecutableElement>> allMethods;
    private boolean synthConstructor;
    private Boolean constructorRefactoring;
    ChangeParametersRefactoring refactoring;

    public ChangeParamsTransformer(ChangeParametersRefactoring changeParametersRefactoring, Set<ElementHandle<ExecutableElement>> set) {
        this.refactoring = changeParametersRefactoring;
        this.allMethods = set;
    }

    private void init() {
        if (this.constructorRefactoring == null) {
            Element element;
            ElementHandle<ExecutableElement> elementHandle = this.allMethods.iterator().next();
            this.constructorRefactoring = elementHandle.getKind() == ElementKind.CONSTRUCTOR;
            this.synthConstructor = this.constructorRefactoring != false && (element = elementHandle.resolve((CompilationInfo)this.workingCopy)) != null && this.workingCopy.getElementUtilities().isSynthetic(element);
        }
    }

    @Override
    public Tree visitCompilationUnit(CompilationUnitTree compilationUnitTree, Element element) {
        this.init();
        return (Tree)super.visitCompilationUnit(compilationUnitTree, element);
    }

    @Override
    public Tree visitNewClass(NewClassTree newClassTree, Element element) {
        if (this.constructorRefactoring.booleanValue() && !this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
            Trees trees = this.workingCopy.getTrees();
            Element element2 = trees.getElement(this.getCurrentPath());
            if ((element2 = this.resolveAnonymousClassConstructor(element2, newClassTree, trees)) != null && this.isMethodMatch(element2)) {
                List<ExpressionTree> list = this.getNewArguments(newClassTree.getArguments());
                NewClassTree newClassTree2 = this.make.NewClass(newClassTree.getEnclosingExpression(), newClassTree.getTypeArguments(), newClassTree.getIdentifier(), list, newClassTree.getClassBody());
                this.rewrite(newClassTree, newClassTree2);
            }
        }
        return (Tree)super.visitNewClass(newClassTree, element);
    }

    private Element resolveAnonymousClassConstructor(Element element, NewClassTree newClassTree, Trees trees) {
        Tree tree;
        if (element != null && newClassTree.getClassBody() != null && (tree = trees.getTree(element)) != null && tree.getKind() == Tree.Kind.METHOD) {
            MethodTree methodTree = (MethodTree)tree;
            Tree tree2 = methodTree.getBody().getStatements().get(0);
            TreePath treePath = trees.getPath(this.getCurrentPath().getCompilationUnit(), ((ExpressionStatementTree)tree2).getExpression());
            element = trees.getElement(treePath);
        }
        return element;
    }

    private List<ExpressionTree> getNewArguments(List<? extends ExpressionTree> list) {
        ArrayList<ExpressionTree> arrayList = new ArrayList<ExpressionTree>();
        ChangeParametersRefactoring.ParameterInfo[] parameterInfoArray = this.refactoring.getParameterInfo();
        for (int i = 0; i < parameterInfoArray.length; ++i) {
            ExpressionTree expressionTree;
            int n = parameterInfoArray[i].getOriginalIndex();
            if (n < 0) {
                String string = parameterInfoArray[i].getDefaultValue();
                SourcePositions[] sourcePositionsArray = new SourcePositions[1];
                expressionTree = this.workingCopy.getTreeUtilities().parseExpression(string, sourcePositionsArray);
            } else {
                if (i == parameterInfoArray.length - 1 && parameterInfoArray[i].getType().endsWith("...")) {
                    for (int j = n; j < list.size(); ++j) {
                        arrayList.add(list.get(j));
                    }
                    break;
                }
                expressionTree = list.get(n);
            }
            arrayList.add(expressionTree);
        }
        return arrayList;
    }

    @Override
    public Tree visitMethodInvocation(MethodInvocationTree methodInvocationTree, Element element) {
        Element element2;
        if ((this.constructorRefactoring.booleanValue() || !this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) && (element2 = this.workingCopy.getTrees().getElement(this.getCurrentPath())) != null && this.isMethodMatch(element2)) {
            List<ExpressionTree> list = this.getNewArguments(methodInvocationTree.getArguments());
            MethodInvocationTree methodInvocationTree2 = this.make.MethodInvocation(methodInvocationTree.getTypeArguments(), methodInvocationTree.getMethodSelect(), list);
            if (this.constructorRefactoring.booleanValue() && this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
                this.rewriteSyntheticConstructor(methodInvocationTree2);
            } else {
                this.rewrite(methodInvocationTree, methodInvocationTree2);
            }
        }
        return (Tree)super.visitMethodInvocation(methodInvocationTree, element);
    }

    private void rewriteSyntheticConstructor(MethodInvocationTree methodInvocationTree) {
        TreePath treePath;
        for (treePath = this.getCurrentPath(); treePath != null && treePath.getLeaf().getKind() != Tree.Kind.METHOD; treePath = treePath.getParentPath()) {
        }
        if (treePath != null) {
            MethodTree methodTree = (MethodTree)treePath.getLeaf();
            BlockTree blockTree = methodTree.getBody();
            blockTree = this.make.removeBlockStatement(blockTree, 0);
            blockTree = this.make.insertBlockStatement(blockTree, 0, (StatementTree)this.make.ExpressionStatement((ExpressionTree)methodInvocationTree));
            if (this.workingCopy.getTreeUtilities().isSynthetic(treePath)) {
                MethodTree methodTree2 = this.make.Method(this.make.Modifiers(methodTree.getModifiers().getFlags(), methodTree.getModifiers().getAnnotations()), (CharSequence)methodTree.getName(), methodTree.getReturnType(), methodTree.getTypeParameters(), methodTree.getParameters(), methodTree.getThrows(), blockTree, (ExpressionTree)methodTree.getDefaultValue());
                this.rewrite(methodTree, methodTree2);
            } else {
                this.rewrite(methodTree.getBody(), blockTree);
            }
        }
    }

    @Override
    public Tree visitMethod(MethodTree methodTree, Element element) {
        if (this.constructorRefactoring.booleanValue() && this.isSyntheticConstructorOfAnnonymousClass(this.workingCopy.getTrees().getElement(this.getCurrentPath()))) {
            return methodTree;
        }
        this.renameDeclIfMatch(this.getCurrentPath(), methodTree, element);
        return (Tree)super.visitMethod(methodTree, element);
    }

    private void renameDeclIfMatch(TreePath treePath, Tree tree, Element element) {
        if (!this.synthConstructor && this.workingCopy.getTreeUtilities().isSynthetic(treePath)) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        Element element2 = this.workingCopy.getTrees().getElement(treePath);
        if (this.isMethodMatch(element2)) {
            List<? extends VariableTree> list = methodTree.getParameters();
            ArrayList<VariableTree> arrayList = new ArrayList<VariableTree>();
            ChangeParametersRefactoring.ParameterInfo[] parameterInfoArray = this.refactoring.getParameterInfo();
            for (int i = 0; i < parameterInfoArray.length; ++i) {
                int n = parameterInfoArray[i].getOriginalIndex();
                VariableTree variableTree = n < 0 ? this.make.Variable(this.make.Modifiers(Collections.emptySet()), (CharSequence)parameterInfoArray[i].getName(), (Tree)this.make.Identifier((CharSequence)parameterInfoArray[i].getType()), null) : list.get(parameterInfoArray[i].getOriginalIndex());
                arrayList.add(variableTree);
            }
            HashSet<Modifier> hashSet = new HashSet<Modifier>(element2.getModifiers());
            if (!element2.getEnclosingElement().getKind().isInterface()) {
                hashSet.removeAll(ALL_ACCESS_MODIFIERS);
                hashSet.addAll(this.refactoring.getModifiers());
            }
            for (VariableTree variableTree : arrayList) {
                Object object;
                Set set = this.workingCopy.getClasspathInfo().getClassIndex().getDeclaredTypes(variableTree.getType().toString(), ClassIndex.NameKind.SIMPLE_NAME, EnumSet.allOf(ClassIndex.SearchScope.class));
                HashSet hashSet2 = new HashSet(set);
                Object object2 = null;
                Object object3 = set.iterator();
                while (object3.hasNext()) {
                    object = (ElementHandle)object3.next();
                    TypeElement typeElement = this.workingCopy.getElements().getTypeElement(object.getQualifiedName());
                    if (typeElement == null) {
                        Logger.getLogger(ChangeParamsTransformer.class.getName()).log(Level.INFO, "Cannot resolve type element \"" + object + "\".");
                        continue;
                    }
                    if (!typeElement.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
                    hashSet2.remove(object);
                }
                if (hashSet2.size() == 1) {
                    object3 = (ElementHandle)hashSet2.iterator().next();
                    object = this.workingCopy.getElements().getTypeElement(object3.getQualifiedName());
                    if (object == null) {
                        Logger.getLogger(ChangeParamsTransformer.class.getName()).log(Level.INFO, "Cannot resolve type element \"" + object3 + "\".");
                        continue;
                    }
                    object2 = object;
                }
                if (object2 == null || (object3 = this.workingCopy.getElements().getPackageOf((Element)object2)).getQualifiedName().toString().equals("java.lang")) continue;
                try {
                    SourceUtils.resolveImport((CompilationInfo)this.workingCopy, (TreePath)treePath, (String)object2.getQualifiedName().toString());
                }
                catch (NullPointerException nullPointerException) {
                    Exceptions.printStackTrace((Throwable)nullPointerException);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            MethodTree methodTree2 = this.make.Method(this.make.Modifiers(hashSet, methodTree.getModifiers().getAnnotations()), (CharSequence)methodTree.getName(), methodTree.getReturnType(), methodTree.getTypeParameters(), arrayList, methodTree.getThrows(), methodTree.getBody(), (ExpressionTree)methodTree.getDefaultValue());
            this.rewrite(tree, methodTree2);
            return;
        }
    }

    private boolean isMethodMatch(Element element) {
        if ((element.getKind() == ElementKind.METHOD || element.getKind() == ElementKind.CONSTRUCTOR) && this.allMethods != null) {
            for (ElementHandle<ExecutableElement> elementHandle : this.allMethods) {
                ExecutableElement executableElement = (ExecutableElement)elementHandle.resolve((CompilationInfo)this.workingCopy);
                if (executableElement == null) {
                    Logger.getLogger("org.netbeans.modules.refactoring.java").info("ChangeParamsTransformer cannot resolve " + elementHandle);
                    continue;
                }
                if (!executableElement.equals(element) && !this.workingCopy.getElements().overrides((ExecutableElement)element, executableElement, this.workingCopy.getElementUtilities().enclosingTypeElement((Element)executableElement))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSyntheticConstructorOfAnnonymousClass(Element element) {
        if (element != null && element.getKind() == ElementKind.CONSTRUCTOR && this.workingCopy.getElementUtilities().isSynthetic(element)) {
            Element element2 = element.getEnclosingElement();
            return element2 != null && element2.getKind().isClass() && ((TypeElement)element2).getNestingKind() == NestingKind.ANONYMOUS;
        }
        return false;
    }
}

