/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.proxy;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbProxy;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class GdbConsoleWindow
extends TopComponent
implements ActionListener,
PropertyChangeListener {
    private GdbDebugger debugger;
    private GdbProxy gdbProxy;
    private JScrollBar scrollBar;
    private static GdbConsoleWindow instance = null;
    private final Object textLock = new String("Console text lock");
    private JLabel commandLB;
    protected JComboBox debuggerCommand;
    protected JTextArea debuggerLog;
    protected JScrollPane debuggerLogPane;
    protected JLabel programLB;
    protected JTextField programName;
    protected JTextField programStatus;
    private JLabel statusLB;

    private GdbConsoleWindow(GdbDebugger gdbDebugger, GdbProxy gdbProxy) {
        GdbConsoleWindow gdbConsoleWindow;
        this.initComponents();
        try {
            gdbConsoleWindow = this;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    gdbConsoleWindow.setDisplayName(NbBundle.getMessage(GdbConsoleWindow.class, (String)"TITLE_GdbConsoleWindow"));
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.scrollBar = this.debuggerLogPane.getVerticalScrollBar();
        this.debugger = gdbDebugger;
        this.gdbProxy = gdbProxy;
        gdbDebugger.addPropertyChangeListener(this);
        gdbConsoleWindow = (ProjectActionEvent)gdbDebugger.getLookup().lookupFirst(null, ProjectActionEvent.class);
        this.programName.setText(gdbConsoleWindow.getExecutable());
    }

    public static GdbConsoleWindow getInstance(GdbDebugger gdbDebugger, GdbProxy gdbProxy) {
        if (instance == null || GdbConsoleWindow.instance.debugger != gdbDebugger || GdbConsoleWindow.instance.gdbProxy != gdbProxy) {
            instance = new GdbConsoleWindow(gdbDebugger, gdbProxy);
            GdbConsoleWindow.docConsole(instance);
        }
        return instance;
    }

    private static void docConsole(final GdbConsoleWindow gdbConsoleWindow) {
        if (SwingUtilities.isEventDispatchThread()) {
            Mode mode = WindowManager.getDefault().findMode("output");
            if (mode != null) {
                mode.dockInto((TopComponent)instance);
            }
            gdbConsoleWindow.open();
            gdbConsoleWindow.requestActive();
        } else {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Mode mode = WindowManager.getDefault().findMode("output");
                        if (mode != null) {
                            mode.dockInto((TopComponent)gdbConsoleWindow);
                        }
                        gdbConsoleWindow.open();
                        gdbConsoleWindow.requestActive();
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void openConsole() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.open();
        } else {
            final GdbConsoleWindow gdbConsoleWindow = this;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    gdbConsoleWindow.open();
                }
            });
        }
    }

    public void closeConsole() {
        instance = null;
        if (SwingUtilities.isEventDispatchThread()) {
            this.close();
        } else {
            final GdbConsoleWindow gdbConsoleWindow = this;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    gdbConsoleWindow.close();
                }
            });
        }
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("state".equals(propertyChangeEvent.getPropertyName())) {
            Object object = propertyChangeEvent.getNewValue();
            if (object == GdbDebugger.State.EXITED) {
                this.closeConsole();
            } else {
                this.updateStatus(object.toString());
            }
        }
    }

    public int getPersistenceType() {
        return 2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (!string.equals("comboBoxEdited")) {
            return;
        }
        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
        String string2 = (String)jComboBox.getSelectedItem();
        if (string2 == null || string2.length() == 0) {
            return;
        }
        this.addCommandToList(string2);
        this.debuggerCommand.setSelectedIndex(0);
        if (this.gdbProxy == null) {
            return;
        }
        this.gdbProxy.getProxyEngine().sendConsoleCommand(string2);
    }

    private void addCommandToList(String string) {
        boolean bl = false;
        for (int i = 0; i < this.debuggerCommand.getItemCount(); ++i) {
            if (string.compareTo((String)this.debuggerCommand.getItemAt(i)) != 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.debuggerCommand.addItem(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String string) {
        Object object = this.textLock;
        synchronized (object) {
            this.debuggerLog.append(string);
        }
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        GdbConsoleWindow.this.scrollBar.setValue(GdbConsoleWindow.this.scrollBar.getMaximum());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateStatus(String string) {
        this.programStatus.setText(string);
    }

    private void initComponents() {
        this.programLB = new JLabel();
        this.programName = new JTextField();
        this.statusLB = new JLabel();
        this.programStatus = new JTextField();
        this.debuggerLogPane = new JScrollPane();
        this.debuggerLog = new JTextArea();
        this.commandLB = new JLabel();
        this.debuggerCommand = new JComboBox();
        this.debuggerCommand.addActionListener(this);
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/proxy/Bundle").getString("ACSN_JP_Debugger_Console"));
        this.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/proxy/Bundle").getString("ACSD_JP_Debugger_Console"));
        this.programLB.setLabelFor(this.programName);
        this.programLB.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/proxy/Bundle").getString("L_Program_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 6, 0, 0);
        this.add(this.programLB, gridBagConstraints);
        this.programLB.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/proxy/Bundle").getString("ACSN_JL_ProgramName"));
        this.programLB.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/proxy/Bundle").getString("ACSD_JL_Program_Name"));
        this.programName.setEditable(false);
        this.programName.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/proxy/Bundle").getString("TOOLTIP_Program_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 6);
        this.add(this.programName, gridBagConstraints);
        this.programName.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/proxy/Bundle").getString("ACSN_JL_ProgramName"));
        this.statusLB.setLabelFor(this.programStatus);
        this.statusLB.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/proxy/Bundle").getString("L_Program_Status"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 0, 2);
        this.add(this.statusLB, gridBagConstraints);
        this.statusLB.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/proxy/Bundle").getString("ACSN_JL_ProgramStatus"));
        this.statusLB.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/proxy/Bundle").getString("ACSD_JL_Program_Status"));
        this.programStatus.setEditable(false);
        this.programStatus.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/proxy/Bundle").getString("TOOLTIP_Program_Status"));
        this.programStatus.setMinimumSize(new Dimension(100, 20));
        this.programStatus.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 0, 0, 6);
        this.add(this.programStatus, gridBagConstraints);
        this.programStatus.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/proxy/Bundle").getString("ACSN_JL_ProgramStatus"));
        this.programStatus.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/proxy/Bundle").getString("ACSD_JTF_Program_Status"));
        this.debuggerLog.setColumns(20);
        this.debuggerLog.setEditable(false);
        this.debuggerLog.setRows(5);
        this.debuggerLogPane.setViewportView(this.debuggerLog);
        this.debuggerLog.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/proxy/Bundle").getString("ACSN_JTA_Debugger_Log"));
        this.debuggerLog.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/proxy/Bundle").getString("ACSD_JTA_Debugger_Log"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 70.0;
        gridBagConstraints.weighty = 70.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add(this.debuggerLogPane, gridBagConstraints);
        this.commandLB.setLabelFor(this.debuggerCommand);
        this.commandLB.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/proxy/Bundle").getString("L_Debugger_Command"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.insets = new Insets(2, 6, 9, 0);
        this.add(this.commandLB, gridBagConstraints);
        this.commandLB.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/proxy/Bundle").getString("ACSN_JL_Debugger_Command"));
        this.commandLB.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/proxy/Bundle").getString("ACSD_JL_Debugger_Command"));
        this.debuggerCommand.setEditable(true);
        this.debuggerCommand.setModel(new DefaultComboBoxModel<String>(new String[]{"", "help ", "info", "-break-insert main", "-break-delete 1", "-exec-run ", "-exec-continue", "-exec-next", "-exec-step", "-data-evaluate-expression "}));
        this.debuggerCommand.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/proxy/Bundle").getString("TOOLTIP_Debugger_Command"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1000.0;
        gridBagConstraints.insets = new Insets(4, 4, 6, 6);
        this.add(this.debuggerCommand, gridBagConstraints);
        this.debuggerCommand.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/proxy/Bundle").getString("ACSN_JL_Debugger_Command"));
        this.debuggerCommand.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/proxy/Bundle").getString("ACSD_JCB_Debugger_Command"));
    }

    static class HideTextAction
    extends AbstractAction {
        public HideTextAction() {
            super("Hide Text", new ImageIcon("cut.gif"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }
}

