/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbProxy;

public class GdbContext
implements PropertyChangeListener {
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final Map<String, Request> requests = new HashMap<String, Request>();
    private final Map<String, Object> cache = new HashMap<String, Object>();
    private final Map<String, Object> waitLocks = new HashMap<String, Object>();
    private static final int SYNC_UPDATE_TIMEOUT = 30000;
    public static final String PROP_REGISTERS = "Registers";
    public static final String PROP_STEP = "Step";
    public static final String PROP_EXIT = "Exit";
    private static GdbContext instance = null;

    private GdbContext() {
        this.requests.put(PROP_REGISTERS, new Request(){

            protected void request(GdbProxy gdbProxy) {
                gdbProxy.data_list_register_values("");
                gdbProxy.data_list_changed_registers();
            }
        });
        this.pcs.addPropertyChangeListener(this);
    }

    public void gdbExit() {
        this.invalidate(true);
        this.pcs.firePropertyChange(PROP_EXIT, 0, 1);
    }

    private void invalidate(boolean bl) {
        this.cache.clear();
        if (bl) {
            for (String string : this.requests.keySet()) {
                if (!this.hasListeners(string)) continue;
                this.pcs.firePropertyChange(string, 0, 1);
            }
        }
    }

    public void gdbStep() {
        this.invalidate(false);
        for (Map.Entry<String, Request> entry : this.requests.entrySet()) {
            if (!this.hasListeners(entry.getKey())) continue;
            entry.getValue().run();
        }
        this.pcs.firePropertyChange(PROP_STEP, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = this.waitLocks.get(propertyChangeEvent.getPropertyName());
        if (object != null) {
            Object object2 = object;
            synchronized (object2) {
                object.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String string) {
        Object object = this.cache.get(string);
        if (object == null) {
            boolean bl = true;
            Object object2 = this.waitLocks.get(string);
            if (object2 == null) {
                bl = false;
                object2 = "Lock for " + string;
            }
            Object object3 = object2;
            synchronized (object3) {
                this.waitLocks.put(string, object2);
                if (bl || this.requests.get(string).run()) {
                    try {
                        object2.wait(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.waitLocks.remove(string);
            }
            return this.cache.get(string);
        }
        return object;
    }

    public void setProperty(String string, Object object) {
        this.cache.put(string, object);
        this.pcs.firePropertyChange(string, 0, 1);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        Request request;
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
        if (!this.cache.containsKey(string) && (request = this.requests.get(string)) != null) {
            request.run();
        }
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    private synchronized boolean hasListeners(String string) {
        return this.pcs.getPropertyChangeListeners(string).length > 0;
    }

    public static synchronized GdbContext getInstance() {
        if (instance == null) {
            instance = new GdbContext();
        }
        return instance;
    }

    private static abstract class Request {
        private Request() {
        }

        public boolean run() {
            GdbDebugger gdbDebugger = GdbDebugger.getGdbDebugger();
            if (gdbDebugger == null) {
                return false;
            }
            GdbProxy gdbProxy = gdbDebugger.getGdbProxy();
            if (gdbProxy != null) {
                if (gdbDebugger.isStopped()) {
                    this.request(gdbProxy);
                }
                return true;
            }
            return false;
        }

        protected abstract void request(GdbProxy var1);
    }
}

