/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.core.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.jaxws.project.config.WsimportOption;
import org.netbeans.modules.websvc.api.jaxws.project.config.WsimportOptions;
import org.netbeans.modules.websvc.api.wseditor.WSEditor;
import org.netbeans.modules.websvc.customization.jaxwssettings.panel.WsimportOptionsPanel;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxwsSettingsEditor
implements WSEditor {
    private Service service;
    private Client client;
    private WsimportOptionsPanel panel;
    private JaxWsModel jaxWsModel;

    JaxwsSettingsEditor(JaxWsModel jaxWsModel) {
        this.jaxWsModel = jaxWsModel;
    }

    public JComponent createWSEditorComponent(Node node) {
        this.service = (Service)node.getLookup().lookup(Service.class);
        this.client = (Client)node.getLookup().lookup(Client.class);
        WsimportOptions wsimportOptions = null;
        if (this.service != null) {
            wsimportOptions = this.service.getWsImportOptions();
        } else if (this.client != null) {
            wsimportOptions = this.client.getWsImportOptions();
        }
        ArrayList<WsimportOption> arrayList = new ArrayList<WsimportOption>();
        ArrayList<WsimportOption> arrayList2 = new ArrayList<WsimportOption>();
        if (wsimportOptions != null) {
            WsimportOption[] wsimportOptionArray = wsimportOptions.getWsimportOptions();
            for (int i = 0; i < wsimportOptionArray.length; ++i) {
                WsimportOption wsimportOption = wsimportOptionArray[i];
                if (wsimportOption.getJaxbOption() != null && wsimportOption.getJaxbOption().booleanValue()) {
                    arrayList2.add(wsimportOption);
                    continue;
                }
                arrayList.add(wsimportOption);
            }
        }
        this.panel = new WsimportOptionsPanel(arrayList, arrayList2, wsimportOptions);
        return this.panel;
    }

    public String getTitle() {
        return NbBundle.getMessage(JaxwsSettingsEditor.class, (String)"JAXWS_SETTINGS_TITLE");
    }

    public void save(Node node) {
        try {
            WsimportOptions wsimportOptions = null;
            if (this.service != null) {
                wsimportOptions = this.service.getWsImportOptions();
                if (wsimportOptions == null) {
                    wsimportOptions = this.service.newWsimportOptions();
                }
            } else if (this.client != null && (wsimportOptions = this.client.getWsImportOptions()) == null) {
                wsimportOptions = this.client.newWsimportOptions();
            }
            wsimportOptions.clearWsimportOptions();
            List<WsimportOption> list = this.getWsimportOptions();
            for (WsimportOption wsimportOption : list) {
                wsimportOptions.addWsimportOption(wsimportOption);
            }
            list = this.getJaxbOptions();
            for (WsimportOption wsimportOption : list) {
                wsimportOption.setJaxbOption(Boolean.valueOf(true));
                wsimportOptions.addWsimportOption(wsimportOption);
            }
            this.jaxWsModel.write();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    public void cancel(Node node) {
    }

    public String getDescription() {
        return NbBundle.getMessage(JaxwsSettingsEditor.class, (String)"JAXWS_SETTINGS_DESC");
    }

    private List<WsimportOption> getWsimportOptions() {
        return this.panel.getWsimportOptions();
    }

    private List<WsimportOption> getJaxbOptions() {
        return this.panel.getJaxbOptions();
    }
}

