/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.spi.ejbjar.support;

import java.awt.Image;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.ejbjar.project.ui.EjbContainerNode;
import org.netbeans.modules.j2ee.ejbjar.project.ui.ServerResourceNode;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbNodesFactory;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileObject;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public final class J2eeProjectView {
    public static final String CONFIG_FILES_VIEW_NAME = "configurationFiles";
    private static EjbNodesFactory factoryInstance = null;

    private J2eeProjectView() {
    }

    public static EjbNodesFactory getEjbNodesFactory() {
        if (factoryInstance == null) {
            factoryInstance = (EjbNodesFactory)Lookup.getDefault().lookup(EjbNodesFactory.class);
        }
        if (factoryInstance == null) {
            Logger.getLogger("global").log(Level.INFO, "No EjbNodesFactory instance available: Enterprise Beans nodes cannot be creater");
        }
        return factoryInstance;
    }

    public static Node createServerResourcesNode(Project project) {
        try {
            return new ServerResourceNode(project);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            return null;
        }
    }

    public static Node createEjbsView(EjbJar ejbJar, Project project) {
        try {
            return new EjbContainerNode(ejbJar, project, J2eeProjectView.getEjbNodesFactory());
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            return null;
        }
    }

    public static Node createConfigFilesView(FileObject fileObject) {
        return new DocBaseNode(DataFolder.findFolder((FileObject)fileObject));
    }

    private static final class VisibilityQueryDataFilter
    implements ChangeListener,
    ChangeableDataFilter {
        EventListenerList ell = new EventListenerList();

        public VisibilityQueryDataFilter() {
            VisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
        }

        public boolean acceptDataObject(DataObject dataObject) {
            FileObject fileObject = dataObject.getPrimaryFile();
            return VisibilityQuery.getDefault().isVisible(fileObject);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object[] objectArray = this.ell.getListenerList();
            ChangeEvent changeEvent2 = null;
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ChangeListener.class) continue;
                if (changeEvent2 == null) {
                    changeEvent2 = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent2);
            }
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.ell.add(ChangeListener.class, changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.ell.remove(ChangeListener.class, changeListener);
        }
    }

    private static final class DocBaseNode
    extends FilterNode {
        private static final DataFilter VISIBILITY_QUERY_FILTER = new VisibilityQueryDataFilter();
        private static Image CONFIGURATION_FILES_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/ejbjar/project/ui/ejbjar.gif", (boolean)true);

        public DocBaseNode(DataFolder dataFolder) {
            super(dataFolder.getNodeDelegate(), dataFolder.createNodeChildren(VISIBILITY_QUERY_FILTER));
        }

        public Image getIcon(int n) {
            return this.computeIcon(false, n);
        }

        public Image getOpenedIcon(int n) {
            return this.computeIcon(true, n);
        }

        private Image computeIcon(boolean bl, int n) {
            Node node = this.getOriginal();
            Image image = bl ? node.getOpenedIcon(n) : node.getIcon(n);
            return ImageUtilities.mergeImages((Image)image, (Image)CONFIGURATION_FILES_BADGE, (int)7, (int)7);
        }

        public String getName() {
            return J2eeProjectView.CONFIG_FILES_VIEW_NAME;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(J2eeProjectView.class, (String)"LBL_Node_ConfigFiles");
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public boolean canRename() {
            return false;
        }

        public boolean canDestroy() {
            return false;
        }

        public Action[] getActions(boolean bl) {
            return new Action[]{SystemAction.get(FindAction.class)};
        }
    }
}

