/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.api.ejbjar;

import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.j2ee.api.ejbjar.Car;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.ejbjar.EarAccessor;
import org.netbeans.modules.j2ee.spi.ejbjar.EarImplementation;
import org.netbeans.modules.j2ee.spi.ejbjar.EarImplementation2;
import org.netbeans.modules.j2ee.spi.ejbjar.EarProvider;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class Ear {
    private static final Lookup.Result<EarProvider> implementations = Lookup.getDefault().lookup(new Lookup.Template(EarProvider.class));
    private final EarImplementation impl;
    private final EarImplementation2 impl2;

    private Ear(EarImplementation earImplementation, EarImplementation2 earImplementation2) {
        assert (earImplementation != null && earImplementation2 == null || earImplementation == null && earImplementation2 != null);
        this.impl = earImplementation;
        this.impl2 = earImplementation2;
    }

    public static Ear getEar(FileObject fileObject) {
        if (fileObject == null) {
            throw new NullPointerException("Passed null to Ear.getEar(FileObject)");
        }
        for (EarProvider earProvider : implementations.allInstances()) {
            Ear ear = earProvider.findEar(fileObject);
            if (ear == null) continue;
            return ear;
        }
        return null;
    }

    public String getJ2eePlatformVersion() {
        if (this.impl2 != null) {
            Profile profile = this.impl2.getJ2eeProfile();
            if (profile != null) {
                return profile.toPropertiesString();
            }
            return null;
        }
        return this.impl.getJ2eePlatformVersion();
    }

    public Profile getJ2eeProfile() {
        if (this.impl2 != null) {
            return this.impl2.getJ2eeProfile();
        }
        return Profile.fromPropertiesString((String)this.impl.getJ2eePlatformVersion());
    }

    public FileObject getDeploymentDescriptor() {
        if (this.impl2 != null) {
            this.impl2.getDeploymentDescriptor();
        }
        return this.impl.getDeploymentDescriptor();
    }

    public void addWebModule(WebModule webModule) {
        if (this.impl2 != null) {
            this.impl2.addWebModule(webModule);
        } else {
            this.impl.addWebModule(webModule);
        }
    }

    public void addEjbJarModule(EjbJar ejbJar) {
        if (this.impl2 != null) {
            this.impl2.addEjbJarModule(ejbJar);
        } else {
            this.impl.addEjbJarModule(ejbJar);
        }
    }

    public void addCarModule(Car car) {
        if (this.impl2 != null) {
            this.impl2.addCarModule(car);
        } else {
            this.impl.addCarModule(car);
        }
    }

    static {
        EarAccessor.DEFAULT = new EarAccessor(){

            public Ear createEar(EarImplementation earImplementation) {
                return new Ear(earImplementation, null);
            }

            public Ear createEar(EarImplementation2 earImplementation2) {
                return new Ear(null, earImplementation2);
            }
        };
    }
}

