/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.pull;

import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URISyntaxException;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.pull.PullAction;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.ui.repository.Repository;
import org.netbeans.modules.mercurial.ui.wizards.CloneRepositoryWizardPanel;
import org.netbeans.modules.mercurial.util.HgProjectUtils;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PullOtherAction
extends ContextAction
implements ChangeListener {
    private final VCSContext context;
    private Repository repository = null;
    private JButton pullButton = null;
    private JButton cancelButton = null;

    public PullOtherAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    public void performAction(ActionEvent actionEvent) {
        Object object;
        File[] fileArray = HgUtils.getActionRoots(this.context);
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        File file = Mercurial.getInstance().getRepositoryRoot(fileArray[0]);
        if (this.repository == null) {
            int bl = 100;
            object = NbBundle.getMessage(CloneRepositoryWizardPanel.class, (String)"CTL_Repository_Location");
            this.repository = new Repository(bl, (String)object, true);
            this.repository.addChangeListener(this);
        }
        this.pullButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.pullButton, (String)NbBundle.getMessage(PullOtherAction.class, (String)"CTL_Pull_Action_Pull"));
        this.pullButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PullOtherAction.class, (String)"ACSD_Pull_Action_Pull"));
        this.pullButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PullOtherAction.class, (String)"ACSN_Pull_Action_Pull"));
        this.cancelButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(PullOtherAction.class, (String)"CTL_Pull_Action_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PullOtherAction.class, (String)"ACSD_Pull_Action_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PullOtherAction.class, (String)"ACSN_Pull_Action_Cancel"));
        boolean bl = this.repository.isValid();
        this.pullButton.setEnabled(bl);
        object = this.repository.show(NbBundle.getMessage(PullOtherAction.class, (String)"CTL_PullDialog_Title"), new HelpCtx(PullOtherAction.class), new Object[]{this.pullButton, this.cancelButton}, true, "hg.pull.dialog");
        if (object == this.pullButton) {
            HgURL hgURL;
            try {
                hgURL = this.repository.getUrl();
            }
            catch (URISyntaxException uRISyntaxException) {
                Mercurial.LOG.log(Level.SEVERE, this.getClass().getName() + ": Could not pull because of invalid URI." + this.repository.getUrlString());
                Mercurial.LOG.log(Level.SEVERE, this.getClass().getName() + ": Invalid URI: " + this.repository.getUrlString());
                return;
            }
            PullOtherAction.pull(this.context, file, hgURL);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.pullButton.setEnabled(this.repository.isValid());
    }

    public static void pull(final VCSContext vCSContext, final File file, final HgURL hgURL) {
        if (file == null || hgURL == null) {
            return;
        }
        final String string = NbBundle.getMessage(PullAction.class, (String)"MSG_EXTERNAL_REPOSITORY");
        final String string2 = HgProjectUtils.getProjectName(file);
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(file);
        HgProgressSupport hgProgressSupport = new HgProgressSupport(){

            public void perform() {
                PullAction.performPull(PullAction.PullType.OTHER, vCSContext, file, hgURL, string, string2, this.getLogger());
            }
        };
        hgProgressSupport.start(requestProcessor, file, NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_PROGRESS"));
    }

    public boolean isEnabled() {
        return HgUtils.isFromHgRepository(this.context);
    }
}

