/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.commit;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.HgFileNode;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.ui.commit.CommitOptions;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitTableModel
extends AbstractTableModel {
    public static final String COLUMN_NAME_NAME = "name";
    public static final String COLUMN_NAME_STATUS = "status";
    public static final String COLUMN_NAME_ACTION = "action";
    public static final String COLUMN_NAME_PATH = "path";
    public static final String COLUMN_NAME_BRANCH = "branch";
    private RootFile rootFile;
    private static final Map<String, String[]> columnLabels = new HashMap<String, String[]>(4);
    private CommitOptions[] commitOptions;
    private HgFileNode[] nodes;
    private String[] columns;

    public CommitTableModel(String[] stringArray) {
        ResourceBundle resourceBundle = NbBundle.getBundle(CommitTableModel.class);
        columnLabels.put(COLUMN_NAME_NAME, new String[]{resourceBundle.getString("CTL_CommitTable_Column_File"), resourceBundle.getString("CTL_CommitTable_Column_File")});
        columnLabels.put(COLUMN_NAME_BRANCH, new String[]{resourceBundle.getString("CTL_CommitTable_Column_Branch"), resourceBundle.getString("CTL_CommitTable_Column_Branch")});
        columnLabels.put(COLUMN_NAME_STATUS, new String[]{resourceBundle.getString("CTL_CommitTable_Column_Status"), resourceBundle.getString("CTL_CommitTable_Column_Status")});
        columnLabels.put(COLUMN_NAME_ACTION, new String[]{resourceBundle.getString("CTL_CommitTable_Column_Action"), resourceBundle.getString("CTL_CommitTable_Column_Action")});
        columnLabels.put(COLUMN_NAME_PATH, new String[]{resourceBundle.getString("CTL_CommitTable_Column_Folder"), resourceBundle.getString("CTL_CommitTable_Column_Folder")});
        this.setColumns(stringArray);
        this.setNodes(new HgFileNode[0]);
    }

    void setNodes(HgFileNode[] hgFileNodeArray) {
        this.nodes = hgFileNodeArray;
        this.defaultCommitOptions();
        this.fireTableDataChanged();
    }

    void setColumns(String[] stringArray) {
        if (Arrays.equals(stringArray, this.columns)) {
            return;
        }
        this.columns = stringArray;
        this.fireTableStructureChanged();
    }

    public Map<HgFileNode, CommitOptions> getCommitFiles() {
        HashMap<HgFileNode, CommitOptions> hashMap = new HashMap<HgFileNode, CommitOptions>(this.nodes.length);
        for (int i = 0; i < this.nodes.length; ++i) {
            hashMap.put(this.nodes[i], this.commitOptions[i]);
        }
        return hashMap;
    }

    @Override
    public String getColumnName(int n) {
        return columnLabels.get(this.columns[n])[0];
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public int getRowCount() {
        return this.nodes.length;
    }

    public Class getColumnClass(int n) {
        String string = this.columns[n];
        if (string.equals(COLUMN_NAME_ACTION)) {
            return CommitOptions.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        String string = this.columns[n2];
        return string.equals(COLUMN_NAME_ACTION);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        String string = this.columns[n2];
        if (string.equals(COLUMN_NAME_NAME)) {
            return this.nodes[n].getName();
        }
        if (string.equals(COLUMN_NAME_STATUS)) {
            HgFileNode hgFileNode = this.nodes[n];
            FileInformation fileInformation = hgFileNode.getInformation();
            return fileInformation.getStatusText();
        }
        if (string.equals(COLUMN_NAME_ACTION)) {
            return this.commitOptions[n];
        }
        if (string.equals(COLUMN_NAME_PATH)) {
            String string2 = null;
            if (this.rootFile != null) {
                String string3 = this.nodes[n].getFile().getAbsolutePath().substring(this.rootFile.rootLocalPath.length());
                string2 = this.rootFile.repositoryPath + string3.replace(File.separatorChar, '/');
            } else {
                string2 = HgUtils.getRelativePath(this.nodes[n].getFile());
                if (string2 == null) {
                    string2 = NbBundle.getMessage(CommitTableModel.class, (String)"CTL_CommitForm_NotInRepository");
                }
            }
            return string2;
        }
        throw new IllegalArgumentException("Column index out of range: " + n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        String string = this.columns[n2];
        if (!string.equals(COLUMN_NAME_ACTION)) {
            throw new IllegalArgumentException("Column index out of range: " + n2);
        }
        this.commitOptions[n] = (CommitOptions)object;
        this.fireTableCellUpdated(n, n2);
    }

    private void defaultCommitOptions() {
        boolean bl = System.getProperty("netbeans.mercurial.excludeNewFiles") != null;
        this.commitOptions = new CommitOptions[this.nodes.length];
        block3: for (int i = 0; i < this.nodes.length; ++i) {
            HgFileNode hgFileNode = this.nodes[i];
            File file = hgFileNode.getFile();
            if (HgModuleConfig.getDefault().isExcludedFromCommit(file.getAbsolutePath())) {
                this.commitOptions[i] = CommitOptions.EXCLUDE;
                continue;
            }
            switch (hgFileNode.getInformation().getStatus()) {
                case 256: 
                case 2048: {
                    this.commitOptions[i] = CommitOptions.COMMIT_REMOVE;
                    continue block3;
                }
                default: {
                    this.commitOptions[i] = CommitOptions.COMMIT;
                }
            }
        }
    }

    public HgFileNode getNode(int n) {
        return this.nodes[n];
    }

    public CommitOptions getOptions(int n) {
        return this.commitOptions[n];
    }

    void setRootFile(String string, String string2) {
        this.rootFile = new RootFile();
        this.rootFile.repositoryPath = string;
        this.rootFile.rootLocalPath = string2;
    }

    private class RootFile {
        String repositoryPath;
        String rootLocalPath;

        private RootFile() {
        }
    }
}

