/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.commit;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgFileNode;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.hooks.spi.HgHook;
import org.netbeans.modules.mercurial.hooks.spi.HgHookContext;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.commit.CommitOptions;
import org.netbeans.modules.mercurial.ui.commit.CommitPanel;
import org.netbeans.modules.mercurial.ui.commit.CommitTable;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.status.StatusAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.DialogBoundsPreserver;
import org.netbeans.modules.versioning.util.IndexingBridge;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitAction
extends ContextAction {
    static final String RECENT_COMMIT_MESSAGES = "recentCommitMessage";
    private final VCSContext context;

    public CommitAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    @Override
    public boolean isEnabled() {
        Set set;
        Set set2 = set = this.context != null ? this.context.getRootFiles() : null;
        return HgUtils.isFromHgRepository(this.context) && set != null && set.size() != 0;
    }

    @Override
    public void performAction(ActionEvent actionEvent) {
        File file = HgUtils.getRootFile(this.context);
        if (file == null) {
            OutputLogger outputLogger = OutputLogger.getLogger(Mercurial.MERCURIAL_OUTPUT_TAB_TITLE);
            outputLogger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_TITLE"));
            outputLogger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_TITLE_SEP"));
            outputLogger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_NOT_SUPPORTED_INVIEW_INFO"));
            outputLogger.output("");
            outputLogger.closeLog();
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_NOT_SUPPORTED_INVIEW"), NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_NOT_SUPPORTED_INVIEW_TITLE"), 1);
            return;
        }
        String string = Utils.getContextDisplayName((VCSContext)this.context);
        CommitAction.commit(string, this.context);
    }

    public static void commit(String string, final VCSContext vCSContext) {
        File file = HgUtils.getRootFile(vCSContext);
        if (file == null) {
            return;
        }
        final CommitPanel commitPanel = new CommitPanel();
        final List<HgHook> list = Mercurial.getInstance().getHooks();
        commitPanel.setHooks(list, new HgHookContext(vCSContext.getRootFiles().toArray(new File[vCSContext.getRootFiles().size()]), null, new HgHookContext.LogEntry[0]));
        final CommitTable commitTable = new CommitTable(commitPanel.filesLabel, CommitTable.COMMIT_COLUMNS, new String[]{"path"});
        commitPanel.setCommitTable(commitTable);
        final JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(CommitAction.class, (String)"CTL_Commit_Action_Commit"));
        jButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommitAction.class, (String)"ACSN_Commit_Action_Commit"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommitAction.class, (String)"ACSD_Commit_Action_Commit"));
        JButton jButton2 = new JButton(NbBundle.getMessage(CommitAction.class, (String)"CTL_Commit_Action_Cancel"));
        Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)NbBundle.getMessage(CommitAction.class, (String)"CTL_Commit_Action_Cancel"));
        jButton2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommitAction.class, (String)"ACSN_Commit_Action_Cancel"));
        jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommitAction.class, (String)"ACSD_Commit_Action_Cancel"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)commitPanel, NbBundle.getMessage(CommitAction.class, (String)"CTL_CommitDialog_Title", (Object)string), true, new Object[]{jButton, jButton2}, (Object)jButton, 0, new HelpCtx(CommitAction.class), null);
        CommitAction.computeNodes(commitTable, commitPanel, vCSContext, file, jButton2);
        jButton.setEnabled(false);
        commitPanel.addVersioningListener(new VersioningListener(){

            public void versioningEvent(VersioningEvent versioningEvent) {
                CommitAction.refreshCommitDialog(commitPanel, commitTable, jButton);
            }
        });
        commitTable.getTableModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                CommitAction.refreshCommitDialog(commitPanel, commitTable, jButton);
            }
        });
        jButton.setEnabled(CommitAction.containsCommitable(commitTable));
        commitPanel.putClientProperty("contentTitle", string);
        commitPanel.putClientProperty("DialogDescriptor", dialogDescriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.addWindowListener((WindowListener)new DialogBoundsPreserver(HgModuleConfig.getDefault().getPreferences(), "hg.commit.dialog"));
        dialog.pack();
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == jButton) {
            final Map<HgFileNode, CommitOptions> map = commitTable.getCommitFiles();
            final String string2 = commitPanel.getCommitMessage();
            if (!commitPanel.isHooksPanelInitialized()) {
                list.clear();
            }
            Utils.insert((Preferences)HgModuleConfig.getDefault().getPreferences(), (String)RECENT_COMMIT_MESSAGES, (String)string2.trim(), (int)20);
            RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(file);
            HgProgressSupport hgProgressSupport = new HgProgressSupport(){

                public void perform() {
                    OutputLogger outputLogger = this.getLogger();
                    CommitAction.performCommit(string2, map, vCSContext, this, outputLogger, list);
                }
            };
            hgProgressSupport.start(requestProcessor, file, NbBundle.getMessage(CommitAction.class, (String)"LBL_Commit_Progress"));
        }
    }

    private static void computeNodes(final CommitTable commitTable, final CommitPanel commitPanel, final VCSContext vCSContext, File file, JButton jButton) {
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(file);
        HgProgressSupport hgProgressSupport = new HgProgressSupport(NbBundle.getMessage(CommitAction.class, (String)"Progress_Preparing_Commit"), jButton){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void perform() {
                block10: {
                    block9: {
                        try {
                            Object object;
                            commitPanel.progressPanel.setVisible(true);
                            StatusAction.executeStatus(vCSContext, this);
                            FileStatusCache fileStatusCache = Mercurial.getInstance().getFileStatusCache();
                            File[] fileArray = vCSContext.getRootFiles().toArray(new File[vCSContext.getRootFiles().size()]);
                            File[][] fileArray2 = Utils.splitFlatOthers((File[])fileArray);
                            ArrayList<File> arrayList = new ArrayList<File>();
                            for (int i = 0; i < fileArray2.length; ++i) {
                                boolean bl;
                                fileArray = fileArray2[i];
                                boolean bl2 = bl = i == 1;
                                if (bl) {
                                    Set<File> set = HgUtils.getRepositoryRoots(vCSContext);
                                    object = fileStatusCache.listFiles(vCSContext, 6612);
                                    for (int j = 0; j < ((File[])object).length; ++j) {
                                        for (int k = 0; k < fileArray.length; ++k) {
                                            if (!set.contains(Mercurial.getInstance().getRepositoryRoot(object[j])) || !HgUtils.isParentOrEqual(fileArray[k], object[j]) || arrayList.contains(object[j])) continue;
                                            arrayList.add(object[j]);
                                        }
                                    }
                                    continue;
                                }
                                File[] fileArray3 = HgUtils.flatten(fileArray, 6612);
                                for (int j = 0; j < fileArray3.length; ++j) {
                                    if (arrayList.contains(fileArray3[j])) continue;
                                    arrayList.add(fileArray3[j]);
                                }
                            }
                            if (arrayList.size() == 0) {
                                Object var12_18 = null;
                                break block9;
                            }
                            ArrayList<File[]> arrayList2 = new ArrayList<File[]>(arrayList.size());
                            for (File file : arrayList) {
                                object = new HgFileNode(file);
                                arrayList2.add((File[])object);
                            }
                            final HgFileNode[] hgFileNodeArray = arrayList2.toArray(new HgFileNode[arrayList.size()]);
                            EventQueue.invokeLater(new Runnable(){

                                public void run() {
                                    commitTable.setNodes(hgFileNodeArray);
                                }
                            });
                            break block10;
                        }
                        catch (Throwable throwable) {
                            Object var12_20 = null;
                            commitPanel.progressPanel.setVisible(false);
                            throw throwable;
                        }
                    }
                    commitPanel.progressPanel.setVisible(false);
                    return;
                }
                Object var12_19 = null;
                commitPanel.progressPanel.setVisible(false);
            }
        };
        commitPanel.progressPanel.add((Component)hgProgressSupport.getProgressComponent());
        commitPanel.progressPanel.setVisible(true);
        hgProgressSupport.start(requestProcessor);
    }

    private static boolean containsCommitable(CommitTable commitTable) {
        Map<HgFileNode, CommitOptions> map = commitTable.getCommitFiles();
        for (CommitOptions commitOptions : map.values()) {
            if (commitOptions == CommitOptions.EXCLUDE) continue;
            return true;
        }
        return false;
    }

    private static void refreshCommitDialog(CommitPanel commitPanel, CommitTable commitTable, JButton jButton) {
        String string;
        Object object;
        HgFileNode hgFileNode2;
        assert (EventQueue.isDispatchThread());
        ResourceBundle resourceBundle = NbBundle.getBundle(CommitAction.class);
        Map<HgFileNode, CommitOptions> map = commitTable.getCommitFiles();
        HashSet hashSet = new HashSet();
        boolean bl = false;
        boolean bl2 = jButton.isEnabled();
        for (HgFileNode hgFileNode2 : map.keySet()) {
            int n;
            object = map.get(hgFileNode2);
            if (object == CommitOptions.EXCLUDE || ((n = hgFileNode2.getInformation().getStatus()) & 0x6A0) == 0 && n != 64) continue;
            bl2 = false;
            string = n == 64 ? resourceBundle.getString("MSG_CommitForm_ErrorConflicts") : resourceBundle.getString("MSG_CommitForm_ErrorRemoteChanges");
            commitPanel.setErrorLabel("<html><font color=\"#002080\">" + string + "</font></html>");
            bl = true;
        }
        if (hashSet.size() > 1) {
            commitTable.setColumns(new String[]{"name", "branch", "status", "action", "path"});
        } else {
            commitTable.setColumns(new String[]{"name", "status", "action", "path"});
        }
        String string2 = (String)commitPanel.getClientProperty("contentTitle");
        hgFileNode2 = (DialogDescriptor)commitPanel.getClientProperty("DialogDescriptor");
        if (hashSet.size() <= 1) {
            String string3;
            String string4 = string3 = hashSet.size() == 0 ? null : (String)hashSet.iterator().next();
            if (string3 == null) {
                hgFileNode2.setTitle(MessageFormat.format(resourceBundle.getString("CTL_CommitDialog_Title"), string2));
                object = "";
            } else {
                hgFileNode2.setTitle(MessageFormat.format(resourceBundle.getString("CTL_CommitDialog_Title_Branch"), string2, string3));
                string = MessageFormat.format(resourceBundle.getString("MSG_CommitForm_InfoBranch"), string3);
                object = "<html><font color=\"#002080\">" + string + "</font></html>";
            }
        } else {
            hgFileNode2.setTitle(MessageFormat.format(resourceBundle.getString("CTL_CommitDialog_Title_Branches"), string2));
            String string5 = resourceBundle.getString("MSG_CommitForm_ErrorMultipleBranches");
            object = "<html><font color=\"#CC0000\">" + string5 + "</font></html>";
        }
        if (!bl) {
            commitPanel.setErrorLabel((String)object);
            bl2 = true;
        }
        jButton.setEnabled(bl2 && CommitAction.containsCommitable(commitTable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performCommit(String string, Map<HgFileNode, CommitOptions> map, VCSContext vCSContext, HgProgressSupport hgProgressSupport, OutputLogger outputLogger, List<HgHook> list) {
        block19: {
            Object object;
            Object object2;
            File[] fileArray;
            FileStatusCache fileStatusCache = Mercurial.getInstance().getFileStatusCache();
            HashMap<File, List<File>> hashMap = new HashMap<File, List<File>>();
            HashMap<File, List<File>> hashMap2 = new HashMap<File, List<File>>();
            HashMap<File, List<File>> hashMap3 = new HashMap<File, List<File>>();
            Iterator<HgFileNode> iterator = map.keySet().iterator();
            ArrayList<String> arrayList = new ArrayList<String>();
            HashMap<File, Boolean> hashMap4 = new HashMap<File, Boolean>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while (iterator.hasNext()) {
                int n;
                if (hgProgressSupport.isCanceled()) {
                    return;
                }
                fileArray = iterator.next();
                object2 = map.get(fileArray);
                object = Mercurial.getInstance().getRepositoryRoot(fileArray.getFile());
                if (object2 != CommitOptions.EXCLUDE) {
                    n = fileStatusCache.getStatus(fileArray.getFile()).getStatus();
                    if ((n & 4) != 0) {
                        CommitAction.putCandidate(hashMap, (File)object, fileArray.getFile());
                    } else if ((n & 0x800) != 0) {
                        CommitAction.putCandidate(hashMap2, (File)object, fileArray.getFile());
                    }
                    CommitAction.putCandidate(hashMap3, (File)object, fileArray.getFile());
                    arrayList2.add(fileArray.getFile().getAbsolutePath());
                    continue;
                }
                arrayList.add(fileArray.getFile().getAbsolutePath());
                if (Boolean.TRUE.equals(hashMap4.get(object))) continue;
                n = fileStatusCache.getCachedStatus(fileArray.getFile()).getStatus();
                hashMap4.put((File)object, (n & 4) == 0);
            }
            if (hgProgressSupport.isCanceled()) {
                return;
            }
            if (!arrayList.isEmpty()) {
                HgModuleConfig.getDefault().addExclusionPaths(arrayList);
            }
            if (!arrayList2.isEmpty()) {
                HgModuleConfig.getDefault().removeExclusionPaths(arrayList2);
            }
            try {
                try {
                    outputLogger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_TITLE"));
                    outputLogger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_TITLE_SEP"));
                    outputLogger.output(string);
                    new Cmd.AddCmd(hashMap, outputLogger, null, "hg add {0} into {1}").handle();
                    new Cmd.RemoveCmd(hashMap2, outputLogger, null, "hg delete {0} from {1}").handle();
                    fileArray = null;
                    if (list.size() > 0) {
                        object2 = new LinkedList();
                        for (List list2 : hashMap3.values()) {
                            object2.addAll(list2);
                        }
                        fileArray = object2.toArray(new File[object2.size()]);
                    }
                    object2 = new HgHookContext(fileArray, string, new HgHookContext.LogEntry[0]);
                    for (HgHook hgHook : list) {
                        try {
                            if ((object2 = hgHook.beforeCommit((HgHookContext)object2)) == null) continue;
                            string = ((HgHookContext)object2).getMessage();
                        }
                        catch (IOException iOException) {}
                    }
                    object = new Cmd.CommitCmd(hashMap3, outputLogger, string, hgProgressSupport, vCSContext, hashMap4);
                    ((Cmd.CommitCmd)object).setCommitHooks((HgHookContext)object2, list, fileArray);
                    IndexingBridge.getInstance().runWithoutIndexing((Callable)new Callable<Void>((Cmd.CommitCmd)object){
                        final /* synthetic */ Cmd.CommitCmd val$commitCmd;
                        {
                            this.val$commitCmd = commitCmd;
                        }

                        @Override
                        public Void call() throws Exception {
                            this.val$commitCmd.handle();
                            return null;
                        }
                    }, hashMap3.keySet().toArray(new File[hashMap3.keySet().size()]));
                }
                catch (HgException hgException) {
                    object2 = new NotifyDescriptor.Exception((Throwable)hgException);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)object2);
                    Object var20_25 = null;
                    fileStatusCache.refreshCached(vCSContext);
                    outputLogger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_DONE"));
                    outputLogger.output("");
                    break block19;
                }
                catch (Exception exception) {
                    Mercurial.LOG.log(Level.INFO, "Cannot run commit with disabled indexing", exception);
                    Object var20_26 = null;
                    fileStatusCache.refreshCached(vCSContext);
                    outputLogger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_DONE"));
                    outputLogger.output("");
                }
                Object var20_24 = null;
                fileStatusCache.refreshCached(vCSContext);
                outputLogger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_DONE"));
                outputLogger.output("");
            }
            catch (Throwable throwable) {
                Object var20_27 = null;
                fileStatusCache.refreshCached(vCSContext);
                outputLogger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_DONE"));
                outputLogger.output("");
                throw throwable;
            }
        }
    }

    private static void putCandidate(Map<File, List<File>> map, File file, File file2) {
        List<File> list = map.get(file);
        if (list == null) {
            list = new ArrayList<File>();
            map.put(file, list);
        }
        list.add(file2);
    }

    private static void handleCandidates(Map<File, List<File>> map, OutputLogger outputLogger, String string) throws HgException {
        for (Map.Entry<File, List<File>> entry : map.entrySet()) {
            HgCommand.doAdd(entry.getKey(), entry.getValue(), outputLogger);
            for (File file : entry.getValue()) {
                outputLogger.output(MessageFormat.format(string, file.getName(), entry.getKey()));
            }
        }
    }

    private static boolean commitAfterMerge(boolean bl, File file) {
        if (bl || HgModuleConfig.getDefault().getConfirmCommitAfterMerge()) {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_AFTER_MERGE_QUERY"));
            confirmation.setTitle(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_AFTER_MERGE_TITLE"));
            confirmation.setMessageType(2);
            confirmation.setOptionType(0);
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            return object == NotifyDescriptor.YES_OPTION;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Cmd {
        protected final Map<File, List<File>> m;
        protected final OutputLogger logger;
        protected final String logMsgFormat;
        protected final String msg;

        public Cmd(Map<File, List<File>> map, OutputLogger outputLogger, String string, String string2) {
            this.m = map;
            this.logger = outputLogger;
            this.logMsgFormat = string2;
            this.msg = string;
        }

        void handle() throws HgException {
            if (this.m.size() == 0) {
                return;
            }
            for (Map.Entry<File, List<File>> entry : this.m.entrySet()) {
                this.doCmd(entry.getKey(), entry.getValue());
                for (File file : entry.getValue()) {
                    this.logger.output(MessageFormat.format(this.logMsgFormat, file.getName(), entry.getKey()));
                }
            }
        }

        abstract void doCmd(File var1, List<File> var2) throws HgException;

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class CommitCmd
        extends Cmd {
            private HgHookContext context;
            private List<HgHook> hooks;
            private final HgProgressSupport support;
            private File[] hookFiles;
            private final VCSContext ctx;
            private final Map<File, Boolean> locallyModifiedExcluded;

            public CommitCmd(Map<File, List<File>> map, OutputLogger outputLogger, String string, HgProgressSupport hgProgressSupport, VCSContext vCSContext, Map<File, Boolean> map2) {
                super(map, outputLogger, string, null);
                this.support = hgProgressSupport;
                this.ctx = vCSContext;
                this.locallyModifiedExcluded = map2;
            }

            public void setCommitHooks(HgHookContext hgHookContext, List<HgHook> list, File[] fileArray) {
                this.context = hgHookContext;
                this.hooks = list;
                this.hookFiles = fileArray;
            }

            @Override
            void handle() throws HgException {
                if (this.m.size() == 0) {
                    return;
                }
                for (Map.Entry entry : this.m.entrySet()) {
                    this.doCmd((File)entry.getKey(), (List)entry.getValue());
                }
            }

            /*
             * WARNING - void declaration
             */
            @Override
            void doCmd(File file, List<File> list) throws HgException {
                boolean bl = false;
                try {
                    HgCommand.doCommit(file, list, this.msg, this.logger);
                }
                catch (HgException.HgTooLongArgListException hgTooLongArgListException) {
                    void var6_11;
                    Object object;
                    NotifyDescriptor.Confirmation confirmation;
                    Iterator<File> iterator;
                    Mercurial.LOG.log(Level.INFO, null, hgTooLongArgListException);
                    String object2 = "";
                    File[] fileArray = HgUtils.filterForRepository(this.ctx, file, true);
                    if (fileArray != null && fileArray.length < 5) {
                        iterator = Arrays.asList(fileArray);
                        confirmation = iterator.iterator();
                        while (confirmation.hasNext()) {
                            void var6_8;
                            object = confirmation.next();
                            String string = (String)var6_8 + "\n" + ((File)object).getName();
                        }
                    } else {
                        iterator = Collections.EMPTY_LIST;
                        String string = "\n" + file.getName();
                    }
                    confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(CommitAction.class, (String)"MSG_LONG_COMMAND_QUERY", (Object)var6_11));
                    confirmation.setTitle(NbBundle.getMessage(CommitAction.class, (String)"MSG_LONG_COMMAND_TITLE"));
                    confirmation.setMessageType(2);
                    confirmation.setOptionType(0);
                    object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                    if (object == NotifyDescriptor.NO_OPTION) {
                        return;
                    }
                    Mercurial.LOG.info("CommitAction: committing with a reduced set of files: " + iterator.toString());
                    HgCommand.doCommit(file, iterator, this.msg, this.logger);
                }
                catch (HgException hgException) {
                    if ("commitAfterMerge".equals(hgException.getMessage())) {
                        if (this.support.isCanceled()) {
                            return;
                        }
                        if (!CommitAction.commitAfterMerge(Boolean.TRUE.equals(this.locallyModifiedExcluded.get(file)), file)) {
                            return;
                        }
                        HgCommand.doCommit(file, Collections.EMPTY_LIST, this.msg, this.logger);
                        bl = true;
                    }
                    throw hgException;
                }
                HgLogMessage hgLogMessage = HgCommand.doTip(file, this.logger);
                this.context = new HgHookContext(this.hookFiles, this.msg, new HgHookContext.LogEntry(hgLogMessage));
                for (HgHook hgHook : this.hooks) {
                    hgHook.afterCommit(this.context);
                }
                if (bl) {
                    this.logger.output(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMITED_FILES_AFTER_MERGE"));
                } else {
                    if (list.size() == 1) {
                        this.logger.output(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_INIT_SEP_ONE", (Object)list.size()));
                    } else {
                        this.logger.output(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_INIT_SEP", (Object)list.size()));
                    }
                    for (File file2 : list) {
                        this.logger.output("\t" + file2.getAbsolutePath());
                    }
                }
                HgUtils.logHgLog(hgLogMessage, this.logger);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class RemoveCmd
        extends Cmd {
            public RemoveCmd(Map<File, List<File>> map, OutputLogger outputLogger, String string, String string2) {
                super(map, outputLogger, string, string2);
            }

            @Override
            void doCmd(File file, List<File> list) throws HgException {
                HgCommand.doRemove(file, list, this.logger);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class AddCmd
        extends Cmd {
            public AddCmd(Map<File, List<File>> map, OutputLogger outputLogger, String string, String string2) {
                super(map, outputLogger, string, string2);
            }

            @Override
            void doCmd(File file, List<File> list) throws HgException {
                HgCommand.doAdd(file, list, this.logger);
            }
        }
    }
}

