/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.remote.support.RemoteException;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.remote.sync.BaseSyncWorker;
import org.netbeans.modules.cnd.remote.sync.FileData;
import org.netbeans.modules.cnd.remote.sync.RfsLocalController;
import org.netbeans.modules.cnd.remote.sync.RfsSetupProvider;
import org.netbeans.modules.cnd.remote.sync.SharabilityFilter;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RfsSyncWorker
extends BaseSyncWorker
implements RemoteSyncWorker {
    private NativeProcess remoteControllerProcess;
    private RfsLocalController localController;
    private String remoteDir;
    private static final String remoteCharSet = System.getProperty("cnd.remote.charset");

    public RfsSyncWorker(ExecutionEnvironment executionEnvironment, PrintWriter printWriter, PrintWriter printWriter2, File file, File ... fileArray) {
        super(executionEnvironment, printWriter, printWriter2, file, fileArray);
    }

    public boolean startup(Map<String, String> map) {
        boolean bl;
        block11: {
            RemotePathMap remotePathMap = RemotePathMap.getPathMap(this.executionEnvironment);
            this.remoteDir = remotePathMap.getRemotePath("/", false);
            if (this.remoteDir == null) {
                if (this.err != null) {
                    this.err.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Cant_find_sync_root", (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString()));
                }
                return false;
            }
            bl = false;
            try {
                Future future;
                if (this.out != null) {
                    this.out.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Copying", (Object)this.remoteDir, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString()));
                }
                if ((Integer)(future = CommonTasksSupport.mkDir((ExecutionEnvironment)this.executionEnvironment, (String)this.remoteDir, (Writer)this.err)).get() != 0) {
                    throw new IOException("Can not create directory " + this.remoteDir);
                }
                this.startupImpl(map);
                bl = true;
            }
            catch (RemoteException remoteException) {
                this.printErr(remoteException);
            }
            catch (InterruptedException interruptedException) {
                RemoteUtil.LOGGER.finest(interruptedException.getMessage());
            }
            catch (InterruptedIOException interruptedIOException) {
                RemoteUtil.LOGGER.finest(interruptedIOException.getMessage());
            }
            catch (ExecutionException executionException) {
                RemoteUtil.LOGGER.log(Level.FINE, null, executionException);
                if (this.err != null) {
                    this.err.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Error_Copying", (Object)this.remoteDir, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString(), (Object)executionException.getLocalizedMessage()));
                }
            }
            catch (IOException iOException) {
                RemoteUtil.LOGGER.log(Level.FINE, null, iOException);
                if (this.err == null) break block11;
                this.err.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Error_Copying", (Object)this.remoteDir, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString(), (Object)iOException.getLocalizedMessage()));
            }
        }
        return bl;
    }

    private void printErr(Exception exception) throws MissingResourceException {
        RemoteUtil.LOGGER.finest(exception.getMessage());
        if (this.err != null) {
            String string = NbBundle.getMessage(this.getClass(), (String)"MSG_Error_Copying", (Object)this.remoteDir, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString(), (Object)exception.getLocalizedMessage());
            this.err.printf("%s\n", string);
            this.err.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Build_Failed"));
            this.err.printf("%s\n", string);
        }
    }

    private BufferedReader getReader(InputStream inputStream) {
        String string;
        String string2 = string = remoteCharSet == null ? "UTF-8" : remoteCharSet;
        if (Charset.isSupported(string)) {
            try {
                return new BufferedReader(new InputStreamReader(inputStream, string));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Exceptions.printStackTrace((Throwable)unsupportedEncodingException);
            }
        }
        return new BufferedReader(new InputStreamReader(inputStream));
    }

    private PrintWriter getWriter(OutputStream outputStream) {
        String string;
        String string2 = string = remoteCharSet == null ? "UTF-8" : remoteCharSet;
        if (Charset.isSupported(string)) {
            try {
                return new PrintWriter(new OutputStreamWriter(outputStream, string));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Exceptions.printStackTrace((Throwable)unsupportedEncodingException);
            }
        }
        return new PrintWriter(outputStream);
    }

    private void startupImpl(Map<String, String> map) throws IOException, InterruptedException, ExecutionException, RemoteException {
        String string;
        String string2;
        try {
            string2 = RfsSetupProvider.getControllerPath(this.executionEnvironment);
            CndUtils.assertTrue((string2 != null ? 1 : 0) != 0);
            string = RfsSetupProvider.getLdLibraryPath(this.executionEnvironment);
            CndUtils.assertTrue((string != null ? 1 : 0) != 0);
        }
        catch (ParseException parseException) {
            throw new ExecutionException(parseException);
        }
        NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.executionEnvironment);
        this.remoteControllerCleanup();
        nativeProcessBuilder.setExecutable(string2);
        nativeProcessBuilder.setWorkingDirectory(this.remoteDir);
        this.remoteControllerProcess = nativeProcessBuilder.call();
        RequestProcessor.getDefault().post((Runnable)new ErrorReader(this.remoteControllerProcess.getErrorStream(), this.err));
        InputStream inputStream = this.remoteControllerProcess.getInputStream();
        OutputStream outputStream = this.remoteControllerProcess.getOutputStream();
        BufferedReader bufferedReader = this.getReader(inputStream);
        PrintWriter printWriter = this.getWriter(outputStream);
        this.localController = new RfsLocalController(this.executionEnvironment, this.files, this.remoteDir, bufferedReader, printWriter, this.err, new FileData(this.privProjectStorageDir, this.executionEnvironment));
        this.localController.feedFiles(new SharabilityFilter());
        String string3 = bufferedReader.readLine();
        if (string3 == null || !string3.startsWith("PORT ")) {
            if (string3 == null) {
                int n = this.remoteControllerProcess.waitFor();
                throw new ExecutionException(String.format("Remote controller failed; rc=%d\n", n), null);
            }
            String string4 = String.format("Protocol error: read \"%s\" expected \"%s\"\n", string3, "PORT <port-number>");
            System.err.printf(string4, new Object[0]);
            this.remoteControllerProcess.destroy();
            throw new ExecutionException(string4, null);
        }
        String string5 = string3.substring(5);
        RemoteUtil.LOGGER.fine("Remote Controller listens port " + string5);
        RequestProcessor.getDefault().post((Runnable)this.localController);
        String string6 = RfsSetupProvider.getPreloadName(this.executionEnvironment);
        CndUtils.assertTrue((string6 != null ? 1 : 0) != 0);
        map.put("LD_PRELOAD", string6);
        String string7 = "LD_LIBRARY_PATH";
        String string8 = RemoteUtil.getEnv(this.executionEnvironment, string7);
        if (string8 != null) {
            string = string + ":" + string8;
        }
        map.put(string7, string);
        map.put("RFS_CONTROLLER_DIR", this.remoteDir);
        map.put("RFS_CONTROLLER_PORT", string5);
        this.addRemoteEnv(map, "cnd.rfs.preload.sleep", "RFS_PRELOAD_SLEEP");
        this.addRemoteEnv(map, "cnd.rfs.preload.log", "RFS_PRELOAD_LOG");
        this.addRemoteEnv(map, "cnd.rfs.controller.log", "RFS_CONTROLLER_LOG");
        this.addRemoteEnv(map, "cnd.rfs.controller.port", "RFS_CONTROLLER_PORT");
        this.addRemoteEnv(map, "cnd.rfs.controller.host", "RFS_CONTROLLER_HOST");
        RemoteUtil.LOGGER.fine("Setting environment:");
    }

    private void addRemoteEnv(Map<String, String> map, String string, String string2) {
        String string3 = System.getProperty(string, null);
        if (string3 != null) {
            map.put(string2, string3);
        }
    }

    public void shutdown() {
        this.shutdownImpl();
    }

    public boolean cancel() {
        return false;
    }

    private void shutdownImpl() {
        this.remoteControllerCleanup();
        this.localControllerCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void localControllerCleanup() {
        RfsLocalController rfsLocalController;
        RfsSyncWorker rfsSyncWorker = this;
        synchronized (rfsSyncWorker) {
            rfsLocalController = this.localController;
            this.localController = null;
        }
        if (rfsLocalController != null) {
            rfsLocalController.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remoteControllerCleanup() {
        NativeProcess nativeProcess;
        RfsSyncWorker rfsSyncWorker = this;
        synchronized (rfsSyncWorker) {
            nativeProcess = this.remoteControllerProcess;
            this.remoteControllerProcess = null;
        }
        if (nativeProcess != null) {
            nativeProcess.destroy();
            nativeProcess = null;
        }
    }

    private static class ErrorReader
    implements Runnable {
        private final BufferedReader errorReader;
        private final PrintWriter errorWriter;

        public ErrorReader(InputStream inputStream, PrintWriter printWriter) {
            this.errorReader = new BufferedReader(new InputStreamReader(inputStream));
            this.errorWriter = printWriter;
        }

        public void run() {
            try {
                String string;
                while ((string = this.errorReader.readLine()) != null) {
                    if (this.errorWriter != null) {
                        this.errorWriter.println(string);
                    }
                    RemoteUtil.LOGGER.fine(string);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }
}

