/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.mapper;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.remote.support.RemoteCommandSupport;
import org.netbeans.modules.cnd.spi.remote.HostInfoProviderFactory;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;

public class RemoteHostInfoProviderFactory
implements HostInfoProviderFactory {
    private static final Map<ExecutionEnvironment, RemoteHostInfo> env2hostinfo = new HashMap<ExecutionEnvironment, RemoteHostInfo>();

    public static synchronized RemoteHostInfo getHostInfo(ExecutionEnvironment executionEnvironment) {
        RemoteHostInfo remoteHostInfo = env2hostinfo.get(executionEnvironment);
        if (remoteHostInfo == null) {
            remoteHostInfo = new RemoteHostInfo(executionEnvironment);
            env2hostinfo.put(executionEnvironment, remoteHostInfo);
        }
        return remoteHostInfo;
    }

    public boolean canCreate(ExecutionEnvironment executionEnvironment) {
        return executionEnvironment.isRemote();
    }

    public HostInfoProvider create(ExecutionEnvironment executionEnvironment) {
        return RemoteHostInfoProviderFactory.getHostInfo(executionEnvironment);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoteHostInfo
    extends HostInfoProvider {
        private final ExecutionEnvironment executionEnvironment;
        private String home = null;
        private PathMap mapper;
        private Map<String, String> envCache = null;
        private Boolean isCshShell;
        private Integer platform;

        public boolean fileExists(String string) {
            RemoteCommandSupport remoteCommandSupport = new RemoteCommandSupport(this.executionEnvironment, "test -d \"" + string + "\" -o -f \"" + string + "\"");
            return remoteCommandSupport.run() == 0;
        }

        public String getLibDir() {
            String string;
            try {
                string = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.executionEnvironment).getTempDir();
            }
            catch (Throwable throwable) {
                string = "/var/tmp";
            }
            String string2 = string + "/tools";
            return string2;
        }

        private RemoteHostInfo(ExecutionEnvironment executionEnvironment) {
            this.executionEnvironment = executionEnvironment;
        }

        public synchronized PathMap getMapper() {
            if (this.mapper == null) {
                this.mapper = RemotePathMap.getPathMap(this.executionEnvironment);
            }
            return this.mapper;
        }

        public synchronized Map<String, String> getEnv() {
            if (this.envCache == null) {
                this.envCache = new HashMap<String, String>();
                RemoteCommandSupport remoteCommandSupport = new RemoteCommandSupport(this.executionEnvironment, "env");
                if (remoteCommandSupport.run() == 0) {
                    String string = remoteCommandSupport.getOutput();
                    String[] stringArray = string.split("\n");
                    for (int i = 0; i < stringArray.length; ++i) {
                        int n = stringArray[i].indexOf(61);
                        if (n <= 0) continue;
                        this.envCache.put(stringArray[i].substring(0, n), stringArray[i].substring(n + 1));
                    }
                }
            }
            return this.envCache;
        }

        public boolean isCshShell() {
            if (this.isCshShell == null) {
                RemoteCommandSupport remoteCommandSupport = new RemoteCommandSupport(this.executionEnvironment, "PATH=/bin:/usr/bin export");
                this.isCshShell = remoteCommandSupport.run() != 0;
            }
            return this.isCshShell;
        }

        public int getPlatform() {
            if (this.platform == null) {
                RemoteCommandSupport remoteCommandSupport = new RemoteCommandSupport(this.executionEnvironment, "uname -sm");
                int n = remoteCommandSupport.run() == 0 ? RemoteHostInfo.recognizePlatform(remoteCommandSupport.getOutput()) : 5;
                this.platform = n;
            }
            return this.platform;
        }

        private static int recognizePlatform(String string) {
            if (string.startsWith("Windows")) {
                return 3;
            }
            if (string.startsWith("Linux")) {
                return 2;
            }
            if (string.startsWith("SunOS")) {
                return string.contains("86") ? 1 : 0;
            }
            if (string.toLowerCase().startsWith("mac")) {
                return 4;
            }
            return 5;
        }
    }
}

