/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.fs;

import java.io.File;
import org.netbeans.modules.cnd.makeproject.api.compilers.BasicCompiler;
import org.netbeans.modules.cnd.remote.fs.RemoteDirectory;
import org.netbeans.modules.cnd.remote.fs.RemoteFileObjectBase;
import org.netbeans.modules.cnd.remote.fs.RemoteFileSupport;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class RemoteFileSystem
extends FileSystem {
    private static final SystemAction[] NO_SYSTEM_ACTIONS = new SystemAction[0];
    private final ExecutionEnvironment execEnv;
    private final String filePrefix;
    private final RemoteFileObjectBase root;
    private final RemoteFileSupport remoteFileSupport;
    private final File cache;

    public RemoteFileSystem(ExecutionEnvironment executionEnvironment) {
        CndUtils.assertTrue((boolean)executionEnvironment.isRemote());
        this.execEnv = executionEnvironment;
        this.remoteFileSupport = new RemoteFileSupport(executionEnvironment);
        this.filePrefix = BasicCompiler.getIncludeFilePrefix((ExecutionEnvironment)executionEnvironment);
        this.cache = new File(this.filePrefix);
        this.cache.mkdirs();
        this.root = new RootFileObject(this, executionEnvironment, this.cache);
    }

    File getCache() {
        return this.cache;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"RFS_DISPLAY_NAME", (Object)this.execEnv.getDisplayName());
    }

    public boolean isReadOnly() {
        return true;
    }

    public FileObject getRoot() {
        return this.root;
    }

    public FileObject findResource(String string) {
        return this.getRoot().getFileObject(string);
    }

    public SystemAction[] getActions() {
        return NO_SYSTEM_ACTIONS;
    }

    public RemoteFileSupport getRemoteFileSupport() {
        return this.remoteFileSupport;
    }

    public String toString() {
        return this.getDisplayName();
    }

    private static class RootFileObject
    extends RemoteDirectory {
        public RootFileObject(RemoteFileSystem remoteFileSystem, ExecutionEnvironment executionEnvironment, File file) {
            super(remoteFileSystem, executionEnvironment, "", file);
        }

        public boolean isRoot() {
            return false;
        }
    }
}

