/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import javax.swing.JTable;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.versioning.util.TableSorter;

public class SortedTable
extends JTable {
    private final TableSorter sorter;

    public SortedTable(TableSorter tableSorter) {
        super(tableSorter);
        this.sorter = tableSorter;
        this.updateSorterTableHeader();
    }

    protected JTableHeader createDefaultTableHeader() {
        return new TableHeader(this.columnModel);
    }

    public void setTableHeader(JTableHeader jTableHeader) {
        if (jTableHeader != this.tableHeader) {
            super.setTableHeader(jTableHeader);
            this.updateSorterTableHeader();
        }
    }

    private void updateSorterTableHeader() {
        if (this.sorter != null) {
            this.sorter.setTableHeader(this.tableHeader);
        }
    }

    private final class TableHeader
    extends JTableHeader {
        private TableHeader(TableColumnModel tableColumnModel) {
            super(tableColumnModel);
            this.setSortingRenderer();
        }

        public void setUI(TableHeaderUI tableHeaderUI) {
            if (tableHeaderUI != this.ui) {
                this.unsetSortingRenderer();
                super.setUI(tableHeaderUI);
                this.setSortingRenderer();
                this.repaint();
            }
        }

        private void unsetSortingRenderer() {
            TableCellRenderer tableCellRenderer = this.getDefaultRenderer();
            if (tableCellRenderer instanceof TableSorter.SortableHeaderRenderer) {
                this.setDefaultRenderer(((TableSorter.SortableHeaderRenderer)tableCellRenderer).getRendererDelegate());
            }
        }

        private void setSortingRenderer() {
            TableCellRenderer tableCellRenderer;
            if (SortedTable.this.sorter != null && !((tableCellRenderer = this.getDefaultRenderer()) instanceof TableSorter.SortableHeaderRenderer)) {
                TableSorter tableSorter = SortedTable.this.sorter;
                tableSorter.getClass();
                this.setDefaultRenderer(new TableSorter.SortableHeaderRenderer(tableSorter, tableCellRenderer));
            }
        }
    }
}

